/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.types;

import java.util.function.Function;
import one.microstream.afs.exceptions.AfsExceptionConsistency;
import one.microstream.afs.exceptions.AfsExceptionMutationInUse;
import one.microstream.afs.exceptions.AfsExceptionUnresolvableRoot;
import one.microstream.afs.types.ACreator;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AIoHandler;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AResolver;
import one.microstream.afs.types.AResolving;
import one.microstream.afs.types.ARoot;
import one.microstream.afs.types.AWritableFile;
import one.microstream.afs.types.AccessManager;
import one.microstream.afs.types.WriteController;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.XArrays;
import one.microstream.collections.types.XGettingTable;

public interface AFileSystem
extends AResolving,
WriteController {
    public String defaultProtocol();

    default public ADirectory ensureDirectoryPath(String ... pathElements) {
        return this.ensureDirectoryPath(pathElements, 0, pathElements.length);
    }

    public ADirectory ensureDirectoryPath(String[] var1, int var2, int var3);

    default public AFile ensureFilePath(String ... pathElements) {
        return this.ensureFilePath(pathElements, 0, pathElements.length - 1, pathElements[pathElements.length - 1]);
    }

    default public AFile ensureFilePath(String[] directoryPathElements, String fileIdentifier) {
        return this.ensureFilePath(directoryPathElements, 0, directoryPathElements.length, fileIdentifier);
    }

    public AFile ensureFilePath(String[] var1, int var2, int var3, String var4);

    public AccessManager accessManager();

    public ACreator creator();

    public AIoHandler ioHandler();

    public AReadableFile wrapForReading(AFile var1, Object var2);

    public AWritableFile wrapForWriting(AFile var1, Object var2);

    public AReadableFile convertToReading(AWritableFile var1);

    public AWritableFile convertToWriting(AReadableFile var1);

    public ADirectory lookupRoot(String var1);

    public ADirectory getRoot(String var1);

    public ADirectory ensureRoot(String var1);

    public ADirectory ensureRoot(ARoot.Creator var1, String var2);

    public ADirectory ensureDefaultRoot();

    public ADirectory removeRoot(String var1);

    public boolean addRoot(ADirectory var1);

    public boolean removeRoot(ADirectory var1);

    public <R> R accessRoots(Function<? super XGettingTable<String, ADirectory>, R> var1);

    public <I extends AItem> I validateMember(I var1);

    default public String assemblePath(AFile file) {
        return this.assemblePath(file, VarString.New()).toString();
    }

    default public String assemblePath(ADirectory directory) {
        return this.assemblePath(directory, VarString.New()).toString();
    }

    public String deriveFileIdentifier(String var1, String var2);

    public String deriveFileName(String var1);

    public String deriveFileType(String var1);

    public VarString assemblePath(AFile var1, VarString var2);

    public VarString assemblePath(ADirectory var1, VarString var2);

    public String[] buildPath(AItem var1);

    default public String[] buildPath(AFile file) {
        return this.buildPath((AItem)file);
    }

    default public String[] buildPath(ADirectory directory) {
        return this.buildPath((AItem)directory);
    }

    public String getFileName(AFile var1);

    public String getFileType(AFile var1);

    public static abstract class Abstract<H extends AIoHandler, D, F>
    implements AFileSystem,
    AResolver<D, F>,
    ACreator {
        private final String defaultProtocol;
        private final EqHashTable<String, ADirectory> rootDirectories = EqHashTable.New();
        private final ACreator creator;
        private final AccessManager accessManager;
        private final H ioHandler;

        protected Abstract(String defaultProtocol, H ioHandler) {
            this(defaultProtocol, null, ioHandler);
        }

        protected Abstract(String defaultProtocol, ACreator.Creator creatorCreator, H ioHandler) {
            this(defaultProtocol, creatorCreator, AccessManager::New, ioHandler);
        }

        protected Abstract(String defaultProtocol, ACreator.Creator creatorCreator, AccessManager.Creator accessManagerCreator, H ioHandler) {
            this.defaultProtocol = defaultProtocol;
            this.creator = this.ensureCreator(creatorCreator);
            this.ioHandler = ioHandler;
            this.accessManager = accessManagerCreator.createAccessManager(this);
        }

        @Override
        public final void validateIsWritable() {
            this.ioHandler.validateIsWritable();
        }

        @Override
        public final boolean isWritable() {
            return this.ioHandler.isWritable();
        }

        protected ACreator ensureCreator(ACreator.Creator creatorCreator) {
            return creatorCreator == null ? this : creatorCreator.createCreator(this);
        }

        @Override
        public AFileSystem fileSystem() {
            return this;
        }

        @Override
        public final String defaultProtocol() {
            return this.defaultProtocol;
        }

        @Override
        public ACreator creator() {
            return this.creator;
        }

        @Override
        public AccessManager accessManager() {
            return this.accessManager;
        }

        public H ioHandler() {
            return this.ioHandler;
        }

        @Override
        public final synchronized ADirectory lookupRoot(String identifier) {
            return (ADirectory)this.rootDirectories.get((Object)identifier);
        }

        @Override
        public final synchronized ADirectory getRoot(String identifier) {
            ADirectory existing = this.lookupRoot(identifier);
            if (existing != null) {
                return existing;
            }
            throw new AfsExceptionUnresolvableRoot("No root directory found with identifier \"" + identifier + "\".");
        }

        @Override
        public final synchronized ADirectory ensureRoot(String identifier) {
            return this.ensureRoot(this.creator, identifier);
        }

        @Override
        public final synchronized <I extends AItem> I validateMember(I item) {
            if (item.fileSystem() == this) {
                return item;
            }
            throw new AfsExceptionConsistency("Incompatible parent FileSystem of " + XChars.systemString(item) + ":" + XChars.systemString((Object)item.fileSystem()) + " != this (" + XChars.systemString((Object)this) + ").");
        }

        private boolean validateRegisteredRootDirectory(ADirectory rootDirectory) {
            String rootIdentifier = rootDirectory.identifier();
            ADirectory registered = (ADirectory)this.rootDirectories.get((Object)rootIdentifier);
            if (registered == null) {
                return false;
            }
            if (registered == rootDirectory) {
                return true;
            }
            throw new AfsExceptionConsistency("Inconsistent root directories for identifier \"" + rootIdentifier + "\": " + XChars.systemString((Object)registered) + " != " + XChars.systemString((Object)rootDirectory));
        }

        private void validateIsUnusedRootDirectory(ADirectory rootDirectory) {
            if (!this.accessManager.isUsed(rootDirectory)) {
                return;
            }
            throw new AfsExceptionMutationInUse("Root directory \"" + rootDirectory.identifier() + " is used an cannot be removed.");
        }

        @Override
        public final synchronized ADirectory ensureRoot(ARoot.Creator rootCreator, String identifier) {
            ADirectory root = (ADirectory)this.rootDirectories.get((Object)identifier);
            if (root != null) {
                return root;
            }
            root = rootCreator.createRootDirectory(this, identifier);
            this.rootDirectories.add((Object)identifier, (Object)root);
            return root;
        }

        @Override
        public ADirectory ensureDefaultRoot() {
            throw new UnsupportedOperationException("This file system implementation (" + this.getClass().getName() + ") doesn't support a default root. " + "Please ensure to create files only in named parent directories.");
        }

        @Override
        public final synchronized boolean addRoot(ADirectory rootDirectory) {
            this.validateMember(rootDirectory);
            if (this.validateRegisteredRootDirectory(rootDirectory)) {
                return false;
            }
            return this.rootDirectories.add((Object)rootDirectory.identifier(), (Object)rootDirectory);
        }

        @Override
        public final synchronized ADirectory removeRoot(String name) {
            ADirectory rootDirectory = this.getRoot(name);
            this.removeRoot(rootDirectory);
            return rootDirectory;
        }

        @Override
        public final synchronized boolean removeRoot(ADirectory rootDirectory) {
            if (!this.validateRegisteredRootDirectory(rootDirectory)) {
                return false;
            }
            this.validateIsUnusedRootDirectory(rootDirectory);
            this.rootDirectories.removeFor((Object)rootDirectory.identifier());
            return true;
        }

        @Override
        public final synchronized <R> R accessRoots(Function<? super XGettingTable<String, ADirectory>, R> logic) {
            return logic.apply((XGettingTable<String, ADirectory>)this.rootDirectories);
        }

        @Override
        public final synchronized ADirectory resolveDirectoryPath(String[] pathElements, int offset, int length) {
            ADirectory root = this.getRoot(pathElements[offset]);
            return root.resolveDirectoryPath(pathElements, offset + 1, length - 1);
        }

        @Override
        public final synchronized ADirectory ensureDirectoryPath(String[] pathElements, int offset, int length) {
            ADirectory root;
            if (length <= 0) {
                return this.ensureDefaultRoot();
            }
            XArrays.validateArrayRange((Object[])pathElements, (int)offset, (int)length);
            ADirectory directory = root = this.ensureRoot(pathElements[offset]);
            int o = offset + 1;
            int l = length - 1;
            while (l > 0) {
                String pathElement = pathElements[o];
                ADirectory elementDir = directory.getDirectory(pathElement);
                if (elementDir == null) {
                    elementDir = directory.ensureDirectory(pathElement);
                }
                directory = elementDir;
                ++o;
                --l;
            }
            return directory;
        }

        @Override
        public final synchronized AFile ensureFilePath(String[] directoryPathElements, int offset, int length, String fileIdentifier) {
            ADirectory directory = this.ensureDirectoryPath(directoryPathElements, offset, length);
            AFile file = directory.getFile(fileIdentifier);
            if (file == null) {
                file = directory.ensureFile(fileIdentifier);
            }
            return file;
        }

        protected abstract VarString assembleItemPath(AItem var1, VarString var2);

        @Override
        public VarString assemblePath(ADirectory directory, VarString vs) {
            return this.assembleItemPath(directory, vs);
        }

        @Override
        public VarString assemblePath(AFile file, VarString vs) {
            return this.assembleItemPath(file, vs);
        }

        @Override
        public String[] buildPath(AItem item) {
            return AItem.buildItemPath(item);
        }

        @Override
        public ARoot createRootDirectory(AFileSystem fileSystem, String protocol, String identifier) {
            return ARoot.New(fileSystem, protocol, identifier);
        }
    }
}

