/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.types;

import one.microstream.afs.exceptions.AfsExceptionReadOnly;

@FunctionalInterface
public interface WriteController {
    default public void validateIsWritable() {
        if (this.isWritable()) {
            return;
        }
        throw new AfsExceptionReadOnly("Writing is not enabled.");
    }

    public boolean isWritable();

    public static WriteController Enabled() {
        return new Enabled();
    }

    public static WriteController Disabled() {
        return new Disabled();
    }

    public static final class Disabled
    implements WriteController {
        Disabled() {
        }

        @Override
        public final boolean isWritable() {
            return false;
        }
    }

    public static final class Enabled
    implements WriteController {
        Enabled() {
        }

        @Override
        public final void validateIsWritable() {
        }

        @Override
        public final boolean isWritable() {
            return true;
        }
    }
}

