/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.types;

import java.nio.ByteBuffer;
import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AReadableFile;

public interface AWritableFile
extends AReadableFile {
    @Override
    default public boolean open() {
        return this.actual().fileSystem().ioHandler().openWriting(this);
    }

    @Override
    default public AWritableFile useWriting(Object user) {
        return this.fileSystem().accessManager().useWriting(this, user);
    }

    @Override
    default public AWritableFile useWriting() {
        return this.fileSystem().accessManager().useWriting(this);
    }

    @Override
    default public long copyTo(AWritableFile target) {
        return this.actual().fileSystem().ioHandler().copyTo(this, target);
    }

    @Override
    default public long copyTo(AWritableFile target, long sourcePosition) {
        return this.actual().fileSystem().ioHandler().copyTo(this, sourcePosition, target);
    }

    @Override
    default public long copyTo(AWritableFile target, long sourcePosition, long length) {
        return this.actual().fileSystem().ioHandler().copyTo(this, sourcePosition, length, target);
    }

    default public long copyFrom(AReadableFile source) {
        return this.actual().fileSystem().ioHandler().copyFrom(source, this);
    }

    default public long copyFrom(AReadableFile source, long sourcePosition) {
        return this.actual().fileSystem().ioHandler().copyFrom(source, sourcePosition, this);
    }

    default public long copyFrom(AReadableFile source, long sourcePosition, long length) {
        return this.actual().fileSystem().ioHandler().copyFrom(source, sourcePosition, length, this);
    }

    default public long writeBytes(ByteBuffer source) {
        return this.writeBytes((Iterable<? extends ByteBuffer>)X.Constant((Object)source));
    }

    default public long writeBytes(Iterable<? extends ByteBuffer> sources) {
        return this.actual().fileSystem().ioHandler().writeBytes(this, sources);
    }

    default public void create() {
        this.actual().fileSystem().ioHandler().create(this);
    }

    @Override
    default public boolean ensureExists() {
        return this.actual().fileSystem().ioHandler().ensureExists(this);
    }

    default public boolean delete() {
        return this.actual().fileSystem().ioHandler().deleteFile(this);
    }

    default public void moveTo(ADirectory targetDirectory) {
        AFile targetFile = targetDirectory.ensureFile(this.identifier(), this.name(), this.type());
        AWritableFile wFile = targetFile.useWriting();
        try {
            this.moveTo(wFile);
        }
        finally {
            wFile.release();
        }
    }

    default public void moveTo(AWritableFile targetFile) {
        this.actual().fileSystem().ioHandler().moveFile(this, targetFile);
    }

    default public AReadableFile downgrade() {
        return this.actual().fileSystem().accessManager().downgrade(this);
    }

    default public void truncate(long newSize) {
        this.actual().fileSystem().ioHandler().truncate(this, newSize);
    }
}

