/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.types;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.chars.XChars;
import one.microstream.collections.HashEnum;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.io.XIO;
import one.microstream.memory.XMemory;

public class AFS {
    public static XGettingEnum<AItem> listItems(ADirectory directory, Predicate<? super AItem> selector) {
        return (XGettingEnum)AFS.listFiles(directory, selector, HashEnum.New());
    }

    public static <C extends Consumer<? super AItem>> C listItems(ADirectory directory, Predicate<? super AItem> selector, C collector) {
        directory.iterateItems(f -> {
            if (selector.test((AItem)f)) {
                collector.accept(f);
            }
        });
        return collector;
    }

    public static XGettingEnum<ADirectory> listDirectories(ADirectory directory, Predicate<? super ADirectory> selector) {
        return (XGettingEnum)AFS.listDirectories(directory, selector, HashEnum.New());
    }

    public static <C extends Consumer<? super ADirectory>> C listDirectories(ADirectory directory, Predicate<? super ADirectory> selector, C collector) {
        directory.iterateDirectories(f -> {
            if (selector.test((ADirectory)f)) {
                collector.accept(f);
            }
        });
        return collector;
    }

    public static XGettingEnum<AFile> listFiles(ADirectory directory, Predicate<? super AFile> selector) {
        return (XGettingEnum)AFS.listFiles(directory, selector, HashEnum.New());
    }

    public static <C extends Consumer<? super AFile>> C listFiles(ADirectory directory, Predicate<? super AFile> selector, C collector) {
        directory.iterateFiles(f -> {
            if (selector.test((AFile)f)) {
                collector.accept(f);
            }
        });
        return collector;
    }

    public static <D extends ADirectory> D ensureExists(D directory) {
        if (!directory.exists()) {
            directory.ensureExists();
        }
        return directory;
    }

    public static String readString(AFile file) {
        return AFS.readString(file, XChars.standardCharset());
    }

    public static String readString(AFile file, Charset charSet) {
        byte[] bytes = AFS.read_bytes(file);
        return XChars.String((byte[])bytes, (Charset)charSet);
    }

    public static byte[] read_bytes(AFile file) {
        ByteBuffer content = AFS.apply(file, f -> f.readBytes());
        byte[] bytes = XMemory.toArray((ByteBuffer)content);
        XMemory.deallocateDirectByteBuffer((ByteBuffer)content);
        return bytes;
    }

    public static final long writeString(AFile file, String string) {
        return AFS.writeString(file, string, XChars.standardCharset());
    }

    public static final long writeString(AFile file, String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        return AFS.write_bytes(file, bytes);
    }

    public static final long write_bytes(AFile file, byte[] bytes) {
        ByteBuffer dbb = XIO.wrapInDirectByteBuffer((byte[])bytes);
        Long writeCount = AFS.writeBytes(file, dbb);
        XMemory.deallocateDirectByteBuffer((ByteBuffer)dbb);
        return writeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R apply(AFile file, Function<? super AReadableFile, R> logic) {
        AReadableFile rFile = file.useReading();
        try {
            R r = logic.apply(rFile);
            return r;
        }
        finally {
            rFile.release();
        }
    }

    public static void execute(AFile file, Consumer<? super AReadableFile> logic) {
        AReadableFile rFile = file.useReading();
        try {
            logic.accept(rFile);
        }
        finally {
            rFile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(AFile file, Object user, Consumer<? super AReadableFile> logic) {
        AReadableFile rFile = file.useReading(user);
        try {
            logic.accept(rFile);
        }
        finally {
            rFile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeBytes(AFile file, ByteBuffer bytes) {
        AWritableFile wFile = file.useWriting();
        try {
            long l = wFile.writeBytes(bytes);
            return l;
        }
        finally {
            wFile.release();
        }
    }

    public static void executeWriting(AFile file, Consumer<? super AWritableFile> logic) {
        AFS.executeWriting(file, file.defaultUser(), logic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWriting(AFile file, Object user, Consumer<? super AWritableFile> logic) {
        AWritableFile writableFile = file.useWriting(user);
        try {
            logic.accept(writableFile);
        }
        finally {
            writableFile.release();
        }
    }

    public static <R> R applyWriting(AFile file, Function<? super AWritableFile, R> logic) {
        return AFS.applyWriting(file, file.defaultUser(), logic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R applyWriting(AFile file, Object user, Function<? super AWritableFile, R> logic) {
        AWritableFile writableFile = file.useWriting(user);
        try {
            R r = logic.apply(writableFile);
            return r;
        }
        finally {
            writableFile.release();
        }
    }

    public static <R> R tryApplyWriting(AFile file, Function<? super AWritableFile, R> logic) {
        return AFS.tryApplyWriting(file, file.defaultUser(), logic);
    }

    public static <R> R tryApplyWritingDefaulting(AFile file, R defaultValue, Function<? super AWritableFile, R> logic) {
        return AFS.tryApplyWritingDefaulting(file, file.defaultUser(), defaultValue, logic);
    }

    public static <R> R tryApplyWriting(AFile file, Object user, Function<? super AWritableFile, R> logic) {
        return AFS.tryApplyWritingDefaulting(file, user, null, logic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R tryApplyWritingDefaulting(AFile file, Object user, R defaultValue, Function<? super AWritableFile, R> logic) {
        AWritableFile writableFile = file.tryUseWriting(user);
        if (writableFile == null) {
            return defaultValue;
        }
        try {
            R r = logic.apply(writableFile);
            return r;
        }
        finally {
            writableFile.release();
        }
    }

    public static void close(AReadableFile file, Throwable cause) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (Throwable t) {
            if (cause != null) {
                t.addSuppressed(cause);
            }
            throw t;
        }
    }

    private AFS() {
        throw new UnsupportedOperationException();
    }
}

