/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.types;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFileSystem;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.collections.XArrays;

public interface AFile
extends AItem {
    @Override
    default public String toPathString() {
        return this.fileSystem().assemblePath(this);
    }

    @Override
    default public String[] toPath() {
        return this.fileSystem().buildPath(this);
    }

    default public String name() {
        return this.fileSystem().getFileName(this);
    }

    default public String type() {
        return this.fileSystem().getFileType(this);
    }

    default public long size() {
        return this.fileSystem().ioHandler().size(this);
    }

    default public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean registerObserver(Observer var1);

    public boolean removeObserver(Observer var1);

    public <C extends Consumer<? super Observer>> C iterateObservers(C var1);

    default public AReadableFile useReading(Object user) {
        return this.fileSystem().accessManager().useReading(this, user);
    }

    default public AWritableFile useWriting(Object user) {
        return this.fileSystem().accessManager().useWriting(this, user);
    }

    default public AReadableFile useReading() {
        return this.fileSystem().accessManager().useReading(this);
    }

    default public AWritableFile useWriting() {
        return this.fileSystem().accessManager().useWriting(this);
    }

    default public AReadableFile tryUseReading(Object user) {
        return this.fileSystem().accessManager().tryUseReading(this, user);
    }

    default public AWritableFile tryUseWriting(Object user) {
        return this.fileSystem().accessManager().tryUseWriting(this, user);
    }

    default public AReadableFile tryUseReading() {
        return this.fileSystem().accessManager().tryUseReading(this);
    }

    default public AWritableFile tryUseWriting() {
        return this.fileSystem().accessManager().tryUseWriting(this);
    }

    @Override
    default public boolean exists() {
        return this.fileSystem().ioHandler().exists(this);
    }

    default public boolean ensureExists() {
        return AFS.applyWriting(this, wf -> wf.ensureExists());
    }

    default public boolean isUsed() {
        return this.fileSystem().accessManager().isUsed(this);
    }

    default public Object defaultUser() {
        return this.fileSystem().accessManager().defaultUser();
    }

    public static AFile New(ADirectory parent, String identifier) {
        return new Default((ADirectory)X.notNull((Object)parent), (String)X.notNull((Object)identifier));
    }

    public static AFile actual(AFile file) {
        return file instanceof Wrapper ? ((Wrapper)file).actual() : file;
    }

    public static interface Wrapper
    extends AFile,
    AItem.Wrapper {
        @Override
        public AFile actual();

        public static abstract class Abstract<U>
        extends AItem.Base
        implements Wrapper {
            private final AFile actual;
            private final U user;

            protected Abstract(AFile actual, U user) {
                this.actual = (AFile)X.notNull((Object)actual);
                this.user = X.notNull(user);
            }

            protected Object mutex() {
                return this.actual;
            }

            public U user() {
                return this.user;
            }

            @Override
            public AFile actual() {
                return this.actual instanceof Wrapper ? ((Wrapper)this.actual).actual() : this.actual;
            }

            @Override
            public AFileSystem fileSystem() {
                return this.actual.fileSystem();
            }

            @Override
            public boolean registerObserver(Observer observer) {
                return this.actual.registerObserver(observer);
            }

            @Override
            public boolean removeObserver(Observer observer) {
                return this.actual.removeObserver(observer);
            }

            @Override
            public <C extends Consumer<? super Observer>> C iterateObservers(C logic) {
                return this.actual.iterateObservers(logic);
            }

            @Override
            public ADirectory parent() {
                return this.actual.parent();
            }

            @Override
            public String identifier() {
                return this.actual.identifier();
            }

            @Override
            public String name() {
                return this.actual.name();
            }

            @Override
            public String type() {
                return this.actual.type();
            }

            @Override
            public boolean exists() {
                return this.actual.exists();
            }
        }
    }

    public static interface Observer {
        default public void onBeforeFileWrite(AWritableFile targetFile, Iterable<? extends ByteBuffer> sources) {
        }

        default public void onAfterFileWrite(AWritableFile targetFile, Iterable<? extends ByteBuffer> sources, long writeCount) {
        }

        default public void onBeforeFileMove(AWritableFile sourceFile, AWritableFile targetFile) {
        }

        default public void onAfterFileMove(AWritableFile sourceFile, AWritableFile targetFile) {
        }

        default public void onBeforeFileClose(AReadableFile fileToClose) {
        }

        default public void onAfterFileClose(AReadableFile closedFile, boolean result) {
        }

        default public void onBeforeFileCreate(AWritableFile fileToCreate) {
        }

        default public void onAfterFileCreate(AWritableFile fileToCreate) {
        }

        default public void onBeforeFileTruncation(AWritableFile fileToTruncate, long newSize) {
        }

        default public void onAfterFileTruncation(AWritableFile truncatedFile, long newSize) {
        }

        default public void onBeforeFileDelete(AWritableFile fileToDelete) {
        }

        default public void onAfterFileDelete(AWritableFile deletedFile, boolean result) {
        }
    }

    public static class Default
    extends AItem.Abstract
    implements AFile {
        private static final Observer[] NO_OBSERVERS = new Observer[0];
        final ADirectory parent;
        private Observer[] observers = NO_OBSERVERS;

        protected Default(ADirectory parent, String identifier) {
            super(identifier);
            this.parent = parent;
        }

        @Override
        public final ADirectory parent() {
            return this.parent;
        }

        @Override
        public final AFileSystem fileSystem() {
            return this.parent.fileSystem();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean registerObserver(Observer observer) {
            Object object = this.mutex();
            synchronized (object) {
                if (this.observers == NO_OBSERVERS) {
                    this.observers = (Observer[])X.Array((Object)observer);
                    return true;
                }
                if (!XArrays.contains((Object[])this.observers, (Object)observer)) {
                    this.observers = (Observer[])XArrays.add((Object[])this.observers, (Object)observer);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean removeObserver(Observer observer) {
            Object object = this.mutex();
            synchronized (object) {
                if (this.observers.length == 1 && this.observers[0] == observer) {
                    this.observers = NO_OBSERVERS;
                    return true;
                }
                if (this.observers == NO_OBSERVERS) {
                    return false;
                }
                int index = XArrays.indexOf((Object)observer, (Object[])this.observers);
                if (index >= 0) {
                    XArrays.remove((Object[])this.observers, (int)index);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <C extends Consumer<? super Observer>> C iterateObservers(C logic) {
            Object object = this.mutex();
            synchronized (object) {
                return (C)XArrays.iterate((Object[])this.observers, logic);
            }
        }
    }
}

