/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.types;

import java.nio.ByteBuffer;
import one.microstream.X;
import one.microstream.afs.exceptions.AfsExceptionConsistency;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AItem;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.afs.types.WriteController;
import one.microstream.chars.XChars;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.io.BufferProvider;
import one.microstream.memory.XMemory;
import one.microstream.util.UtilStackTrace;

public interface AIoHandler
extends WriteController {
    public boolean isHandledItem(AItem var1);

    public boolean isHandledFile(AFile var1);

    public boolean isHandledDirectory(ADirectory var1);

    public boolean isHandledReadableFile(AReadableFile var1);

    public boolean isHandledWritableFile(AWritableFile var1);

    public void validateHandledFile(AFile var1);

    public void validateHandledDirectory(ADirectory var1);

    public void validateHandledReadableFile(AReadableFile var1);

    public void validateHandledWritableFile(AWritableFile var1);

    public long size(AFile var1);

    public boolean exists(AFile var1);

    public boolean exists(ADirectory var1);

    public void create(ADirectory var1);

    public void create(AWritableFile var1);

    public boolean ensureExists(ADirectory var1);

    public boolean ensureExists(AWritableFile var1);

    public void inventorize(ADirectory var1);

    public boolean isOpen(AReadableFile var1);

    public boolean openReading(AReadableFile var1);

    public boolean openWriting(AWritableFile var1);

    public boolean close(AReadableFile var1);

    public ByteBuffer readBytes(AReadableFile var1);

    public ByteBuffer readBytes(AReadableFile var1, long var2);

    public ByteBuffer readBytes(AReadableFile var1, long var2, long var4);

    public long readBytes(AReadableFile var1, ByteBuffer var2);

    public long readBytes(AReadableFile var1, ByteBuffer var2, long var3);

    public long readBytes(AReadableFile var1, ByteBuffer var2, long var3, long var5);

    public long readBytes(AReadableFile var1, BufferProvider var2);

    public long readBytes(AReadableFile var1, BufferProvider var2, long var3);

    public long readBytes(AReadableFile var1, BufferProvider var2, long var3, long var5);

    public long copyTo(AReadableFile var1, AWritableFile var2);

    public long copyTo(AReadableFile var1, long var2, AWritableFile var4);

    public long copyTo(AReadableFile var1, long var2, long var4, AWritableFile var6);

    public long copyFrom(AReadableFile var1, AWritableFile var2);

    public long copyFrom(AReadableFile var1, long var2, AWritableFile var4);

    public long copyFrom(AReadableFile var1, long var2, long var4, AWritableFile var6);

    public long writeBytes(AWritableFile var1, Iterable<? extends ByteBuffer> var2);

    public void moveFile(AWritableFile var1, AWritableFile var2);

    public boolean deleteFile(AWritableFile var1);

    public void truncate(AWritableFile var1, long var2);

    public XGettingEnum<String> listItems(ADirectory var1);

    public XGettingEnum<String> listDirectories(ADirectory var1);

    public XGettingEnum<String> listFiles(ADirectory var1);

    public boolean isEmpty(ADirectory var1);

    public static abstract class Abstract<FS, DS, I extends AItem, F extends AFile, D extends ADirectory, R extends AReadableFile, W extends AWritableFile>
    implements AIoHandler {
        private final WriteController writeController;
        private final Class<I> typeItem;
        private final Class<F> typeFile;
        private final Class<D> typeDirectory;
        private final Class<R> typeReadableFile;
        private final Class<W> typeWritableFile;

        protected Abstract(WriteController writeController, Class<I> typeItem, Class<F> typeFile, Class<D> typeDirectory, Class<R> typeReadableFile, Class<W> typeWritableFile) {
            this.writeController = (WriteController)X.notNull((Object)writeController);
            this.typeItem = (Class)X.notNull(typeItem);
            this.typeFile = (Class)X.notNull(typeFile);
            this.typeDirectory = (Class)X.notNull(typeDirectory);
            this.typeReadableFile = (Class)X.notNull(typeReadableFile);
            this.typeWritableFile = (Class)X.notNull(typeWritableFile);
        }

        @Override
        public final void validateIsWritable() {
            this.writeController.validateIsWritable();
        }

        @Override
        public final boolean isWritable() {
            return this.writeController.isWritable();
        }

        protected abstract long specificSize(F var1);

        protected abstract boolean specificExists(F var1);

        protected abstract boolean specificExists(D var1);

        protected abstract XGettingEnum<String> specificListItems(D var1);

        protected abstract XGettingEnum<String> specificListDirectories(D var1);

        protected abstract XGettingEnum<String> specificListFiles(D var1);

        protected abstract void specificInventorize(D var1);

        protected abstract boolean specificIsEmpty(D var1);

        protected abstract boolean specificIsOpen(R var1);

        protected abstract boolean specificOpenReading(R var1);

        protected abstract boolean specificOpenWriting(W var1);

        protected abstract boolean specificClose(R var1);

        protected abstract void specificCreate(D var1);

        protected abstract void specificCreate(W var1);

        protected abstract ByteBuffer specificReadBytes(R var1);

        protected abstract ByteBuffer specificReadBytes(R var1, long var2);

        protected abstract ByteBuffer specificReadBytes(R var1, long var2, long var4);

        protected abstract long specificReadBytes(R var1, ByteBuffer var2);

        protected abstract long specificReadBytes(R var1, ByteBuffer var2, long var3);

        protected abstract long specificReadBytes(R var1, ByteBuffer var2, long var3, long var5);

        protected abstract long specificReadBytes(R var1, BufferProvider var2);

        protected abstract long specificReadBytes(R var1, BufferProvider var2, long var3);

        protected abstract long specificReadBytes(R var1, BufferProvider var2, long var3, long var5);

        protected abstract long specificCopyTo(R var1, AWritableFile var2);

        protected abstract long specificCopyTo(R var1, long var2, AWritableFile var4);

        protected abstract long specificCopyTo(R var1, long var2, long var4, AWritableFile var6);

        protected abstract long specificCopyFrom(AReadableFile var1, W var2);

        protected abstract long specificCopyFrom(AReadableFile var1, long var2, W var4);

        protected abstract long specificCopyFrom(AReadableFile var1, long var2, long var4, W var6);

        protected abstract long specificWriteBytes(W var1, Iterable<? extends ByteBuffer> var2);

        protected abstract void specificMoveFile(W var1, AWritableFile var2);

        protected abstract boolean specificDeleteFile(W var1);

        protected abstract void specificTruncateFile(W var1, long var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long copyGeneric(AReadableFile source, AWritableFile target) {
            long sourceSize = source.size();
            ByteBuffer dbb = XMemory.allocateDirectNative((long)sourceSize);
            try {
                source.readBytes(dbb);
                dbb.flip();
                target.writeBytes(dbb);
            }
            finally {
                XMemory.deallocateDirectByteBuffer((ByteBuffer)dbb);
            }
            return sourceSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long copyGeneric(AReadableFile source, long sourcePosition, AWritableFile target) {
            long sourceSize = source.size();
            long length = sourceSize - sourcePosition;
            X.validateRange((long)sourceSize, (long)sourcePosition, (long)length);
            ByteBuffer dbb = XMemory.allocateDirectNative((long)length);
            try {
                source.readBytes(dbb, sourcePosition);
                dbb.flip();
                target.writeBytes(dbb);
            }
            finally {
                XMemory.deallocateDirectByteBuffer((ByteBuffer)dbb);
            }
            return length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long copyGeneric(AReadableFile source, long sourcePosition, AWritableFile target, long length) {
            long sourceSize = source.size();
            X.validateRange((long)sourceSize, (long)sourcePosition, (long)length);
            ByteBuffer dbb = XMemory.allocateDirectNative((long)length);
            try {
                source.readBytes(dbb, sourcePosition);
                dbb.flip();
                target.writeBytes(dbb);
            }
            finally {
                XMemory.deallocateDirectByteBuffer((ByteBuffer)dbb);
            }
            return length;
        }

        protected RuntimeException createUnhandledTypeException(Object subject, Class<?> checkedType) {
            return this.createUnhandledTypeException(subject, checkedType, 1);
        }

        protected RuntimeException createUnhandledTypeException(Object subject, Class<?> checkedType, int cutStackTrace) {
            return (RuntimeException)UtilStackTrace.cutStacktraceByN((Throwable)((Object)new AfsExceptionConsistency("Instance is not of type \"" + checkedType + "\" and thus cannot be handled: " + XChars.systemString((Object)subject))), (int)(cutStackTrace + 1));
        }

        protected RuntimeException createUnhandledTypeExceptionItem(Object subject) {
            return this.createUnhandledTypeException(subject, this.typeItem, 1);
        }

        protected RuntimeException createUnhandledTypeExceptionFile(Object subject) {
            return this.createUnhandledTypeException(subject, this.typeFile, 1);
        }

        protected RuntimeException createUnhandledTypeExceptionDirectory(Object subject) {
            return this.createUnhandledTypeException(subject, this.typeDirectory, 1);
        }

        protected RuntimeException createUnhandledTypeExceptionReadableFile(Object subject) {
            return this.createUnhandledTypeException(subject, this.typeReadableFile, 1);
        }

        protected RuntimeException createUnhandledTypeExceptionWritableFile(Object subject) {
            return this.createUnhandledTypeException(subject, this.typeWritableFile, 1);
        }

        @Override
        public boolean isHandledItem(AItem item) {
            return this.typeItem.isInstance(item);
        }

        @Override
        public boolean isHandledFile(AFile file) {
            return this.typeFile.isInstance(file);
        }

        @Override
        public boolean isHandledDirectory(ADirectory directory) {
            return this.typeDirectory.isInstance(directory);
        }

        @Override
        public boolean isHandledReadableFile(AReadableFile file) {
            return this.typeReadableFile.isInstance(file);
        }

        @Override
        public boolean isHandledWritableFile(AWritableFile file) {
            return this.typeWritableFile.isInstance(file);
        }

        @Override
        public final void validateHandledFile(AFile file) {
            if (this.isHandledFile(file)) {
                return;
            }
            throw this.createUnhandledTypeExceptionFile(file);
        }

        @Override
        public final void validateHandledDirectory(ADirectory directory) {
            if (this.isHandledDirectory(directory)) {
                return;
            }
            throw this.createUnhandledTypeExceptionDirectory(directory);
        }

        @Override
        public final void validateHandledReadableFile(AReadableFile file) {
            if (this.isHandledReadableFile(file)) {
                return;
            }
            throw this.createUnhandledTypeExceptionReadableFile(file);
        }

        @Override
        public final void validateHandledWritableFile(AWritableFile file) {
            if (this.isHandledWritableFile(file)) {
                return;
            }
            throw this.createUnhandledTypeExceptionWritableFile(file);
        }

        protected R castReadableFile(AReadableFile file) {
            this.validateHandledReadableFile(file);
            return (R)((AReadableFile)this.typeReadableFile.cast(file));
        }

        protected W castWritableFile(AWritableFile file) {
            this.validateHandledWritableFile(file);
            return (W)((AWritableFile)this.typeWritableFile.cast(file));
        }

        protected abstract FS toSubjectFile(AFile var1);

        protected abstract DS toSubjectDirectory(ADirectory var1);

        protected abstract long subjectFileSize(FS var1);

        protected abstract boolean subjectFileExists(FS var1);

        protected abstract boolean subjectDirectoryExists(DS var1);

        @Override
        public long size(AFile file) {
            if (!this.isHandledFile(file)) {
                return this.subjectFileSize(this.toSubjectFile(file));
            }
            return this.specificSize((AFile)this.typeFile.cast(file));
        }

        @Override
        public boolean exists(AFile file) {
            if (!this.isHandledFile(file)) {
                return this.subjectFileExists(this.toSubjectFile(file));
            }
            return this.specificExists((D)((AFile)this.typeFile.cast(file)));
        }

        @Override
        public boolean exists(ADirectory directory) {
            if (directory.parent() == null && directory.identifier().isEmpty()) {
                return true;
            }
            if (!this.isHandledDirectory(directory)) {
                return this.subjectDirectoryExists(this.toSubjectDirectory(directory));
            }
            return this.specificExists((D)((ADirectory)this.typeDirectory.cast(directory)));
        }

        @Override
        public XGettingEnum<String> listItems(ADirectory parent) {
            this.validateHandledDirectory(parent);
            return this.specificListItems((ADirectory)this.typeDirectory.cast(parent));
        }

        @Override
        public XGettingEnum<String> listDirectories(ADirectory parent) {
            this.validateHandledDirectory(parent);
            return this.specificListDirectories((ADirectory)this.typeDirectory.cast(parent));
        }

        @Override
        public XGettingEnum<String> listFiles(ADirectory parent) {
            this.validateHandledDirectory(parent);
            return this.specificListFiles((ADirectory)this.typeDirectory.cast(parent));
        }

        @Override
        public void inventorize(ADirectory directory) {
            this.validateHandledDirectory(directory);
            this.specificInventorize((ADirectory)this.typeDirectory.cast(directory));
        }

        @Override
        public boolean isEmpty(ADirectory directory) {
            this.validateHandledDirectory(directory);
            return this.specificIsEmpty((ADirectory)this.typeDirectory.cast(directory));
        }

        @Override
        public boolean openReading(AReadableFile file) {
            this.validateHandledReadableFile(file);
            return this.specificOpenReading((AReadableFile)this.typeReadableFile.cast(file));
        }

        @Override
        public boolean isOpen(AReadableFile file) {
            this.validateHandledReadableFile(file);
            return this.specificIsOpen((AReadableFile)this.typeReadableFile.cast(file));
        }

        @Override
        public boolean close(AReadableFile file) {
            this.validateHandledReadableFile(file);
            file.iterateObservers(o -> o.onBeforeFileClose(file));
            boolean result = this.specificClose((AReadableFile)this.typeReadableFile.cast(file));
            file.iterateObservers(o -> o.onAfterFileClose(file, result));
            return result;
        }

        @Override
        public boolean openWriting(AWritableFile file) {
            this.validateHandledWritableFile(file);
            this.validateIsWritable();
            return this.specificOpenWriting((AWritableFile)this.typeWritableFile.cast(file));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void create(ADirectory directory) {
            this.validateHandledDirectory(directory);
            ADirectory aDirectory = ADirectory.actual(directory);
            synchronized (aDirectory) {
                this.validateIsWritable();
                directory.iterateObservers(o -> o.onBeforeDirectoryCreate(directory));
                this.specificCreate((W)((ADirectory)this.typeDirectory.cast(directory)));
                directory.iterateObservers(o -> o.onAfterDirectoryCreate(directory));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void create(AWritableFile file) {
            this.validateHandledWritableFile(file);
            ADirectory parent = ADirectory.actual(file.parent());
            this.ensureExists(parent);
            ADirectory aDirectory = parent;
            synchronized (aDirectory) {
                this.validateIsWritable();
                file.parent().iterateObservers(o -> o.onBeforeFileCreate(file));
                AFile aFile = file.actual();
                synchronized (aFile) {
                    file.iterateObservers(o -> o.onBeforeFileCreate(file));
                    this.specificCreate((W)((AWritableFile)this.typeWritableFile.cast(file)));
                    file.iterateObservers(o -> o.onAfterFileCreate(file));
                }
                file.parent().iterateObservers(o -> o.onAfterFileCreate(file));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ensureExists(ADirectory directory) {
            ADirectory aDirectory = ADirectory.actual(directory);
            synchronized (aDirectory) {
                if (this.exists(directory)) {
                    return false;
                }
                this.create(directory);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ensureExists(AWritableFile file) {
            AFile aFile = file.actual();
            synchronized (aFile) {
                if (this.exists(file)) {
                    return false;
                }
                this.create(file);
            }
            return true;
        }

        @Override
        public ByteBuffer readBytes(AReadableFile sourceFile) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile));
        }

        @Override
        public ByteBuffer readBytes(AReadableFile sourceFile, long position) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile), position);
        }

        @Override
        public ByteBuffer readBytes(AReadableFile sourceFile, long position, long length) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile), position, length);
        }

        @Override
        public long readBytes(AReadableFile sourceFile, ByteBuffer targetBuffer) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile), targetBuffer);
        }

        @Override
        public long readBytes(AReadableFile sourceFile, ByteBuffer targetBuffer, long position) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile), targetBuffer, position);
        }

        @Override
        public long readBytes(AReadableFile sourceFile, ByteBuffer targetBuffer, long position, long length) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile), targetBuffer, position, length);
        }

        @Override
        public long readBytes(AReadableFile sourceFile, BufferProvider bufferProvider) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile), bufferProvider);
        }

        @Override
        public long readBytes(AReadableFile sourceFile, BufferProvider bufferProvider, long position) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile), bufferProvider, position);
        }

        @Override
        public long readBytes(AReadableFile sourceFile, BufferProvider bufferProvider, long position, long length) {
            this.validateHandledReadableFile(sourceFile);
            return this.specificReadBytes((AReadableFile)this.typeReadableFile.cast(sourceFile), bufferProvider, position, length);
        }

        @Override
        public long copyTo(AReadableFile sourceSubject, AWritableFile target) {
            if (sourceSubject.fileSystem() != target.fileSystem() || !this.isHandledReadableFile(sourceSubject) || !this.isHandledWritableFile(target)) {
                target.ensureExists();
                return this.copyGeneric(sourceSubject, target);
            }
            this.validateHandledReadableFile(sourceSubject);
            target.ensureExists();
            return this.specificCopyTo((AReadableFile)this.typeReadableFile.cast(sourceSubject), target);
        }

        @Override
        public long copyTo(AReadableFile sourceSubject, long sourcePosition, AWritableFile target) {
            if (sourceSubject.fileSystem() != target.fileSystem() || !this.isHandledReadableFile(sourceSubject) || !this.isHandledWritableFile(target)) {
                target.ensureExists();
                return this.copyGeneric(sourceSubject, sourcePosition, target);
            }
            this.validateHandledReadableFile(sourceSubject);
            target.ensureExists();
            this.validateIsWritable();
            return this.specificCopyTo((AReadableFile)this.typeReadableFile.cast(sourceSubject), sourcePosition, target);
        }

        @Override
        public long copyTo(AReadableFile sourceSubject, long sourcePosition, long length, AWritableFile target) {
            if (length == 0L) {
                return 0L;
            }
            if (sourceSubject.fileSystem() != target.fileSystem() || !this.isHandledReadableFile(sourceSubject) || !this.isHandledWritableFile(target)) {
                target.ensureExists();
                return this.copyGeneric(sourceSubject, sourcePosition, target, length);
            }
            this.validateHandledReadableFile(sourceSubject);
            target.ensureExists();
            this.validateIsWritable();
            return this.specificCopyTo((AReadableFile)this.typeReadableFile.cast(sourceSubject), sourcePosition, length, target);
        }

        @Override
        public long copyFrom(AReadableFile source, AWritableFile targetSubject) {
            if (source.fileSystem() != targetSubject.fileSystem() || !this.isHandledReadableFile(source) || !this.isHandledWritableFile(targetSubject)) {
                targetSubject.ensureExists();
                return this.copyGeneric(source, targetSubject);
            }
            this.validateHandledWritableFile(targetSubject);
            targetSubject.ensureExists();
            this.validateIsWritable();
            return this.specificCopyFrom(source, (AWritableFile)this.typeWritableFile.cast(targetSubject));
        }

        @Override
        public long copyFrom(AReadableFile source, long sourcePosition, AWritableFile targetSubject) {
            if (source.fileSystem() != targetSubject.fileSystem() || !this.isHandledReadableFile(source) || !this.isHandledWritableFile(targetSubject)) {
                targetSubject.ensureExists();
                return this.copyGeneric(source, sourcePosition, targetSubject);
            }
            this.validateHandledWritableFile(targetSubject);
            targetSubject.ensureExists();
            this.validateIsWritable();
            return this.specificCopyFrom(source, sourcePosition, (AWritableFile)this.typeWritableFile.cast(targetSubject));
        }

        @Override
        public long copyFrom(AReadableFile source, long sourcePosition, long length, AWritableFile targetSubject) {
            if (length == 0L) {
                return 0L;
            }
            if (source.fileSystem() != targetSubject.fileSystem() || !this.isHandledReadableFile(source) || !this.isHandledWritableFile(targetSubject)) {
                targetSubject.ensureExists();
                return this.copyGeneric(source, sourcePosition, targetSubject, length);
            }
            this.validateHandledWritableFile(targetSubject);
            targetSubject.ensureExists();
            this.validateIsWritable();
            return this.specificCopyFrom(source, sourcePosition, length, (AWritableFile)this.typeWritableFile.cast(targetSubject));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long writeBytes(AWritableFile targetFile, Iterable<? extends ByteBuffer> sourceBuffers) {
            this.validateHandledWritableFile(targetFile);
            AFile aFile = targetFile.actual();
            synchronized (aFile) {
                this.validateIsWritable();
                targetFile.iterateObservers(o -> o.onBeforeFileWrite(targetFile, sourceBuffers));
                long writeCount = this.specificWriteBytes((AWritableFile)this.typeWritableFile.cast(targetFile), sourceBuffers);
                targetFile.iterateObservers(o -> o.onAfterFileWrite(targetFile, sourceBuffers, writeCount));
                return writeCount;
            }
        }

        @Override
        public void moveFile(AWritableFile sourceFile, AWritableFile targetFile) {
            this.validateHandledWritableFile(sourceFile);
            ADirectory sourceParent = ADirectory.actual(sourceFile.parent());
            ADirectory targetParent = ADirectory.actual(targetFile.parent());
            this.validateIsWritable();
            targetParent.iterateObservers(o -> o.onBeforeFileMove(sourceFile, targetFile));
            sourceParent.iterateObservers(o -> o.onBeforeFileDelete(sourceFile));
            targetFile.iterateObservers(o -> o.onBeforeFileMove(sourceFile, targetFile));
            sourceFile.iterateObservers(o -> o.onBeforeFileDelete(sourceFile));
            this.specificMoveFile((AWritableFile)this.typeWritableFile.cast(sourceFile), targetFile);
            targetFile.iterateObservers(o -> o.onAfterFileMove(sourceFile, targetFile));
            sourceFile.iterateObservers(o -> o.onAfterFileDelete(sourceFile, true));
            targetParent.iterateObservers(o -> o.onAfterFileMove(sourceFile, targetFile));
            sourceParent.iterateObservers(o -> o.onAfterFileDelete(sourceFile, true));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean deleteFile(AWritableFile file) {
            boolean result;
            ADirectory parent;
            this.validateHandledWritableFile(file);
            ADirectory aDirectory = parent = ADirectory.actual(file.parent());
            synchronized (aDirectory) {
                this.validateIsWritable();
                file.parent().iterateObservers(o -> o.onBeforeFileDelete(file));
                AFile aFile = file.actual();
                synchronized (aFile) {
                    this.validateIsWritable();
                    file.iterateObservers(o -> o.onBeforeFileDelete(file));
                    result = this.specificDeleteFile((AWritableFile)this.typeWritableFile.cast(file));
                    if (result) {
                        file.close();
                    }
                    file.iterateObservers(o -> o.onAfterFileDelete(file, result));
                }
                file.parent().iterateObservers(o -> o.onAfterFileDelete(file, result));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncate(AWritableFile file, long newSize) {
            this.validateHandledWritableFile(file);
            AFile aFile = file.actual();
            synchronized (aFile) {
                this.validateIsWritable();
                file.iterateObservers(o -> o.onBeforeFileTruncation(file, newSize));
                this.specificTruncateFile((AWritableFile)this.typeWritableFile.cast(file), newSize);
                file.iterateObservers(o -> o.onAfterFileTruncation(file, newSize));
            }
        }
    }
}

