/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.afs.types;

import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFileSystem;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;

public interface AItem {
    public AFileSystem fileSystem();

    public ADirectory parent();

    public String toPathString();

    public String[] toPath();

    public String identifier();

    public boolean exists();

    public static char defaultSeparator() {
        return '/';
    }

    public static String[] buildItemPath(AItem item) {
        int depth = 0;
        for (AItem i = item; i != null; i = i.parent()) {
            ++depth;
        }
        String[] path = new String[depth];
        for (AItem i = item; i != null; i = i.parent()) {
            path[--depth] = i.identifier();
        }
        return path;
    }

    public static VarString assembleDebugString(AItem item, VarString vs) {
        XChars.addSystemString((Object)item, (VarString)vs);
        vs.add('(').add('\"');
        XChars.appendArraySeperated((VarString)vs, (char)AItem.defaultSeparator(), (Object[])AItem.buildItemPath(item));
        vs.add('\"').add(')');
        return vs;
    }

    public static AItem actual(AItem item) {
        return item instanceof Wrapper ? ((Wrapper)item).actual() : item;
    }

    public static interface Wrapper
    extends AItem {
        public AItem actual();

        public Object user();
    }

    public static abstract class Abstract
    extends Base {
        private final String identifier;

        protected Abstract(String identifier) {
            this.identifier = (String)X.notNull((Object)identifier);
        }

        @Override
        public final String identifier() {
            return this.identifier;
        }

        protected final Object mutex() {
            return this;
        }
    }

    public static abstract class Base
    implements AItem {
        public String toString() {
            VarString vs = VarString.New((int)50);
            AItem.assembleDebugString(this, vs);
            return vs.toString();
        }
    }
}

