/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.chars;

public class SimpleStringConcatenator {
    private int reservedCharCount;
    private final String[] parts;

    private static int countTotalChars(String[] parts) {
        int totalCharCount = 0;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                totalCharCount += s.length();
            }
            ++n2;
        }
        return totalCharCount;
    }

    public static StringBuilder assemble(StringBuilder sb, String[] parts, Object ... values) {
        int i = 0;
        while (i < parts.length && i < values.length) {
            sb.append(parts[i]).append(values[i++]);
        }
        while (i < parts.length) {
            sb.append(parts[i++]);
        }
        return sb;
    }

    public SimpleStringConcatenator(String[] parts) {
        this(parts, parts.length);
    }

    public SimpleStringConcatenator(String[] parts, int reservedValueCharacterCount) {
        this.reservedCharCount = SimpleStringConcatenator.countTotalChars(parts) + reservedValueCharacterCount < 0 ? 0 : reservedValueCharacterCount;
        this.parts = parts;
    }

    public SimpleStringConcatenator(String[] parts, float reservedValueCharacterFactor) {
        this(parts, (int)((float)SimpleStringConcatenator.countTotalChars(parts) * (reservedValueCharacterFactor < 1.0f ? 1.0f : reservedValueCharacterFactor)));
    }

    public int getReservedCharCount() {
        return this.reservedCharCount;
    }

    public String[] getParts() {
        return this.parts;
    }

    public void setReservedCharCount(int reservedCharCount) {
        this.reservedCharCount = reservedCharCount;
    }

    public StringBuilder assemble(Object ... values) {
        return SimpleStringConcatenator.assemble(new StringBuilder(this.reservedCharCount), this.parts, values);
    }

    public StringBuilder assemble(StringBuilder sb, Object ... values) {
        return SimpleStringConcatenator.assemble(sb, this.parts, values);
    }
}

