/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import one.microstream.X;
import one.microstream.collections.AbstractExtendedCollection;
import one.microstream.collections.interfaces.Sized;
import one.microstream.math.XMath;

public abstract class AbstractArrayCollection<E>
extends AbstractExtendedCollection<E>
implements Sized {
    private static final transient Object MARKER = new Object();

    protected static final <E> E marker() {
        return (E)MARKER;
    }

    protected static final <E> E[] newArray(int length) {
        return new Object[length];
    }

    protected static final <E> E[] newArray(int length, E[] oldData, int oldDataLength) {
        E[] newArray = AbstractArrayCollection.newArray(length);
        System.arraycopy(oldData, 0, newArray, 0, oldDataLength);
        return newArray;
    }

    public static final int pow2BoundMaxed(long n) {
        return XMath.pow2BoundMaxed(X.checkArrayRange(n));
    }

    protected abstract E[] internalGetStorageArray();
}

