/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Random;
import java.util.function.BiConsumer;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.XArrays;
import one.microstream.collections._intList;
import one.microstream.collections.interfaces._intCollecting;
import one.microstream.exceptions.IndexBoundsException;
import one.microstream.functional._intFunction;
import one.microstream.functional._intIndexProcedure;
import one.microstream.functional._intPredicate;
import one.microstream.functional._intProcedure;
import one.microstream.math.FastRandom;
import one.microstream.math.XMath;
import one.microstream.meta.NotImplementedYetError;

public abstract class Abstract_intArrayStorage {
    static final String exceptionSkipNegative(int skip) {
        return "Skip count may not be negative: " + skip;
    }

    static final String exceptionRange(int size, int offset, int length) {
        return "Range [" + (length < 0 ? String.valueOf(offset + length + 1) + ";" + offset : (length > 0 ? String.valueOf(offset) + ";" + (offset + length - 1) : String.valueOf(offset) + ";" + offset)) + "] not in [0;" + (size - 1) + "]";
    }

    static final String exceptionIndexOutOfBounds(long size, long index) {
        return "Index: " + index + ", Size: " + size;
    }

    private static String exceptionIllegalSwapBounds(int size, int indexA, int indexB, int length) {
        return "Illegal swap bounds: (" + indexA + " [" + length + "] -> " + indexB + " [" + length + "]) in range [0;" + (size - 1) + "]";
    }

    public static final int checkIterationDirection(int size, int offset, int length) {
        if (length > 0) {
            if (offset < 0 || offset + length > size) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
            }
            return 1;
        }
        if (length < 0) {
            if (offset >= size || offset + length < -1) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
            }
            return -1;
        }
        if (offset < 0 || offset >= size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
        }
        return 0;
    }

    public static final void validateRange0Based(int size, int offset, int length) {
        if (length > 0 ? offset < 0 || offset + length > size : (length < 0 ? offset >= size || offset + length < -1 : offset < 0 || offset >= size)) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
        }
    }

    public static final int addAll(int[] data, int size, int[] elements, int srcIndex, int srcLength, _intPredicate predicate) {
        int d;
        if (srcIndex < 0 || srcIndex >= elements.length) {
            throw new IndexBoundsException((long)elements.length, srcIndex);
        }
        if (srcLength > 0) {
            if (srcIndex + srcLength >= elements.length) {
                throw new IndexBoundsException((long)elements.length, srcIndex + srcLength);
            }
            d = 1;
        } else if (srcLength < 0) {
            if (srcIndex + srcLength < 0) {
                throw new IndexBoundsException((long)elements.length, srcIndex + srcLength);
            }
            d = -1;
        } else {
            return 0;
        }
        int endIndex = srcIndex + srcLength - d;
        int i = srcIndex - d;
        while (i != endIndex) {
            int element = elements[i += d];
            if (!predicate.test(element)) continue;
            data[size++] = element;
        }
        return size;
    }

    public static final int addAll(int[] data, int size, int[] elements, int srcIndex, int srcLength, _intPredicate predicate, int skip, Integer limit) {
        int element;
        int d;
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0) {
            return 0;
        }
        if (srcIndex < 0 || srcIndex >= elements.length) {
            throw new IndexBoundsException((long)elements.length, srcIndex);
        }
        if (srcLength > 0) {
            if (srcIndex + srcLength >= elements.length) {
                throw new IndexBoundsException((long)elements.length, srcIndex + srcLength);
            }
            d = 1;
        } else if (srcLength < 0) {
            if (srcIndex + srcLength < 0) {
                throw new IndexBoundsException((long)elements.length, srcIndex + srcLength);
            }
            d = -1;
        } else {
            return 0;
        }
        int endIndex = srcIndex + srcLength - d;
        int i = srcIndex - d;
        while (i != endIndex && skip != 0) {
            element = elements[i += d];
            if (!predicate.test(element)) continue;
            --skip;
        }
        while (i != endIndex && lim != 0) {
            element = elements[i += d];
            if (!predicate.test(element)) continue;
            data[size++] = element;
            --lim;
        }
        return size;
    }

    public static final boolean contains(int[] data, int size, int element) {
        int i = 0;
        while (i < size) {
            if (element == data[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean rngContains(int[] data, int size, int offset, int length, int element) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return false;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (data[i += d] != element) continue;
            return true;
        }
        return false;
    }

    public static final boolean contains(int[] data, int size, _intPredicate predicate) {
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean rngContains(int[] data, int size, int offset, int length, _intPredicate predicate) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return false;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i += d])) continue;
            return true;
        }
        return false;
    }

    public static final boolean containsAll(int[] data, int size, int[] elements, int elementsOffset, int elementsLength) {
        int ei = elementsOffset;
        int bound = elementsOffset + elementsLength;
        while (ei < bound) {
            block3: {
                int element = elements[ei];
                int di = 0;
                while (di < size) {
                    if (element != data[di]) {
                        ++di;
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++ei;
        }
        return true;
    }

    public static final boolean rngContainsAll(int[] data, int size, int offset, int length, _intList elements) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return false;
        }
        int endIndex = offset + length - d;
        int[] eData = elements.internalGetStorageArray();
        int eSize = elements.size();
        int ei = 0;
        while (ei < eSize) {
            block4: {
                int element = eData[ei];
                int di = offset - d;
                while (di != endIndex) {
                    if (element != data[di += d]) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++ei;
        }
        return true;
    }

    public static final int count(int[] data, int size, int element) {
        int count = 0;
        int i = 0;
        while (i < size) {
            if (data[i] == element) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static final int rngCount(int[] data, int size, int offset, int length, int element) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int count = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (data[i += d] != element) continue;
            ++count;
        }
        return count;
    }

    public static final int count(int[] data, int size, _intPredicate predicate) {
        int count = 0;
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static final int rngCount(int[] data, int size, int offset, int length, _intPredicate predicate) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int count = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i += d])) continue;
            ++count;
        }
        return count;
    }

    public static final <C extends _intCollecting> C copyTo(int[] data, int size, C target) {
        if (target instanceof _intList) {
            ((_intList)target).addAll(data, 0, size);
            return target;
        }
        int i = 0;
        while (i < size) {
            target.add(data[i]);
            ++i;
        }
        return target;
    }

    public static final <C extends _intCollecting> C rngCopyTo(int[] data, int size, int offset, int length, C target) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return target;
        }
        int endIndex = offset + length - d;
        if (target instanceof _intList) {
            ((_intList)target).addAll(data, offset, length);
            return target;
        }
        int i = offset - d;
        while (i != endIndex) {
            target.add(data[i += d]);
        }
        return target;
    }

    public static final <C extends _intCollecting> C copyTo(int[] data, int size, C target, _intPredicate predicate) {
        int i = 0;
        while (i < size) {
            int element = data[i];
            if (predicate.test(element)) {
                target.add(element);
            }
            ++i;
        }
        return target;
    }

    public static final <C extends _intCollecting> C rngCopyTo(int[] data, int size, int offset, int length, C target, _intPredicate predicate) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return target;
        }
        int endIndex = offset + length - d;
        if (target instanceof _intList) {
            throw new NotImplementedYetError();
        }
        int i = offset - d;
        while (i != endIndex) {
            int element = data[i += d];
            if (!predicate.test(element)) continue;
            target.add(element);
        }
        return target;
    }

    public static final <C extends _intCollecting> C copyTo(int[] data, int size, C target, _intPredicate predicate, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return target;
        }
        int lastIndex = size - 1;
        int i = -1;
        while (i != lastIndex && skip != 0) {
            if (!predicate.test(data[++i])) continue;
            --skip;
        }
        while (i != lastIndex && lim != 0) {
            int element;
            if (!predicate.test(element = data[++i])) continue;
            target.add(element);
            --lim;
        }
        return target;
    }

    public static final <C extends _intCollecting> C rngCopyTo(int[] data, int size, int offset, int length, C target, _intPredicate predicate, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return target;
        }
        int endIndex = offset + length - d;
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return target;
        }
        int i = offset - d;
        while (i != endIndex && skip != 0) {
            if (!predicate.test(data[i += d])) continue;
            --skip;
        }
        while (i != endIndex && lim != 0) {
            int element = data[i += d];
            if (!predicate.test(element)) continue;
            target.add(element);
            --lim;
        }
        return target;
    }

    public static final int[] rngCopyTo(int[] data, int size, int offset, int length, int[] target, int targetOffset) {
        int endIndex;
        if (length >= 0) {
            if (length == 0) {
                return target;
            }
            System.arraycopy(data, offset, target, offset, length);
            return target;
        }
        if (length < 0) {
            endIndex = offset + length + 1;
            if (endIndex < 0 || offset >= size) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
            }
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, offset));
            }
            return target;
        }
        int i = offset;
        int t = targetOffset;
        while (i >= endIndex) {
            target[t++] = data[i];
            --i;
        }
        return target;
    }

    public static final <C extends _intCollecting> C copySelection(int[] data, int size, long[] indices, C target) {
        int length = indices.length;
        int i = 0;
        while (i < length) {
            if (indices[i] < 0L || indices[i] >= (long)size) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, indices[i]));
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            target.add(data[(int)indices[i]]);
            ++i;
        }
        return target;
    }

    public static final Integer search(int[] data, int size, _intPredicate predicate) {
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                return data[i];
            }
            ++i;
        }
        return null;
    }

    public static final Integer rngSearch(int[] data, int size, int offset, int length, _intPredicate predicate) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return null;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i])) continue;
            return data[i];
        }
        return null;
    }

    public static final int max(int[] data, int size) {
        if (size == 0) {
            return 0;
        }
        int loopMaxElement = data[0];
        int i = 1;
        while (i < size) {
            if (loopMaxElement < data[i]) {
                loopMaxElement = data[i];
            }
            ++i;
        }
        return loopMaxElement;
    }

    public static final int min(int[] data, int size) {
        if (size == 0) {
            return 0;
        }
        int loopMaxElement = data[0];
        int i = 1;
        while (i < size) {
            if (loopMaxElement > data[i]) {
                loopMaxElement = data[i];
            }
            ++i;
        }
        return loopMaxElement;
    }

    public static final void rngIterate(int[] data, int size, int offset, int length, _intProcedure procedure) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            procedure.accept(data[i += d]);
        }
    }

    public static final void iterate(int[] data, int size, _intProcedure procedure) {
        int i = 0;
        while (i < size) {
            procedure.accept(data[i]);
            ++i;
        }
    }

    public static final void iterate(int[] data, int size, _intIndexProcedure procedure) {
        int i = 0;
        while (i < size) {
            procedure.accept(data[i], i);
            ++i;
        }
    }

    public static final void rngIterate(int[] data, int size, int offset, int length, _intIndexProcedure procedure) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            procedure.accept(data[i += d], i);
        }
    }

    public static final void iterate(int[] data, int size, _intPredicate predicate, _intProcedure procedure) {
        int i = 0;
        while (i < size) {
            int element = data[i];
            if (predicate.test(element)) {
                procedure.accept(element);
            }
            ++i;
        }
    }

    public static final void rngIterate(int[] data, int size, int offset, int length, _intPredicate predicate, _intProcedure procedure) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            int element = data[i += d];
            if (!predicate.test(element)) continue;
            procedure.accept(element);
        }
    }

    public static final void iterate(int[] data, int size, _intPredicate predicate, _intProcedure procedure, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return;
        }
        int lastIndex = size - 1;
        int i = -1;
        while (i != lastIndex && skip != 0) {
            if (!predicate.test(data[++i])) continue;
            --skip;
        }
        while (i != lastIndex && lim != 0) {
            int element;
            if (!predicate.test(element = data[++i])) continue;
            procedure.accept(element);
            --lim;
        }
    }

    public static final void rngIterate(int[] data, int size, int offset, int length, _intPredicate predicate, _intProcedure procedure, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return;
        }
        int endIndex = offset + length - d;
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return;
        }
        int i = offset - d;
        while (i != endIndex && skip != 0) {
            if (!predicate.test(data[i += d])) continue;
            --skip;
        }
        while (i != endIndex && lim != 0) {
            int element = data[i += d];
            if (!predicate.test(element)) continue;
            procedure.accept(element);
            --lim;
        }
    }

    public static final int indexOf(int[] data, int size, int element) {
        int i = 0;
        while (i < size) {
            if (data[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int rngIndexOF(int[] data, int size, int offset, int length, int element) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return -1;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (data[i += d] != element) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int[] data, int size, _intPredicate predicate) {
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int rngIndexOf(int[] data, int size, int offset, int length, _intPredicate predicate) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return -1;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i += d])) continue;
            return i;
        }
        return -1;
    }

    public static final int lastIndexOf(int[] data, int size, _intPredicate predicate) {
        int i = size;
        while (i-- > 0) {
            if (!predicate.test(data[i])) continue;
            return i;
        }
        return -1;
    }

    public static final int scan(int[] data, int size, _intPredicate predicate) {
        int foundIndex = -1;
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                foundIndex = i;
            }
            ++i;
        }
        return foundIndex;
    }

    public static final int rngScan(int[] data, int size, int offset, int length, _intPredicate predicate) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return -1;
        }
        int endIndex = offset + length - d;
        int foundIndex = -1;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i += d])) continue;
            foundIndex = i;
        }
        return foundIndex;
    }

    public static final int rngRemove(int[] data, int size, int offset, int length, int element) {
        int bound;
        int start;
        if (length >= 0) {
            if (length == 0) {
                return 0;
            }
            start = offset;
            bound = offset + length;
        } else if (length < 0) {
            bound = offset + 1;
            start = offset + length + 1;
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, offset));
            }
            return 0;
        }
        if (start < 0 || bound > size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
        }
        return XArrays.removeAllFromArray(data, start, bound, element);
    }

    public static final int remove(int[] data, int size, int element, int skip, Integer limit, int removeMarker) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return 0;
        }
        int i = 0;
        while (i < size && skip != 0) {
            if (data[i++] != element) continue;
            --skip;
        }
        int removeStartIndex = i;
        while (i < size && lim != 0) {
            if (data[i] == element) {
                data[i] = removeMarker;
                --lim;
            }
            ++i;
        }
        return XArrays.removeAllFromArray(data, removeStartIndex, i, removeMarker);
    }

    public static final int rngRemove(int[] data, int size, int offset, int length, int element, int skip, Integer limit, int removeMarker) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return 0;
        }
        int i = offset - d;
        while (i != endIndex && skip != 0) {
            if (element != data[i += d]) continue;
            --skip;
        }
        int removeStartIndex = i + d;
        while (i != endIndex && lim != 0) {
            if (element != data[i += d]) continue;
            data[i] = removeMarker;
            --lim;
        }
        if (d < 0) {
            int temp = removeStartIndex;
            removeStartIndex = i;
            i = temp;
        }
        return XArrays.removeAllFromArray(data, removeStartIndex, ++i, element);
    }

    public static final int reduce(int[] data, int size, _intPredicate predicate, int removeMarker) {
        int removeCount;
        if (size == 0) {
            return 0;
        }
        int i = 0;
        try {
            while (i < size) {
                if (predicate.test(data[i])) {
                    data[i] = removeMarker;
                }
                ++i;
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, i, removeMarker);
        }
        return removeCount;
    }

    public static final int rngReduce(int[] data, int size, int offset, int length, _intPredicate predicate, int removeMarker) {
        int removeCount;
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        try {
            while (i != endIndex) {
                if (!predicate.test(data[i += d])) continue;
                data[i] = removeMarker;
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int reduce(int[] data, int size, _intPredicate predicate, int skip, Integer limit, int removeMarker) {
        int removeCount;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0) return 0;
        if (size == 0) {
            return 0;
        }
        int lastIndex = size - 1;
        int i = -1;
        while (skip != 0) {
            if (predicate.test(data[++i])) {
                --skip;
            }
            if (i != lastIndex) continue;
            return 0;
        }
        int removeStartIndex = i + 1;
        try {
            block11: {
                block10: {
                    if (!true) break block10;
                    if (i == lastIndex) return removeCount;
                    if (lim == 0) break block11;
                }
                do {
                    if (predicate.test(data[++i])) {
                        data[i] = removeMarker;
                        --lim;
                    }
                    if (i == lastIndex) return removeCount;
                } while (lim != 0);
            }
            return removeCount;
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int rngReduce(int[] data, int size, int offset, int length, _intPredicate predicate, int skip, Integer limit, int removeMarker) {
        int removeCount;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0) return 0;
        if (size == 0) {
            return 0;
        }
        int i = offset - d;
        while (skip != 0) {
            if (predicate.test(data[i += d])) {
                --skip;
            }
            if (i != endIndex) continue;
            return 0;
        }
        int removeStartIndex = i + d;
        try {
            block13: {
                block12: {
                    if (!true) break block12;
                    if (i == endIndex) return removeCount;
                    if (lim == 0) break block13;
                }
                do {
                    if (predicate.test(data[i += d])) {
                        data[i] = removeMarker;
                        --lim;
                    }
                    if (i == endIndex) return removeCount;
                } while (lim != 0);
            }
            return removeCount;
        }
        finally {
            if (d < 0) {
                int temp = removeStartIndex;
                removeStartIndex = i;
                i = temp;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
    }

    public static final int retainAll(int[] data, int size, _intList elements, int removeMarker) {
        int removeCount;
        if (elements.size() == 0) {
            int i = size;
            while (i-- > 0) {
                data[i] = 0;
            }
            return size;
        }
        int lastIndex = size - 1;
        int i = -1;
        try {
            while (i < lastIndex) {
                if (elements.contains(data[++i])) continue;
                data[i] = removeMarker;
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final int rngRetainAll(int[] data, int size, int offset, int length, _intList elements, int removeMarker) {
        int removeCount;
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        try {
            while (i != endIndex) {
                if (elements.contains(data[i += d])) continue;
                data[i] = removeMarker;
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final int process(int[] data, int size, _intProcedure procedure, int removeMarker) {
        int removeCount;
        int i = 0;
        try {
            while (i < size) {
                procedure.accept(data[i]);
                data[i] = removeMarker;
                ++i;
            }
            while (i-- > 0) {
                data[i] = 0;
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, i, removeMarker);
        }
        return removeCount;
    }

    public static final int rngProcess(int[] data, int size, int offset, int length, _intProcedure procedure, int removeMarker) {
        int removeCount;
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        try {
            while (i != endIndex) {
                procedure.accept(data[i += d]);
                data[i] = removeMarker;
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final int moveTo(int[] data, int size, _intCollecting target, _intPredicate predicate, int removeMarker) {
        int removeCount;
        int lastIndex = size - 1;
        int i = -1;
        try {
            while (i < lastIndex) {
                int element;
                if (!predicate.test(element = data[++i])) continue;
                target.add(element);
                data[i] = removeMarker;
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final int rngMoveTo(int[] data, int size, int offset, int length, _intCollecting target, _intPredicate predicate, int removeMarker) {
        int removeCount;
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        try {
            while (i != endIndex) {
                int element = data[i += d];
                if (!predicate.test(element)) continue;
                target.add(element);
                data[i] = removeMarker;
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final int moveSelection(int[] data, int size, long[] indices, _intCollecting target, int removeMarker) {
        int removeCount;
        long min;
        int length = indices.length;
        if (length == 0) {
            return 0;
        }
        long max = min = indices[0];
        int i = 1;
        while (i < length) {
            if (indices[i] < min) {
                min = indices[i];
            } else if (indices[i] > max) {
                max = indices[i];
            }
            ++i;
        }
        if (min < 0L) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, min));
        }
        if (max >= (long)size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, max));
        }
        try {
            int i2 = 0;
            while (i2 < length) {
                target.add(data[(int)indices[i2]]);
                data[(int)indices[i2]] = removeMarker;
                ++i2;
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, (int)min, (int)(++max), removeMarker);
        }
        return removeCount;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int moveTo(int[] data, int size, _intCollecting target, _intPredicate predicate, int skip, Integer limit, int removeMarker) {
        int removeCount;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0) return 0;
        if (size == 0) {
            return 0;
        }
        int lastIndex = size - 1;
        int i = -1;
        while (skip != 0) {
            if (predicate.test(data[++i])) {
                --skip;
            }
            if (i != lastIndex) continue;
            return 0;
        }
        int removeStartIndex = i + 1;
        try {
            block11: {
                block10: {
                    if (!true) break block10;
                    if (i == lastIndex) return removeCount;
                    if (lim == 0) break block11;
                }
                do {
                    int element;
                    if (predicate.test(element = data[++i])) {
                        target.add(element);
                        data[i] = removeMarker;
                        --lim;
                    }
                    if (i == lastIndex) return removeCount;
                } while (lim != 0);
            }
            return removeCount;
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int rngMoveTo(int[] data, int size, int offset, int length, _intCollecting target, _intPredicate predicate, int skip, Integer limit, int removeMarker) {
        int removeCount;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0) return 0;
        if (size == 0) {
            return 0;
        }
        int i = offset - d;
        while (skip != 0) {
            if (predicate.test(data[i += d])) {
                --skip;
            }
            if (i != endIndex) continue;
            return 0;
        }
        int removeStartIndex = i + d;
        try {
            block13: {
                block12: {
                    if (!true) break block12;
                    if (i == endIndex) return removeCount;
                    if (lim == 0) break block13;
                }
                do {
                    int element;
                    if (predicate.test(element = data[i += d])) {
                        target.add(element);
                        data[i] = removeMarker;
                        --lim;
                    }
                    if (i == endIndex) return removeCount;
                } while (lim != 0);
            }
            return removeCount;
        }
        finally {
            if (d < 0) {
                int temp = removeStartIndex;
                removeStartIndex = i;
                i = temp;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int removeAll(int[] data, int size, _intList elements, int skip, Integer limit, int removeMarker) {
        int removeCount;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0) return 0;
        if (size == 0) {
            return 0;
        }
        int lastIndex = size - 1;
        int i = -1;
        while (skip != 0) {
            if (elements.contains(data[++i])) {
                --skip;
            }
            if (i != lastIndex) continue;
            return 0;
        }
        int removeStartIndex = i + 1;
        try {
            block11: {
                block10: {
                    if (!true) break block10;
                    if (i == lastIndex) return removeCount;
                    if (lim == 0) break block11;
                }
                do {
                    if (elements.contains(data[++i])) {
                        data[i] = removeMarker;
                        --lim;
                    }
                    if (i == lastIndex) return removeCount;
                } while (lim != 0);
            }
            return removeCount;
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int rngRemoveAll(int[] data, int size, int offset, int length, _intList elements, int skip, Integer limit, int removeMarker) {
        int removeCount;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0) return 0;
        if (size == 0) {
            return 0;
        }
        if (elements.size() == 0) {
            return 0;
        }
        int i = offset - d;
        while (skip != 0) {
            if (elements.contains(data[i += d])) {
                --skip;
            }
            if (i != endIndex) continue;
            return 0;
        }
        int removeStartIndex = i + d;
        try {
            block14: {
                block13: {
                    if (!true) break block13;
                    if (i == endIndex) return removeCount;
                    if (lim == 0) break block14;
                }
                do {
                    if (elements.contains(data[i += d])) {
                        data[i] = removeMarker;
                        --lim;
                    }
                    if (i == endIndex) return removeCount;
                } while (lim != 0);
            }
            return removeCount;
        }
        finally {
            if (d < 0) {
                int temp = removeStartIndex;
                removeStartIndex = i;
                i = temp;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
    }

    public static final int removeDuplicates(int[] data, int size, int removeMarker) {
        return Abstract_intArrayStorage.rngRemoveDuplicates(data, size, 0, size, removeMarker);
    }

    public static final int rngRemoveDuplicates(int[] data, int size, int offset, int length, int removeMarker) {
        int removeCount;
        int i;
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int removeStartIndex = i = offset - d;
        try {
            while (i != endIndex) {
                int ei = data[i += d];
                if (ei == removeMarker) continue;
                int j = i;
                while (j != endIndex) {
                    int ej = data[j += d];
                    if (ej == removeMarker || ei != ej) continue;
                    data[j] = removeMarker;
                }
            }
        }
        finally {
            if (d < 0) {
                int temp = removeStartIndex;
                removeStartIndex = i;
                i = temp;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final int removeSelection(int[] data, int size, int[] indices, int removeMarker) {
        int removeCount;
        int min;
        int length = indices.length;
        if (length == 0) {
            return 0;
        }
        int max = min = indices[0];
        int i = 1;
        while (i < length) {
            int idx = indices[i];
            if (idx < min) {
                min = idx;
            } else if (idx > max) {
                max = idx;
            }
            ++i;
        }
        if (min < 0) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, min));
        }
        if (max >= size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, max));
        }
        try {
            int i2 = 0;
            while (i2 < length) {
                data[indices[i2]] = removeMarker;
                ++i2;
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, min, ++max, removeMarker);
        }
        return removeCount;
    }

    public static final int removeRange(int[] data, int size, int offset, int length) {
        int bound;
        int start;
        if (length >= 0) {
            if (length == 0) {
                return 0;
            }
            start = offset;
            bound = offset + length;
        } else if (length < 0) {
            bound = offset + 1;
            start = offset + length + 1;
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, offset));
            }
            return 0;
        }
        if (start < 0 || bound > size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
        }
        System.arraycopy(data, bound, data, start, size - bound);
        int i = size;
        while (i < size) {
            data[i] = 0;
            ++i;
        }
        return length;
    }

    public static final int retrieve(int[] data, int size, int element, int notFoundMarker) {
        int i = 0;
        while (i < size) {
            if (data[i] == element) {
                if (i < --size) {
                    System.arraycopy(data, i + 1, data, i, size - i);
                }
                data[size] = 0;
                return element;
            }
            ++i;
        }
        return notFoundMarker;
    }

    public static final int retrieve(int[] data, int size, _intPredicate predicate, int notFoundMarker) {
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                int oldElement = data[i];
                if (i < --size) {
                    System.arraycopy(data, i + 1, data, i, size - i);
                }
                data[size] = 0;
                return oldElement;
            }
            ++i;
        }
        return notFoundMarker;
    }

    public static final boolean removeOne(int[] data, int size, int element) {
        int i = 0;
        while (i < size) {
            if (data[i] == element) {
                if (i < --size) {
                    System.arraycopy(data, i + 1, data, i, size - i);
                }
                data[size] = 0;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final int rngRetrieve(int[] data, int size, int offset, int length, int element, int notFoundMarker) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return notFoundMarker;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (element != data[i += d]) continue;
            if (i < --size) {
                System.arraycopy(data, i + 1, data, i, size - i);
            }
            data[size] = 0;
            return element;
        }
        return notFoundMarker;
    }

    public static final int rngRetrieve(int[] data, int size, int offset, int length, _intPredicate predicate, int notFoundMarker) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return notFoundMarker;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i += d])) continue;
            int oldElement = data[i];
            if (i < --size) {
                System.arraycopy(data, i + 1, data, i, size - i);
            }
            data[size] = 0;
            return oldElement;
        }
        return notFoundMarker;
    }

    public static final boolean rngRemoveOne(int[] data, int size, int offset, int length, int element) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return false;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (element != data[i += d]) continue;
            if (i < --size) {
                System.arraycopy(data, i + 1, data, i, size - i);
            }
            data[size] = 0;
            return true;
        }
        return false;
    }

    public static final boolean replaceOne(int[] data, int size, int oldElement, int newElement) {
        int i = 0;
        while (i < size) {
            if (data[i] == oldElement) {
                data[i] = newElement;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final int rngReplaceOne(int[] data, int size, int offset, int length, int oldElement, int newElement) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return -1;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (oldElement != data[i += d]) continue;
            data[i] = newElement;
            return i;
        }
        return -1;
    }

    public static final boolean substituteOne(int[] data, int size, _intPredicate predicate, int replacement) {
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                data[i] = replacement;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final int rngReplaceOne(int[] data, int size, int offset, int length, _intPredicate predicate, int newElement) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return -1;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i += d])) continue;
            data[i] = newElement;
            return i;
        }
        return -1;
    }

    public static final int replace(int[] data, int size, int oldElement, int newElement) {
        int replaceCount = 0;
        int i = 0;
        while (i < size) {
            if (data[i] == oldElement) {
                data[i] = newElement;
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static final int rngReplace(int[] data, int size, int offset, int length, int oldElement, int newElement) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (data[i += d] != oldElement) continue;
            data[i] = newElement;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final int substitute(int[] data, int size, _intPredicate predicate, int newElement) {
        int replaceCount = 0;
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                data[i] = newElement;
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static final int rngReplace(int[] data, int size, int offset, int length, _intPredicate predicate, int newElement) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i += d])) continue;
            data[i] = newElement;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final int replace(int[] data, int size, int oldElement, int newElement, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return 0;
        }
        int lastIndex = size - 1;
        int i = -1;
        while (i != lastIndex && skip != 0) {
            if (oldElement != data[++i]) continue;
            --skip;
        }
        int replaceCount = 0;
        while (i != lastIndex && lim != 0) {
            if (oldElement != data[++i]) continue;
            data[i] = newElement;
            ++replaceCount;
            --lim;
        }
        return replaceCount;
    }

    public static final int rngReplace(int[] data, int size, int offset, int length, int oldElement, int newElement, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return 0;
        }
        int i = offset - d;
        while (i != endIndex && skip != 0) {
            if (oldElement != data[i += d]) continue;
            --skip;
        }
        int replaceCount = 0;
        while (i != endIndex && lim != 0) {
            if (oldElement != data[i += d]) continue;
            data[i] = newElement;
            ++replaceCount;
            --lim;
        }
        return replaceCount;
    }

    public static final int replace(int[] data, int size, _intPredicate predicate, int newElement, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return 0;
        }
        int lastIndex = size - 1;
        int i = -1;
        while (i != lastIndex && skip != 0) {
            if (!predicate.test(data[++i])) continue;
            --skip;
        }
        int replaceCount = 0;
        while (i != lastIndex && lim != 0) {
            if (!predicate.test(data[++i])) continue;
            data[i] = newElement;
            --lim;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final int rngReplace(int[] data, int size, int offset, int length, _intPredicate predicate, int newElement, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return 0;
        }
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex && skip != 0) {
            if (!predicate.test(data[i += d])) continue;
            --skip;
        }
        while (i != endIndex && lim != 0) {
            if (!predicate.test(data[i += d])) continue;
            data[i] = newElement;
            ++replaceCount;
            --lim;
        }
        return replaceCount;
    }

    public static final int rngReplaceAll(int[] data, int size, int offset, int length, _intList oldElements, int newElement) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (!oldElements.contains(data[i += d])) continue;
            data[i] = newElement;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final int replaceAll(int[] data, int size, _intList oldElements, int newElement, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return 0;
        }
        int lastIndex = size - 1;
        int i = -1;
        while (i != lastIndex && skip != 0) {
            if (!oldElements.contains(data[++i])) continue;
            --skip;
        }
        int replaceCount = 0;
        while (i != lastIndex && lim != 0) {
            if (!oldElements.contains(data[++i])) continue;
            data[i] = newElement;
            --lim;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final int rngReplaceAll(int[] data, int size, int offset, int length, _intList oldElements, int newElement, int skip, Integer limit) {
        int lim;
        if (skip < 0) {
            throw new IllegalArgumentException(Abstract_intArrayStorage.exceptionSkipNegative(skip));
        }
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int n = lim = limit == null ? Integer.MAX_VALUE : limit;
        if (lim <= 0 || size == 0) {
            return 0;
        }
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex && skip != 0) {
            if (!oldElements.contains(data[i += d])) continue;
            --skip;
        }
        while (i != endIndex && lim != 0) {
            if (!oldElements.contains(data[i += d])) continue;
            data[i] = newElement;
            ++replaceCount;
            --lim;
        }
        return replaceCount;
    }

    public static final int modify(int[] data, int size, _intFunction mapper) {
        int replaceCount = 0;
        int i = 0;
        while (i < size) {
            data[i] = mapper.apply(data[i]);
            if (data[i] != data[i]) {
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static final int modify(int[] data, int size, _intPredicate predicate, _intFunction mapper) {
        int replaceCount = 0;
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                data[i] = mapper.apply(data[i]);
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static final int rngModify(int[] data, int size, int offset, int length, _intFunction mapper) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (data[i += d] == (data[i] = mapper.apply(data[i]))) continue;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final void swap(int[] data, int size, int indexA, int indexB) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (indexA >= size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, indexA));
        }
        if (indexB >= size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, indexB));
        }
        int t = data[indexA];
        data[indexA] = data[indexB];
        data[indexB] = t;
    }

    /*
     * Unable to fully structure code
     */
    public static final void swap(int[] data, int size, int indexA, int indexB, int length) {
        if (length == 0 || indexA == indexB) {
            return;
        }
        if (indexA > indexB) {
            t = indexA;
            indexA = indexB;
            indexB = t;
        }
        if (indexA >= 0 && length >= 0 && (bound = indexA + length) < indexB && indexB + length < size) ** GOTO lbl12
        throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIllegalSwapBounds(size, indexA, indexB, length));
lbl-1000:
        // 1 sources

        {
            t = data[indexA];
            data[indexA++] = data[indexB];
            data[indexB++] = t;
lbl12:
            // 2 sources

            ** while (indexA < bound)
        }
lbl13:
        // 1 sources

    }

    public static final void reverse(int[] data, int size) {
        int halfSize = size >> 1;
        int i = 0;
        int j = size - 1;
        while (i < halfSize) {
            int element = data[i];
            data[i] = data[j];
            data[j] = element;
            ++i;
            --j;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void rngReverse(int[] data, int size, int offset, int length) {
        block6: {
            block5: {
                if (length < 0) break block5;
                low = offset;
                if (low < 0 || (high = offset + length - 1) >= size) {
                    throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
                }
                if (length == 0) {
                    return;
                }
                ** GOTO lbl21
            }
            if (length >= 0) break block6;
            low = offset + length + 1;
            if (low < 0 || (high = offset) >= size) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
            }
            ** GOTO lbl21
        }
        if (offset < 0 || offset >= size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, offset));
        }
        return;
lbl-1000:
        // 1 sources

        {
            element = data[low];
            data[low++] = data[high];
            data[high--] = element;
lbl21:
            // 3 sources

            ** while (low < high)
        }
lbl22:
        // 1 sources

    }

    public static final void set(int[] data, int size, int offset, int ... elements) {
        if (offset < 0 || offset + elements.length > size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, offset + elements.length - 1));
        }
        System.arraycopy(elements, 0, data, offset, elements.length);
    }

    public static final void set(int[] data, int size, int offset, int[] src, int srcIndex, int srcLength) {
        if (srcLength < 0) {
            if (offset < 0 || offset - srcLength > size) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, offset - srcLength + 1));
            }
            if (srcIndex >= src.length) {
                throw new ArrayIndexOutOfBoundsException(srcIndex);
            }
            int bound = offset + srcLength;
            if (bound < -1) {
                throw new ArrayIndexOutOfBoundsException(bound + 1);
            }
            int s = srcIndex;
            int i = offset;
            while (s > bound) {
                data[i++] = src[s];
                --s;
            }
            return;
        }
        if (offset < 0 || offset + srcLength > size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, offset + src.length - 1));
        }
        System.arraycopy(src, srcIndex, data, offset, srcLength);
    }

    public static final void fill(int[] data, int size, int offset, int length, int element) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            data[i += d] = element;
        }
    }

    public static final String toString(int[] data, int size) {
        if (size == 0) {
            return "[]";
        }
        VarString vc = VarString.New((int)((float)size * 2.0f)).append('[');
        int i = 0;
        while (i < size) {
            vc.add(data[i]).add(',', ' ');
            ++i;
        }
        vc.deleteLast().setLast(']');
        return vc.toString();
    }

    public static final VarString appendTo(int[] data, int size, VarString vc) {
        int i = 0;
        while (i < size) {
            vc.add(data[i]);
            ++i;
        }
        return vc;
    }

    public static final VarString appendTo(int[] data, int size, VarString vc, char separator) {
        if (size == 0) {
            return vc;
        }
        int i = 0;
        while (i < size) {
            vc.add(data[i]).append(separator);
            ++i;
        }
        vc.deleteLast();
        return vc;
    }

    public static final VarString appendTo(int[] data, int size, VarString vc, String separator) {
        if (size == 0) {
            return vc;
        }
        if (separator == null || separator.isEmpty()) {
            int i = 0;
            while (i < size) {
                vc.add(data[i]);
                ++i;
            }
        } else {
            char[] sepp = XChars.readChars(separator);
            int i = 0;
            while (i < size) {
                vc.add(data[i]).add(sepp);
                ++i;
            }
            vc.deleteLast(sepp.length);
        }
        return vc;
    }

    public static final VarString appendTo(int[] data, int size, VarString vc, BiConsumer<VarString, Integer> appender) {
        if (size == 0) {
            return vc;
        }
        int i = 0;
        while (i < size) {
            appender.accept(vc, data[i]);
            ++i;
        }
        return vc;
    }

    public static final VarString appendTo(int[] data, int size, VarString vc, BiConsumer<VarString, Integer> appender, char separator) {
        if (size == 0) {
            return vc;
        }
        int i = 0;
        while (i < size) {
            appender.accept(vc, data[i]);
            vc.append(separator);
            ++i;
        }
        vc.deleteLast();
        return vc;
    }

    public static final VarString appendTo(int[] data, int size, VarString vc, BiConsumer<VarString, Integer> appender, String separator) {
        if (size == 0) {
            return vc;
        }
        if (separator == null || separator.isEmpty()) {
            int i = 0;
            while (i < size) {
                appender.accept(vc, data[i]);
                ++i;
            }
        } else {
            char[] sepp = XChars.readChars(separator);
            int i = 0;
            while (i < size) {
                appender.accept(vc, data[i]);
                vc.add(sepp);
                ++i;
            }
            vc.deleteLast(sepp.length);
        }
        return vc;
    }

    public static final VarString rngAppendTo(int[] data, int size, int offset, int length, VarString vc) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            vc.add(data[i += d]);
        }
        return vc;
    }

    public static final VarString rngAppendTo(int[] data, int size, int offset, int length, VarString vc, char separator) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            vc.add(data[i += d]).append(separator);
        }
        vc.deleteLast();
        return vc;
    }

    public static final VarString rngAppendTo(int[] data, int size, int offset, int length, VarString vc, String separator) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        if (separator == null || separator.isEmpty()) {
            int i = offset - d;
            while (i != endIndex) {
                vc.add(data[i += d]);
            }
        } else {
            char[] sepp = XChars.readChars(separator);
            int i = offset - d;
            while (i != endIndex) {
                vc.add(data[i += d]).add(sepp);
            }
            vc.deleteLast(sepp.length);
        }
        return vc;
    }

    public static final VarString rngAppendTo(int[] data, int size, int offset, int length, VarString vc, BiConsumer<VarString, Integer> appender) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            appender.accept(vc, data[i += d]);
        }
        return vc;
    }

    public static final VarString rngAppendTo(int[] data, int size, int offset, int length, VarString vc, BiConsumer<VarString, Integer> appender, char separator) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            appender.accept(vc, data[i += d]);
            vc.append(separator);
        }
        vc.deleteLast();
        return vc;
    }

    public static final VarString rngAppendTo(int[] data, int size, int offset, int length, VarString vc, BiConsumer<VarString, Integer> appender, String separator) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        if (separator == null || separator.isEmpty()) {
            int i = offset - d;
            while (i != endIndex) {
                appender.accept(vc, data[i += d]);
            }
        } else {
            char[] sepp = XChars.readChars(separator);
            int i = offset - d;
            while (i != endIndex) {
                appender.accept(vc, data[i += d]);
                vc.add(sepp);
            }
            vc.deleteLast(sepp.length);
        }
        return vc;
    }

    public static final boolean isSorted(int[] data, int size, boolean ascending) {
        return ascending ? Abstract_intArrayStorage.isSortedAscending(data, size) : Abstract_intArrayStorage.isSortedDescending(data, size);
    }

    public static final boolean isSortedAscending(int[] data, int size) {
        if (size <= 1) {
            return true;
        }
        int loopLastElement = data[0];
        int i = 1;
        while (i < size) {
            if (loopLastElement > data[i]) {
                return false;
            }
            loopLastElement = data[i];
            ++i;
        }
        return true;
    }

    public static final boolean isSortedDescending(int[] data, int size) {
        if (size <= 1) {
            return true;
        }
        int loopLastElement = data[0];
        int i = 1;
        while (i < size) {
            if (loopLastElement < data[i]) {
                return false;
            }
            loopLastElement = data[i];
            ++i;
        }
        return true;
    }

    public static final void shuffle(int[] data, int size) {
        FastRandom random = new FastRandom();
        int i = size;
        while (i > 1) {
            int t = data[i - 1];
            int j = random.nextInt(i);
            data[i - 1] = data[j];
            data[j] = t;
            --i;
        }
    }

    public static final void rngShuffle(int[] data, int size, int offset, int length) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return;
        }
        int endIndex = offset + length - d;
        Random r = XMath.random();
        int i = offset - d;
        while (i != endIndex) {
            int t = data[i += d];
            int j = r.nextInt(i);
            data[i] = data[j];
            data[j] = t;
        }
    }

    public static final int[] toReversed(int[] array, int size) {
        int[] rArray = new int[size];
        int i = 0;
        int r = size;
        while (i < size) {
            rArray[--r] = array[i];
            ++i;
        }
        return rArray;
    }

    public static final boolean rngHasUniqueValues(int[] data, int size, int offset, int length) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return true;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            int element = data[i += d];
            int j = i;
            while (j != endIndex) {
                if (data[j += d] != element) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean containsSearched(int[] data, int size, _intPredicate predicate) {
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean appliesAll(int[] data, int size, _intPredicate predicate) {
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (!predicate.test(data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean rngAppliesAll(int[] data, int size, int offset, int length, _intPredicate predicate) {
        int d = Abstract_intArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return false;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (predicate.test(data[i += d])) continue;
            return false;
        }
        return true;
    }

    public static final int[] rngToArray(int[] data, int size, int offset, int length) {
        if (offset < 0 || offset >= size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, offset));
        }
        if (length == 0) {
            return new int[0];
        }
        if (length > 0) {
            int[] array = new int[length];
            System.arraycopy(data, offset, array, 0, length);
            return array;
        }
        int boundIndex = offset + length;
        if (boundIndex < -1) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
        }
        int[] array = new int[-length];
        int i = offset;
        int j = 0;
        while (i > boundIndex) {
            array[j++] = data[i];
            --i;
        }
        return array;
    }

    public static final int[] rngToArray(int[] data, int size, int offset, int length, int[] a) {
        if (offset < 0 || offset >= size) {
            throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionIndexOutOfBounds(size, offset));
        }
        if (length == 0) {
            if (a.length == 0) {
                return new int[0];
            }
            return a;
        }
        if (length > 0) {
            if (a.length < length) {
                a = new int[length];
            }
            System.arraycopy(data, offset, a, 0, length);
        } else {
            int boundIndex = offset + length;
            if (boundIndex < -1) {
                throw new IndexOutOfBoundsException(Abstract_intArrayStorage.exceptionRange(size, offset, length));
            }
            if (a.length < -length) {
                a = new int[-length];
            }
            int i = offset;
            int j = 0;
            while (i > boundIndex) {
                a[j++] = data[i];
                --i;
            }
        }
        if (a.length > size) {
            a[size] = 0;
        }
        return a;
    }

    public static int arrayHashCode(int[] data, int size) {
        int hashCode = 1;
        int i = 0;
        while (i < size) {
            hashCode = 31 * hashCode + data[i];
            ++i;
        }
        return hashCode;
    }
}

