/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.function.Consumer;
import one.microstream.chars.VarString;
import one.microstream.collections.BulkList;
import one.microstream.collections.interfaces.OptimizableCollection;
import one.microstream.collections.types.XList;
import one.microstream.functional._longProcedure;
import one.microstream.math.XMath;
import one.microstream.typing.Composition;
import one.microstream.typing.KeyValue;

public final class HashMapIdObject<E>
implements OptimizableCollection,
Composition {
    private Entry<E>[] hashSlots;
    private int hashRange;
    private int size;

    private static <T> Entry<T>[] newHashSlots(int length) {
        return new Entry[length];
    }

    public static final <T> HashMapIdObject<T> New() {
        return new HashMapIdObject(1);
    }

    public static final <T> HashMapIdObject<T> New(int initialSlotLength) {
        return new HashMapIdObject(XMath.pow2BoundCapped(initialSlotLength));
    }

    HashMapIdObject(int initialSlotLength) {
        this.hashSlots = HashMapIdObject.newHashSlots(initialSlotLength);
        this.hashRange = initialSlotLength - 1;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    private void rebuild(int newLength) {
        if (this.hashSlots.length >= newLength || newLength <= 0) {
            return;
        }
        int newRange = newLength - 1;
        Entry<E>[] oldSlots = this.hashSlots;
        Entry<T>[] newSlots = HashMapIdObject.newHashSlots(newLength);
        int i = 0;
        while (i < oldSlots.length) {
            if (oldSlots[i] != null) {
                Entry<E> entry = oldSlots[i];
                while (entry != null) {
                    Entry next = entry.link;
                    entry.link = newSlots[(int)(entry.id & (long)newRange)];
                    newSlots[(int)(entry.id & (long)newRange)] = entry;
                    entry = next;
                }
            }
            ++i;
        }
        this.hashSlots = newSlots;
        this.hashRange = newRange;
    }

    private void rebuild() {
        int newModulo = (this.hashRange + 1 << 1) - 1;
        Entry[] newSlots = new Entry[newModulo + 1];
        Entry<E>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                Entry next = entry.link;
                entry.link = newSlots[(int)(entry.id & (long)newModulo)];
                newSlots[(int)(entry.id & (long)newModulo)] = entry;
                entry = next;
            }
            ++n2;
        }
        this.hashSlots = newSlots;
        this.hashRange = newModulo;
    }

    private void putEntry(int index, Entry<E> entry) {
        this.hashSlots[index] = entry;
        if (++this.size >= this.hashRange) {
            this.rebuild();
        }
    }

    public final boolean add(long id, E object) {
        int index = (int)(id & (long)(this.hashSlots.length - 1));
        Entry<E> entry = this.hashSlots[index];
        if (entry == null) {
            this.putEntry(index, new Entry<E>(id, object));
            return true;
        }
        do {
            if (entry.id != id) continue;
            return false;
        } while ((entry = entry.link) != null);
        this.putEntry(index, new Entry<E>(id, object, this.hashSlots[index]));
        return true;
    }

    public final boolean put(long id, E object) {
        int index = (int)(id & (long)(this.hashSlots.length - 1));
        Entry<E> entry = this.hashSlots[index];
        if (entry == null) {
            this.putEntry(index, new Entry<E>(id, object));
            return true;
        }
        do {
            if (entry.id != id) continue;
            entry.item = object;
            return false;
        } while ((entry = entry.link) != null);
        this.putEntry(index, new Entry<E>(id, object, this.hashSlots[index]));
        return true;
    }

    public final E putGet(long id, E object) {
        int index = (int)(id & (long)this.hashRange);
        Entry<E> head = this.hashSlots[index];
        if (head == null) {
            this.hashSlots[index] = new Entry<E>(id, object);
            if (this.size++ >= this.hashRange) {
                this.rebuild(this.hashRange + 1 << 1);
            }
            return null;
        }
        if (head.id == id) {
            Object oldRef = head.item;
            head.item = object;
            return oldRef;
        }
        Entry entry = head.link;
        while (entry != null) {
            if (entry.id == id) {
                Object oldRef = entry.item;
                entry.item = object;
                return oldRef;
            }
            entry = entry.link;
        }
        this.hashSlots[index] = new Entry<E>(id, object, head);
        if (this.size++ >= this.hashRange) {
            this.rebuild(this.hashRange + 1 << 1);
        }
        return null;
    }

    public final E get(long id) {
        Entry<E> entry = this.hashSlots[(int)(id & (long)this.hashRange)];
        while (entry != null) {
            if (entry.id == id) {
                return entry.item;
            }
            entry = entry.link;
        }
        return null;
    }

    public final XList<E> getObjects() {
        BulkList list = new BulkList(this.size);
        Entry<E>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                list.add(entry.item);
                entry = entry.link;
            }
            ++n2;
        }
        return list;
    }

    public final XList<Long> getIds() {
        BulkList<Long> list = new BulkList<Long>(this.size);
        Entry<E>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                list.add(entry.id);
                entry = entry.link;
            }
            ++n2;
        }
        return list;
    }

    public final int iterateValues(Consumer<? super E> procedure) {
        Entry<E>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                procedure.accept(entry.item);
                entry = entry.link;
            }
            ++n2;
        }
        return this.size;
    }

    public final String toString() {
        VarString vc = VarString.New().add('{');
        Entry<E>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                vc.add(entry.id).add(" -> ").add(entry.item).add(", ");
                entry = entry.link;
            }
            ++n2;
        }
        return vc.deleteLast().setLast('}').toString();
    }

    @Override
    public final long optimize() {
        this.rebuild(XMath.pow2BoundCapped(this.size));
        return this.size;
    }

    public final int iterateKeys(Consumer<? super Long> procedure) {
        Entry<E>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                procedure.accept((Long)entry.id);
                entry = entry.link;
            }
            ++n2;
        }
        return this.size;
    }

    public final int iterateIds(_longProcedure procedure) {
        Entry<E>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                procedure.accept(entry.id);
                entry = entry.link;
            }
            ++n2;
        }
        return this.size;
    }

    public final int iterate(Consumer<? super KeyValue<Long, E>> procedure) {
        Entry<E>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                procedure.accept(entry);
                entry = entry.link;
            }
            ++n2;
        }
        return this.size;
    }

    public final void clear() {
        Entry<E>[] slots = this.hashSlots;
        int i = 0;
        int len = slots.length;
        while (i < len) {
            slots[i] = null;
            ++i;
        }
        this.size = 0;
    }

    static final class Entry<E>
    implements KeyValue<Long, E>,
    Composition {
        final long id;
        E item;
        Entry<E> link;

        Entry(long id, E item, Entry<E> next) {
            this.id = id;
            this.item = item;
            this.link = next;
        }

        Entry(long id, E item) {
            this.id = id;
            this.item = item;
            this.link = null;
        }

        @Override
        public final Long key() {
            return this.id;
        }

        @Override
        public final E value() {
            return this.item;
        }

        public final String toString() {
            return String.valueOf('[') + String.valueOf(this.id) + " -> " + String.valueOf(this.item) + ']';
        }
    }
}

