/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.collections.Constant;
import one.microstream.collections.InvalidCapacityException;
import one.microstream.collections.types.XEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XList;
import one.microstream.collections.types.XReference;
import one.microstream.collections.types.XReferencing;
import one.microstream.equality.Equalator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;

public class Single<E>
implements XList<E>,
XEnum<E>,
XReference<E> {
    E element;

    private static void validateIndex(long index) {
        if (index != 0L) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static void validateElementsLength(int length) {
        if (length != 1) {
            throw new IndexOutOfBoundsException();
        }
    }

    public Single() {
        this.element = null;
    }

    public Single(E element) {
        this.element = element;
    }

    @Override
    public void set(E element) {
        this.element = element;
    }

    @Override
    public void accept(E element) {
        this.internalPut(element);
    }

    private boolean internalAdd(E element) {
        if (this.element != null) {
            return false;
        }
        this.element = element;
        return true;
    }

    private boolean internalPut(E element) {
        if (this.element != null) {
            this.element = element;
            return false;
        }
        this.element = element;
        return true;
    }

    @Override
    public boolean add(E element) {
        if (this.element != null) {
            return false;
        }
        this.element = element;
        return true;
    }

    @Override
    public boolean nullAdd() {
        throw new NullPointerException();
    }

    @Override
    public boolean nullAllowed() {
        return false;
    }

    @Override
    public boolean hasVolatileElements() {
        return false;
    }

    @Override
    public Single<E> ensureFreeCapacity(long minimalFreeCapacity) {
        if (minimalFreeCapacity == 0L || this.element == null && minimalFreeCapacity == 1L) {
            return this;
        }
        throw new InvalidCapacityException(1L, minimalFreeCapacity);
    }

    @Override
    public Single<E> ensureCapacity(long minimalCapacity) {
        if (minimalCapacity == 1L) {
            return this;
        }
        throw new InvalidCapacityException(1L, minimalCapacity);
    }

    @Override
    public long currentCapacity() {
        return 1L;
    }

    @Override
    public long maximumCapacity() {
        return 1L;
    }

    @Override
    public long remainingCapacity() {
        return this.element == null ? 1 : 0;
    }

    @Override
    public boolean isFull() {
        return this.element != null;
    }

    @Override
    public long size() {
        return this.element == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.element == null;
    }

    @Override
    public long optimize() {
        return 1L;
    }

    @Override
    public boolean put(E element) {
        return this.internalPut(element);
    }

    @Override
    public boolean nullPut() {
        throw new NullPointerException();
    }

    @Override
    public XReferencing<E> view() {
        throw new NotImplementedYetError();
    }

    @Override
    public XReferencing<E> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public Constant<E> immure() {
        return new Constant<E>(this.element);
    }

    @Override
    public Iterator<E> iterator() {
        throw new NotImplementedYetError();
    }

    @Override
    public Object[] toArray() {
        throw new NotImplementedYetError();
    }

    @Override
    public OldSingle old() {
        throw new NotImplementedYetError();
    }

    @Override
    public Equalator<? super E> equality() {
        throw new NotImplementedYetError();
    }

    @Override
    public E[] toArray(Class<E> type) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullContained() {
        return false;
    }

    @Override
    public boolean containsId(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean contains(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public long count(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public E seek(E sample) {
        throw new NotImplementedYetError();
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T distinct(T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T distinct(T target, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T copyTo(T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T filterTo(T target, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public void clear() {
        throw new NotImplementedYetError();
    }

    @Override
    public void truncate() {
        throw new NotImplementedYetError();
    }

    @Override
    public long consolidate() {
        throw new NotImplementedYetError();
    }

    @Override
    public long nullRemove() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean removeOne(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public long remove(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public long retainAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeDuplicates() {
        throw new NotImplementedYetError();
    }

    @Override
    public E retrieve(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E retrieveBy(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeDuplicates(Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeBy(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public E at(long index) {
        Single.validateIndex(index);
        return this.element;
    }

    @Override
    public E get() {
        if (this.element == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.element;
    }

    @Override
    public E first() {
        if (this.element == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.element;
    }

    @Override
    public E last() {
        if (this.element == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.element;
    }

    @Override
    public E poll() {
        return this.element;
    }

    @Override
    public E peek() {
        return this.element;
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public long indexOf(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public long lastIndexOf(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        throw new NotImplementedYetError();
    }

    @Override
    public E removeAt(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public E fetch() {
        throw new NotImplementedYetError();
    }

    @Override
    public E pop() {
        throw new NotImplementedYetError();
    }

    @Override
    public E pinch() {
        throw new NotImplementedYetError();
    }

    @Override
    public E pick() {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> removeRange(long offset, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> retainRange(long offset, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeSelection(long[] indices) {
        throw new NotImplementedYetError();
    }

    @Override
    public <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        throw new NotImplementedYetError();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new NotImplementedYetError();
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean input(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullInput(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final long inputAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public long inputAll(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public long inputAll(long index, XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean insert(long index, E element) {
        Single.validateIndex(index);
        return this.internalAdd(element);
    }

    @Override
    public boolean nullInsert(long index) {
        throw new NullPointerException();
    }

    @Override
    public long insertAll(long index, E ... elements) {
        Single.validateIndex(index);
        Single.validateElementsLength(elements.length);
        return this.internalAdd(elements[0]) ? 1 : 0;
    }

    @Override
    public long insertAll(long index, E[] elements, int offset, int length) {
        Single.validateIndex(index);
        return this.internalAdd(elements[offset]) ? 1 : 0;
    }

    @Override
    public long insertAll(long index, XGettingCollection<? extends E> elements) {
        Single.validateIndex(index);
        if (this.element != null) {
            return 0L;
        }
        return this.internalAdd(elements.get()) ? 1 : 0;
    }

    @Override
    public boolean prepend(E element) {
        return this.internalAdd(element);
    }

    @Override
    public boolean nullPrepend() {
        throw new NullPointerException();
    }

    @Override
    public boolean preput(E element) {
        return this.internalPut(element);
    }

    @Override
    public boolean nullPreput() {
        throw new NullPointerException();
    }

    @Override
    public boolean replaceOne(E element, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public long replace(E element, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        throw new NotImplementedYetError();
    }

    @Override
    public long replace(Predicate<? super E> predicate, E substitute) {
        throw new NotImplementedYetError();
    }

    @Override
    public long substitute(Function<? super E, ? extends E> mapper) {
        throw new NotImplementedYetError();
    }

    @Override
    public long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean set(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E setGet(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public void setFirst(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public void setLast(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E addGet(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E deduplicate(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E putGet(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E replace(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final Single<E> addAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> addAll(E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> addAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final Single<E> putAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> putAll(E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> putAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final Single<E> prependAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> prependAll(E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> prependAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final Single<E> preputAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> preputAll(E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> preputAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final Single<E> setAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> set(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> set(long index, XGettingSequence<? extends E> elements, long offset, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> swap(long indexA, long indexB) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> swap(long indexA, long indexB, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        procedure.accept(this.element);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        joiner.accept(this.element, aggregate);
        return aggregate;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        throw new NotImplementedYetError();
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> copy() {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> toReversed() {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> reverse() {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> range(long fromIndex, long toIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> fill(long offset, long length, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> sort(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> shiftTo(long sourceIndex, long targetIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> shiftBy(long sourceIndex, long distance) {
        throw new NotImplementedYetError();
    }

    @Override
    public Single<E> shiftBy(long sourceIndex, long distance, long length) {
        throw new NotImplementedYetError();
    }

    final class OldSingle
    implements one.microstream.collections.old.OldSingle<E> {
        OldSingle() {
        }

        @Override
        public int size() {
            return XTypes.to_int(Single.this.size());
        }

        @Override
        public boolean isEmpty() {
            return Single.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new NotImplementedYetError();
        }

        @Override
        public Iterator<E> iterator() {
            return Single.this.iterator();
        }

        @Override
        public Object[] toArray() {
            return new Object[]{Single.this.element};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new NotImplementedYetError();
        }

        @Override
        public boolean add(E e) {
            return Single.this.add(e);
        }

        @Override
        public boolean remove(Object o) {
            throw new NotImplementedYetError();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new NotImplementedYetError();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new NotImplementedYetError();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new NotImplementedYetError();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new NotImplementedYetError();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new NotImplementedYetError();
        }

        @Override
        public void clear() {
            Single.this.clear();
        }

        @Override
        public E get(int index) {
            return Single.this.at(index);
        }

        @Override
        public E set(int index, E element) {
            return Single.this.setGet(index, element);
        }

        @Override
        public void add(int index, E element) {
            Single.this.insert(index, element);
        }

        @Override
        public E remove(int index) {
            return Single.this.removeAt(index);
        }

        @Override
        public int indexOf(Object o) {
            throw new NotImplementedYetError();
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new NotImplementedYetError();
        }

        @Override
        public ListIterator<E> listIterator() {
            return Single.this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return Single.this.listIterator(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public Single<E> parent() {
            return Single.this;
        }
    }
}

