/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.collections.View;
import one.microstream.collections.old.BridgeXCollection;
import one.microstream.collections.types.XCollection;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XImmutableCollection;
import one.microstream.concurrency.Synchronized;
import one.microstream.equality.Equalator;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.SynchronizedIterator;

public final class SynchCollection<E>
implements XCollection<E>,
Synchronized {
    private final XCollection<E> subject;

    public SynchCollection(XCollection<E> collection) {
        this.subject = collection;
    }

    @Override
    public final synchronized E get() {
        return this.subject.get();
    }

    @Override
    public final synchronized Equalator<? super E> equality() {
        return this.subject.equality();
    }

    @Override
    @SafeVarargs
    public final synchronized SynchCollection<E> addAll(E ... elements) {
        this.subject.addAll((Object[])elements);
        return this;
    }

    @Override
    public final synchronized boolean nullAdd() {
        return this.subject.nullAdd();
    }

    @Override
    public final synchronized boolean add(E e) {
        return this.subject.add(e);
    }

    @Override
    public final synchronized SynchCollection<E> addAll(E[] elements, int offset, int length) {
        this.subject.addAll((Object[])elements, offset, length);
        return this;
    }

    @Override
    public final synchronized SynchCollection<E> addAll(XGettingCollection<? extends E> elements) {
        this.subject.addAll((XGettingCollection)elements);
        return this;
    }

    @Override
    public final synchronized boolean nullPut() {
        return this.subject.nullPut();
    }

    @Override
    public final synchronized void accept(E e) {
        this.subject.accept(e);
    }

    @Override
    public final synchronized boolean put(E e) {
        return this.subject.put(e);
    }

    @Override
    @SafeVarargs
    public final synchronized SynchCollection<E> putAll(E ... elements) {
        this.subject.putAll((Object[])elements);
        return this;
    }

    @Override
    public final synchronized SynchCollection<E> putAll(XGettingCollection<? extends E> elements) {
        this.subject.putAll((XGettingCollection)elements);
        return this;
    }

    @Override
    public final synchronized SynchCollection<E> putAll(E[] elements, int offset, int length) {
        this.subject.putAll((Object[])elements, offset, length);
        return this;
    }

    @Override
    public final synchronized boolean containsSearched(Predicate<? super E> predicate) {
        return this.subject.containsSearched(predicate);
    }

    @Override
    public final synchronized boolean applies(Predicate<? super E> predicate) {
        return this.subject.applies(predicate);
    }

    @Override
    public final synchronized void clear() {
        this.subject.clear();
    }

    @Override
    public final synchronized long consolidate() {
        return this.subject.consolidate();
    }

    @Override
    public final synchronized boolean contains(E element) {
        return this.subject.contains(element);
    }

    @Override
    public final synchronized boolean containsAll(XGettingCollection<? extends E> elements) {
        return this.subject.containsAll(elements);
    }

    @Override
    public final synchronized boolean containsId(E element) {
        return this.subject.containsId(element);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.subject.filterTo(target, predicate);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C copyTo(C target) {
        return this.subject.copyTo(target);
    }

    @Override
    public final synchronized long count(E element) {
        return this.subject.count(element);
    }

    @Override
    public final synchronized long countBy(Predicate<? super E> predicate) {
        return this.subject.countBy(predicate);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.subject.distinct(target, equalator);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C distinct(C target) {
        return this.subject.distinct(target);
    }

    @Override
    public final synchronized SynchCollection<E> ensureFreeCapacity(long minimalFreeCapacity) {
        this.subject.ensureFreeCapacity(minimalFreeCapacity);
        return this;
    }

    @Override
    public final synchronized SynchCollection<E> ensureCapacity(long minimalCapacity) {
        this.subject.ensureCapacity(minimalCapacity);
        return this;
    }

    @Override
    @Deprecated
    public final synchronized boolean equals(Object o) {
        return this.subject.equals(o);
    }

    @Override
    public final synchronized boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equals(this.subject, equalator);
    }

    @Override
    public final synchronized boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equalsContent(this.subject, equalator);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.except(other, equalator, target);
    }

    @Override
    public final synchronized <P extends Consumer<? super E>> P iterate(P procedure) {
        return this.subject.iterate(procedure);
    }

    @Override
    public final synchronized <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        return this.subject.join(joiner, aggregate);
    }

    @Override
    @Deprecated
    public final synchronized int hashCode() {
        return this.subject.hashCode();
    }

    @Override
    public final synchronized boolean hasVolatileElements() {
        return this.subject.hasVolatileElements();
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.intersect(other, equalator, target);
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public final synchronized Iterator<E> iterator() {
        return new SynchronizedIterator(this.subject.iterator());
    }

    @Override
    public final synchronized E max(Comparator<? super E> comparator) {
        return this.subject.max(comparator);
    }

    @Override
    public final synchronized E min(Comparator<? super E> comparator) {
        return this.subject.min(comparator);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        return this.subject.moveTo(target, predicate);
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        return this.subject.process(procedure);
    }

    @Override
    public final synchronized E fetch() {
        return this.subject.fetch();
    }

    @Override
    public final synchronized E pinch() {
        return this.subject.pinch();
    }

    @Override
    public final synchronized long removeBy(Predicate<? super E> predicate) {
        return this.subject.removeBy(predicate);
    }

    @Override
    public final synchronized E retrieve(E element) {
        return this.subject.retrieve(element);
    }

    @Override
    public final synchronized E retrieveBy(Predicate<? super E> predicate) {
        return this.subject.retrieveBy(predicate);
    }

    @Override
    public final synchronized boolean removeOne(E element) {
        return this.subject.removeOne(element);
    }

    @Override
    public final synchronized long remove(E element) {
        return this.subject.remove(element);
    }

    @Override
    public final synchronized long removeAll(XGettingCollection<? extends E> samples) {
        return this.subject.removeAll(this.subject);
    }

    @Override
    public final synchronized long removeDuplicates(Equalator<? super E> equalator) {
        return this.subject.removeDuplicates(equalator);
    }

    @Override
    public final synchronized long removeDuplicates() {
        return this.subject.removeDuplicates();
    }

    @Override
    public final synchronized long retainAll(XGettingCollection<? extends E> samples) {
        return this.subject.retainAll(this.subject);
    }

    @Override
    public final synchronized E seek(E sample) {
        return this.subject.seek(sample);
    }

    @Override
    public final synchronized E search(Predicate<? super E> predicate) {
        return this.subject.search(predicate);
    }

    @Override
    public final synchronized long optimize() {
        return this.subject.optimize();
    }

    @Override
    public final synchronized long size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public final synchronized Object[] toArray() {
        return this.subject.toArray();
    }

    @Override
    public final synchronized E[] toArray(Class<E> type) {
        return this.subject.toArray(type);
    }

    @Override
    public final synchronized void truncate() {
        this.subject.truncate();
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.union(other, equalator, target);
    }

    @Override
    public final synchronized long currentCapacity() {
        return this.subject.currentCapacity();
    }

    @Override
    public final synchronized long maximumCapacity() {
        return this.subject.maximumCapacity();
    }

    @Override
    public final synchronized boolean isFull() {
        return this.subject.isFull();
    }

    @Override
    public final synchronized long remainingCapacity() {
        return this.subject.remainingCapacity();
    }

    @Override
    public final synchronized boolean nullAllowed() {
        return this.subject.nullAllowed();
    }

    @Override
    public final synchronized boolean nullContained() {
        return this.subject.nullContained();
    }

    @Override
    public final synchronized long nullRemove() {
        return this.subject.nullRemove();
    }

    @Override
    public final synchronized SynchCollection<E> copy() {
        return new SynchCollection<E>(this.subject.copy());
    }

    @Override
    public final synchronized XImmutableCollection<E> immure() {
        return this.subject.immure();
    }

    @Override
    public final View<E> view() {
        return new View(this);
    }

    @Override
    public final OldSynchCollection<E> old() {
        return new OldSynchCollection(this);
    }

    public static final class OldSynchCollection<E>
    extends BridgeXCollection<E> {
        OldSynchCollection(SynchCollection<E> set) {
            super(set);
        }

        @Override
        public final SynchCollection<E> parent() {
            return (SynchCollection)super.parent();
        }
    }
}

