/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.com;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import one.microstream.X;
import one.microstream.com.ComException;
import one.microstream.com.ComExceptionTimeout;
import one.microstream.memory.XMemory;

public final class XSockets {
    private static final int IO_LOOP_SLEEP_TIME = 10;

    public static ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    public static final ServerSocketChannel openServerSocketChannel(InetSocketAddress address) throws ComException {
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().bind(address);
            return serverSocketChannel;
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static final SocketChannel acceptSocketChannel(ServerSocketChannel serverSocketChannel) throws ComException {
        try {
            return serverSocketChannel.accept();
        }
        catch (Exception e) {
            throw new ComException(e);
        }
    }

    public static SocketChannel openChannel(InetSocketAddress address) throws ComException {
        X.notNull(address);
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.connect(address);
            return socketChannel;
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static InetAddress localHostAddress() throws ComException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new ComException(e);
        }
    }

    public static InetSocketAddress localHostSocketAddress() throws ComException {
        return XSockets.localHostSocketAddress(0);
    }

    public static InetSocketAddress localHostSocketAddress(int port) throws ComException {
        return new InetSocketAddress(XSockets.localHostAddress(), port);
    }

    public static SocketChannel openChannelLocalhost() throws ComException {
        return XSockets.openChannel(XSockets.localHostSocketAddress());
    }

    public static SocketChannel openChannelLocalhost(int port) throws ComException {
        return XSockets.openChannel(XSockets.localHostSocketAddress(port));
    }

    public static final void closeChannel(NetworkChannel channel) throws ComException {
        try {
            channel.close();
        }
        catch (Exception e) {
            throw new ComException(e);
        }
    }

    public static ByteBuffer writeCompletely(SocketChannel socketChannel, ByteBuffer byteBuffer) throws ComException {
        try {
            socketChannel.write(byteBuffer);
            return byteBuffer;
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static ByteBuffer readCompletely(SocketChannel socketChannel, ByteBuffer byteBuffer) throws ComException {
        try {
            socketChannel.read(byteBuffer);
            return byteBuffer;
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static final ByteBuffer readIntoBufferKnownLength(SocketChannel channel, ByteBuffer buffer, int responseTimeout, int length) throws ComException {
        ByteBuffer checkedBuffer;
        if (length > buffer.capacity()) {
            checkedBuffer = XMemory.allocateDirectNative(length);
        } else {
            checkedBuffer = buffer;
            checkedBuffer.clear().limit(length);
        }
        XSockets.readIntoBuffer(channel, checkedBuffer, responseTimeout);
        return checkedBuffer;
    }

    public static void read(SocketChannel channel, ByteBuffer buffer) throws ComException {
        try {
            channel.read(buffer);
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static void write(SocketChannel channel, ByteBuffer buffer) throws ComException {
        try {
            channel.write(buffer);
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static void readIntoBuffer(SocketChannel channel, ByteBuffer buffer, int responseTimeout) throws ComException, ComExceptionTimeout {
        XSockets.performIoOperation(buffer, XSockets::read, channel, responseTimeout);
    }

    public static void writeFromBuffer(SocketChannel channel, ByteBuffer buffer, int responseTimeout) throws ComException, ComExceptionTimeout {
        XSockets.performIoOperation(buffer, XSockets::write, channel, responseTimeout);
    }

    private static void performIoOperation(ByteBuffer buffer, IoOperation operation, SocketChannel channel, int responseTimeout) throws ComException, ComExceptionTimeout {
        long responseTimeoutPoint = System.currentTimeMillis() + (long)responseTimeout;
        long remaining = buffer.remaining();
        while (true) {
            operation.execute(channel, buffer);
            if (!buffer.hasRemaining()) break;
            if ((long)buffer.remaining() < remaining) {
                responseTimeoutPoint = System.currentTimeMillis() + (long)responseTimeout;
                remaining = buffer.remaining();
            } else if (System.currentTimeMillis() >= responseTimeoutPoint) {
                throw new ComExceptionTimeout();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private XSockets() {
        throw new UnsupportedOperationException();
    }

    private static interface IoOperation {
        public void execute(SocketChannel var1, ByteBuffer var2) throws ComException;
    }
}

