/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.concurrency;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.collections.interfaces.ConsolidatableCollection;
import one.microstream.collections.interfaces.OptimizableCollection;
import one.microstream.math.XMath;
import one.microstream.reference.Referencing;

public class Threaded<E>
implements ConsolidatableCollection,
OptimizableCollection,
Referencing<E> {
    private volatile Entry<E>[] slots;
    private volatile int size;
    private volatile Consumer<E> cleanUpOperation;

    private static <E> Entry<E>[] createSlots(int minimumLength) {
        if (XMath.isGreaterThanOrEqualHighestPowerOf2(minimumLength)) {
            return new Entry[XMath.highestPowerOf2_int()];
        }
        int slotCount = 1;
        while (slotCount < minimumLength) {
            slotCount <<= 1;
        }
        return new Entry[slotCount];
    }

    public static final <E> Threaded<E> New() {
        return new Threaded<E>();
    }

    public static final <E> Threaded<E> New(E currentThreadsElement) {
        Threaded<E> threaded = new Threaded<E>();
        threaded.set(currentThreadsElement);
        return threaded;
    }

    public Threaded() {
        this.slots = new Entry[1];
        this.size = 0;
        this.cleanUpOperation = null;
    }

    public Threaded(int initialCapacity) {
        this.slots = Threaded.createSlots(initialCapacity);
        this.size = 0;
        this.cleanUpOperation = null;
    }

    public Consumer<E> getCleanUpOperation() {
        return this.cleanUpOperation;
    }

    public Threaded<E> setCleanUpOperation(Consumer<E> cleanUpOperation) {
        this.cleanUpOperation = cleanUpOperation;
        return this;
    }

    @Override
    public E get() {
        Entry<E>[] slots = this.slots;
        Entry<E> e = this.slots[System.identityHashCode(Thread.currentThread()) & slots.length - 1];
        while (e != null) {
            if (e.get() == Thread.currentThread()) {
                return e.value;
            }
            e = e.next;
        }
        return this.lookupMissFallbackElement();
    }

    public E set(E element) {
        Entry<E>[] slots = this.slots;
        Entry<E> e = this.slots[System.identityHashCode(Thread.currentThread()) & slots.length - 1];
        while (e != null) {
            if (e.get() == Thread.currentThread()) {
                Object old = e.value;
                e.value = element;
                return old;
            }
            e = e.next;
        }
        this.addForCurrentThread(element);
        return null;
    }

    public E remove() {
        Entry<E>[] slots = this.slots;
        Entry<E> e = this.slots[System.identityHashCode(Thread.currentThread()) & slots.length - 1];
        while (e != null) {
            if (e.get() == Thread.currentThread()) {
                this.removeForCurrentThread(System.identityHashCode(Thread.currentThread()));
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected E lookupMissFallbackElement() {
        return null;
    }

    protected void addForCurrentThread(E element) {
        this.addEntry(System.identityHashCode(Thread.currentThread()), new Entry<E>(element));
    }

    private synchronized void addEntry(int threadIdHashCode, Entry<E> entry) {
        Entry<E>[] slots = this.slots;
        this.slots[threadIdHashCode & slots.length - 1] = entry.next(slots[threadIdHashCode & slots.length - 1]);
        if (this.size++ == slots.length) {
            this.internalOptimize();
        }
    }

    private synchronized void removeForCurrentThread(int threadIdHashCode) {
        Entry<E>[] slots = this.slots;
        Entry<E> head = this.slots[threadIdHashCode & slots.length - 1];
        if (head != null) {
            if (head.get() == Thread.currentThread()) {
                slots[threadIdHashCode & slots.length - 1] = head.next;
                head.next = null;
                head.value = null;
                return;
            }
            Entry<E> last = head;
            Entry entry = last.next;
            while (entry != null) {
                if (entry.get() == Thread.currentThread()) {
                    last.next = entry.next;
                    entry.next = null;
                    entry.value = null;
                    return;
                }
                last = entry;
                entry = last.next;
            }
        }
    }

    private int internalOptimize() {
        Entry[] buffer = new Entry[this.size];
        Entry<E>[] slots = this.slots;
        int slotsLength = this.slots.length;
        Consumer<E> cleanUpOp = this.cleanUpOperation;
        int count = 0;
        int i = 0;
        while (i < slotsLength) {
            Entry<E> entry = slots[i];
            while (entry != null) {
                if (entry.get() != null) {
                    buffer[count++] = entry;
                } else if (cleanUpOp != null) {
                    try {
                        cleanUpOp.accept(entry.value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                entry = entry.next;
            }
            ++i;
        }
        if (count == buffer.length && count < slotsLength) {
            return slotsLength - count;
        }
        Entry<E>[] newSlots = Threaded.createSlots(count);
        int modulo = newSlots.length - 1;
        int i2 = 0;
        while (i2 < count) {
            Thread thread = (Thread)buffer[i2].get();
            if (thread == null) {
                if (cleanUpOp != null) {
                    try {
                        cleanUpOp.accept(buffer[i2].value);
                    }
                    catch (Exception exception) {}
                }
            } else {
                int index = System.identityHashCode(thread) & modulo;
                newSlots[index] = new Entry(thread, buffer[i2].value, newSlots[index]);
            }
            ++i2;
        }
        this.size = count;
        this.slots = newSlots;
        return newSlots.length - count;
    }

    @Override
    public synchronized long optimize() {
        return this.internalOptimize();
    }

    @Override
    public synchronized long consolidate() {
        int oldSize = this.size;
        this.internalOptimize();
        return oldSize - this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long size() {
        return this.size;
    }

    public synchronized boolean containsSearched(Predicate<? super E> predicate) {
        Entry<E>[] slots = this.slots;
        int slotsLength = this.slots.length;
        int i = 0;
        while (i < slotsLength) {
            Entry<E> entry = slots[i];
            while (entry != null) {
                if (predicate.test(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
            ++i;
        }
        return false;
    }

    private static final class Entry<E>
    extends WeakReference<Thread> {
        E value;
        Entry<E> next;

        Entry(E value) {
            super(Thread.currentThread());
            this.value = value;
            this.next = null;
        }

        Entry(Thread thread, E value, Entry<E> next) {
            super(thread);
            this.value = value;
            this.next = next;
        }

        Entry<E> next(Entry<E> next) {
            this.next = next;
            return this;
        }
    }
}

