/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.concurrency;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public final class XThreads {
    private static final Object GLOBAL_LOCK = new Object();
    private static final Method Throwable_getStackTraceElement = XThreads.getThrowable_getStackTraceElement();
    private static final Integer ONE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeSynchronized(Supplier<T> logic) {
        Object object = GLOBAL_LOCK;
        synchronized (object) {
            return logic.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSynchronized(Runnable logic) {
        Object object = GLOBAL_LOCK;
        synchronized (object) {
            logic.run();
        }
    }

    public static final <T extends Thread> T start(T thread) {
        thread.start();
        return thread;
    }

    public static final Thread start(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.start();
        return t;
    }

    public static final void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static final void sleep(long millis, int nanos) {
        try {
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static final void executeDelayed(final long millis, final Runnable action) {
        new Thread(){

            @Override
            public void run() {
                XThreads.sleep(millis);
                action.run();
            }
        }.start();
    }

    public static final String getSourcePosition() {
        String stackTraceElementString = new Throwable().getStackTrace()[1].toString();
        return stackTraceElementString.substring(stackTraceElementString.indexOf(46));
    }

    private static final Method getThrowable_getStackTraceElement() {
        try {
            Method m = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final StackTraceElement getStackTraceElement() {
        try {
            return (StackTraceElement)Throwable_getStackTraceElement.invoke((Object)new Throwable(), ONE);
        }
        catch (Exception e) {
            return new Throwable().getStackTrace()[1];
        }
    }

    public static final StackTraceElement getStackTraceElement(Integer index) {
        try {
            return (StackTraceElement)Throwable_getStackTraceElement.invoke((Object)new Throwable(), index);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
        catch (Exception e) {
            return new Throwable().getStackTrace()[index];
        }
    }

    public static StackTraceElement getStackTraceElementForDeclaringClass(Class<?> declaringClass) {
        return XThreads.getStackTraceElementForDeclaringClassName(declaringClass.getName());
    }

    public static StackTraceElement getStackTraceElementForDeclaringClassName(String declaringClassName) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (e.getClassName().equals(declaringClassName)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static String getMethodNameForDeclaringClass(Class<?> declaringClass) {
        return XThreads.getMethodNameForDeclaringClassName(declaringClass.getName());
    }

    public static String getMethodNameForDeclaringClassName(String declaringClassName) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (e.getClassName().equals(declaringClassName)) {
                return e.getMethodName();
            }
            ++n2;
        }
        return null;
    }

    public static String getCurrentMethodName() {
        return new Throwable().getStackTrace()[1].getMethodName();
    }

    public static void defaultHandleUncaughtThrowable(Thread t, Throwable e) {
        if (e instanceof ThreadDeath) {
            return;
        }
        System.err.print("Exception in thread \"" + t.getName() + "\" ");
        e.printStackTrace(System.err);
    }

    private XThreads() {
        throw new UnsupportedOperationException();
    }
}

