/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.entity;

import one.microstream.X;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XCollection;
import one.microstream.collections.types.XGettingList;
import one.microstream.entity.EntityExceptionIdentityMismatch;
import one.microstream.entity.EntityExceptionInaccessibleEntityType;
import one.microstream.entity.EntityLayer;
import one.microstream.entity.EntityLayerIdentity;
import one.microstream.entity.EntityLayerProvider;
import one.microstream.entity.EntityLayerProviderProvider;

public interface Entity {
    public static <E extends Entity> E identity(E instance) {
        if (instance instanceof AbstractAccessible) {
            return (E)((AbstractAccessible)instance).entityIdentity();
        }
        if (instance instanceof Accessible) {
            return (E)((Accessible)instance).entityIdentity();
        }
        if (instance == null) {
            return null;
        }
        throw new EntityExceptionInaccessibleEntityType(instance);
    }

    public static <E extends Entity> E data(E instance) {
        if (instance instanceof AbstractAccessible) {
            return (E)((AbstractAccessible)instance).entityData();
        }
        if (instance instanceof Accessible) {
            return (E)((Accessible)instance).entityData();
        }
        if (instance == null) {
            return null;
        }
        throw new EntityExceptionInaccessibleEntityType(instance);
    }

    public static <E extends Entity> boolean updateData(E entity, E data) {
        if (entity instanceof AbstractAccessible) {
            return ((AbstractAccessible)entity).updateEntityData(data);
        }
        if (entity instanceof Accessible) {
            return ((Accessible)entity).updateEntityData(data);
        }
        throw new EntityExceptionInaccessibleEntityType(entity);
    }

    public static <E> E searchLayer(Entity entity, Class<E> type) {
        Entity layer = Entity.identity(entity);
        do {
            if (!type.isInstance(layer)) continue;
            return type.cast(layer);
        } while ((layer = Static.inner(layer)) != null);
        return null;
    }

    public static XGettingList<Entity> layers(Entity entity) {
        BulkList<Entity> layers = BulkList.New();
        Entity layer = Entity.identity(entity);
        do {
            layers.add(layer);
        } while ((layer = Static.inner(layer)) != null);
        return layers.immure();
    }

    default public boolean isSameIdentity(Entity other) {
        return Entity.identity(this) == Entity.identity(other);
    }

    default public void validateIdentity(Entity newData) {
        if (this.isSameIdentity(newData)) {
            return;
        }
        throw new EntityExceptionIdentityMismatch(this, newData);
    }

    public static abstract class AbstractAccessible
    implements Entity {
        protected abstract Entity entityIdentity();

        protected abstract Entity entityData();

        protected abstract void entityCreated();

        protected abstract boolean updateEntityData(Entity var1);
    }

    public static interface Accessible
    extends Entity {
        public Entity entityIdentity();

        public Entity entityData();

        public void entityCreated();

        public boolean updateEntityData(Entity var1);
    }

    public static interface Creator<E extends Entity, C extends Creator<E, C>> {
        public E create();

        public E createData(E var1);

        public C copy(E var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public C addLayer(EntityLayerProvider layerProvider) {
            Creator creator = this;
            synchronized (creator) {
                XCollection<EntityLayerProvider> layerProviders;
                XCollection<EntityLayerProvider> xCollection = layerProviders = this.layers();
                synchronized (xCollection) {
                    layerProviders.add(layerProvider);
                }
            }
            return (C)this;
        }

        default public C addLayer(EntityLayerProviderProvider layerProviderProvider) {
            return this.addLayer(layerProviderProvider.provideEntityLayerProvider());
        }

        public XCollection<EntityLayerProvider> layers();

        public static abstract class Abstract<E extends Entity, C extends Creator<E, C>>
        implements Creator<E, C> {
            private final BulkList<EntityLayerProvider> layerProviders = BulkList.New();

            @Override
            public XCollection<EntityLayerProvider> layers() {
                return this.layerProviders;
            }

            protected Entity dispatchDataInstance(Entity dataInstance) {
                Entity innerLayer = dataInstance;
                for (EntityLayerProvider lp : this.layerProviders) {
                    innerLayer = lp.provideEntityLayer(innerLayer);
                }
                return innerLayer;
            }

            @Override
            public E create() {
                EntityLayerIdentity entity = this.createEntityInstance();
                Entity data = this.createData(entity.entityIdentity());
                Entity innerInstance = this.dispatchDataInstance(data);
                entity.setInner(innerInstance);
                Static.entityCreated(entity);
                return (E)entity.entityIdentity();
            }

            protected abstract EntityLayerIdentity createEntityInstance();
        }

        public static class Static {
            static void entityCreated(Entity entity) {
                if (entity instanceof AbstractAccessible) {
                    ((AbstractAccessible)entity).entityCreated();
                } else if (entity instanceof Accessible) {
                    ((Accessible)entity).entityCreated();
                }
            }
        }
    }

    public static final class Static {
        public static Entity inner(Entity entity) {
            return entity instanceof EntityLayer ? ((EntityLayer)entity).inner() : null;
        }

        private Static() {
            throw new Error();
        }
    }

    public static interface Updater<E extends Entity, U extends Updater<E, U>> {
        public boolean update();

        public U copy(E var1);

        public static abstract class Abstract<E extends Entity, U extends Updater<E, U>>
        implements Updater<E, U> {
            private final E entityIdentity;

            protected Abstract(E entity) {
                this.entityIdentity = Entity.identity((Entity)X.notNull(entity));
                this.copy(Entity.data(entity));
            }

            protected abstract E createData(E var1);

            @Override
            public boolean update() {
                return Entity.updateData(this.entityIdentity, this.createData(this.entityIdentity));
            }
        }
    }
}

