/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.functional;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.equality.Equalator;
import one.microstream.functional.AbstractProcedureLimit;
import one.microstream.functional.AbstractProcedureSkip;
import one.microstream.functional.AbstractProcedureSkipLimit;
import one.microstream.functional.AggregateCount;
import one.microstream.functional.Aggregator;
import one.microstream.functional.EqualsSample;

public final class XFunc {
    public static final <T> Predicate<T> all() {
        return e -> true;
    }

    public static final <T> Predicate<T> any() {
        return XFunc.all();
    }

    public static final <T> Predicate<T> none() {
        return e -> false;
    }

    public static <T> Predicate<T> notNull() {
        return e -> e != null;
    }

    public static final <T, R> Function<T, R> toNull() {
        return t -> null;
    }

    public static final <T> Function<T, T> passThrough() {
        return t -> t;
    }

    public static <E> void noOp(E e) {
    }

    @SafeVarargs
    public static final <T> Predicate<T> all(Predicate<? super T> ... predicates) {
        return e -> {
            Predicate[] predicateArray2 = predicates;
            int n = predicates.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate predicate = predicateArray2[n2];
                if (!predicate.test(e)) {
                    return false;
                }
                ++n2;
            }
            return true;
        };
    }

    public static final <T> Predicate<T> select(Predicate<T> predicate) {
        return predicate;
    }

    @SafeVarargs
    public static final <T> Predicate<T> one(Predicate<? super T> ... predicates) {
        return e -> {
            int size = predicates.length;
            int i = 0;
            while (i < size) {
                if (!predicates[i++].test(e)) continue;
                while (i < size) {
                    if (!predicates[i++].test(e)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    public static final <E> Predicate<E> isEqual(E sample, Equalator<? super E> equalator) {
        return new EqualsSample<E>(sample, equalator);
    }

    public static final <T> Predicate<T> isEqualTo(final T subject) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return subject == null ? o == null : subject.equals(o);
            }
        };
    }

    public static final <T> Predicate<T> isSameAs(final T subject) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return subject == o;
            }
        };
    }

    public static final <T, E extends T> Predicate<T> predicate(final E subject, final Equalator<T> equalator) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return equalator.equal(subject, t);
            }
        };
    }

    public static Predicate<Object> isInstanceOf(Class<?> type) {
        return e -> type.isInstance(e);
    }

    public static Predicate<Object> notIsInstanceOf(Class<?> type) {
        return e -> !type.isInstance(e);
    }

    public static final Predicate<Object> isInstanceOf(Class<?> ... types) {
        return object -> {
            Class[] classArray2 = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class type = classArray2[n2];
                if (type.isInstance(object)) {
                    return true;
                }
                ++n2;
            }
            return false;
        };
    }

    public static final Predicate<Object> notIsInstanceOf(Class<?> ... types) {
        return object -> {
            Class[] classArray2 = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class type = classArray2[n2];
                if (type.isInstance(object)) {
                    return false;
                }
                ++n2;
            }
            return true;
        };
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static final Aggregator<Integer, Integer> max(int initialValue) {
        return new MaxInteger(initialValue);
    }

    public static final <E> AggregateCount<E> count() {
        return new AggregateCount();
    }

    public static final <E, R> Aggregator<E, R> aggregator(final BiConsumer<? super E, ? super R> joiner, final R aggregate) {
        return new Aggregator<E, R>(){

            @Override
            public void accept(E element) {
                joiner.accept(element, aggregate);
            }

            @Override
            public R yield() {
                return aggregate;
            }
        };
    }

    public static <E> Aggregator<E, Long> counter() {
        return new Aggregator<E, Long>(){
            long count;

            @Override
            public void accept(E element) {
                ++this.count;
            }

            @Override
            public Long yield() {
                return this.count;
            }
        };
    }

    public static <E> Consumer<E> wrapWithSkip(final Consumer<? super E> target, long skip) {
        return new AbstractProcedureSkip<E>(skip){

            @Override
            public void accept(E e) {
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(e);
            }
        };
    }

    public static <E> Consumer<E> wrapWithLimit(final Consumer<? super E> target, long limit) {
        return new AbstractProcedureLimit<E>(limit){

            @Override
            public void accept(E e) {
                target.accept(e);
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static <E> Consumer<E> wrapWithSkipLimit(final Consumer<? super E> target, long skip, long limit) {
        return new AbstractProcedureSkipLimit<E>(skip, limit){

            @Override
            public void accept(E e) {
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(e);
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static final <E> Consumer<E> wrapWithPredicate(Consumer<? super E> target, Predicate<? super E> predicate) {
        return e -> {
            if (!predicate.test((Object)e)) {
                return;
            }
            target.accept((Object)e);
        };
    }

    public static <E> Consumer<E> wrapWithPredicateSkip(final Consumer<? super E> target, final Predicate<? super E> predicate, long skip) {
        return new AbstractProcedureSkip<E>(skip){

            @Override
            public void accept(E e) {
                if (!predicate.test(e)) {
                    return;
                }
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(e);
            }
        };
    }

    public static <E> Consumer<E> wrapWithPredicateLimit(final Consumer<? super E> target, final Predicate<? super E> predicate, long limit) {
        return new AbstractProcedureLimit<E>(limit){

            @Override
            public void accept(E e) {
                if (!predicate.test(e)) {
                    return;
                }
                target.accept(e);
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static <E> Consumer<E> wrapWithPredicateSkipLimit(final Consumer<? super E> target, final Predicate<? super E> predicate, long skip, long limit) {
        return new AbstractProcedureSkipLimit<E>(skip, limit){

            @Override
            public void accept(E e) {
                if (!predicate.test(e)) {
                    return;
                }
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(e);
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static final <I, O> Consumer<I> wrapWithFunction(Consumer<? super O> target, Function<? super I, O> function) {
        return e -> target.accept((Object)function.apply((Object)e));
    }

    public static <I, O> Consumer<I> wrapWithFunctionSkip(final Consumer<? super O> target, final Function<? super I, O> function, long skip) {
        return new AbstractProcedureSkip<I>(skip){

            @Override
            public void accept(I e) {
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(function.apply(e));
            }
        };
    }

    public static <I, O> Consumer<I> wrapWithFunctionLimit(final Consumer<? super O> target, final Function<? super I, O> function, long limit) {
        return new AbstractProcedureLimit<I>(limit){

            @Override
            public void accept(I e) {
                target.accept(function.apply(e));
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static <I, O> Consumer<I> wrapWithFunctionSkipLimit(final Consumer<? super O> target, final Function<? super I, O> function, long skip, long limit) {
        return new AbstractProcedureSkipLimit<I>(skip, limit){

            @Override
            public void accept(I e) {
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(function.apply(e));
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static final <I, O> Consumer<I> wrapWithPredicateFunction(Consumer<? super O> target, Predicate<? super I> predicate, Function<? super I, O> function) {
        return e -> {
            if (!predicate.test((Object)e)) {
                return;
            }
            target.accept((Object)function.apply((Object)e));
        };
    }

    public static <I, O> Consumer<I> wrapWithPredicateFunctionSkip(final Consumer<? super O> target, final Predicate<? super I> predicate, final Function<? super I, O> function, long skip) {
        return new AbstractProcedureSkip<I>(skip){

            @Override
            public void accept(I e) {
                if (!predicate.test(e)) {
                    return;
                }
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(function.apply(e));
            }
        };
    }

    public static <I, O> Consumer<I> wrapWithPredicateFunctionLimit(final Consumer<? super O> target, final Predicate<? super I> predicate, final Function<? super I, O> function, long limit) {
        return new AbstractProcedureLimit<I>(limit){

            @Override
            public void accept(I e) {
                if (!predicate.test(e)) {
                    return;
                }
                target.accept(function.apply(e));
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static <I, O> Consumer<I> wrapWithPredicateFunctionSkipLimit(final Consumer<? super O> target, final Predicate<? super I> predicate, final Function<? super I, O> function, long skip, long limit) {
        return new AbstractProcedureSkipLimit<I>(skip, limit){

            @Override
            public void accept(I e) {
                if (!predicate.test(e)) {
                    return;
                }
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(function.apply(e));
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static final <T extends S, S> Function<T, S> upcast() {
        return XFunc.passThrough();
    }

    private XFunc() {
        throw new UnsupportedOperationException();
    }

    public static final class MaxInteger
    implements Aggregator<Integer, Integer> {
        private int max;

        public MaxInteger(int max) {
            this.max = max;
        }

        @Override
        public final void accept(Integer value) {
            if (value != null && value > this.max) {
                this.max = value;
            }
        }

        @Override
        public final Integer yield() {
            return this.max;
        }
    }
}

