/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import one.microstream.X;

public final class ByteBufferInputStream
extends InputStream {
    private final List<ByteBuffer> sourceBuffers = new ArrayList<ByteBuffer>();
    private int currentBufferIndex = 0;

    public static ByteBufferInputStream New(ByteBuffer sourceBuffer) {
        return new ByteBufferInputStream(Arrays.asList(X.notNull(sourceBuffer)));
    }

    public static ByteBufferInputStream New(Iterable<? extends ByteBuffer> sourceBuffers) {
        return new ByteBufferInputStream(X.notNull(sourceBuffers));
    }

    private ByteBufferInputStream(Iterable<? extends ByteBuffer> sourceBuffers) {
        sourceBuffers.forEach(this.sourceBuffers::add);
    }

    private synchronized int internalRead(Function<ByteBuffer, Integer> reader) {
        if (this.sourceBuffers == null || this.currentBufferIndex >= this.sourceBuffers.size()) {
            return -1;
        }
        ByteBuffer currentBuffer = this.sourceBuffers.get(this.currentBufferIndex);
        while (!currentBuffer.hasRemaining()) {
            if (++this.currentBufferIndex >= this.sourceBuffers.size()) {
                return -1;
            }
            currentBuffer = this.sourceBuffers.get(this.currentBufferIndex);
        }
        return reader.apply(currentBuffer);
    }

    @Override
    public synchronized int available() throws IOException {
        int available = 0;
        int i = this.currentBufferIndex;
        int c = this.sourceBuffers.size();
        while (i < c) {
            available += this.sourceBuffers.get(i).remaining();
            ++i;
        }
        return available;
    }

    @Override
    public int read() throws IOException {
        return this.internalRead(buffer -> buffer.get() & 0xFF);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.internalRead(buffer -> {
            int amount = Math.min(length, buffer.remaining());
            buffer.get(bytes, offset, amount);
            return amount;
        });
    }
}

