/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import one.microstream.X;
import one.microstream.math.XMath;

public final class LimitedInputStream
extends FilterInputStream {
    private long left;
    private long mark = -1L;

    public static LimitedInputStream New(InputStream in, long limit) {
        return new LimitedInputStream(X.notNull(in), XMath.positive(limit));
    }

    private LimitedInputStream(InputStream in, long limit) {
        super(in);
        this.left = limit;
    }

    @Override
    public int available() throws IOException {
        return X.checkArrayRange(Math.min((long)this.in.available(), this.left));
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.left;
    }

    @Override
    public int read() throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            --this.left;
        }
        return result;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read(bytes, offset, X.checkArrayRange(Math.min((long)length, this.left)));
        if (result > 0) {
            this.left -= (long)result;
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(Math.min(n, this.left));
        this.left -= skipped;
        return skipped;
    }
}

