/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.memory;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import one.microstream.exceptions.InstantiationRuntimeException;
import one.microstream.memory.MemoryAccessor;
import one.microstream.memory.MemoryStatistics;

public class MemoryAccessorReversing
implements MemoryAccessor {
    private final MemoryAccessor actual;

    MemoryAccessorReversing(MemoryAccessor actual) {
        this.actual = actual;
    }

    @Override
    public final void guaranteeUsability() {
        this.actual.guaranteeUsability();
    }

    @Override
    public final long getDirectByteBufferAddress(ByteBuffer directBuffer) {
        return this.actual.getDirectByteBufferAddress(directBuffer);
    }

    @Override
    public final boolean deallocateDirectByteBuffer(ByteBuffer directBuffer) {
        return this.actual.deallocateDirectByteBuffer(directBuffer);
    }

    @Override
    public final boolean isDirectByteBuffer(ByteBuffer byteBuffer) {
        return this.actual.isDirectByteBuffer(byteBuffer);
    }

    @Override
    public final ByteBuffer guaranteeDirectByteBuffer(ByteBuffer directBuffer) {
        return this.actual.guaranteeDirectByteBuffer(directBuffer);
    }

    @Override
    public final long allocateMemory(long bytes) {
        return this.actual.allocateMemory(bytes);
    }

    @Override
    public final long reallocateMemory(long address, long bytes) {
        return this.actual.reallocateMemory(address, bytes);
    }

    @Override
    public final void freeMemory(long address) {
        this.actual.freeMemory(address);
    }

    @Override
    public final void fillMemory(long address, long length, byte value) {
        this.actual.fillMemory(address, length, value);
    }

    @Override
    public final byte get_byte(long address) {
        return this.actual.get_byte(address);
    }

    @Override
    public final boolean get_boolean(long address) {
        return this.actual.get_boolean(address);
    }

    @Override
    public final short get_short(long address) {
        return Short.reverseBytes(this.actual.get_short(address));
    }

    @Override
    public final char get_char(long address) {
        return Character.reverseBytes(this.actual.get_char(address));
    }

    @Override
    public final int get_int(long address) {
        return Integer.reverseBytes(this.actual.get_int(address));
    }

    @Override
    public final float get_float(long address) {
        return Float.intBitsToFloat(this.get_int(address));
    }

    @Override
    public final long get_long(long address) {
        return Long.reverseBytes(this.actual.get_long(address));
    }

    @Override
    public final double get_double(long address) {
        return Double.longBitsToDouble(this.get_long(address));
    }

    @Override
    public final byte get_byte(Object instance, long offset) {
        return this.actual.get_byte(instance, offset);
    }

    @Override
    public final boolean get_boolean(Object instance, long offset) {
        return this.actual.get_boolean(instance, offset);
    }

    @Override
    public final short get_short(Object instance, long offset) {
        return Short.reverseBytes(this.actual.get_short(instance, offset));
    }

    @Override
    public final char get_char(Object instance, long offset) {
        return Character.reverseBytes(this.actual.get_char(instance, offset));
    }

    @Override
    public final int get_int(Object instance, long offset) {
        return Integer.reverseBytes(this.actual.get_int(instance, offset));
    }

    @Override
    public final float get_float(Object instance, long offset) {
        return Float.intBitsToFloat(this.get_int(instance, offset));
    }

    @Override
    public final long get_long(Object instance, long offset) {
        return Long.reverseBytes(this.actual.get_long(instance, offset));
    }

    @Override
    public final double get_double(Object instance, long offset) {
        return Double.longBitsToDouble(this.get_long(instance, offset));
    }

    @Override
    public final Object getObject(Object instance, long offset) {
        return this.actual.getObject(instance, offset);
    }

    @Override
    public final void set_byte(long address, byte value) {
        this.actual.set_byte(address, value);
    }

    @Override
    public final void set_boolean(long address, boolean value) {
        this.actual.set_boolean(address, value);
    }

    @Override
    public final void set_short(long address, short value) {
        this.actual.set_short(address, Short.reverseBytes(value));
    }

    @Override
    public final void set_char(long address, char value) {
        this.actual.set_char(address, Character.reverseBytes(value));
    }

    @Override
    public final void set_int(long address, int value) {
        this.actual.set_int(address, Integer.reverseBytes(value));
    }

    @Override
    public final void set_float(long address, float value) {
        this.set_int(address, Float.floatToRawIntBits(value));
    }

    @Override
    public final void set_long(long address, long value) {
        this.actual.set_long(address, Long.reverseBytes(value));
    }

    @Override
    public final void set_double(long address, double value) {
        this.set_long(address, Double.doubleToRawLongBits(value));
    }

    @Override
    public final void set_byte(Object instance, long offset, byte value) {
        this.actual.set_byte(instance, offset, value);
    }

    @Override
    public final void set_boolean(Object instance, long offset, boolean value) {
        this.actual.set_boolean(instance, offset, value);
    }

    @Override
    public final void set_short(Object instance, long offset, short value) {
        this.actual.set_short(instance, offset, Short.reverseBytes(value));
    }

    @Override
    public final void set_char(Object instance, long offset, char value) {
        this.actual.set_char(instance, offset, Character.reverseBytes(value));
    }

    @Override
    public final void set_int(Object instance, long offset, int value) {
        this.actual.set_int(instance, offset, Integer.reverseBytes(value));
    }

    @Override
    public final void set_float(Object instance, long offset, float value) {
        this.set_int(instance, offset, Float.floatToRawIntBits(value));
    }

    @Override
    public final void set_long(Object instance, long offset, long value) {
        this.actual.set_long(instance, offset, Long.reverseBytes(value));
    }

    @Override
    public final void set_double(Object instance, long offset, double value) {
        this.set_long(instance, offset, Double.doubleToRawLongBits(value));
    }

    @Override
    public final void setObject(Object instance, long offset, Object value) {
        this.actual.setObject(instance, offset, value);
    }

    @Override
    public final void copyRange(long sourceAddress, long targetAddress, long length) {
        this.actual.copyRange(sourceAddress, targetAddress, length);
    }

    @Override
    public final void copyRangeToArray(long sourceAddress, byte[] target) {
        this.actual.copyRangeToArray(sourceAddress, target);
    }

    @Override
    public final void copyRangeToArray(long sourceAddress, boolean[] target) {
        this.actual.copyRangeToArray(sourceAddress, target);
    }

    @Override
    public final void copyRangeToArray(long sourceAddress, short[] target) {
        this.actual.copyRangeToArray(sourceAddress, target);
        int i = 0;
        while (i < target.length) {
            target[i] = Short.reverseBytes(target[i]);
            ++i;
        }
    }

    @Override
    public final void copyRangeToArray(long sourceAddress, char[] target) {
        this.actual.copyRangeToArray(sourceAddress, target);
        int i = 0;
        while (i < target.length) {
            target[i] = Character.reverseBytes(target[i]);
            ++i;
        }
    }

    @Override
    public final void copyRangeToArray(long sourceAddress, int[] target) {
        this.actual.copyRangeToArray(sourceAddress, target);
        int i = 0;
        while (i < target.length) {
            target[i] = Integer.reverseBytes(target[i]);
            ++i;
        }
    }

    @Override
    public final void copyRangeToArray(long sourceAddress, float[] target) {
        this.actual.copyRangeToArray(sourceAddress, target);
        int i = 0;
        while (i < target.length) {
            target[i] = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(target[i])));
            ++i;
        }
    }

    @Override
    public final void copyRangeToArray(long sourceAddress, long[] target) {
        this.actual.copyRangeToArray(sourceAddress, target);
        int i = 0;
        while (i < target.length) {
            target[i] = Long.reverseBytes(target[i]);
            ++i;
        }
    }

    @Override
    public final void copyRangeToArray(long sourceAddress, double[] target) {
        this.actual.copyRangeToArray(sourceAddress, target);
        int i = 0;
        while (i < target.length) {
            target[i] = Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(target[i])));
            ++i;
        }
    }

    @Override
    public final void copyArrayToAddress(byte[] array, long targetAddress) {
        this.actual.copyArrayToAddress(array, targetAddress);
    }

    @Override
    public final void copyArrayToAddress(boolean[] array, long targetAddress) {
        this.actual.copyArrayToAddress(array, targetAddress);
    }

    @Override
    public final void copyArrayToAddress(short[] array, long targetAddress) {
        short[] byteReversedArray = new short[array.length];
        int i = 0;
        while (i < array.length) {
            byteReversedArray[i] = Short.reverseBytes(array[i]);
            ++i;
        }
        this.actual.copyArrayToAddress(byteReversedArray, targetAddress);
    }

    @Override
    public final void copyArrayToAddress(char[] array, long targetAddress) {
        char[] byteReversedArray = new char[array.length];
        int i = 0;
        while (i < array.length) {
            byteReversedArray[i] = Character.reverseBytes(array[i]);
            ++i;
        }
        this.actual.copyArrayToAddress(byteReversedArray, targetAddress);
    }

    @Override
    public final void copyArrayToAddress(int[] array, long targetAddress) {
        int[] byteReversedArray = new int[array.length];
        int i = 0;
        while (i < array.length) {
            byteReversedArray[i] = Integer.reverseBytes(array[i]);
            ++i;
        }
        this.actual.copyArrayToAddress(byteReversedArray, targetAddress);
    }

    @Override
    public final void copyArrayToAddress(float[] array, long targetAddress) {
        int[] byteReversedArray = new int[array.length];
        int i = 0;
        while (i < array.length) {
            byteReversedArray[i] = Integer.reverseBytes(Float.floatToRawIntBits(array[i]));
            ++i;
        }
        this.actual.copyArrayToAddress(byteReversedArray, targetAddress);
    }

    @Override
    public final void copyArrayToAddress(long[] array, long targetAddress) {
        long[] byteReversedArray = new long[array.length];
        int i = 0;
        while (i < array.length) {
            byteReversedArray[i] = Long.reverseBytes(array[i]);
            ++i;
        }
        this.actual.copyArrayToAddress(byteReversedArray, targetAddress);
    }

    @Override
    public final void copyArrayToAddress(double[] array, long targetAddress) {
        long[] byteReversedArray = new long[array.length];
        int i = 0;
        while (i < array.length) {
            byteReversedArray[i] = Long.reverseBytes(Double.doubleToRawLongBits(array[i]));
            ++i;
        }
        this.actual.copyArrayToAddress(byteReversedArray, targetAddress);
    }

    @Override
    public final void set_byteInBytes(byte[] bytes, int index, byte value) {
        this.actual.set_byteInBytes(bytes, index, value);
    }

    @Override
    public final void set_booleanInBytes(byte[] bytes, int index, boolean value) {
        this.actual.set_booleanInBytes(bytes, index, value);
    }

    @Override
    public final void set_shortInBytes(byte[] bytes, int index, short value) {
        this.actual.set_shortInBytes(bytes, index, Short.reverseBytes(value));
    }

    @Override
    public final void set_charInBytes(byte[] bytes, int index, char value) {
        this.actual.set_charInBytes(bytes, index, Character.reverseBytes(value));
    }

    @Override
    public final void set_intInBytes(byte[] bytes, int index, int value) {
        this.actual.set_intInBytes(bytes, index, Integer.reverseBytes(value));
    }

    @Override
    public final void set_floatInBytes(byte[] bytes, int index, float value) {
        this.set_intInBytes(bytes, index, Float.floatToRawIntBits(value));
    }

    @Override
    public final void set_longInBytes(byte[] bytes, int index, long value) {
        this.actual.set_longInBytes(bytes, index, Long.reverseBytes(value));
    }

    @Override
    public final void set_doubleInBytes(byte[] bytes, int index, double value) {
        this.set_longInBytes(bytes, index, Double.doubleToRawLongBits(value));
    }

    @Override
    public final byte[] asByteArray(long[] values) {
        long[] byteReversedArray = new long[values.length];
        int i = 0;
        while (i < values.length) {
            byteReversedArray[i] = Long.reverseBytes(values[i]);
            ++i;
        }
        return this.actual.asByteArray(byteReversedArray);
    }

    @Override
    public final byte[] asByteArray(long value) {
        return this.actual.asByteArray(Long.reverseBytes(value));
    }

    @Override
    public final long objectFieldOffset(Field field) {
        return this.actual.objectFieldOffset(field);
    }

    @Override
    public final long[] objectFieldOffsets(Field ... fields) {
        return this.actual.objectFieldOffsets(fields);
    }

    @Override
    public final long objectFieldOffset(Class<?> objectClass, Field field) {
        return this.actual.objectFieldOffset(objectClass, field);
    }

    @Override
    public final long[] objectFieldOffsets(Class<?> objectClass, Field ... fields) {
        return this.actual.objectFieldOffsets(objectClass, fields);
    }

    @Override
    public final void ensureClassInitialized(Class<?> c) {
        this.actual.ensureClassInitialized(c);
    }

    @Override
    public void ensureClassInitialized(Class<?> c, Iterable<Field> usedFields) {
        this.actual.ensureClassInitialized(c, usedFields);
    }

    @Override
    public final <T> T instantiateBlank(Class<T> c) throws InstantiationRuntimeException {
        return this.actual.instantiateBlank(c);
    }

    @Override
    public MemoryStatistics createHeapMemoryStatistics() {
        return this.actual.createHeapMemoryStatistics();
    }

    @Override
    public MemoryStatistics createNonHeapMemoryStatistics() {
        return this.actual.createNonHeapMemoryStatistics();
    }

    @Override
    public final boolean isReversing() {
        return true;
    }

    @Override
    public final MemoryAccessor toReversing() {
        return this.actual;
    }
}

