/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.reference;

import java.text.DecimalFormat;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.memory.MemoryStatistics;
import one.microstream.memory.MemoryStatisticsProvider;
import one.microstream.meta.XDebug;
import one.microstream.reference.LazyReferenceManager;
import one.microstream.reference.ObjectSwizzling;
import one.microstream.reference.Referencing;
import one.microstream.reference.Swizzling;

public interface Lazy<T>
extends Referencing<T> {
    @Override
    public T get();

    public T peek();

    public T clear();

    public boolean isStored();

    public boolean isLoaded();

    public long lastTouched();

    public boolean clear(ClearingEvaluator var1);

    public static <T> T get(Lazy<T> reference) {
        if (reference == null) {
            return null;
        }
        return reference.get();
    }

    public static <T> T peek(Lazy<T> reference) {
        if (reference == null) {
            return null;
        }
        return reference.peek();
    }

    public static void clear(Lazy<?> reference) {
        if (reference == null) {
            return;
        }
        reference.clear();
    }

    public static boolean isStored(Lazy<?> reference) {
        if (reference == null) {
            return false;
        }
        return reference.isStored();
    }

    public static boolean isLoaded(Lazy<?> reference) {
        if (reference == null) {
            return false;
        }
        return reference.isLoaded();
    }

    public static <T> Lazy<T> Reference(T subject) {
        return Lazy.register(new Default<T>(subject));
    }

    public static <T> Lazy<T> New(long objectId) {
        return Lazy.register(new Default<Object>(null, objectId, null));
    }

    public static <T> Lazy<T> New(long objectId, ObjectSwizzling loader) {
        return Lazy.register(new Default<Object>(null, objectId, loader));
    }

    public static <T> Lazy<T> New(T subject, long objectId, ObjectSwizzling loader) {
        return Lazy.register(new Default<T>(subject, objectId, loader));
    }

    public static <T, L extends Lazy<T>> L register(L lazyReference) {
        LazyReferenceManager.get().register(lazyReference);
        return lazyReference;
    }

    public static Checker Checker() {
        return Lazy.Checker(null);
    }

    public static Checker Checker(long millisecondTimeout) {
        return Lazy.Checker(millisecondTimeout, Checker.Defaults.defaultMemoryQuota());
    }

    public static Checker Checker(double memoryQuota) {
        return Lazy.Checker(Checker.Defaults.defaultTimeout(), memoryQuota);
    }

    public static Checker Checker(long millisecondTimeout, double memoryQuota) {
        return Lazy.Checker(millisecondTimeout, memoryQuota, null, null);
    }

    public static Checker Checker(Check customCheck) {
        return Lazy.Checker(Checker.Defaults.defaultTimeout(), Checker.Defaults.defaultMemoryQuota(), customCheck, null);
    }

    public static Checker Checker(long millisecondTimeout, double memoryQuota, Check customCheck, LazyReferenceManager.CycleEvaluator cycleEvaluator) {
        return new Checker.Default(Checker.validateTimeout(millisecondTimeout), Checker.validateMemoryQuota(memoryQuota), X.mayNull(customCheck), X.mayNull(cycleEvaluator));
    }

    public static Checker CheckerTimeout(long millisecondTimeout) {
        return Lazy.Checker(millisecondTimeout, 0.0);
    }

    public static Checker CheckerMemory(double memoryQuota) {
        return Lazy.Checker(Long.MAX_VALUE, memoryQuota);
    }

    @FunctionalInterface
    public static interface Check {
        public Boolean test(Lazy<?> var1, MemoryStatistics var2, long var3);
    }

    @FunctionalInterface
    public static interface Checker {
        default public void beginCheckCycle() {
        }

        public boolean check(Lazy<?> var1);

        default public void endCheckCycle() {
        }

        public static boolean isValidTimeout(long millisecondTimeout) {
            return millisecondTimeout > 0L;
        }

        public static boolean isValidMemoryQuota(double memoryQuota) {
            return memoryQuota >= 0.0 && memoryQuota <= 1.0;
        }

        public static long validateTimeout(long millisecondTimeout) {
            if (Checker.isValidTimeout(millisecondTimeout)) {
                return millisecondTimeout;
            }
            throw new IllegalArgumentException("Timeout must be greater than 0.");
        }

        public static double validateMemoryQuota(double memoryQuota) {
            if (Checker.isValidMemoryQuota(memoryQuota)) {
                return memoryQuota;
            }
            throw new IllegalArgumentException("Memory quota must be in the range [0.0; 1.0].");
        }

        public static final class Default
        implements Checker,
        ClearingEvaluator {
            private final Check customCheck;
            private final LazyReferenceManager.CycleEvaluator cycleEvaluator;
            private final long timeoutMs;
            private final long graceTimeMs;
            private final double memoryQuota;
            private MemoryStatistics cycleMemoryStatistics;
            private long cycleStartMs;
            private long cycleTimeoutThresholdMs;
            private long cycleGraceTimeThresholdMs;
            private long cycleMemoryLimit;
            private long cycleMemoryUsed;
            private long cycleClearCount;
            private long sh10MemoryLimit;
            private long sh10MemoryUsed;

            public static double memoryQuotaNoCheck() {
                return 0.0;
            }

            public static long graceTimeMinimum() {
                return 1000L;
            }

            Default(long timeoutMs, double memoryQuota, Check customCheck, LazyReferenceManager.CycleEvaluator cycleEvaluator) {
                this.timeoutMs = timeoutMs;
                this.memoryQuota = memoryQuota;
                this.customCheck = customCheck;
                this.cycleEvaluator = cycleEvaluator;
                this.graceTimeMs = Default.deriveGraceTime(timeoutMs);
            }

            private static long deriveGraceTime(long timeoutMs) {
                return Math.min(Default.graceTimeMinimum(), timeoutMs / 2L);
            }

            private static long shift10(long value) {
                return value << 10;
            }

            private boolean isMemoryCheckEnabled() {
                return this.memoryQuota != Default.memoryQuotaNoCheck();
            }

            @Override
            public final void beginCheckCycle() {
                this.cycleStartMs = System.currentTimeMillis();
                this.cycleTimeoutThresholdMs = this.cycleStartMs - this.timeoutMs;
                this.cycleGraceTimeThresholdMs = this.cycleStartMs - this.graceTimeMs;
                this.updateMemoryUsage();
                this.cycleClearCount = 0L;
            }

            @Override
            public void endCheckCycle() {
                if (this.cycleEvaluator != null) {
                    this.cycleEvaluator.evaluateCycle(this.cycleMemoryStatistics, this.cycleClearCount, this.memoryQuota);
                }
            }

            private void updateMemoryUsage() {
                this.cycleMemoryStatistics = MemoryStatisticsProvider.get().heapMemoryUsage();
                this.cycleMemoryLimit = this.calculateMemoryLimit(this.cycleMemoryStatistics);
                this.cycleMemoryUsed = this.cycleMemoryStatistics.used();
                this.sh10MemoryLimit = Default.shift10(this.cycleMemoryLimit);
                this.sh10MemoryUsed = Default.shift10(this.cycleMemoryUsed);
            }

            final void DEBUG_printCycleState() {
                DecimalFormat format = new DecimalFormat("00,000,000,000");
                VarString vs = VarString.New().lf().add("Timeout          = " + this.timeoutMs + " ms").lf().add("GraceTime        = " + this.graceTimeMs + " ms").lf().add("memory maximum   = " + format.format(this.cycleMemoryStatistics.max()) + " bytes").lf().add("memory committed = " + format.format(this.cycleMemoryStatistics.committed()) + " bytes").lf().add("cycleMemoryLimit = " + format.format(this.cycleMemoryLimit) + " bytes").lf().add("cycleMemoryUsed  = " + format.format(this.cycleMemoryUsed) + " bytes");
                XDebug.println(vs.toString());
            }

            private void registerClearing() {
                if ((++this.cycleClearCount & 0x7FL) == 0L) {
                    this.updateMemoryUsage();
                }
            }

            private boolean clear(boolean decision) {
                if (decision) {
                    this.registerClearing();
                    return true;
                }
                return false;
            }

            private long calculateMemoryLimit(MemoryStatistics memoryStatistics) {
                if (!this.isMemoryCheckEnabled()) {
                    return Long.MAX_VALUE;
                }
                return (long)((double)memoryStatistics.committed() * this.memoryQuota);
            }

            @Override
            public final boolean check(Lazy<?> lazyReference) {
                return lazyReference.clear(this);
            }

            private Boolean performCustomCheck(Lazy<?> lazyReference) {
                return this.customCheck.test(lazyReference, this.cycleMemoryStatistics, this.timeoutMs);
            }

            @Override
            public final boolean needsClearing(Lazy<?> lazyReference) {
                Boolean check;
                if (this.customCheck != null && (check = this.performCustomCheck(lazyReference)) != null) {
                    return this.clear(check);
                }
                long lastTouched = lazyReference.lastTouched();
                if (lastTouched >= this.cycleGraceTimeThresholdMs) {
                    return false;
                }
                if (lastTouched < this.cycleTimeoutThresholdMs) {
                    this.registerClearing();
                    return true;
                }
                return this.checkByMemoryWithAgePenalty(lastTouched);
            }

            private boolean checkByMemoryWithAgePenalty(long lastTouched) {
                if (!this.isMemoryCheckEnabled()) {
                    return false;
                }
                long age = this.cycleStartMs - lastTouched;
                long sh10Weight = Default.shift10(age) / this.timeoutMs;
                boolean clearingDecision = this.sh10MemoryUsed + this.cycleMemoryUsed * sh10Weight >= this.sh10MemoryLimit;
                return this.clear(clearingDecision);
            }

            final void DEBUG_printAgePenaltyInfo(Lazy<?> lazyReference, long age, long sh10Weight, String label) {
                DecimalFormat format = new DecimalFormat("000,000,000,000");
                VarString vs = VarString.New().add(label).add(" age = ").add(age).add(" (").padLeft(Integer.toString((int)(100.0 * (double)age / (double)this.timeoutMs)), 2, ' ').add("%)").add(": ").add(format.format(this.sh10MemoryUsed + this.cycleMemoryUsed * sh10Weight)).add(" <> ").add(format.format(this.sh10MemoryLimit)).add("  ").add(XChars.systemString(lazyReference.peek()));
                XDebug.println(vs.toString());
            }
        }

        public static interface Defaults {
            public static long defaultTimeout() {
                return 1000000L;
            }

            public static double defaultMemoryQuota() {
                return 1.0;
            }
        }
    }

    @FunctionalInterface
    public static interface ClearingEvaluator {
        public boolean needsClearing(Lazy<?> var1);
    }

    public static final class Default<T>
    implements Lazy<T> {
        private T subject;
        transient long lastTouched;
        transient long objectId;
        private transient ObjectSwizzling loader;

        public static final Class<Default<?>> genericType() {
            return Default.class;
        }

        Default(T subject) {
            this(subject, Swizzling.toUnmappedObjectId(subject), null);
        }

        Default(T subject, long objectId, ObjectSwizzling loader) {
            this.subject = subject;
            this.objectId = objectId;
            this.loader = loader;
            this.touch();
        }

        public final long objectId() {
            return this.objectId;
        }

        @Override
        public final long lastTouched() {
            return this.lastTouched;
        }

        @Override
        public final synchronized boolean isStored() {
            return Swizzling.isFoundId(this.objectId);
        }

        @Override
        public final synchronized boolean isLoaded() {
            return Swizzling.isNotProperId(this.objectId) || this.subject != null;
        }

        @Override
        public final synchronized T peek() {
            return this.subject;
        }

        @Override
        public final synchronized T clear() {
            T subject = this.subject;
            this.internalClear();
            return subject;
        }

        @Override
        public final synchronized boolean clear(ClearingEvaluator clearingEvaluator) {
            if (this.isStored() && this.subject != null && clearingEvaluator.needsClearing(this)) {
                this.internalClear();
                return true;
            }
            return false;
        }

        private void touch() {
            this.lastTouched = this.subject != null ? System.currentTimeMillis() : Long.MAX_VALUE;
        }

        private void validateObjectIdToBeSet(long objectId) {
            if (Swizzling.isFoundId(this.objectId) && this.objectId != objectId) {
                throw new IllegalStateException("ObjectId already set: " + this.objectId);
            }
        }

        void internalClear() {
            if (!this.isStored()) {
                throw new IllegalStateException("Cannot clear an unstored lazy reference.");
            }
            this.subject = null;
            this.touch();
        }

        public final synchronized void $link(long objectId, ObjectSwizzling loader) {
            this.validateObjectIdToBeSet(objectId);
            this.$setLoader(loader);
            this.objectId = objectId;
        }

        public final synchronized void $setLoader(ObjectSwizzling loader) {
            if (this.loader != null) {
                return;
            }
            this.loader = loader;
        }

        @Override
        public final synchronized T get() {
            if (this.subject == null && Swizzling.isProperId(this.objectId)) {
                this.load();
            }
            this.touch();
            return this.subject;
        }

        private synchronized void load() {
            this.subject = this.loader.getObject(this.objectId);
        }

        final synchronized boolean clearIfTimedout(long millisecondThreshold) {
            if (this.lastTouched >= millisecondThreshold || !this.isStored()) {
                return false;
            }
            this.internalClear();
            return true;
        }

        public String toString() {
            return this.subject == null ? "(" + this.objectId + " not loaded)" : String.valueOf(this.objectId) + " " + XChars.systemString(this.subject);
        }
    }
}

