/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.reference;

import java.util.Iterator;
import one.microstream.collections.Constant;
import one.microstream.reference.Referencing;

public interface LinkingReferencing<T>
extends Referencing<T>,
Iterable<T> {
    public boolean hasNext();

    public boolean isNext(LinkingReferencing<T> var1);

    public LinkingReferencing<T> next();

    public Object[] toArray();

    public String toString();

    public String toChainString();

    public static final class ChainIterator<T>
    implements Iterator<T> {
        private LinkingReferencing<T> current;

        ChainIterator(LinkingReferencing<T> current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current.next() != null;
        }

        @Override
        public T next() {
            LinkingReferencing<T> currentCurrent = this.current;
            this.current = currentCurrent.next();
            return currentCurrent.get();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Can't remove current element in a one directional chain");
        }
    }

    public static class Default<T>
    extends Constant<T>
    implements LinkingReferencing<T> {
        private final LinkingReferencing<T> next = null;

        public Default(T ref) {
            super(ref);
        }

        @Override
        public LinkingReferencing<T> next() {
            return this.next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean isNext(LinkingReferencing<T> linkedReference) {
            return this.next == linkedReference;
        }

        @Override
        public Object[] toArray() {
            LinkingReferencing<T> loopNext = this;
            int i = 1;
            while ((loopNext = loopNext.next()) != null) {
                ++i;
            }
            Object[] array = new Object[i];
            loopNext = this;
            i = 0;
            do {
                array[i++] = loopNext.get();
            } while ((loopNext = loopNext.next()) != null);
            return array;
        }

        @Override
        public Iterator<T> iterator() {
            return new ChainIterator(this);
        }

        @Override
        public String toString() {
            String e = String.valueOf(this.get());
            StringBuilder sb = new StringBuilder(e.length() + 3);
            return sb.append('(').append(e).append(')').append(this.hasNext() ? (char)'-' : 'x').toString();
        }

        @Override
        public String toChainString() {
            StringBuilder sb = new StringBuilder(1024);
            sb.append('(').append(this.get()).append(')');
            LinkingReferencing<T> r = this.next;
            while (r != null) {
                sb.append('-').append('(').append(r.get()).append(')');
                r = r.next();
            }
            return sb.toString();
        }
    }
}

