/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.reflect;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.collections.XArrays;
import one.microstream.functional.XFunc;
import one.microstream.reflect.CopyPredicate;
import one.microstream.reflect.XReflect;

public interface ReflectiveCopier<S> {
    default public <T extends S> T copyTo(T targetInstance) {
        return this.copy(this.sourceInstance(), targetInstance);
    }

    public <T extends S> T copy(S var1, T var2);

    public Class<?> sourceClass();

    public S sourceInstance();

    public Predicate<? super Field> fieldSelector();

    public CopyPredicate copySelector();

    public <I extends Consumer<? super Field>> I iterateFields(I var1);

    public static <S> ReflectiveCopier<S> New(S sourceInstance) {
        return ReflectiveCopier.New(XReflect.getClass(sourceInstance), sourceInstance);
    }

    public static <S, C extends S> ReflectiveCopier<S> New(Class<C> sourceClass) {
        return ReflectiveCopier.New(sourceClass, null);
    }

    public static <S, C extends S> ReflectiveCopier<S> New(Class<C> sourceClass, S sourceInstance) {
        return ReflectiveCopier.New(sourceClass, sourceInstance, XFunc.all());
    }

    public static <S, C extends S> ReflectiveCopier<S> New(Class<C> sourceClass, S sourceInstance, Predicate<? super Field> fieldSelector) {
        return ReflectiveCopier.New(sourceClass, sourceInstance, fieldSelector, CopyPredicate::all);
    }

    public static <S, C extends S> ReflectiveCopier<S> New(Class<C> sourceClass, S sourceInstance, Predicate<? super Field> fieldSelector, CopyPredicate copySelector) {
        Field[] copyFields = XReflect.collectInstanceFields(sourceClass, fieldSelector);
        return new Default<S>(sourceClass, sourceInstance, fieldSelector, copyFields, copySelector);
    }

    public static final class Default<S>
    implements ReflectiveCopier<S> {
        private final Class<?> sourceClass;
        private final S sourceInstance;
        private final Predicate<? super Field> fieldSelector;
        private final Field[] fields;
        private final CopyPredicate copySelector;

        Default(Class<?> sourceClass, S sourceInstance, Predicate<? super Field> fieldSelector, Field[] fields, CopyPredicate copySelector) {
            this.sourceClass = sourceClass;
            this.sourceInstance = sourceInstance;
            this.fieldSelector = fieldSelector;
            this.fields = fields;
            this.copySelector = copySelector;
        }

        @Override
        public final Class<?> sourceClass() {
            return this.sourceClass;
        }

        @Override
        public final S sourceInstance() {
            return this.sourceInstance;
        }

        @Override
        public final Predicate<? super Field> fieldSelector() {
            return this.fieldSelector;
        }

        @Override
        public final CopyPredicate copySelector() {
            return this.copySelector;
        }

        @Override
        public final <I extends Consumer<? super Field>> I iterateFields(I iterator) {
            return XArrays.iterate(this.fields, iterator);
        }

        @Override
        public final <T extends S> T copy(S sourceInstance, T targetInstance) {
            return XReflect.copyFields(sourceInstance, targetInstance, this.fields, this.copySelector);
        }
    }
}

