/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.typing;

import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XTable;
import one.microstream.hashing.HashEqualator;
import one.microstream.typing.TypeMappingLookup;
import one.microstream.typing.TypePair;

public interface TypeMapping<V>
extends TypeMappingLookup<V> {
    public boolean add(TypePair var1, V var2);

    public boolean put(TypePair var1, V var2);

    public TypeMapping<V> register(TypePair var1, V var2);

    default public boolean add(Class<?> type1, Class<?> type2, V value) {
        return this.add(TypePair.New(type1, type2), value);
    }

    default public boolean put(Class<?> type1, Class<?> type2, V value) {
        return this.put(TypePair.New(type1, type2), value);
    }

    default public TypeMapping<V> register(Class<?> type1, Class<?> type2, V value) {
        this.register(TypePair.New(type1, type2), value);
        return this;
    }

    @Override
    public XTable<TypePair, V> table();

    public static <T> TypeMapping<T> New() {
        return TypeMapping.New(TypePair.HashEquality());
    }

    public static <T> TypeMapping<T> New(HashEqualator<? super TypePair> hashEquality) {
        return new Default(EqHashTable.New(hashEquality));
    }

    public static final class Default<V>
    implements TypeMapping<V> {
        private final EqHashTable<TypePair, V> table;

        Default(EqHashTable<TypePair, V> table) {
            this.table = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean contains(TypePair typePair) {
            EqHashTable<TypePair, V> eqHashTable = this.table;
            synchronized (eqHashTable) {
                return this.table.keys().contains(typePair);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final V lookup(TypePair typePair) {
            EqHashTable<TypePair, V> eqHashTable = this.table;
            synchronized (eqHashTable) {
                return this.table.get(typePair);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean add(TypePair typePair, V value) {
            EqHashTable<TypePair, V> eqHashTable = this.table;
            synchronized (eqHashTable) {
                return this.table.add(typePair, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean put(TypePair typePair, V value) {
            EqHashTable<TypePair, V> eqHashTable = this.table;
            synchronized (eqHashTable) {
                return this.table.put(typePair, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final TypeMapping<V> register(TypePair typePair, V value) {
            EqHashTable<TypePair, V> eqHashTable = this.table;
            synchronized (eqHashTable) {
                this.table.put(typePair, value);
            }
            return this;
        }

        @Override
        public final XTable<TypePair, V> table() {
            return this.table;
        }
    }
}

