/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import one.microstream.X;
import one.microstream.util.BufferingCollector;

public interface Executor<EX extends Throwable> {
    public Executor<EX> reset();

    public boolean handle(Throwable var1);

    public void complete(Runnable var1);

    default public void execute(Runnable logic) {
        block2: {
            try {
                logic.run();
            }
            catch (Throwable e) {
                if (this.handle(e)) break block2;
                throw e;
            }
        }
    }

    default public <E> void execute(E element, Consumer<? super E> logic) {
        block2: {
            try {
                logic.accept(element);
            }
            catch (Throwable e) {
                if (this.handle(e)) break block2;
                throw e;
            }
        }
    }

    default public <E> void executeNullIgnoring(E element, Consumer<? super E> logic) {
        block3: {
            if (element == null) {
                return;
            }
            try {
                logic.accept(element);
            }
            catch (Throwable e) {
                if (this.handle(e)) break block3;
                throw e;
            }
        }
    }

    default public <E> void executeNullHandling(E element, Consumer<? super E> logic, Runnable nullCaseLogic) {
        block4: {
            try {
                if (element != null) {
                    logic.accept(element);
                } else {
                    nullCaseLogic.run();
                }
            }
            catch (Throwable e) {
                if (this.handle(e)) break block4;
                throw e;
            }
        }
    }

    default public <R> R executeR(Supplier<? extends R> logic) {
        try {
            return logic.get();
        }
        catch (Throwable e) {
            if (this.handle(e)) {
                return null;
            }
            throw e;
        }
    }

    default public <E, R> R executeR(E element, Function<? super E, R> logic) {
        try {
            return logic.apply(element);
        }
        catch (Throwable e) {
            if (this.handle(e)) {
                return null;
            }
            throw e;
        }
    }

    default public <E, R> R executeRNullIgnoring(E element, Function<? super E, R> logic) {
        if (element == null) {
            return null;
        }
        try {
            return logic.apply(element);
        }
        catch (Throwable e) {
            if (this.handle(e)) {
                return null;
            }
            throw e;
        }
    }

    default public <E, R> R executeRNullHandling(E element, Function<? super E, R> logic, Supplier<? extends R> nullCaseLogic) {
        try {
            if (element == null) {
                return nullCaseLogic.get();
            }
            return logic.apply(element);
        }
        catch (Throwable e) {
            if (this.handle(e)) {
                return null;
            }
            throw e;
        }
    }

    public static Executor<Exception> New(BufferingCollector<? super Exception> collector) {
        return Executor.New(Exception.class, collector);
    }

    public static Executor<Exception> New(Consumer<? super Exception> exceptionFinalizer) {
        return Executor.New(Exception.class, BufferingCollector.New(X.notNull(exceptionFinalizer)));
    }

    public static <EX extends Throwable> Executor<EX> New(Class<EX> exceptionType, BufferingCollector<? super EX> collector) {
        return new Default<EX>(X.notNull(exceptionType), X.notNull(collector));
    }

    public static <EX extends Throwable> Executor<EX> New(Class<EX> exceptionType, Consumer<? super EX> exceptionFinalizer) {
        return new Default<EX>(X.notNull(exceptionType), BufferingCollector.New(X.notNull(exceptionFinalizer)));
    }

    public static final class Default<EX extends Throwable>
    implements Executor<EX> {
        final Class<EX> type;
        final BufferingCollector<? super EX> collector;

        Default(Class<EX> type, BufferingCollector<? super EX> collector) {
            this.type = type;
            this.collector = collector;
        }

        @Override
        public Default<EX> reset() {
            this.collector.resetElements();
            return this;
        }

        @Override
        public boolean handle(Throwable t) {
            if (this.type.isAssignableFrom(t.getClass())) {
                this.collector.accept(this.type.cast(t));
                return true;
            }
            return false;
        }

        @Override
        public void complete(Runnable onSuccessLogics) {
            if (this.collector.isEmpty()) {
                onSuccessLogics.run();
            } else {
                this.collector.finalizeElements();
            }
        }
    }
}

