/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XIterable;
import one.microstream.hashing.HashEqualator;
import one.microstream.typing.Clearable;
import one.microstream.typing.Composition;

public interface Substituter<T> {
    public T substitute(T var1);

    public static <T> Default<T> New() {
        return new Default(EqHashEnum.New());
    }

    public static <T> Default<T> New(HashEqualator<? super T> hashEqualator) {
        return new Default<T>(EqHashEnum.New(hashEqualator));
    }

    public static <T> Default<T> New(EqHashEnum<T> elements) {
        return new Default<T>(X.notNull(elements));
    }

    public static final class Default<T>
    implements Managed<T>,
    Composition {
        private static final int MAX_TO_STRING_ITEMS = 10;
        final EqHashEnum<T> elements;

        Default(EqHashEnum<T> elements) {
            this.elements = elements;
        }

        public final XGettingEnum<T> elements() {
            return this.elements;
        }

        @Override
        public final synchronized T substitute(T item) {
            if (item == null) {
                return null;
            }
            return this.elements.deduplicate(item);
        }

        @Override
        public final synchronized void clear() {
            this.elements.clear();
        }

        @Override
        public final synchronized <P extends Consumer<? super T>> P iterate(P procedure) {
            this.elements.iterate(procedure);
            return procedure;
        }

        @Override
        public final synchronized boolean contains(T item) {
            return this.elements.contains(item);
        }

        @Override
        public final synchronized T lookup(T instance) {
            return this.elements.seek(instance);
        }

        @Override
        public final synchronized T remove(T item) {
            return this.elements.retrieve(item);
        }

        @Override
        public final synchronized long size() {
            return this.elements.size();
        }

        public final String toString() {
            return this.iterate(new Consumer<T>(){
                final VarString vs = VarString.New(1000);
                int count;

                @Override
                public void accept(T e) {
                    if (++this.count > 10) {
                        return;
                    }
                    this.vs.add(e).add(',');
                }

                final String yield() {
                    if (this.count > 10) {
                        this.vs.add("... [" + (this.count - 10) + " more]");
                    } else if (!this.vs.isEmpty()) {
                        this.vs.deleteLast();
                    }
                    return this.vs.toString();
                }
            }).yield();
        }

        public EqHashEnum<T> $elements() {
            return this.elements;
        }
    }

    public static interface Iterable<T>
    extends Substituter<T>,
    XIterable<T> {
    }

    public static interface Managed<T>
    extends Removing<T>,
    Iterable<T>,
    Queryable<T> {
    }

    public static interface Queryable<T>
    extends Substituter<T> {
        public boolean contains(T var1);

        public T lookup(T var1);

        public long size();
    }

    public static interface Removing<T>
    extends Substituter<T>,
    Clearable {
        @Override
        public void clear();

        public T remove(T var1);
    }
}

