/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.config;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.BulkList;
import one.microstream.collections.EqConstHashTable;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XAddingCollection;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingTable;
import one.microstream.meta.XDebug;
import one.microstream.typing.KeyValue;
import one.microstream.util.config.Config;
import one.microstream.util.config.ConfigEntry;
import one.microstream.util.config.ConfigFile;

public abstract class AbstractConfig
implements Config {
    final String identifier;
    final char variableStarter;
    final char variableTerminator;
    final String stringStarter;
    final String stringTerminator;
    final XGettingMap<String, String> customVariables;
    final EqHashTable<String, ConfigFile> configFiles = EqHashTable.New();
    final XGettingTable<String, ConfigFile> viewConfigFiles = this.configFiles.view();

    static final EqHashTable<String, String> toTable(EqHashEnum<ConfigFile> configFiles) {
        final EqHashTable<String, String> newConfig = EqHashTable.New();
        configFiles.iterate(new Consumer<ConfigFile>(){

            @Override
            public void accept(ConfigFile e) {
                newConfig.addAll(e.table());
            }
        });
        return newConfig;
    }

    static final EqHashTable<String, String> toTable(XGettingCollection<KeyValue<String, String>> entries) {
        EqHashTable<String, String> newConfig = EqHashTable.New();
        newConfig.addAll((XGettingCollection)entries);
        return newConfig;
    }

    public static char variableStarter() {
        return '{';
    }

    public static char variableTerminator() {
        return '}';
    }

    AbstractConfig(String identifier, XGettingMap<String, String> customVariables, Character variableStarter, Character variableTerminator) {
        this.identifier = X.notNull(identifier);
        this.variableStarter = variableStarter != null ? variableStarter.charValue() : AbstractConfig.variableStarter();
        this.variableTerminator = variableTerminator != null ? variableTerminator.charValue() : AbstractConfig.variableTerminator();
        this.customVariables = customVariables;
        this.stringStarter = String.valueOf(this.variableStarter);
        this.stringTerminator = String.valueOf(this.variableTerminator);
    }

    AbstractConfig(String identifier, XGettingMap<String, String> customVariables) {
        this(identifier, customVariables, null, null);
    }

    AbstractConfig(String identifier) {
        this(identifier, null);
    }

    public final XGettingTable<String, ConfigFile> files() {
        return this.viewConfigFiles;
    }

    @Override
    public abstract XGettingTable<String, String> table();

    @Override
    public final String identifier() {
        return this.identifier;
    }

    private String parseRawValue(String originalKey, String rawValue) {
        if (rawValue.isEmpty()) {
            return rawValue;
        }
        char[] chars = XChars.readChars(rawValue);
        int length = chars.length;
        char variableStarter = this.variableStarter;
        char variableTerminator = this.variableTerminator;
        String stringStrt = this.stringStarter;
        String stringTerm = this.stringTerminator;
        BulkList<String> elements = null;
        int lastOffset = 0;
        int i = 0;
        while (i < length) {
            if (chars[i] == variableStarter || chars[i] == variableTerminator) {
                if (elements == null) {
                    elements = BulkList.New();
                }
                if (i != lastOffset) {
                    elements.add(new String(chars, lastOffset, i - lastOffset));
                }
                elements.add(chars[i] == variableStarter ? stringStrt : stringTerm);
                lastOffset = i + 1;
            }
            ++i;
        }
        if (elements == null) {
            return rawValue;
        }
        if (lastOffset != length) {
            elements.add(new String(chars, lastOffset, length - lastOffset));
        }
        return this.resolveParsedElements(elements.toArray(String.class), length, originalKey);
    }

    @Override
    public String getValue(String key) {
        String rawValue = this.getRawValue(key);
        if (rawValue == null) {
            return null;
        }
        return this.parseRawValue(key, rawValue);
    }

    private String resolveParsedElements(String[] elements, int originalValueLength, String originalKey) {
        XGettingMap<String, String> customVariables = this.customVariables;
        String stringStrt = this.stringStarter;
        String stringTerm = this.stringTerminator;
        XGettingTable<String, String> table = this.table();
        int length = elements.length;
        int startBound = length - 2;
        VarString result = VarString.New(originalValueLength);
        int i = 0;
        while (i < startBound) {
            String resolved;
            if (!stringStrt.equals(elements[i]) || !stringTerm.equals(elements[i + 2])) {
                result.add(elements[i++]);
                continue;
            }
            String variable = elements[i + 1];
            String string = resolved = customVariables == null ? null : customVariables.get(variable);
            if (resolved == null) {
                if (originalKey.equals(variable)) {
                    throw new RuntimeException("Reference loop for key \"" + originalKey + "\"");
                }
                String dereferenced = (String)table.get(variable);
                if (dereferenced != null) {
                    resolved = this.parseRawValue(originalKey, dereferenced);
                }
            }
            if (resolved != null) {
                result.add(resolved);
            } else {
                result.add(stringStrt).add(variable).add(stringTerm);
            }
            i += 3;
        }
        while (i < length) {
            result.add(elements[i]);
            ++i;
        }
        return result.toString();
    }

    @Override
    public final <T> T get(ConfigEntry<T> entry) {
        try {
            return entry.parse(this.getValue(entry.key()));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception for entry " + entry.key(), e);
        }
    }

    void updateFile(ConfigFile newConfigFile) {
        ConfigFile file = this.configFiles.get(newConfigFile.name());
        if (file == null) {
            file = newConfigFile;
            this.configFiles.add(newConfigFile.name(), file);
        } else {
            file.table().putAll(newConfigFile.table());
        }
    }

    void updateFiles(EqHashTable<String, ConfigFile> newConfigFiles) {
        newConfigFiles.values().iterate(e -> this.updateFile((ConfigFile)e));
    }

    EqConstHashTable<String, String> compileEntries() {
        EqHashTable table = EqHashTable.New();
        this.configFiles.values().iterate(e -> {
            XAddingCollection xAddingCollection = table.addAll(e.table());
        });
        return table.immure();
    }

    public String toString() {
        final VarString vs = VarString.New();
        this.configFiles.values().iterate(new Consumer<ConfigFile>(){

            @Override
            public void accept(ConfigFile e) {
                vs.add(e.name()).blank().add('(').add(e.name).add(')').lf();
                XDebug.assembleTable(vs, e.table(), "---", "---\n", "\n---", null, null);
                vs.lf().add("|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||").lf();
            }
        });
        return vs.toString();
    }
}

