/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.config;

import one.microstream.X;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingList;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.util.Substituter;
import one.microstream.util.config.ConfigFile;
import one.microstream.util.xcsv.XCsvRowCollector;

public final class ConfigEntryAggregator
implements XCsvRowCollector {
    private final Substituter<String> stringCache;
    private final EqHashTable<String, ConfigFile> configs = EqHashTable.New();
    private final String[] entry = new String[2];
    private EqHashTable<String, String> config;
    private String name;
    private int entryIndex;

    public static final ConfigEntryAggregator New() {
        return ConfigEntryAggregator.New(Substituter.New());
    }

    public static final ConfigEntryAggregator New(Substituter<String> stringCache) {
        return new ConfigEntryAggregator(X.notNull(stringCache));
    }

    private ConfigEntryAggregator(Substituter<String> stringCache) {
        this.stringCache = stringCache;
    }

    public ConfigEntryAggregator setNewConfig(String name) {
        this.completeConfig();
        this.config = EqHashTable.New();
        this.name = name;
        return this;
    }

    public void completeConfig() {
        if (this.config != null) {
            this.configs.add(this.name, new ConfigFile(this.name, this.config));
            this.name = null;
            this.config = null;
        }
    }

    private void clear() {
        this.entry[0] = null;
        this.entry[1] = null;
        this.entryIndex = 0;
    }

    @Override
    public final void beginTable(String tableName, XGettingSequence<String> columnNames, XGettingList<String> columnTypes) {
    }

    @Override
    public final void accept(char[] data, int offset, int length) {
        this.entry[this.entryIndex++] = data == null ? null : this.stringCache.substitute(new String(data, offset, length));
    }

    @Override
    public final void completeRow() {
        this.config.add(this.entry[0], this.entry[1]);
        this.clear();
    }

    @Override
    public final void completeTable() {
        this.clear();
    }

    public final EqHashTable<String, ConfigFile> yield() {
        this.completeConfig();
        return this.configs;
    }
}

