/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.xcsv;

import one.microstream.collections.EqConstHashTable;
import one.microstream.collections.EqHashTable;
import one.microstream.exceptions.XCsvException;
import one.microstream.math.XMath;
import one.microstream.util.xcsv.XCSV;
import one.microstream.util.xcsv.XCsvConfiguration;

public enum XCsvDataType {
    XCSV("xcsv", XCsvDataType.map(XCsvDataType.vc('\t', 1.3), XCsvDataType.vc(';', 1.2), XCsvDataType.vc(',', 1.1), XCsvDataType.vc('|', 1.0), XCsvDataType.vc(':', 0.9))),
    TSV("tsv", XCsvDataType.map(XCsvDataType.vc('\t', 1.3), XCsvDataType.vc(';', 1.2), XCsvDataType.vc(',', 1.1), XCsvDataType.vc('|', 1.0), XCsvDataType.vc(':', 0.9))),
    CSV("csv", XCsvDataType.map(XCsvDataType.vc('\t', 1.1), XCsvDataType.vc(';', 1.2), XCsvDataType.vc(',', 1.3), XCsvDataType.vc('|', 1.0), XCsvDataType.vc(':', 0.9)));

    private final String identifier;
    private final EqConstHashTable<Character, XCSV.ValueSeparatorWeight> valueSeparatorWeights;
    private final XCsvConfiguration configuration;

    static final XCSV.ValueSeparatorWeight vc(char valueSeparator, double weight) {
        return new XCSV.ValueSeparatorWeight.Default(one.microstream.util.xcsv.XCSV.validateValueSeparator(valueSeparator), XMath.positive((float)weight));
    }

    static final EqConstHashTable<Character, XCSV.ValueSeparatorWeight> map(XCSV.ValueSeparatorWeight ... weights) {
        EqHashTable<Character, XCSV.ValueSeparatorWeight> table = EqHashTable.New();
        XCSV.ValueSeparatorWeight[] valueSeparatorWeightArray = weights;
        int n = weights.length;
        int n2 = 0;
        while (n2 < n) {
            XCSV.ValueSeparatorWeight weight = valueSeparatorWeightArray[n2];
            table.add(Character.valueOf(weight.valueSeparator()), weight);
            ++n2;
        }
        return table.immure();
    }

    static final char determinePreferredValueSeparator(Iterable<? extends XCSV.ValueSeparatorWeight> weights) {
        float maxWeight = -1.0f;
        char maxWeightChar = '0';
        for (XCSV.ValueSeparatorWeight valueSeparatorWeight : weights) {
            if (!(valueSeparatorWeight.weight() >= maxWeight)) continue;
            maxWeight = valueSeparatorWeight.weight();
            maxWeightChar = valueSeparatorWeight.valueSeparator();
        }
        if (maxWeightChar == '0') {
            throw new XCsvException("Invalid value separator weights: " + weights);
        }
        return maxWeightChar;
    }

    public static XCsvDataType fromIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        return XCsvDataType.valueOf(identifier.toUpperCase());
    }

    private XCsvDataType(String identifier, EqConstHashTable<Character, XCSV.ValueSeparatorWeight> valueSeparatorWeights) {
        this(identifier, valueSeparatorWeights, XCsvConfiguration.Builder());
    }

    private XCsvDataType(String identifier, EqConstHashTable<Character, XCSV.ValueSeparatorWeight> valueSeparatorWeights, XCsvConfiguration.Builder configurationBuilder) {
        this.identifier = identifier;
        this.valueSeparatorWeights = valueSeparatorWeights;
        char preferredValueSeparator = XCsvDataType.determinePreferredValueSeparator(valueSeparatorWeights.values());
        this.configuration = configurationBuilder.setValueSeparator(preferredValueSeparator).buildConfiguration();
    }

    public final String identifier() {
        return this.identifier;
    }

    public final XCsvConfiguration configuration() {
        return this.configuration;
    }

    public final EqConstHashTable<Character, XCSV.ValueSeparatorWeight> valueSeparatorWeights() {
        return this.valueSeparatorWeights;
    }

    public final boolean isValidValueSeparator(Character c) {
        return this.valueSeparatorWeights.keys().contains(c);
    }

    public final boolean isValidValueSeparator(char c) {
        return this.isValidValueSeparator(Character.valueOf(c));
    }

    public final XCSV.ValueSeparatorWeight lookupValueSeparator(Character c) {
        return this.valueSeparatorWeights.get(c);
    }

    public final XCSV.ValueSeparatorWeight lookupValueSeparator(char c) {
        return this.lookupValueSeparator(Character.valueOf(c));
    }
}

