package one.microstream.collections;

/*-
 * #%L
 * microstream-base
 * %%
 * Copyright (C) 2019 - 2022 MicroStream Software
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */

import java.util.function.Predicate;

final class ElementIsContained<E> implements Predicate<E>
{
	/* note:
	 * - the term element for a collection element is fixed and will never change
	 * - the reference can never be ruined from outside as this function is always instantiated in a local scope
	 * hence, the field is intentionally declared public to improve local performance and readability
	 */
	E element;

	ElementIsContained()
	{
		super();
	}

	@Override
	public boolean test(final E e)
	{
		return e == this.element;
	}
}
