package one.microstream.collections.sorting;

/*-
 * #%L
 * microstream-base
 * %%
 * Copyright (C) 2019 - 2022 MicroStream Software
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */

import one.microstream.collections.types.XBasicList;
import one.microstream.collections.types.XGettingCollection;

public interface XLadder<E> extends XSortation<E>, XBasicList<E>
{
	public interface Factory<E> extends XSortation.Factory<E>, XBasicList.Creator<E>
	{
		@Override
		public XLadder<E> newInstance();

	}



	@Override
	public XLadder<E> copy();

	@Override
	public XLadder<E> toReversed();

	@SuppressWarnings("unchecked")
	@Override
	public XLadder<E> putAll(E... elements);
	@Override
	public XLadder<E> putAll(E[] elements, int srcStartIndex, int srcLength);
	@Override
	public XLadder<E> putAll(XGettingCollection<? extends E> elements);

	@SuppressWarnings("unchecked")
	@Override
	public XLadder<E> addAll(E... elements);
	@Override
	public XLadder<E> addAll(E[] elements, int srcStartIndex, int srcLength);
	@Override
	public XLadder<E> addAll(XGettingCollection<? extends E> elements);

}
