package one.microstream.util.cql;

/*-
 * #%L
 * microstream-base
 * %%
 * Copyright (C) 2019 - 2022 MicroStream Software
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */

import java.util.function.BiConsumer;
import java.util.function.Consumer;

import one.microstream.functional.Aggregator;

public final class CqlWrapperCollectorLinkingFinalizing<O, R> implements Aggregator<O, R>
{
	///////////////////////////////////////////////////////////////////////////
	// instance fields //
	////////////////////
	
	final R                   target   ;
	final BiConsumer<O, R>   linker   ;
	final Consumer<? super R> finalizer;

	
	
	///////////////////////////////////////////////////////////////////////////
	// constructors //
	/////////////////
	
	CqlWrapperCollectorLinkingFinalizing(
		final R                   target   ,
		final BiConsumer<O, R>   linker   ,
		final Consumer<? super R> finalizer
	)
	{
		super();
		this.target    = target   ;
		this.linker    = linker   ;
		this.finalizer = finalizer;
	}
	
	
	
	///////////////////////////////////////////////////////////////////////////
	// override methods //
	/////////////////////

	@Override
	public final void accept(final O element)
	{
		this.linker.accept(element, this.target);
	}

	@Override
	public final R yield()
	{
		this.finalizer.accept(this.target);
		return this.target;
	}

}
