/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.bytes;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Consumer;
import one.microstream.exceptions.ArrayCapacityException;
import one.microstream.exceptions.IndexBoundsException;
import one.microstream.functional._byteProcedure;
import one.microstream.math.XMath;
import one.microstream.memory.XMemory;

public final class VarByte
implements Externalizable {
    private static final int CAPACITY_MIN = 4;
    private static final int CAPACITY_SMALL = 64;
    private static final int BITS_1_BYTE = 8;
    private static final int BITS_2_BYTES = 16;
    private static final int BITS_3_BYTES = 24;
    private static final int BITS_4_BYTES = 32;
    private static final int BITS_5_BYTES = 40;
    private static final int BITS_6_BYTES = 48;
    private static final int BITS_7_BYTES = 56;
    private static final int BYTE_LENGTH_BYTE = 1;
    private static final int BYTE_LENGTH_BOOLEAN = 1;
    private static final int BYTE_LENGTH_SHORT = 2;
    private static final int BYTE_LENGTH_CHAR = 2;
    private static final int BYTE_LENGTH_INT = 4;
    private static final int BYTE_LENGTH_FLOAT = 4;
    private static final int BYTE_LENGTH_LONG = 8;
    private static final int BYTE_LENGTH_DOUBLE = 8;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    byte[] data;
    int size;

    private static final int boundPow2(int n) {
        if (XMath.isGreaterThanHighestPowerOf2(n)) {
            return Integer.MAX_VALUE;
        }
        int p2 = 4;
        while (p2 < n) {
            p2 <<= 1;
        }
        return p2;
    }

    public static VarByte New() {
        return new VarByte(64);
    }

    public static VarByte New(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity may not be negative: " + initialCapacity);
        }
        return new VarByte(VarByte.boundPow2(initialCapacity));
    }

    private VarByte() {
        this(4);
    }

    private VarByte(int uncheckedInitialCapacity) {
        this.data = new byte[uncheckedInitialCapacity];
        this.size = 0;
    }

    public byte get(int index) {
        if (index < 0 || index >= this.size) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public byte lastByte() {
        if (this.size == 0) {
            throw new StringIndexOutOfBoundsException(0);
        }
        return this.data[this.size - 1];
    }

    public byte firstByte() {
        if (this.size == 0) {
            throw new StringIndexOutOfBoundsException(0);
        }
        return this.data[0];
    }

    public int length() {
        return this.size;
    }

    public VarByte subSequence(int start, int end) {
        VarByte subSequence = new VarByte(end - start);
        System.arraycopy(this.data, start, subSequence.data, 0, end - start);
        return subSequence;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.read();
        byte[] data = new byte[VarByte.boundPow2(size)];
        int i = 0;
        while (i < size) {
            data[i] = in.readByte();
            ++i;
        }
        this.data = data;
        this.size = size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] data = this.data;
        int size = this.size;
        out.write(size);
        int i = 0;
        while (i < size) {
            out.writeByte(data[i]);
            ++i;
        }
    }

    public String toString() {
        return new String(this.data, 0, this.size);
    }

    public String toString(Charset charset) throws UnsupportedEncodingException {
        return new String(this.data, 0, this.size, charset);
    }

    public VarByte add(boolean b) {
        if (this.size >= this.data.length) {
            this.data = new byte[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        this.data[this.size++] = b ? (byte)1 : 0;
        return this;
    }

    public VarByte add(byte c) {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new ArrayCapacityException();
            }
            this.data = new byte[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        this.data[this.size++] = c;
        return this;
    }

    public VarByte add(short s) {
        this.ensureFreeCapacity(2);
        this.data[this.size] = (byte)(s >> 8);
        this.data[this.size + 1] = (byte)s;
        this.size += 2;
        return this;
    }

    public VarByte add(int i) {
        this.ensureFreeCapacity(4);
        this.data[this.size] = (byte)(i >> 24);
        this.data[this.size + 1] = (byte)(i >> 16);
        this.data[this.size + 2] = (byte)(i >> 8);
        this.data[this.size + 3] = (byte)i;
        this.size += 4;
        return this;
    }

    public VarByte add(long l) {
        this.ensureFreeCapacity(8);
        this.data[this.size] = (byte)(l >> 56);
        this.data[this.size + 1] = (byte)(l >> 48);
        this.data[this.size + 2] = (byte)(l >> 40);
        this.data[this.size + 3] = (byte)(l >> 32);
        this.data[this.size + 4] = (byte)(l >> 24);
        this.data[this.size + 5] = (byte)(l >> 16);
        this.data[this.size + 6] = (byte)(l >> 8);
        this.data[this.size + 7] = (byte)l;
        this.size += 8;
        return this;
    }

    public VarByte add(float f) {
        return this.add(Float.floatToIntBits(f));
    }

    public VarByte add(double d) {
        return this.add(Double.doubleToLongBits(d));
    }

    public VarByte add(byte[] bytes) {
        this.internalAppend(bytes);
        return this;
    }

    public VarByte add(String s) {
        this.internalAppend(s.getBytes());
        return this;
    }

    public VarByte add(VarByte varByte) {
        if (varByte.size == 0) {
            return this;
        }
        this.internalAppend(varByte.data, 0, varByte.size);
        return this;
    }

    public void ensureFreeCapacity(int requiredFreeCapacity) {
        int newCapacity;
        if (this.data.length - this.size >= requiredFreeCapacity) {
            return;
        }
        if (Integer.MAX_VALUE - this.size < requiredFreeCapacity) {
            throw new ArrayCapacityException((long)requiredFreeCapacity + (long)this.size);
        }
        int newSize = this.size + requiredFreeCapacity;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        byte[] data = new byte[newCapacity];
        System.arraycopy(this.data, 0, data, 0, this.size);
        this.data = data;
    }

    private void internalAppend(byte[] bytes, int offset, int length) {
        this.ensureFreeCapacity(length);
        System.arraycopy(bytes, offset, this.data, this.size, length);
        this.size += length;
    }

    private void internalAppend(byte[] bytes) {
        this.ensureFreeCapacity(bytes.length);
        System.arraycopy(bytes, 0, this.data, this.size, bytes.length);
        this.size += bytes.length;
    }

    public VarByte appendArray(byte ... bytes) {
        this.internalAppend(bytes, 0, bytes.length);
        return this;
    }

    public VarByte append(byte[] bytes) {
        this.internalAppend(bytes);
        return this;
    }

    public VarByte append(byte[] bytes, int offset, int length) {
        this.internalAppend(bytes, offset, length);
        return this;
    }

    public VarByte append(byte value) {
        this.ensureFreeCapacity(1);
        this.data[this.size++] = value;
        return this;
    }

    public VarByte append(boolean value) {
        this.ensureFreeCapacity(1);
        this.data[this.size++] = value ? (byte)1 : 0;
        return this;
    }

    public VarByte append(short value) {
        this.ensureFreeCapacity(2);
        XMemory.set_shortInBytes(this.data, this.size, value);
        this.size += 2;
        return this;
    }

    public VarByte append(char value) {
        this.ensureFreeCapacity(2);
        XMemory.set_charInBytes(this.data, this.size, value);
        this.size += 2;
        return this;
    }

    public VarByte append(int value) {
        this.ensureFreeCapacity(4);
        XMemory.set_intInBytes(this.data, this.size, value);
        this.size += 4;
        return this;
    }

    public VarByte append(float value) {
        this.ensureFreeCapacity(4);
        XMemory.set_floatInBytes(this.data, this.size, value);
        this.size += 4;
        return this;
    }

    public VarByte append(long value) {
        this.ensureFreeCapacity(8);
        XMemory.set_longInBytes(this.data, this.size, value);
        this.size += 8;
        return this;
    }

    public VarByte append(double value) {
        this.ensureFreeCapacity(8);
        XMemory.set_doubleInBytes(this.data, this.size, value);
        this.size += 8;
        return this;
    }

    public VarByte setByte(int index, byte c) {
        if (index < 0 || index >= this.size) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.data[index] = c;
        return this;
    }

    public VarByte setBytes(int index, byte ... c) {
        if (index + c.length >= this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        System.arraycopy(c, 0, this.data, index, c.length);
        return this;
    }

    public VarByte setLastByte(byte c) {
        this.data[this.size - 1] = c;
        return this;
    }

    public VarByte reverse() {
        byte[] data = this.data;
        int i = this.size >> 1;
        int last = this.size - 1;
        while (i != 0) {
            byte loopSwapByte = data[i];
            data[i] = data[last - i];
            data[last - i] = loopSwapByte;
            --i;
        }
        return this;
    }

    @Deprecated
    public VarByte surrogateByteReverse() {
        return this.reverse();
    }

    public int indexOf(byte c) {
        byte[] data = this.data;
        int i = 0;
        int size = this.size;
        while (i < size) {
            if (data[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(byte c, int fromIndex) {
        int size = this.size;
        if (fromIndex < 0 || fromIndex >= size) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        byte[] data = this.data;
        int i = fromIndex;
        while (i < size) {
            if (data[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(byte[] bytes) {
        if (bytes.length == 0) {
            return 0;
        }
        byte firstByte = bytes[0];
        byte[] data = this.data;
        int scanBound = this.size - bytes.length + 1;
        int s = 0;
        while (s < scanBound) {
            block5: {
                if (data[s] == firstByte) {
                    int c = 1;
                    int j = s;
                    while (c < bytes.length) {
                        if (data[++j] == bytes[c]) {
                            ++c;
                            continue;
                        }
                        break block5;
                    }
                    return s;
                }
            }
            ++s;
        }
        return -1;
    }

    public int indexOf(byte[] bytes, int offset) {
        if (offset < 0 || offset >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (bytes.length == 0) {
            return offset;
        }
        byte firstByte = bytes[0];
        byte[] data = this.data;
        int scanBound = this.size - bytes.length + 1;
        int s = offset;
        while (s < scanBound) {
            block6: {
                if (data[s] == firstByte) {
                    int c = 1;
                    int j = s;
                    while (c < bytes.length) {
                        if (data[++j] == bytes[c]) {
                            ++c;
                            continue;
                        }
                        break block6;
                    }
                    return s;
                }
            }
            ++s;
        }
        return -1;
    }

    public boolean contains(byte c) {
        byte[] data = this.data;
        int i = 0;
        int size = this.size;
        while (i < size) {
            if (data[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int lastIndexOf(byte c) {
        byte[] data = this.data;
        int i = this.size;
        while (i-- > 0) {
            if (data[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte c, int fromIndex) {
        if (fromIndex < 0 || fromIndex >= this.size) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        byte[] data = this.data;
        int i = fromIndex;
        while (i > 0) {
            if (data[i] == c) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int count(byte c) {
        byte[] data = this.data;
        int size = this.size;
        int count = 0;
        int i = 0;
        while (i < size) {
            if (data[i] == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public VarByte deleteByteAt(int index) {
        int lastIndex = this.size - 1;
        if (index < 0 || index > lastIndex) {
            throw new StringIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.data, index + 1, this.data, index, lastIndex - index);
        --this.size;
        return this;
    }

    public VarByte deleteLastByte() {
        if (this.size == 0) {
            throw new StringIndexOutOfBoundsException("Cannot delete last byte of no bytes");
        }
        --this.size;
        return this;
    }

    public VarByte deleteLast(int n) {
        if (this.size < n) {
            throw new StringIndexOutOfBoundsException(String.valueOf(n) + " bytes cannot be deleted from " + this.size + " bytes");
        }
        this.size -= n;
        return this;
    }

    public VarByte shrinkTo(int n) {
        if (this.size < n) {
            throw new StringIndexOutOfBoundsException("Cannot shrink to size " + n + " on with a size of only " + this.size);
        }
        this.size = n;
        return this;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.data, 0, bytes, 0, this.size);
        return bytes;
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.size) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        System.arraycopy(this.data, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trimToSize() {
        int size = this.size;
        if (size << 1 > this.data.length || XMath.isGreaterThanHighestPowerOf2(size)) {
            return;
        }
        int newCapacity = 4;
        while (newCapacity < size) {
            newCapacity <<= 1;
        }
        byte[] data = new byte[newCapacity];
        System.arraycopy(this.data, 0, data, 0, size);
        this.data = data;
    }

    public static final boolean hasNoContent(VarByte varByte) {
        return varByte == null || varByte.size == 0;
    }

    public static final boolean hasContent(VarByte varByte) {
        return varByte != null && varByte.size != 0;
    }

    public VarByte replaceFirst(byte sample, byte replacement) {
        byte[] data = this.data;
        int i = 0;
        int size = this.size;
        while (i < size) {
            if (data[i] == sample) {
                data[i] = replacement;
                break;
            }
            ++i;
        }
        return this;
    }

    public VarByte replaceFirst(int beginIndex, byte sample, byte replacement) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (beginIndex > this.size) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        byte[] data = this.data;
        int i = beginIndex;
        int size = this.size;
        while (i < size) {
            if (data[i] == sample) {
                data[i] = replacement;
                break;
            }
            ++i;
        }
        return this;
    }

    public VarByte subsequence(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.size) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        int length = endIndex - beginIndex;
        VarByte vc = new VarByte(length);
        System.arraycopy(this.data, beginIndex, vc.data, 0, length);
        vc.size = length;
        return vc;
    }

    public void process(_byteProcedure processor) {
        byte[] data = this.data;
        int i = 0;
        int size = this.size;
        while (i < size) {
            processor.accept(data[i]);
            ++i;
        }
    }

    public VarByte clear() {
        byte[] data = this.data;
        int i = 0;
        int length = data.length;
        while (i < length) {
            data[i] = 0;
            ++i;
        }
        this.size = 0;
        return this;
    }

    public final VarByte reset() {
        this.size = 0;
        return this;
    }

    public void truncate() {
        this.data = new byte[this.data.length];
        this.size = 0;
    }

    public VarByte printlnTo(PrintStream printStream) {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.data, 0, bytes, 0, this.size);
        printStream.println(Arrays.toString(bytes));
        return this;
    }

    public VarByte printTo(PrintStream printStream) {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.data, 0, bytes, 0, this.size);
        printStream.print(Arrays.toString(bytes));
        return this;
    }

    public VarByte repeat(int amount, byte b) {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Negative amount is invalid.");
            }
            return this;
        }
        int size = this.size;
        if (Integer.MAX_VALUE - amount < size) {
            throw new ArrayIndexOutOfBoundsException("Technical array capacity exceeded.");
        }
        int targetSize = size + amount;
        if (this.data.length < targetSize) {
            this.data = new byte[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, size);
        }
        byte[] data = this.data;
        while (size < targetSize) {
            data[size] = b;
            ++size;
        }
        this.size = size;
        return this;
    }

    public VarByte apply(Consumer<? super VarByte> procedure) {
        procedure.accept(this);
        return this;
    }
}

