/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.chars;

import java.util.function.Consumer;
import one.microstream.chars.StringStamper;
import one.microstream.chars.XChars;

public final class StringSubstituter
implements StringStamper {
    private Entry[] slots = StringSubstituter.newSlots(1);
    private int range;
    private int size;

    private static Entry[] newSlots(int slotsLength) {
        return new Entry[slotsLength];
    }

    public static final StringSubstituter New() {
        return new StringSubstituter();
    }

    StringSubstituter() {
    }

    private void synchRebuildHashTable(int newLength) {
        int newRange = newLength == Integer.MAX_VALUE ? newLength : newLength - 1;
        Entry[] oldSlots = this.slots;
        Entry[] newSlots = StringSubstituter.newSlots(newLength);
        int i = 0;
        while (i < oldSlots.length) {
            if (oldSlots[i] != null) {
                Entry entry = oldSlots[i];
                while (entry != null) {
                    Entry next = entry.link;
                    entry.link = newSlots[entry.hash & newRange];
                    newSlots[entry.hash & newRange] = entry;
                    entry = next;
                }
            }
            ++i;
        }
        this.slots = newSlots;
        this.range = newRange;
    }

    private void synchIncrement() {
        if (++this.size >= this.range) {
            this.synchRebuildHashTable((int)((float)this.slots.length * 2.0f));
        }
    }

    private void synchDecrement() {
        if (--this.size << 1 < this.slots.length) {
            this.synchRebuildHashTable(this.slots.length >> 1);
        }
    }

    public final synchronized String substitute(String item) {
        if (item == null) {
            return null;
        }
        int hash = item.hashCode();
        Entry e = this.slots[this.range & hash];
        while (e != null) {
            if (e.hash == hash && e.item.equals(item)) {
                return e.item;
            }
            e = e.link;
        }
        this.slots[this.range & hash] = new Entry(hash, item, this.slots[this.range & hash]);
        this.synchIncrement();
        return item;
    }

    private static boolean equals(char[] sChars, char[] chars, int offset, int length) {
        int i = 0;
        while (i < length) {
            if (sChars[i] != chars[offset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final synchronized String substitute(char[] chars, int offset, int length) {
        XChars.validateRange(chars, offset, length);
        if (length == 0) {
            return this.substitute("");
        }
        int hash = XChars.internalHashCode(chars, offset, length);
        Entry e = this.slots[this.range & hash];
        while (e != null) {
            if (e.hash == hash && e.item.length() == length && StringSubstituter.equals(XChars.readChars(e.item), chars, offset, length)) {
                return e.item;
            }
            e = e.link;
        }
        String item = new String(chars, offset, length);
        this.slots[this.range & hash] = new Entry(hash, item, this.slots[this.range & hash]);
        this.synchIncrement();
        return item;
    }

    public final synchronized void clear() {
        this.range = 0;
        this.size = 0;
        this.slots = StringSubstituter.newSlots(1);
    }

    public final synchronized StringSubstituter iterate(Consumer<? super String> procedure) {
        Entry[] hashSlots = this.slots;
        int i = 0;
        while (i < hashSlots.length) {
            if (hashSlots[i] != null) {
                Entry entry = hashSlots[i];
                while (entry != null) {
                    procedure.accept(entry.item);
                    entry = entry.link;
                }
            }
            ++i;
        }
        return this;
    }

    public final synchronized boolean contains(String item) {
        int hash = item.hashCode();
        Entry e = this.slots[this.range & hash];
        while (e != null) {
            if (e.hash == hash && e.item.equals(item)) {
                return true;
            }
            e = e.link;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public final synchronized String remove(String item) {
        hash = item.hashCode();
        last = this.slots[this.range & hash];
        if (!last.item.equals(item)) ** GOTO lbl12
        this.slots[this.range & hash] = last.link;
        this.synchDecrement();
        return last.item;
lbl-1000:
        // 1 sources

        {
            if (e.hash == hash && e.item.equals(item)) {
                last = e.link;
                this.synchDecrement();
                return last.item;
            }
            last = e;
lbl12:
            // 2 sources

            ** while ((e = last.link) != null)
        }
lbl13:
        // 1 sources

        return null;
    }

    @Override
    public final String stampString(char[] chars, int offset, int length) {
        return this.substitute(chars, offset, length);
    }

    static final class Entry {
        final int hash;
        final String item;
        Entry link;

        Entry(int hash, String item, Entry next) {
            this.hash = hash;
            this.item = item;
            this.link = next;
        }
    }
}

