/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.chars;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import one.microstream.X;
import one.microstream.branching.ThrowBreak;
import one.microstream.bytes.VarByte;
import one.microstream.chars.CharConversionIntegers;
import one.microstream.chars.CharConversion_double;
import one.microstream.chars.CharConversion_float;
import one.microstream.chars.VarString;
import one.microstream.collections.BulkList;
import one.microstream.collections.XArrays;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.exceptions.NumberRangeException;
import one.microstream.functional._charPredicate;
import one.microstream.functional._charProcedure;
import one.microstream.math.XMath;
import one.microstream.memory.XMemory;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;

public final class XChars {
    static final transient char[] CHARS_MIN_VALUE_byte = Integer.toString(-128).toCharArray();
    static final transient char[] CHARS_MAX_VALUE_byte = Integer.toString(127).toCharArray();
    static final transient char[] CHARS_MIN_VALUE_short = Integer.toString(Short.MIN_VALUE).toCharArray();
    static final transient char[] CHARS_MAX_VALUE_short = Integer.toString(Short.MAX_VALUE).toCharArray();
    static final transient char[] CHARS_MIN_VALUE_int = Integer.toString(Integer.MIN_VALUE).toCharArray();
    static final transient char[] CHARS_MAX_VALUE_int = Integer.toString(Integer.MAX_VALUE).toCharArray();
    static final transient char[] CHARS_MIN_VALUE_long = Long.toString(Long.MIN_VALUE).toCharArray();
    static final transient char[] CHARS_MAX_VALUE_long = Long.toString(Long.MAX_VALUE).toCharArray();
    static final transient char[] CHARS_ZERO = Double.toString(0.0).toCharArray();
    static final transient char[] CHARS_ONE = Double.toString(1.0).toCharArray();
    static final transient char[] CHARS_NAN = Double.toString(Double.NaN).toCharArray();
    static final transient char[] CHARS_NEGATIVE_INFINITY = Double.toString(Double.NEGATIVE_INFINITY).toCharArray();
    static final transient char[] CHARS_POSITIVE_INFINITY = Double.toString(Double.POSITIVE_INFINITY).toCharArray();
    static final transient char[] CHARS_NORM_THRESH_HIGH = Double.toString(1.0E7).toCharArray();
    static final transient char[] EMPTY = new char[0];
    static final transient int MAX_CHAR_COUNT_byte = CHARS_MIN_VALUE_byte.length;
    static final transient int MAX_CHAR_COUNT_boolean = 5;
    static final transient int MAX_CHAR_COUNT_short = CHARS_MIN_VALUE_short.length;
    static final transient int MAX_CHAR_COUNT_int = CHARS_MIN_VALUE_int.length;
    static final transient int MAX_CHAR_COUNT_long = CHARS_MIN_VALUE_long.length;
    static final transient int MAX_CHAR_COUNT_float = 15;
    static final transient int MAX_CHAR_COUNT_double = 24;
    static final transient int SIGNLESS_MAX_CHAR_COUNT_byte = CHARS_MAX_VALUE_byte.length;
    static final transient int SIGNLESS_MAX_CHAR_COUNT_short = CHARS_MAX_VALUE_short.length;
    static final transient int SIGNLESS_MAX_CHAR_COUNT_int = CHARS_MAX_VALUE_int.length;
    static final transient int SIGNLESS_MAX_CHAR_COUNT_long = CHARS_MAX_VALUE_long.length;
    static final transient int LITERAL_LENGTH_NULL = 4;
    static final transient int LITERAL_LENGTH_TRUE = 4;
    static final transient int LITERAL_LENGTH_FALSE = 5;
    static final transient char DIGIT_LOWER_INDEX = '0';
    static final transient char DIGIT_UPPER_BOUND = ':';
    private static final char LOWEST_NON_WHITESPACE = '!';
    static final transient int DECIMAL_CHAR_TABLES_LENGTH = 100;
    static final transient int DECIMAL_BASE = 10;
    static final transient char[] DECIMAL_CHAR_TABLE_10S = new char[100];
    static final transient char[] DECIMAL_CHAR_TABLE_01S = new char[100];

    static {
        int i = 0;
        while (i < 100) {
            XChars.DECIMAL_CHAR_TABLE_10S[i] = (char)(48 + i / 10);
            XChars.DECIMAL_CHAR_TABLE_01S[i] = (char)(48 + i % 10);
            ++i;
        }
    }

    public static final int maxCharCount_byte() {
        return MAX_CHAR_COUNT_byte;
    }

    public static final int maxCharCount_boolean() {
        return 5;
    }

    public static final int maxCharCount_short() {
        return MAX_CHAR_COUNT_short;
    }

    public static final int maxCharCount_char() {
        return 1;
    }

    public static final int maxCharCount_int() {
        return MAX_CHAR_COUNT_int;
    }

    public static final int maxCharCount_float() {
        return 15;
    }

    public static final int maxCharCount_long() {
        return MAX_CHAR_COUNT_long;
    }

    public static final int maxCharCount_double() {
        return 24;
    }

    public static final boolean isWhitespace(char c) {
        return c < '!';
    }

    public static final boolean isNonWhitespace(char c) {
        return c >= '!';
    }

    public static final int shortStringLength() {
        return 1000;
    }

    public static final Charset utf8() {
        return StandardCharsets.UTF_8;
    }

    public static final Charset standardCharset() {
        return XChars.utf8();
    }

    public static final Charset defaultJvmCharset() {
        return Charset.defaultCharset();
    }

    public static final void validateIndex(char[] chars, int index) {
        if (index < 0 || index >= chars.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public static final void validateRange(char[] chars, int offset, int length) {
        XChars.validateIndex(chars, offset);
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        XChars.validateIndex(chars, offset + length - 1);
    }

    public static final boolean isEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static final boolean equals(String string, char[] chars, int offset) {
        XChars.validateIndex(chars, offset);
        int length = string.length();
        char[] sChars = XChars.readChars(string);
        if (length != chars.length - offset) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (sChars[i] != chars[offset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(char[] chars1, int offset1, char[] chars2, int offset2, int length) {
        XChars.validateRange(chars1, offset1, length);
        XChars.validateRange(chars2, offset2, length);
        return XChars.uncheckedEquals(chars1, offset1, chars2, offset2, length);
    }

    static final boolean uncheckedEquals(char[] chars1, int offset1, char[] chars2, int offset2, int length) {
        int i = 0;
        while (i < length) {
            if (chars1[offset1 + i] != chars2[offset2 + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isEqualIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static final char toHexadecimal(int b) throws IllegalArgumentException {
        switch (b) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        throw new IllegalArgumentException(String.valueOf(b) + " is no positive hexadecimal digit value");
    }

    public static final int indexOf(char[] data, char c) {
        return XChars.uncheckedIndexOf(data, 0, data.length, c);
    }

    public static final int indexOf(char[] data, int offset, int length, char c) {
        XChars.validateIndex(data, offset);
        XChars.validateIndex(data, offset + length);
        return XChars.uncheckedIndexOf(data, offset, offset + length, c);
    }

    static final int uncheckedIndexOf(char[] data, int bound, int offset, char c) {
        int i = offset;
        while (i < bound) {
            if (data[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static final int uncheckedLastIndexOf(char[] data, int size, char c) {
        int i = size;
        while (i-- > 0) {
            if (data[i] != c) continue;
            return i;
        }
        return -1;
    }

    static final void uncheckedReverse(char[] data, int size) {
        int last = size - 1;
        int i = size >>> 1;
        while (i != 0) {
            char loopSwapChar = data[i];
            data[i] = data[last - i];
            data[last - i] = loopSwapChar;
            --i;
        }
    }

    public static final int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int paddedFromIndex;
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        int n = paddedFromIndex = fromIndex < 0 ? 0 : fromIndex;
        if (targetCount == 0) {
            return paddedFromIndex;
        }
        char first = target[targetOffset];
        int maxFirstIndex = sourceOffset + sourceCount - targetCount;
        int i = sourceOffset + paddedFromIndex;
        while (i <= maxFirstIndex) {
            if (source[i] != first) {
                while (++i <= maxFirstIndex && source[i] != first) {
                }
            }
            if (i <= maxFirstIndex) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = targetOffset + 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    public static final VarByte readAllBytesFromInputStream(VarByte bytes, InputStream inputStream) throws IOException {
        byte[] buffer = new byte[XMemory.defaultBufferSize()];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            bytes.append(buffer, 0, bytesRead);
        }
        return bytes;
    }

    public static final VarByte readAllBytesFromInputStream(InputStream inputStream) throws IOException {
        return XChars.readAllBytesFromInputStream(VarByte.New(XMemory.defaultBufferSize()), inputStream);
    }

    public static final String readStringFromInputStream(InputStream inputStream, Charset charset) throws IOException {
        return XChars.readAllBytesFromInputStream(VarByte.New(XMemory.defaultBufferSize()), inputStream).toString(charset);
    }

    public static final int indexOf(char[] data, int dataLength, char[] subject) {
        if (dataLength < 0 || dataLength > data.length) {
            throw new ArrayIndexOutOfBoundsException(dataLength);
        }
        return XChars.uncheckedIndexOf(data, dataLength, subject);
    }

    static final int uncheckedIndexOf(char[] data, int dataLength, char[] subject) {
        if (subject.length == 0) {
            return 0;
        }
        char firstChar = subject[0];
        int scanBound = dataLength - subject.length + 1;
        int i = 0;
        while (i < scanBound) {
            block5: {
                if (data[i] == firstChar) {
                    int c = 1;
                    int i2 = i;
                    while (c < subject.length) {
                        if (data[++i2] == subject[c]) {
                            ++c;
                            continue;
                        }
                        break block5;
                    }
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(char[] data, int dataOffset, int dataLength, char[] chars) {
        if (dataOffset < 0 || dataOffset >= data.length) {
            throw new ArrayIndexOutOfBoundsException(dataOffset);
        }
        return XChars.uncheckedIndexOf(data, dataOffset, dataLength, chars);
    }

    static final int uncheckedIndexOf(char[] data, int dataOffset, int dataLength, char[] chars) {
        if (chars.length == 0) {
            return dataOffset;
        }
        char firstChar = chars[0];
        int scanBound = dataOffset + dataLength - chars.length + 1;
        int s = dataOffset;
        while (s < scanBound) {
            block5: {
                if (data[s] == firstChar) {
                    int c = 1;
                    int j = s;
                    while (c < chars.length) {
                        if (data[++j] == chars[c]) {
                            ++c;
                            continue;
                        }
                        break block5;
                    }
                    return s;
                }
            }
            ++s;
        }
        return -1;
    }

    public static final int indexOf(char[] source, int sourceCount, char[] target, int targetCount, int fromIndex) {
        int paddedFromIndex;
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        int n = paddedFromIndex = fromIndex < 0 ? 0 : fromIndex;
        if (targetCount == 0) {
            return paddedFromIndex;
        }
        if (targetCount == 0) {
            return paddedFromIndex;
        }
        char first = target[0];
        int max = sourceCount - targetCount;
        int i = paddedFromIndex;
        while (i <= max) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static final int replaceFirst(char[] chars, int offset, int length, char sample, char replacement) {
        XChars.validateRange(chars, offset, length);
        return XChars.uncheckedReplaceFirst(chars, offset, length, sample, replacement);
    }

    static final int uncheckedReplaceFirst(char[] chars, int offset, int length, char sample, char replacement) {
        int bound = offset + length;
        int i = offset;
        while (i < bound) {
            if (chars[i] == sample) {
                chars[i] = replacement;
                return i;
            }
            ++i;
        }
        return -1;
    }

    static final int uncheckedReplaceAll(char[] chars, int offset, int length, char sample, char replacement) {
        int count = 0;
        int bound = offset + length;
        int i = offset;
        while (i < bound) {
            if (chars[i] == sample) {
                chars[i] = replacement;
                ++count;
            }
            ++i;
        }
        return count;
    }

    static final void uncheckedRepeat(char[] chars, int offset, int count, char c) {
        int bound = offset + count;
        int i = offset;
        while (i < bound) {
            chars[i] = c;
            ++i;
        }
    }

    static final void uncheckedRepeat(char[] chars, int offset, int count, char[] subject) {
        int bound = offset + count;
        int i = offset;
        while (i < bound) {
            i = XChars.put(subject, chars, i);
        }
    }

    public static final int count(char[] input, int startIndex, int boundIndex, char c) {
        int count = 0;
        int i = startIndex;
        while (i < boundIndex) {
            if (input[i] == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static final int count(char[] data, int dataOffset, int dataCount, char[] subject, int subjectOffset, int subjectCount) {
        int count = 0;
        int i = -1;
        while ((i = XChars.indexOf(data, dataOffset, dataCount, subject, subjectOffset, subjectCount, i + 1)) != -1) {
            ++count;
        }
        return count;
    }

    public static final boolean hasContent(CharSequence s) {
        return s != null && s.length() != 0;
    }

    public static final boolean hasNoContent(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static final boolean hasContent(String s) {
        return s != null && !s.isEmpty();
    }

    public static final boolean hasNoContent(String s) {
        return s == null || s.isEmpty();
    }

    public static final String asString(char c) {
        switch (c) {
            case '\t': {
                return "\t";
            }
            case '\n': {
                return "\n";
            }
            case '\r': {
                return "\r";
            }
            case ' ': {
                return " ";
            }
            case '!': {
                return "!";
            }
            case '\"': {
                return "\"";
            }
            case '#': {
                return "#";
            }
            case '$': {
                return "$";
            }
            case '%': {
                return "%";
            }
            case '&': {
                return "&";
            }
            case '\'': {
                return "'";
            }
            case '(': {
                return "(";
            }
            case ')': {
                return ")";
            }
            case '*': {
                return "*";
            }
            case '+': {
                return " + ";
            }
            case ',': {
                return ",";
            }
            case '-': {
                return "-";
            }
            case '.': {
                return ".";
            }
            case '/': {
                return "/";
            }
            case '0': {
                return "0";
            }
            case '1': {
                return "1";
            }
            case '2': {
                return "2";
            }
            case '3': {
                return "3";
            }
            case '4': {
                return "4";
            }
            case '5': {
                return "5";
            }
            case '6': {
                return "6";
            }
            case '7': {
                return "7";
            }
            case '8': {
                return "8";
            }
            case '9': {
                return "9";
            }
            case ':': {
                return ":";
            }
            case ';': {
                return ";";
            }
            case '<': {
                return "<";
            }
            case '=': {
                return "=";
            }
            case '>': {
                return ">";
            }
            case '?': {
                return "?";
            }
            case '@': {
                return "@";
            }
            case 'A': {
                return "A";
            }
            case 'B': {
                return "B";
            }
            case 'C': {
                return "C";
            }
            case 'D': {
                return "D";
            }
            case 'E': {
                return "E";
            }
            case 'F': {
                return "F";
            }
            case 'G': {
                return "G";
            }
            case 'H': {
                return "H";
            }
            case 'I': {
                return "I";
            }
            case 'J': {
                return "J";
            }
            case 'K': {
                return "K";
            }
            case 'L': {
                return "L";
            }
            case 'M': {
                return "M";
            }
            case 'N': {
                return "N";
            }
            case 'O': {
                return "O";
            }
            case 'P': {
                return "P";
            }
            case 'Q': {
                return "Q";
            }
            case 'R': {
                return "R";
            }
            case 'S': {
                return "S";
            }
            case 'T': {
                return "T";
            }
            case 'U': {
                return "U";
            }
            case 'V': {
                return "V";
            }
            case 'W': {
                return "W";
            }
            case 'X': {
                return "X";
            }
            case 'Y': {
                return "Y";
            }
            case 'Z': {
                return "Z";
            }
            case '[': {
                return "[";
            }
            case '\\': {
                return "\\";
            }
            case ']': {
                return "]";
            }
            case '^': {
                return "^";
            }
            case '_': {
                return "_";
            }
            case '`': {
                return "`";
            }
            case 'a': {
                return "a";
            }
            case 'b': {
                return "b";
            }
            case 'c': {
                return "c";
            }
            case 'd': {
                return "d";
            }
            case 'e': {
                return "e";
            }
            case 'f': {
                return "f";
            }
            case 'g': {
                return "g";
            }
            case 'h': {
                return "h";
            }
            case 'i': {
                return "i";
            }
            case 'j': {
                return "j";
            }
            case 'k': {
                return "k";
            }
            case 'l': {
                return "l";
            }
            case 'm': {
                return "m";
            }
            case 'n': {
                return "n";
            }
            case 'o': {
                return "o";
            }
            case 'p': {
                return "p";
            }
            case 'q': {
                return "q";
            }
            case 'r': {
                return "r";
            }
            case 's': {
                return "s";
            }
            case 't': {
                return "t";
            }
            case 'u': {
                return "u";
            }
            case 'v': {
                return "v";
            }
            case 'w': {
                return "w";
            }
            case 'x': {
                return "x";
            }
            case 'y': {
                return "y";
            }
            case 'z': {
                return "z";
            }
            case '{': {
                return "{";
            }
            case '|': {
                return "|";
            }
            case '}': {
                return "}";
            }
            case '~': {
                return "~";
            }
        }
        return String.valueOf(c);
    }

    public static final String asString(char ... chars) {
        return String.valueOf(chars);
    }

    public static final String upperCaseFirstChar(String s) {
        char first;
        if (s == null || s.isEmpty() || Character.isUpperCase(first = s.charAt(0))) {
            return s;
        }
        return String.valueOf(Character.toUpperCase(first)) + s.substring(1);
    }

    public static final String lowerCaseFirstChar(String s) {
        char first;
        if (s == null || s.isEmpty() || Character.isLowerCase(first = s.charAt(0))) {
            return s;
        }
        return String.valueOf(Character.toLowerCase(first)) + s.substring(1);
    }

    public static final char[] concat(char[] ... arrays) {
        int length = 0;
        int i = 0;
        while (i < arrays.length) {
            if (arrays[i] != null) {
                length += arrays[i].length;
            }
            ++i;
        }
        char[] chars = new char[length];
        length = 0;
        int i2 = 0;
        while (i2 < arrays.length) {
            if (arrays[i2] != null) {
                System.arraycopy(arrays[i2], 0, chars, length, arrays[i2].length);
                length += arrays[i2].length;
            }
            ++i2;
        }
        return chars;
    }

    public static final VarString appendArraySeperated(VarString vs, String separator, Object ... elements) {
        if (separator == null) {
            return vs.addObjects(elements);
        }
        if (elements == null) {
            return vs;
        }
        int i = 0;
        while (i < elements.length) {
            vs.add(elements[i]).add(separator);
            ++i;
        }
        return vs.deleteLast(separator.length());
    }

    public static final VarString appendArraySeperated(VarString vc, char separator, Object ... elements) {
        if (elements == null) {
            return vc;
        }
        int i = 0;
        while (i < elements.length) {
            vc.add(elements[i]).add(separator);
            ++i;
        }
        return vc.deleteLast();
    }

    public static final char[] toCharArray(CharSequence c) {
        if (c instanceof String) {
            return ((String)c).toCharArray();
        }
        if (c instanceof VarString) {
            return ((VarString)c).toArray();
        }
        if (c instanceof StringBuilder) {
            return XChars.toCharArray((StringBuilder)c);
        }
        if (c instanceof StringBuffer) {
            return XChars.toCharArray((StringBuffer)c);
        }
        return c.toString().toCharArray();
    }

    public static final char[] toCharArray(StringBuilder asb) {
        char[] charArray = new char[asb.length()];
        asb.getChars(0, asb.length(), charArray, 0);
        return charArray;
    }

    public static final char[] toCharArray(StringBuffer asb) {
        char[] charArray = new char[asb.length()];
        asb.getChars(0, asb.length(), charArray, 0);
        return charArray;
    }

    public static final boolean intersects(char[] chars1, char[] chars2) {
        int i = 0;
        while (i < chars1.length) {
            int j = 0;
            while (j < chars2.length) {
                if (chars1[i] == chars2[j]) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static final char[] append(char c, char[] string) {
        char[] result = new char[string.length + 1];
        System.arraycopy(string, 0, result, 1, string.length);
        result[0] = c;
        return result;
    }

    public static final char[] append(char[] string, char c) {
        char[] result = new char[string.length + 1];
        System.arraycopy(string, 0, result, 0, string.length);
        result[result.length - 1] = c;
        return result;
    }

    public static final char[] append(char[] a, char[] b) {
        char[] result = new char[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private static int lcsLength(String a, String b) {
        int lenA = a.length();
        int lenB = b.length();
        int[] p = new int[lenB];
        int[] d = new int[lenB];
        int maxLen = 0;
        int i = 0;
        while (i < lenA) {
            int j = 0;
            while (j < lenB) {
                if ((a.charAt(i) != b.charAt(j) ? 0 : (d[j] = i == 0 || j == 0 ? 1 : p[j - 1] + 1)) > maxLen) {
                    maxLen = d[j];
                }
                ++j;
            }
            int[] swap = p;
            p = d;
            d = swap;
            ++i;
        }
        return maxLen;
    }

    private static int lcsLength(char[] a, char[] b) {
        int lenA = a.length;
        int lenB = b.length;
        int[] p = new int[lenB];
        int[] d = new int[lenB];
        int maxLen = 0;
        int i = 0;
        while (i < lenA) {
            int j = 0;
            while (j < lenB) {
                if ((a[i] != b[j] ? 0 : (d[j] = i == 0 || j == 0 ? 1 : p[j - 1] + 1)) > maxLen) {
                    maxLen = d[j];
                }
                ++j;
            }
            int[] swap = p;
            p = d;
            d = swap;
            ++i;
        }
        return maxLen;
    }

    public static final int longestCommonSubstringLength(String a, String b) {
        if (a.isEmpty() || b.isEmpty()) {
            return 0;
        }
        return a.length() > b.length() ? XChars.lcsLength(a, b) : XChars.lcsLength(b, a);
    }

    public static final int commonSubstringLength(char[] a, char[] b) {
        if (a.length == 0 || b.length == 0) {
            return 0;
        }
        return a.length > b.length ? XChars.lcsLength(a, b) : XChars.lcsLength(b, a);
    }

    public static final String longestCommonSubstring(String a, String b) {
        if (a.isEmpty() || b.isEmpty()) {
            return "";
        }
        int lenPreA = a.length() + 1;
        String[] prefixesA = new String[lenPreA];
        int lenPreB = b.length() + 1;
        String[] prefixesB = new String[lenPreB];
        int i = 0;
        while (i < lenPreA) {
            prefixesA[i] = a.substring(0, i);
            ++i;
        }
        i = 0;
        while (i < lenPreB) {
            prefixesB[i] = b.substring(0, i);
            ++i;
        }
        String[][] suffixes = new String[lenPreA][];
        String longestCommonSubstring = "";
        int i2 = 0;
        while (i2 < lenPreA) {
            suffixes[i2] = new String[lenPreB];
            int j = 0;
            while (j < lenPreB) {
                suffixes[i2][j] = "";
                int k1 = prefixesA[i2].length() - 1;
                int k2 = prefixesB[j].length() - 1;
                while (k1 >= 0 && k2 >= 0) {
                    if (prefixesA[i2].charAt(k1) != prefixesB[j].charAt(k2)) break;
                    suffixes[i2][j] = String.valueOf(String.valueOf(prefixesA[i2].charAt(k1))) + suffixes[i2][j];
                    --k1;
                    --k2;
                }
                if (suffixes[i2][j].length() > longestCommonSubstring.length()) {
                    longestCommonSubstring = suffixes[i2][j];
                }
                ++j;
            }
            ++i2;
        }
        return longestCommonSubstring;
    }

    public static final char[] longestCommonSubstring(char[] a, char[] b) {
        if (a.length == 0 || b.length == 0) {
            return new char[0];
        }
        int lenPreA = a.length + 1;
        char[][] prefixesA = new char[lenPreA][];
        int lenPreB = b.length + 1;
        char[][] prefixesB = new char[lenPreB][];
        int i = 0;
        while (i < lenPreA) {
            prefixesA[i] = XChars.substring(a, 0, i);
            ++i;
        }
        i = 0;
        while (i < lenPreB) {
            prefixesB[i] = XChars.substring(b, 0, i);
            ++i;
        }
        char[][][] suffixes = new char[lenPreA][][];
        char[] longestCommonSubstring = EMPTY;
        int i2 = 0;
        while (i2 < lenPreA) {
            suffixes[i2] = new char[lenPreB][];
            int j = 0;
            while (j < lenPreB) {
                suffixes[i2][j] = EMPTY;
                int k1 = prefixesA[i2].length - 1;
                int k2 = prefixesB[j].length - 1;
                while (k1 >= 0 && k2 >= 0) {
                    if (prefixesA[i2][k1] != prefixesB[j][k2]) break;
                    suffixes[i2][j] = XChars.append(prefixesA[i2][k1], suffixes[i2][j]);
                    --k1;
                    --k2;
                }
                if (suffixes[i2][j].length > longestCommonSubstring.length) {
                    longestCommonSubstring = suffixes[i2][j];
                }
                ++j;
            }
            ++i2;
        }
        return longestCommonSubstring;
    }

    public static final char[] substring(char[] string, int offset, int bound) {
        if (offset == bound) {
            if (offset < 0 || offset >= string.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            return new char[0];
        }
        char[] substring = new char[bound - offset];
        System.arraycopy(string, offset, substring, 0, substring.length);
        return substring;
    }

    public static final String convertUnderscoresToCamelCase(String parameterName) {
        return XChars.convertUnderscoresToCamelCase(VarString.New(parameterName.length()), parameterName).toString();
    }

    public static final VarString convertUnderscoresToCamelCase(VarString vs, String s) {
        if (XChars.hasNoContent(s) || s.indexOf(95) < 0) {
            return vs.add(s);
        }
        int vcStartLength = vs.length();
        int lastIndex = s.length() - 1;
        int i = 0;
        while (i <= lastIndex) {
            char next;
            if (s.charAt(i) != '_') {
                vs.add(s.charAt(i));
            } else if (i != 0 && i < lastIndex && (next = s.charAt(i + 1)) != '_') {
                if (Character.isLowerCase(next)) {
                    if (!vs.isEmpty() && Character.isUpperCase(vs.last())) {
                        vs.add('_');
                    }
                    vs.add(Character.toUpperCase(next));
                } else if (XChars.isDigit(next)) {
                    if (!vs.isEmpty() && XChars.isDigit(vs.last())) {
                        vs.add('_');
                    }
                    vs.add(next);
                } else if (Character.isUpperCase(next) && !vs.isEmpty() && Character.isUpperCase(vs.last())) {
                    vs.add('_').add(next);
                } else if (next != vs.last()) {
                    vs.add(Character.toUpperCase(next));
                } else {
                    vs.add('_', next);
                }
                ++i;
            }
            ++i;
        }
        if (vcStartLength == vs.length()) {
            vs.add(s);
        }
        return vs;
    }

    public static final int longestCommonPrefixLength(String a, String b) {
        int len = a.length() < b.length() ? a.length() : b.length();
        int i = 0;
        while (i < len) {
            if (a.charAt(i) != b.charAt(i)) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static final int longestCommonSuffixLength(String a, String b) {
        int lenB;
        int lenA = a.length();
        int len = lenA < (lenB = b.length()) ? lenA : lenB;
        int i = 1;
        while (i <= len) {
            if (a.charAt(lenA - i) != b.charAt(lenB - i)) {
                return i - 1;
            }
            ++i;
        }
        return len;
    }

    public static final String longestCommonSuffix(String a, String b) {
        int len = XChars.longestCommonSuffixLength(a, b);
        if (len == 0) {
            return "";
        }
        return a.substring(a.length() - len, a.length());
    }

    public static final String longestCommonPrefix(String a, String b) {
        int len = XChars.longestCommonPrefixLength(a, b);
        if (len == 0) {
            return "";
        }
        return a.substring(0, len);
    }

    public static final int commonPrefixLength(char[] a, char[] b) {
        int len = a.length < b.length ? a.length : b.length;
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static final int commonSuffixLength(char[] a, char[] b) {
        int lenA = a.length;
        int lenB = b.length;
        int len = lenA < lenB ? lenA : lenB;
        int i = 1;
        while (i <= len) {
            if (a[lenA - i] != b[lenB - i]) {
                return i - 1;
            }
            ++i;
        }
        return len;
    }

    public static final char[] longestCommonSuffix(char[] a, char[] b) {
        int len = XChars.commonSuffixLength(a, b);
        if (len == 0) {
            return new char[0];
        }
        char[] prefix = new char[len];
        System.arraycopy(a, a.length - len, prefix, 0, len);
        return prefix;
    }

    public static final char[] longestCommonPrefix(char[] a, char[] b) {
        int len = XChars.commonPrefixLength(a, b);
        if (len == 0) {
            return new char[0];
        }
        char[] prefix = new char[len];
        System.arraycopy(a, 0, prefix, 0, len);
        return prefix;
    }

    public static final String padLeft(String s, int totalLength, char paddingChar) {
        return VarString.New(totalLength).padLeft(s, totalLength, paddingChar).toString();
    }

    public static final String padRight(String s, int totalLength, char paddingChar) {
        return VarString.New(totalLength).padRight(s, totalLength, paddingChar).toString();
    }

    public static final String padLeft(String s, int totalLength) {
        return VarString.New(totalLength).padLeft(s, totalLength, ' ').toString();
    }

    public static final String padRight(String s, int totalLength) {
        return VarString.New(totalLength).padRight(s, totalLength, ' ').toString();
    }

    public static final String padLeft0(String s, int totalLength) {
        return VarString.New(totalLength).padLeft(s, totalLength, '0').toString();
    }

    public static final String padRight0(String s, int totalLength) {
        return VarString.New(totalLength).padRight(s, totalLength, '0').toString();
    }

    public static final char parseChar(String s) {
        if (s.charAt(0) != '\\' && s.length() != 1 || s.charAt(0) == '\\' && s.length() != 2) {
            throw new IllegalArgumentException(s);
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        switch (s.charAt(1)) {
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
        }
        throw new IllegalArgumentException(s);
    }

    public static final VarString escapeChar(VarString vc, char c) {
        switch (c) {
            case '\t': {
                return vc.add('\\', 't');
            }
            case '\b': {
                return vc.add('\\', 'b');
            }
            case '\n': {
                return vc.add('\\', 'n');
            }
            case '\r': {
                return vc.add('\\', 'r');
            }
            case '\f': {
                return vc.add('\\', 'f');
            }
            case '\'': {
                return vc.add('\\', '\'');
            }
            case '\\': {
                return vc.add('\\', '\\');
            }
        }
        return vc.append(c);
    }

    public static final String escapeChar(char c) {
        switch (c) {
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    public static final String createMedialCapitalsString(String ... elements) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return "";
        }
        if (elements.length == 1) {
            return elements[0];
        }
        VarString sb = VarString.New(512);
        sb.add(elements[0]);
        int i = 1;
        while (i < elements.length) {
            String element = elements[i];
            if (element != null && !element.isEmpty()) {
                char firstLetter = element.charAt(0);
                if (Character.isUpperCase(firstLetter)) {
                    sb.add(element.toString());
                } else {
                    sb.append(Character.toUpperCase(firstLetter)).add(element.substring(1));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String ensureCharAtEnd(String s, char c) {
        if (s.charAt(s.length() - 1) == c) {
            return s;
        }
        return String.valueOf(s) + c;
    }

    public static final String toSingleLine(String multiLineString, String lineBreakReplacement) {
        return multiLineString.replaceAll("((\\r)?\\n) + ", lineBreakReplacement);
    }

    public static final String padSpace(String s, int chars) {
        VarString sb = VarString.New(chars).add(s);
        int i = s.length();
        while (i < chars) {
            sb.add(' ');
            ++i;
        }
        return sb.toString();
    }

    public static final String concat(char separator, Object ... parts) {
        if (parts == null) {
            return null;
        }
        VarString sb = VarString.New(128);
        int lastIndex = parts.length - 1;
        int i = 0;
        while (i <= lastIndex) {
            if (parts[i] != null) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.add(parts[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final <C extends CharSequence> C notEmpty(C charSequence) {
        if (charSequence.length() == 0) {
            throw new IllegalArgumentException();
        }
        return charSequence;
    }

    public static final boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static final void iterate(CharSequence chars, _charProcedure iterator) {
        if (chars instanceof String) {
            XChars.iterate((String)chars, iterator);
            return;
        }
        if (chars instanceof VarString) {
            ((VarString)chars).iterate(iterator);
            return;
        }
        try {
            int length = chars.length();
            int i = 0;
            while (i < length) {
                iterator.accept(chars.charAt(i));
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final void iterate(String chars, _charProcedure iterator) {
        XChars.iterate(XChars.readChars(chars), iterator);
    }

    public static final void iterate(char[] chars, _charProcedure iterator) {
        XChars.iterate(chars, 0, chars.length, iterator);
    }

    public static final void iterate(char[] chars, int offset, int length, _charProcedure iterator) {
        try {
            int i = offset;
            while (i < length) {
                iterator.accept(chars[i++]);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final int put(byte value, char[] target, int offset) {
        return CharConversionIntegers.put_byte(value, target, offset);
    }

    public static final int putHexDec(byte value, char[] target, int offset) {
        target[offset] = XChars.toHexadecimal(value >>> 4 & 0xF);
        target[offset + 1] = XChars.toHexadecimal(value & 0xF);
        return offset + 2;
    }

    public static final int put(boolean value, char[] target, int offset) {
        return value ? XChars.putTrue(target, offset) : XChars.putFalse(target, offset);
    }

    public static final int put(short value, char[] target, int offset) {
        return CharConversionIntegers.put_short(value, target, offset);
    }

    public static final int put(int value, char[] target, int offset) {
        return CharConversionIntegers.put_int(value, target, offset);
    }

    public static final int put(float value, char[] target, int offset) {
        return CharConversion_float.put(value, target, offset);
    }

    public static final int put(long value, char[] target, int offset) {
        return CharConversionIntegers.put_long(value, target, offset);
    }

    public static final int put(double value, char[] target, int offset) {
        return CharConversion_double.put(value, target, offset);
    }

    public static final int put(String s, char[] target, int offset) {
        s.getChars(0, s.length(), target, offset);
        return offset + s.length();
    }

    public static final int put(char[] value, char[] target, int offset) {
        System.arraycopy(value, 0, target, offset, value.length);
        return offset + value.length;
    }

    public static final int putNull(char[] target, int offset) {
        target[offset] = 110;
        target[offset + 1] = 117;
        target[offset + 2] = 108;
        target[offset + 3] = 108;
        return offset + 4;
    }

    public static final int putTrue(char[] target, int offset) {
        target[offset] = 116;
        target[offset + 1] = 114;
        target[offset + 2] = 117;
        target[offset + 3] = 101;
        return offset + 4;
    }

    public static final int putFalse(char[] target, int offset) {
        target[offset] = 102;
        target[offset + 1] = 97;
        target[offset + 2] = 108;
        target[offset + 3] = 115;
        target[offset + 4] = 101;
        return offset + 5;
    }

    public static final String String(byte value) {
        char[] chars = new char[MAX_CHAR_COUNT_byte];
        return new String(chars, 0, CharConversionIntegers.put_byte(value, chars, 0));
    }

    public static final String String(boolean value) {
        return Boolean.toString(value);
    }

    public static final String String(short value) {
        char[] chars = new char[MAX_CHAR_COUNT_short];
        return new String(chars, 0, CharConversionIntegers.put_short(value, chars, 0));
    }

    public static final String String(char value) {
        return String.valueOf(value);
    }

    public static final String String(int value) {
        char[] chars = new char[MAX_CHAR_COUNT_int];
        return new String(chars, 0, CharConversionIntegers.put_int(value, chars, 0));
    }

    public static final String String(float value) {
        return XChars.String((double)value);
    }

    public static final String String(long value) {
        char[] chars = new char[MAX_CHAR_COUNT_long];
        return new String(chars, 0, CharConversionIntegers.put_long(value, chars, 0));
    }

    public static final String String(double value) {
        char[] chars = new char[24];
        return new String(chars, 0, CharConversion_double.put(value, chars, 0));
    }

    public static final String String(char[] chars) {
        return new String(chars);
    }

    public static final String String(char[] chars, int offset, int length) {
        return XChars.String(chars, offset, length);
    }

    public static final String String(byte[] chars) {
        return XChars.String(chars, XChars.standardCharset());
    }

    public static final String String(byte[] chars, Charset charset) {
        return XChars.String(chars, 0, chars.length, charset);
    }

    public static final String String(byte[] chars, int offset, int length) {
        return XChars.String(chars, offset, length, XChars.standardCharset());
    }

    public static final String String(byte[] chars, int offset, int length, Charset charset) {
        return new String(chars, offset, length, charset);
    }

    public static final String String(ByteBuffer chars) {
        return XChars.String(chars, XChars.standardCharset());
    }

    public static final String String(ByteBuffer chars, Charset charset) {
        return new String(XMemory.toArray(chars), charset);
    }

    public static final String String(ByteBuffer chars, int offset, int length) {
        return XChars.String(chars, offset, length, XChars.standardCharset());
    }

    public static final String String(ByteBuffer chars, int offset, int length, Charset charset) {
        return new String(XMemory.toArray(chars, offset, length), charset);
    }

    public static final StringBuilder StringBuilder(VarString vs) {
        return new StringBuilder(vs.size).append(vs.data, 0, vs.size);
    }

    public static final StringBuilder StringBuilder(VarString vs, int offset, int length) {
        vs.validateRange(offset, length);
        return new StringBuilder(length).append(vs.data, offset, length);
    }

    public static final StringBuffer StringBuffer(VarString vs) {
        return new StringBuffer(vs.size).append(vs.data, 0, vs.size);
    }

    public static final StringBuffer StringBuffer(VarString vs, int offset, int length) {
        vs.validateRange(offset, length);
        return new StringBuffer(length).append(vs.data, offset, length);
    }

    public static final char[] readChars(String s) {
        return s.toCharArray();
    }

    public static final int hashCode(char[] chars, int offset, int length) {
        XChars.validateRange(chars, offset, length);
        return XChars.internalHashCode(chars, offset, length);
    }

    static final int internalHashCode(char[] chars, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        int hashCode = 0;
        int bound = offset + length;
        int i = offset;
        while (i < bound) {
            hashCode = 31 * hashCode + chars[i];
            ++i;
        }
        return hashCode;
    }

    public static final <C extends Consumer<String>> C splitAndTrimToStrings(String input, char separator, C collector) {
        return XChars.splitAndTrimToStrings(XChars.readChars(input), separator, collector);
    }

    public static final <C extends Consumer<String>> C splitAndTrimToStrings(char[] input, char separator, C collector) {
        int lowerIndex = 0;
        int i = 0;
        while (i < input.length) {
            if (input[i] == separator) {
                collector.accept((String)XChars.trimToString(input, lowerIndex, i - lowerIndex));
                lowerIndex = i + 1;
            }
            ++i;
        }
        if (lowerIndex <= input.length) {
            collector.accept((String)XChars.trimToString(input, lowerIndex, input.length - lowerIndex));
        }
        return collector;
    }

    public static String[] splitSimple(String s, String separator) {
        if (s.length() > XChars.shortStringLength()) {
            return XChars.splitSimple(s, separator, BulkList.New()).toArray(String.class);
        }
        StringTokenizer pathTokenizer = new StringTokenizer(s, separator);
        boolean startWithSeparator = s.startsWith(separator);
        int swsValue = startWithSeparator ? 1 : 0;
        int tokenCount = pathTokenizer.countTokens() + swsValue;
        String[] pathParts = new String[tokenCount];
        if (startWithSeparator) {
            pathParts[0] = "";
        }
        int i = swsValue;
        while (pathTokenizer.hasMoreTokens()) {
            pathParts[i] = pathTokenizer.nextToken();
            ++i;
        }
        return pathParts;
    }

    public static <C extends Consumer<? super String>> C splitSimple(String s, String separator, C collector) {
        StringTokenizer pathTokenizer = new StringTokenizer(s, separator);
        if (s.startsWith(separator)) {
            collector.accept((String)"");
        }
        while (pathTokenizer.hasMoreTokens()) {
            String token = pathTokenizer.nextToken();
            collector.accept((String)token);
        }
        return collector;
    }

    public static final String trimToString(char[] input, int lowerOffset, int length) {
        if (length <= 0) {
            if (length < 0) {
                throw new NotImplementedYetError();
            }
            return "";
        }
        int bound = lowerOffset + length;
        int low = lowerOffset;
        while (low < bound && XChars.isWhitespace(input[low])) {
            ++low;
        }
        if (low >= lowerOffset + length) {
            return "";
        }
        int upper = lowerOffset + length - 1;
        while (XChars.isWhitespace(input[upper])) {
            --upper;
        }
        return new String(input, low, upper - low + 1);
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static final int[] parseTo_intArray(String ... intStrings) {
        if (intStrings == null) {
            return null;
        }
        int[] ints = new int[intStrings.length];
        int i = 0;
        while (i < intStrings.length) {
            ints[i] = Integer.parseInt(intStrings[i]);
            ++i;
        }
        return ints;
    }

    public static final Integer[] parseToIntegerArray(String ... intStrings) {
        if (intStrings == null) {
            return null;
        }
        Integer[] ints = new Integer[intStrings.length];
        int i = 0;
        while (i < intStrings.length) {
            ints[i] = new Integer(intStrings[i]);
            ++i;
        }
        return ints;
    }

    public static final VarString assembleNewLinedTabbed(VarString vs, CharSequence ... elements) {
        vs.lf().add(elements[0]);
        int i = 1;
        while (i < elements.length) {
            vs.tab().add(elements[i]);
            ++i;
        }
        return vs;
    }

    public static final VarString assembleSeparated(VarString vs, char separator, CharSequence ... elements) {
        if (XArrays.hasNoContent(elements)) {
            return vs;
        }
        vs.add(elements[0]);
        int i = 1;
        while (i < elements.length) {
            vs.add(separator).add(elements[i]);
            ++i;
        }
        return vs;
    }

    public static final byte parse_byteDecimal(char[] input) {
        return XChars.uncheckedParse_byteDecimal(input, 0, input.length);
    }

    public static final short parse_shortDecimal(char[] input) {
        return XChars.uncheckedParse_shortDecimal(input, 0, input.length);
    }

    public static final int parse_intLiteral(char[] input) {
        return XChars.uncheckedParse_intLiteral(input, 0, input.length);
    }

    public static final long parse_longDecimal(char[] input) {
        return XChars.uncheckedParse_longLiteral(input, 0, input.length);
    }

    public static final byte parse_byteDecimal(char[] input, int offset, int length) {
        XChars.validateRange(input, offset, length);
        return XChars.uncheckedParse_byteDecimal(input, offset, length);
    }

    public static final short parse_shortDecimal(char[] input, int offset, int length) {
        XChars.validateRange(input, offset, length);
        return XChars.uncheckedParse_shortDecimal(input, offset, length);
    }

    public static final int parse_intLiteral(char[] input, int offset, int length) {
        XChars.validateRange(input, offset, length);
        return XChars.uncheckedParse_intLiteral(input, offset, length);
    }

    public static final long parse_longDecimal(char[] input, int offset, int length) {
        XChars.validateRange(input, offset, length);
        return XChars.uncheckedParse_longLiteral(input, offset, length);
    }

    public static final float parse_float(char[] input, int offset, int length) {
        XChars.validateRange(input, offset, length);
        return Float.parseFloat(String.valueOf(input, offset, length));
    }

    public static final double parse_double(char[] input, int offset, int length) {
        XChars.validateRange(input, offset, length);
        return Double.parseDouble(String.valueOf(input, offset, length));
    }

    public static final byte uncheckedParse_byteDecimal(char[] input, int offset, int length) {
        if (length >= SIGNLESS_MAX_CHAR_COUNT_byte) {
            XChars.checkNumberRanges(input, offset, length, CHARS_MIN_VALUE_byte, CHARS_MAX_VALUE_byte);
        }
        try {
            return (byte)XChars.internalParse_longLiteral(input, offset, length);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.copyValueOf(input, offset, length));
        }
    }

    public static final short uncheckedParse_shortDecimal(char[] input, int offset, int length) {
        if (length >= SIGNLESS_MAX_CHAR_COUNT_short) {
            XChars.checkNumberRanges(input, offset, length, CHARS_MIN_VALUE_short, CHARS_MAX_VALUE_short);
        }
        try {
            return (short)XChars.internalParse_longLiteral(input, offset, length);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.copyValueOf(input, offset, length));
        }
    }

    public static final int uncheckedParse_intLiteral(char[] input, int offset, int length) {
        if (length >= SIGNLESS_MAX_CHAR_COUNT_int) {
            XChars.checkNumberRanges(input, offset, length, CHARS_MIN_VALUE_int, CHARS_MAX_VALUE_int);
        }
        try {
            return (int)XChars.internalParse_longLiteral(input, offset, length);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.copyValueOf(input, offset, length));
        }
    }

    public static final long uncheckedParse_longLiteral(char[] input, int offset, int length) {
        if (length >= SIGNLESS_MAX_CHAR_COUNT_long) {
            XChars.checkNumberRanges(input, offset, length, CHARS_MIN_VALUE_long, CHARS_MAX_VALUE_long);
        }
        try {
            return XChars.internalParse_longLiteral(input, offset, length);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.copyValueOf(input, offset, length));
        }
    }

    private static void checkNumberRanges(char[] input, int offset, int length, char[] minValueLiteral, char[] maxValueLiteral) {
        int len;
        int maxCharCount = minValueLiteral.length;
        int signlessMaxCharCount = maxCharCount - 1;
        int pos = offset;
        if (length > maxCharCount) {
            if (input[pos] == '-' || input[pos] == '+') {
                ++pos;
            }
            while (input[pos] == '0') {
                ++pos;
            }
        }
        if ((len = length - (pos - offset) - (input[pos] == '-' || input[pos] == '+' ? 1 : 0)) > signlessMaxCharCount) {
            throw new NumberRangeException(String.copyValueOf(input, pos, len));
        }
        if (len < signlessMaxCharCount) {
            return;
        }
        if (input[offset] == '-' ? len == signlessMaxCharCount && XChars.isNumericalLessThan(minValueLiteral, 1, input, pos, len) : (input[offset] == '+' ? len == signlessMaxCharCount && XChars.isNumericalLessThan(maxValueLiteral, 0, input, pos, len) : len == signlessMaxCharCount && XChars.isNumericalLessThan(maxValueLiteral, 0, input, pos, len))) {
            throw new NumberRangeException(String.copyValueOf(input, pos, len));
        }
    }

    public static final long internalParse_longLiteral(char[] input, int offset, int length) {
        if (length == 1) {
            return XChars.to_int(input[offset]);
        }
        int i = offset;
        int bound = i + length;
        boolean negative = input[i] == '-';
        if (negative || input[i] == '+') {
            if (length == CHARS_MIN_VALUE_long.length && XChars.uncheckedEquals(input, offset, CHARS_MIN_VALUE_long, 0, length)) {
                return Long.MIN_VALUE;
            }
            ++i;
        }
        long value = 0L;
        while (i < bound) {
            value = value * 10L + (long)XChars.to_int(input[i++]);
        }
        return negative ? -value : value;
    }

    static final boolean isNumericalLessThan(char[] chars1, int offset1, char[] chars2, int offset2, int length) {
        int i = 0;
        while (i < length) {
            if (chars1[offset1 + i] != chars2[offset2 + i]) {
                return chars1[offset1 + i] < chars2[offset2 + i];
            }
            ++i;
        }
        return false;
    }

    public static final int to_int(char digit) {
        if (digit < '0' || digit >= ':') {
            throw new NumberFormatException(String.valueOf(digit));
        }
        return digit - 48;
    }

    public static final char[][] toArrays(XGettingSequence<String> strings) {
        char[][] arrays = new char[X.checkArrayRange(strings.size())][];
        strings.iterateIndexed((e, i) -> {
            cArray[X.checkArrayRange((long)i)] = e.toCharArray();
            char[] cArray2 = cArray[X.checkArrayRange((long)i)];
        });
        return arrays;
    }

    public static final boolean contains(String[] strings, String subject) {
        X.notNull(subject);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (subject.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean contains(String s, char c) {
        return s.indexOf(c) >= 0;
    }

    public static final boolean contains(char[] subject, int subjectOffset, int subjectLength, char[] sample, int sampleOffset, int sampleLength) {
        int startBound = subjectOffset + subjectLength - sampleLength;
        int i = subjectOffset;
        while (i < startBound) {
            if (XChars.equals(subject, i, sample, sampleOffset, sampleLength)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean contains(char[] data, char c) {
        return XChars.uncheckedContains(data, 0, data.length, c);
    }

    public static final boolean contains(char[] data, int dataOffset, int dataLength, char c) {
        XArrays.checkBounds(data.length, dataOffset, dataOffset + XMath.notNegative(dataLength));
        return XChars.uncheckedContains(data, dataLength, dataOffset, c);
    }

    static final boolean uncheckedContains(char[] data, int dataOffset, int dataLength, char c) {
        int dataBound = dataOffset + dataLength;
        int i = dataOffset;
        while (i < dataBound) {
            if (data[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String systemString(Object instance) {
        return instance == null ? null : String.valueOf(instance.getClass().getName()) + '@' + Integer.toHexString(System.identityHashCode(instance));
    }

    public static VarString addSystemString(Object instance, VarString vs) {
        return instance == null ? vs.addNull() : vs.add(instance.getClass().getName()).add('@').add(Integer.toHexString(System.identityHashCode(instance)));
    }

    public static String nonNullString(Object object) {
        return object == null ? "" : object.toString();
    }

    public static String valueString(Object value) {
        return value == null ? null : value.toString();
    }

    public static String trimEmptyToNull(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) > ' ') {
                return s.trim();
            }
            ++i;
        }
        return null;
    }

    public static final VarString assembleCautiously(VarString vs, Object object) {
        return vs.add(XTypes.isValueType(object) ? object.toString() : XChars.systemString(object));
    }

    public static final boolean applies(CharSequence chars, _charPredicate predicate) {
        return XChars.applies(chars, 0, predicate);
    }

    public static final boolean applies(CharSequence chars, int startIndex, _charPredicate predicate) {
        int length = chars.length();
        if (length == 0) {
            return false;
        }
        int i = startIndex;
        while (i < length) {
            if (!predicate.test(chars.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static char randomReadable_char() {
        return (char)(33 + XMath.random(94));
    }

    public static int countCharacter(String data, char c) {
        return XChars.countCodePoint(data, c);
    }

    public static int countCodePoint(String data, int codePoint) {
        CodePointCounter counter = new CodePointCounter(codePoint);
        IntStream codePoints = data.codePoints();
        codePoints.forEach(counter);
        return counter.yield();
    }

    public static String mathRangeIncInc(long minimum, long maximum) {
        return XChars.mathRangeIncInc(Long.toString(minimum), Long.toString(maximum));
    }

    public static String mathRangeIncExc(long minimum, long upperBound) {
        return XChars.mathRangeIncExc(Long.toString(minimum), Long.toString(upperBound));
    }

    public static String mathRangeExcInc(long lowerBound, long maximum) {
        return XChars.mathRangeExcInc(Long.toString(lowerBound), Long.toString(maximum));
    }

    public static String mathRangeExcExc(long lowerBound, long upperBound) {
        return XChars.mathRangeExcExc(Long.toString(lowerBound), Long.toString(upperBound));
    }

    public static String mathRangeIncInc(double minimum, double maximum) {
        return XChars.mathRangeIncInc(Double.toString(minimum), Double.toString(maximum));
    }

    public static String mathRangeIncExc(double minimum, double upperBound) {
        return XChars.mathRangeIncExc(Double.toString(minimum), Double.toString(upperBound));
    }

    public static String mathRangeExcInc(double lowerBound, double maximum) {
        return XChars.mathRangeExcInc(Double.toString(lowerBound), Double.toString(maximum));
    }

    public static String mathRangeExcExc(double lowerBound, double upperBound) {
        return XChars.mathRangeExcExc(Double.toString(lowerBound), Double.toString(upperBound));
    }

    public static String mathRangeIncInc(String minimum, String maximum) {
        return "[" + minimum + "; " + maximum + "]";
    }

    public static String mathRangeIncExc(String minimum, String upperBound) {
        return "[" + minimum + "; " + upperBound + "[";
    }

    public static String mathRangeExcInc(String lowerBound, String maximum) {
        return "]" + lowerBound + "; " + maximum + "]";
    }

    public static String mathRangeExcExc(String lowerBound, String upperBound) {
        return "]" + lowerBound + "; " + upperBound + "[";
    }

    private XChars() {
        throw new UnsupportedOperationException();
    }

    static final class CodePointCounter
    implements IntConsumer {
        int codePoint;
        int count;

        CodePointCounter(int codePoint) {
            this.codePoint = codePoint;
        }

        @Override
        public void accept(int value) {
            if (value == this.codePoint) {
                ++this.count;
            }
        }

        public final int yield() {
            return this.count;
        }
    }
}

