/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.branching.ThrowBreak;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.AbstractSimpleArrayCollection;
import one.microstream.collections.CachedSampleEquality;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.HashEnum;
import one.microstream.collections.IndexExceededException;
import one.microstream.collections.XArrays;
import one.microstream.collections.XSort;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XMap;
import one.microstream.equality.Equalator;
import one.microstream.functional.AggregateMax;
import one.microstream.functional.AggregateMin;
import one.microstream.functional.Aggregator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.functional.IsCustomEqual;
import one.microstream.functional.IsGreater;
import one.microstream.functional.IsNull;
import one.microstream.functional.IsSame;
import one.microstream.functional.IsSmaller;
import one.microstream.functional.XFunc;
import one.microstream.hashing.HashEqualator;
import one.microstream.math.FastRandom;
import one.microstream.math.XMath;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;

public abstract class AbstractArrayStorage {
    public static final void validateRange0toUpperBound(int upperBound, int offset, int length) {
        if (offset < 0 || offset >= upperBound) {
            throw new IndexExceededException(upperBound, offset);
        }
        if (length > 0 && offset + length > upperBound) {
            throw new IndexExceededException(upperBound, (long)offset + (long)length);
        }
        if (length < 0 && offset + length < -1) {
            throw new IndexExceededException(-1L, (long)offset + (long)length);
        }
    }

    private static final void clearRest(Object[] data, int offset) {
        int i = offset;
        while (i < data.length) {
            data[i] = null;
            ++i;
        }
    }

    public static final <E> int rangedIndexOF(E[] data, int size, int offset, int length, E element) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardIndexOf(data, offset, offset + length, element) : AbstractArrayStorage.reverseIndexOf(data, offset, offset + length + 1, element);
    }

    public static final <E> int forwardIndexOf(E[] data, int lowOffset, int highBound, E element) {
        int i = lowOffset;
        while (i < highBound) {
            if (data[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final <E> int reverseIndexOf(E[] data, int highOffset, int lowEnd, E element) {
        int i = highOffset;
        while (i >= lowEnd) {
            if (data[i] == element) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static final <E> int rangedConditionalIndexOf(E[] data, int size, int offset, int length, Predicate<? super E> predicate) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardConditionalIndexOf(data, offset, offset + length, predicate) : AbstractArrayStorage.reverseConditionalIndexOf(data, offset, offset + length + 1, predicate);
    }

    public static final <E> int forwardConditionalIndexOf(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate) {
        try {
            int i = lowOffset;
            while (i < highBound) {
                if (predicate.test(data[i])) {
                    return i;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    public static final <E> int reverseConditionalIndexOf(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate) {
        try {
            int i = highOffset;
            while (i >= lowEnd) {
                if (predicate.test(data[i])) {
                    return i;
                }
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    public static final <E> int rangedScan(E[] data, int size, int offset, int length, Predicate<? super E> predicate) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardScan(data, offset, offset + length, predicate) : AbstractArrayStorage.reverseScan(data, offset, offset + length + 1, predicate);
    }

    public static final <E> int forwardScan(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate) {
        int index = -1;
        try {
            int i = lowOffset;
            while (i < highBound) {
                if (predicate.test(data[i])) {
                    index = i;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return index;
    }

    public static final <E> int reverseScan(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate) {
        int index = -1;
        try {
            int i = highOffset;
            while (i >= lowEnd) {
                if (predicate.test(data[i])) {
                    index = i;
                }
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return index;
    }

    public static final <E> boolean rangedContains(E[] data, int size, int offset, int length, Predicate<? super E> predicate) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardContains(data, offset, offset + length, predicate) : AbstractArrayStorage.reverseContains(data, offset, offset + length + 1, predicate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <E> boolean forwardContains(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate) {
        try {
            int i = lowOffset;
            while (true) {
                if (i >= highBound) {
                    return false;
                }
                if (predicate.test(data[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <E> boolean reverseContains(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate) {
        try {
            int i = highOffset;
            while (true) {
                if (i < lowEnd) {
                    return false;
                }
                if (predicate.test(data[i])) {
                    return true;
                }
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return false;
    }

    public static final <E> boolean rangedApplies(E[] data, int size, int offset, int length, Predicate<? super E> predicate) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardApplies(data, offset, offset + length, predicate) : AbstractArrayStorage.reverseApplies(data, offset, offset + length + 1, predicate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <E> boolean forwardApplies(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate) {
        if (lowOffset == highBound) {
            return false;
        }
        try {
            int i = lowOffset;
            while (true) {
                if (i >= highBound) {
                    return true;
                }
                if (!predicate.test(data[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <E> boolean reverseApplies(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate) {
        if (highOffset == lowEnd) {
            return false;
        }
        try {
            int i = highOffset;
            while (true) {
                if (i < lowEnd) {
                    return true;
                }
                if (!predicate.test(data[i])) {
                    return false;
                }
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return true;
    }

    public static final <E> int rangedConditionalCount(E[] data, int size, int offset, int length, Predicate<? super E> predicate) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardConditionalCount(data, offset, offset + length, predicate) : AbstractArrayStorage.reverseConditionalCount(data, offset, offset + length + 1, predicate);
    }

    public static final <E> int forwardConditionalCount(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate) {
        int count = 0;
        try {
            int i = lowOffset;
            while (i < highBound) {
                if (predicate.test(data[i])) {
                    ++count;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return count;
    }

    public static final <E> int reverseConditionalCount(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate) {
        int count = 0;
        try {
            int i = highOffset;
            while (i >= lowEnd) {
                if (predicate.test(data[i])) {
                    ++count;
                }
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return count;
    }

    public static final <E> E rangedSearchElement(E[] data, int size, int offset, int length, Predicate<? super E> predicate, E notFoundMarker) {
        return length >= 0 ? AbstractArrayStorage.forwardSearchElement(data, offset, offset + length, predicate, notFoundMarker) : AbstractArrayStorage.reverseSearchElement(data, offset, offset + length + 1, predicate, notFoundMarker);
    }

    public static final <E> E forwardSearchElement(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate, E notFoundMarker) {
        try {
            int i = lowOffset;
            while (i < highBound) {
                if (predicate.test(data[i])) {
                    return data[i];
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return notFoundMarker;
    }

    public static final <E> E reverseSearchElement(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate, E notFoundMarker) {
        try {
            int i = highOffset;
            while (i >= lowEnd) {
                if (predicate.test(data[i])) {
                    return data[i];
                }
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return notFoundMarker;
    }

    public static final <E> E rangedQueryElement(E[] data, int size, int offset, int length, Predicate<? super E> predicate, E notFoundMarker) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardQueryElement(data, offset, offset + length, predicate, notFoundMarker) : AbstractArrayStorage.reverseQueryElement(data, offset, offset + length + 1, predicate, notFoundMarker);
    }

    public static final <E> E forwardQueryElement(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate, E notFoundMarker) {
        E match = notFoundMarker;
        try {
            int i = lowOffset;
            while (i < highBound) {
                if (predicate.test(data[i])) {
                    match = data[i];
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return match;
    }

    public static final <E> E reverseQueryElement(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate, E notFoundMarker) {
        E match = notFoundMarker;
        try {
            int i = highOffset;
            while (i >= lowEnd) {
                if (predicate.test(data[i])) {
                    match = data[i];
                }
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return match;
    }

    public static final <E> void iterate(E[] data, int size, Consumer<? super E> iterator) {
        try {
            int i = 0;
            while (i < size) {
                iterator.accept(data[i]);
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final <E, A> void join(E[] data, int size, BiConsumer<? super E, ? super A> joiner, A aggregate) {
        try {
            int i = 0;
            while (i < size) {
                joiner.accept(data[i], aggregate);
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final <E> void rangedIterate(E[] data, int size, int offset, int length, Consumer<? super E> procedure) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        if (length >= 0) {
            AbstractArrayStorage.forwardIterate(data, offset, offset + length, procedure);
        } else {
            AbstractArrayStorage.reverseIterate(data, offset, offset + length + 1, procedure);
        }
    }

    public static final <E, A> void rangedJoin(E[] data, int size, int offset, int length, BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        if (length >= 0) {
            AbstractArrayStorage.forwardJoin(data, offset, offset + length, joiner, aggregate);
        } else {
            AbstractArrayStorage.reverseJoin(data, offset, offset + length + 1, joiner, aggregate);
        }
    }

    public static final <E> void forwardIterate(E[] data, int lowOffset, int highBound, Consumer<? super E> procedure) {
        try {
            int i = lowOffset;
            while (i < highBound) {
                procedure.accept(data[i]);
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final <E> void reverseIterate(E[] data, int highOffset, int lowEnd, Consumer<? super E> procedure) {
        try {
            int i = highOffset;
            while (i >= lowEnd) {
                procedure.accept(data[i]);
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final <E, A> void forwardJoin(E[] data, int lowOffset, int highBound, BiConsumer<? super E, ? super A> joiner, A aggregate) {
        try {
            int i = lowOffset;
            while (i < highBound) {
                joiner.accept(data[i], aggregate);
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final <E, A> void reverseJoin(E[] data, int highOffset, int lowEnd, BiConsumer<? super E, ? super A> joiner, A aggregate) {
        try {
            int i = highOffset;
            while (i >= lowEnd) {
                joiner.accept(data[i], aggregate);
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final <E> void rangedConditionalIterate(E[] data, int size, int offset, int length, Predicate<? super E> predicate, Consumer<? super E> procedure) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        if (length >= 0) {
            AbstractArrayStorage.forwardConditionalIterate(data, offset, offset + length, predicate, procedure);
        } else {
            AbstractArrayStorage.reverseConditionalIterate(data, offset, offset + length + 1, predicate, procedure);
        }
    }

    public static final <E> void forwardConditionalIterate(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate, Consumer<? super E> procedure) {
        AbstractArrayStorage.forwardIterate(data, lowOffset, highBound, XFunc.wrapWithPredicate(procedure, predicate));
    }

    public static final <E> void reverseConditionalIterate(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate, Consumer<? super E> procedure) {
        AbstractArrayStorage.reverseIterate(data, highOffset, lowEnd, XFunc.wrapWithPredicate(procedure, predicate));
    }

    public static final <E, R> R rangedAggregate(E[] data, int size, int offset, int length, Aggregator<? super E, R> aggregator) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardAggregate(data, offset, offset + length, aggregator) : AbstractArrayStorage.reverseAggregate(data, offset, offset + length + 1, aggregator);
    }

    public static final <E, R> R forwardAggregate(E[] data, int lowOffset, int highBound, Aggregator<? super E, R> aggregator) {
        AbstractArrayStorage.forwardIterate(data, lowOffset, highBound, aggregator);
        return aggregator.yield();
    }

    public static final <E, R> R reverseAggregate(E[] data, int highOffset, int lowEnd, Aggregator<? super E, R> aggregator) {
        AbstractArrayStorage.reverseIterate(data, highOffset, lowEnd, aggregator);
        return aggregator.yield();
    }

    public static final <E, R> R rangedConditionalAggregate(E[] data, int size, int offset, int length, Predicate<? super E> predicate, Aggregator<? super E, R> aggregator) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardConditionalAggregate(data, offset, offset + length, predicate, aggregator) : AbstractArrayStorage.reverseConditionalAggregate(data, offset, offset + length + 1, predicate, aggregator);
    }

    public static final <E, R> R forwardConditionalAggregate(E[] data, int lowOffset, int highBound, Predicate<? super E> predicate, Aggregator<? super E, R> aggregator) {
        AbstractArrayStorage.forwardConditionalIterate(data, lowOffset, highBound, predicate, aggregator);
        return aggregator.yield();
    }

    public static final <E, R> R reverseConditionalAggregate(E[] data, int highOffset, int lowEnd, Predicate<? super E> predicate, Aggregator<? super E, R> aggregator) {
        AbstractArrayStorage.reverseConditionalIterate(data, highOffset, lowEnd, predicate, aggregator);
        return aggregator.yield();
    }

    public static final <E> int addAll(E[] data, int size, E[] src, int srcIndex, int srcLength, Predicate<? super E> predicate) {
        AbstractArrayStorage.validateRange0toUpperBound(src.length, srcIndex, srcLength);
        try {
            return srcLength >= 0 ? AbstractArrayStorage.forwardAddAll(data, size, src, srcIndex, srcLength, predicate) : AbstractArrayStorage.reverseAddAll(data, size, src, srcIndex, srcLength, predicate);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            AbstractArrayStorage.clearRest(data, size);
            throw e;
        }
    }

    private static final <E> int forwardAddAll(E[] data, int size, E[] src, int srcIndex, int srcLength, Predicate<? super E> predicate) {
        int s = size;
        try {
            int srcBound = srcIndex + srcLength;
            int i = srcIndex;
            while (i < srcBound) {
                if (predicate.test(src[i])) {
                    data[s++] = src[i];
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return s;
    }

    private static final <E> int reverseAddAll(E[] data, int size, E[] src, int srcIndex, int srcLength, Predicate<? super E> predicate) {
        int s = size;
        try {
            int srcBound = srcIndex + srcLength;
            int i = srcIndex;
            while (i > srcBound) {
                if (predicate.test(src[i])) {
                    data[s++] = src[i];
                }
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return s;
    }

    public static final <E> boolean rangedContainsNull(E[] data, int size, int offset, int length) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardNullContained(data, offset, offset + length) : AbstractArrayStorage.reverseNullContained(data, offset, offset + length + 1);
    }

    public static final <E> boolean forwardNullContained(E[] data, int lowOffset, int highBound) {
        return AbstractArrayStorage.forwardContains(data, lowOffset, highBound, new IsNull());
    }

    public static final <E> boolean reverseNullContained(E[] data, int highOffset, int lowEnd) {
        return AbstractArrayStorage.reverseContains(data, highOffset, lowEnd, new IsNull());
    }

    public static final <E> boolean rangedContainsSame(E[] data, int size, int offset, int length, E element) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardContainsSame(data, offset, offset + length, element) : AbstractArrayStorage.reverseContainsSame(data, offset, offset + length + 1, element);
    }

    public static final <E> boolean forwardContainsSame(E[] data, int lowOffset, int highBound, E element) {
        return AbstractArrayStorage.forwardContains(data, lowOffset, highBound, new IsSame<E>(element));
    }

    public static final <E> boolean reverseContainsSame(E[] data, int lowOffset, int highBound, E element) {
        return AbstractArrayStorage.reverseContains(data, lowOffset, highBound, new IsSame<E>(element));
    }

    public static final <E> boolean containsAll(E[] data, int size, XGettingCollection<? extends E> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return XArrays.uncheckedContainsAll(data, 0, size, AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        return elements.applies(e -> AbstractArrayStorage.forwardContainsSame(data, 0, size, e));
    }

    public static final <E> boolean rangedContainsAll(E[] data, int size, int offset, int length, XGettingCollection<? extends E> elements) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        if (elements instanceof AbstractSimpleArrayCollection) {
            return XArrays.uncheckedContainsAll(data, length >= 0 ? offset : offset + length + 1, length >= 0 ? offset + length : offset + 1, AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        if (length < 0) {
            return elements.applies(e -> AbstractArrayStorage.reverseContainsSame(data, offset, offset + length + 1, e));
        }
        return elements.applies(e -> AbstractArrayStorage.forwardContainsSame(data, offset, offset + length, e));
    }

    public static final <E> boolean containsAll(E[] data, int size, XGettingCollection<? extends E> elements, Equalator<? super E> equalator) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return XArrays.uncheckedContainsAll(data, 0, size, AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()), equalator);
        }
        return elements.applies(e -> AbstractArrayStorage.forwardContains(data, 0, size, new IsCustomEqual<Object>(equalator, e)));
    }

    public static final <E> int rangedCount(E[] data, int size, int offset, int length, E element) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardCount(data, offset, offset + length, element) : AbstractArrayStorage.reverseCount(data, offset, offset + length + 1, element);
    }

    public static final <E> int forwardCount(E[] data, int lowOffset, int highBound, E element) {
        return AbstractArrayStorage.forwardConditionalCount(data, lowOffset, highBound, new IsSame<E>(element));
    }

    public static final <E> int reverseCount(E[] data, int highOffset, int lowEnd, E element) {
        return AbstractArrayStorage.reverseConditionalCount(data, highOffset, lowEnd, new IsSame<E>(element));
    }

    public static final <E> E max(E[] data, int size, Comparator<? super E> comparator) {
        return (E)AbstractArrayStorage.forwardAggregate(data, 0, size, new AggregateMax<E>(comparator));
    }

    public static final <E> E min(E[] data, int size, Comparator<? super E> comparator) {
        return (E)AbstractArrayStorage.forwardAggregate(data, 0, size, new AggregateMin<E>(comparator));
    }

    public static final <E> int lastIndexOf(E[] data, int size, Predicate<? super E> predicate) {
        return AbstractArrayStorage.reverseConditionalIndexOf(data, size - 1, 0, predicate);
    }

    public static final <E> int maxIndex(E[] data, int size, Comparator<? super E> comparator) {
        return AbstractArrayStorage.forwardScan(data, 0, size, new IsGreater<E>(comparator));
    }

    public static final <E> int minIndex(E[] data, int size, Comparator<? super E> comparator) {
        return AbstractArrayStorage.forwardScan(data, 0, size, new IsSmaller<E>(comparator));
    }

    public static final <E, C extends Consumer<? super E>> C rangedCopyTo(E[] data, int size, int offset, int length, C target) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardCopyTo(data, offset, offset + length, target) : AbstractArrayStorage.reverseCopyTo(data, offset, offset + length + 1, target);
    }

    public static final <E, C extends Consumer<? super E>> C forwardCopyTo(E[] data, int lowOffset, int highBound, C target) {
        AbstractArrayStorage.forwardIterate(data, lowOffset, highBound, target);
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C reverseCopyTo(E[] data, int highOffset, int lowEnd, C target) {
        AbstractArrayStorage.reverseIterate(data, highOffset, lowEnd, target);
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C rangedCopyTo(E[] data, int size, int offset, int length, C target, Predicate<? super E> predicate) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.forwardCopyTo(data, offset, offset + length, target, predicate) : AbstractArrayStorage.reverseCopyTo(data, offset, offset + length + 1, target, predicate);
    }

    public static final <E, C extends Consumer<? super E>> C forwardCopyTo(E[] data, int lowOffset, int highBound, C target, Predicate<? super E> predicate) {
        AbstractArrayStorage.forwardIterate(data, lowOffset, highBound, XFunc.wrapWithPredicate(target, predicate));
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C reverseCopyTo(E[] data, int highOffset, int lowEnd, C target, Predicate<? super E> predicate) {
        AbstractArrayStorage.reverseIterate(data, highOffset, lowEnd, XFunc.wrapWithPredicate(target, predicate));
        return target;
    }

    public static final <E, T> T[] rangedCopyTo(E[] data, int size, int offset, int length, T[] target, int targetOffset) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        AbstractArrayStorage.validateRange0toUpperBound(target.length, targetOffset, length);
        if (length >= 0) {
            if (length != 0) {
                System.arraycopy(data, offset, target, offset, length);
            }
            return target;
        }
        int lowEnd = offset + length + 1;
        int i = offset;
        int t = targetOffset;
        while (i >= lowEnd) {
            target[t] = data[i];
            --i;
            ++t;
        }
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C copySelection(E[] data, int size, long[] indices, C target) {
        int length = indices.length;
        int i = 0;
        while (i < length) {
            if (indices[i] < 0L || indices[i] >= (long)size) {
                throw new IndexExceededException(size, indices[i]);
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            target.accept(data[(int)indices[i]]);
            ++i;
        }
        return target;
    }

    public static final <E> int binarySearch(E[] data, int size, E element, Comparator<? super E> comparator) {
        return AbstractArrayStorage.internalBinarySearch(data, 0, size - 1, element, comparator);
    }

    public static final <E> int rangedBinarySearch(E[] data, int size, int offset, int length, E element, Comparator<? super E> comparator) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        return length >= 0 ? AbstractArrayStorage.internalBinarySearch(data, offset, offset + length - 1, element, comparator) : AbstractArrayStorage.internalBinarySearch(data, offset + length - 1, offset, element, comparator);
    }

    static final <E> int internalBinarySearch(E[] data, int low, int high, E element, Comparator<? super E> comparator) {
        try {
            while (low <= high) {
                int mid = low + high >>> 1;
                int order = comparator.compare(data[mid], element);
                if (order < 0) {
                    low = mid + 1;
                    continue;
                }
                if (order > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -(low + 1);
    }

    public static final <E, C extends Consumer<? super E>> C intersect(E[] data, int size, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int arrayLength = XTypes.to_int(samples.size());
            int di = 0;
            while (di < size) {
                E element = data[di];
                int i = 0;
                while (i < arrayLength) {
                    if (equalator.equal(element, array[i])) {
                        target.accept(element);
                        break;
                    }
                    ++i;
                }
                ++di;
            }
            return target;
        }
        CachedSampleEquality<? super E> equalCurrentElement = new CachedSampleEquality<E>(equalator);
        int di = 0;
        while (di < size) {
            equalCurrentElement.sample = data[di];
            if (samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            ++di;
        }
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C except(E[] data, int size, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int arrayLength = XTypes.to_int(samples.size());
            int di = 0;
            while (di < size) {
                block6: {
                    E element = data[di];
                    int i = 0;
                    while (i < arrayLength) {
                        if (!equalator.equal(element, array[i])) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    target.accept(element);
                }
                ++di;
            }
            return target;
        }
        CachedSampleEquality<? super E> equalCurrentElement = new CachedSampleEquality<E>(equalator);
        int di = 0;
        while (di < size) {
            equalCurrentElement.sample = data[di];
            if (!samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            ++di;
        }
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C union(E[] data, int size, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        AbstractArrayStorage.forwardCopyTo(data, 0, size, target);
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int arrayLength = XTypes.to_int(samples.size());
            int i = 0;
            while (i < size) {
                block4: {
                    Object sample = array[i];
                    int di = 0;
                    while (di < arrayLength) {
                        if (!equalator.equal(data[di], sample)) {
                            ++di;
                            continue;
                        }
                        break block4;
                    }
                    target.accept(sample);
                }
                ++i;
            }
            return target;
        }
        samples.iterate(e -> {
            Object[] data2 = data;
            int size2 = size;
            Equalator equalator2 = equalator;
            int di = 0;
            while (di < size2) {
                if (equalator2.equal(e, data2[di])) {
                    return;
                }
                ++di;
            }
            target.accept(e);
        });
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C rangedIntersect(E[] data, int size, int offset, int length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return target;
        }
        int bound = offset + length;
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int arrayLength = XTypes.to_int(samples.size());
            int di = offset;
            while (di != bound) {
                E element = data[di];
                int i = 0;
                while (i < arrayLength) {
                    if (equalator.equal(element, array[i])) {
                        target.accept(element);
                        break;
                    }
                    ++i;
                }
                di += d;
            }
            return target;
        }
        CachedSampleEquality<? super E> equalCurrentElement = new CachedSampleEquality<E>(equalator);
        int di = offset;
        while (di != bound) {
            equalCurrentElement.sample = data[di];
            if (samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            di += d;
        }
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C rangedExcept(E[] data, int size, int offset, int length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return target;
        }
        int bound = offset + length;
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int arrayLength = XTypes.to_int(samples.size());
            int di = offset;
            while (di != bound) {
                block7: {
                    E element = data[di];
                    int i = 0;
                    while (i < arrayLength) {
                        if (!equalator.equal(element, array[i])) {
                            ++i;
                            continue;
                        }
                        break block7;
                    }
                    target.accept(element);
                }
                di += d;
            }
            return target;
        }
        CachedSampleEquality<? super E> equalCurrentElement = new CachedSampleEquality<E>(equalator);
        int di = offset;
        while (di != bound) {
            equalCurrentElement.sample = data[di];
            if (!samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            di += d;
        }
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C rangedUnion(E[] data, int size, int offset, int length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return target;
        }
        int bound = offset + length;
        AbstractArrayStorage.rangedCopyTo(data, size, offset, length, target);
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int arrayLength = XTypes.to_int(samples.size());
            int i = 0;
            while (i < arrayLength) {
                block5: {
                    Object sample = array[i];
                    int di = offset;
                    while (di != bound) {
                        if (!equalator.equal(data[di], sample)) {
                            di += d;
                            continue;
                        }
                        break block5;
                    }
                    target.accept(sample);
                }
                ++i;
            }
            return target;
        }
        samples.iterate(e -> {
            Object[] data2 = data;
            int bound2 = bound;
            Equalator equalator2 = equalator;
            int di = offset;
            while (di != bound2) {
                if (equalator2.equal(e, data2[di])) {
                    return;
                }
                di += d;
            }
            target.accept(e);
        });
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C distinct(E[] data, int size, C target) {
        HashEnum<E> distincts = HashEnum.New();
        int i = 0;
        while (i < size) {
            E element = data[i];
            if (!distincts.containsId(element)) {
                distincts.add(element);
                target.accept(element);
            }
            ++i;
        }
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C rangedDistinct(E[] data, int size, int offset, int length, C target) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return target;
        }
        int endIndex = offset + length - d;
        HashEnum<E> distincts = HashEnum.New();
        int i = offset - d;
        while (i != endIndex) {
            E element = data[i += d];
            if (distincts.containsId(element)) continue;
            distincts.add(element);
            target.accept(element);
        }
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C distinct(E[] data, int size, C target, Equalator<? super E> equalator) {
        Object[] distincts = new Object[size];
        int k = 0;
        int i = 0;
        while (i < size) {
            block3: {
                E element = data[i];
                int j = 0;
                while (j < k) {
                    if (!equalator.equal(distincts[j], element)) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                distincts[k++] = element;
                target.accept(element);
            }
            ++i;
        }
        return target;
    }

    public static final <E, C extends Consumer<? super E>> C rangedDistinct(E[] data, int size, int offset, int length, C target, Equalator<? super E> equalator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return target;
        }
        int endIndex = offset + length - d;
        Object[] distincts = new Object[size];
        int k = 0;
        int i = offset - d;
        block0: while (i != endIndex) {
            E element = data[i += d];
            int j = 0;
            while (j < k) {
                if (equalator.equal(distincts[j], element)) continue block0;
                ++j;
            }
            distincts[k++] = element;
            target.accept(element);
        }
        return target;
    }

    public static final <E> void iterate(E[] data, int size, IndexedAcceptor<? super E> procedure) {
        try {
            int i = 0;
            while (i < size) {
                procedure.accept(data[i], i);
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final <E> void rangedIterate(E[] data, int size, int offset, int length, IndexedAcceptor<? super E> procedure) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return;
        }
        try {
            int endIndex = offset + length - d;
            int i = offset - d;
            while (i != endIndex) {
                procedure.accept(data[i += d], i);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    public static final <E> int rangedRemove(E[] data, int size, int offset, int length, E element) {
        int bound;
        int start;
        if (length >= 0) {
            if (length == 0) {
                return 0;
            }
            start = offset;
            bound = offset + length;
        } else if (length < 0) {
            bound = offset + 1;
            start = offset + length + 1;
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexExceededException(size, offset);
            }
            return 0;
        }
        if (start < 0 || bound > size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        return XArrays.removeAllFromArray(data, start, bound, element);
    }

    public static final <E> int rangedRemove(E[] data, int size, int offset, int length, E sample, Equalator<? super E> equalator) {
        int bound;
        int start;
        if (length >= 0) {
            if (length == 0) {
                return 0;
            }
            start = offset;
            bound = offset + length;
        } else if (length < 0) {
            bound = offset + 1;
            start = offset + length + 1;
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexExceededException(size, offset);
            }
            return 0;
        }
        if (start < 0 || bound > size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        return XArrays.removeAllFromArray(data, start, bound, sample, equalator);
    }

    public static final <E> int rangedRemoveNull(E[] data, int size, int offset, int length) {
        int bound;
        int start;
        if (length >= 0) {
            if (length == 0) {
                return 0;
            }
            start = offset;
            bound = offset + length;
        } else if (length < 0) {
            bound = offset + 1;
            start = offset + length + 1;
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexExceededException(size, offset);
            }
            return 0;
        }
        if (start < 0 || bound > size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        return XArrays.removeAllFromArray(null, data, start, bound);
    }

    public static final <E> int reduce(E[] data, int size, Predicate<? super E> predicate, E removeMarker) {
        int removeCount;
        if (size == 0) {
            return 0;
        }
        int i = 0;
        try {
            while (i < size) {
                if (predicate.test(data[i])) {
                    data[i] = removeMarker;
                }
                ++i;
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, size, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int rangedReduce(E[] data, int size, int offset, int length, Predicate<? super E> predicate, E removeMarker) {
        int removeCount;
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        try {
            while (i != endIndex) {
                if (!predicate.test(data[i += d])) continue;
                data[i] = removeMarker;
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int retainAll(E[] data, int size, XGettingCollection<E> elements, E removeMarker) {
        int removeCount;
        if (XTypes.to_int(elements.size()) == 0) {
            int i = size;
            while (i-- > 0) {
                data[i] = null;
            }
            return size;
        }
        int lastIndex = size - 1;
        int i = -1;
        try {
            try {
                while (i < lastIndex) {
                    if (elements.containsId(data[++i])) continue;
                    data[i] = removeMarker;
                }
            }
            catch (ThrowBreak throwBreak) {
                removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int rangedRetainAll(E[] data, int size, int offset, int length, XGettingCollection<E> elements, E removeMarker) {
        int removeCount;
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        boolean removeNulls = !elements.nullContained();
        int i = offset - d;
        try {
            try {
                while (i != endIndex) {
                    E e = data[i += d];
                    if (e == null) {
                        if (!removeNulls) continue;
                        data[i] = removeMarker;
                        continue;
                    }
                    if (elements.containsId(e)) continue;
                    data[i] = removeMarker;
                }
            }
            catch (ThrowBreak throwBreak) {
                int removeStartIndex;
                if (d < 0) {
                    removeStartIndex = i;
                    i = offset;
                } else {
                    removeStartIndex = offset;
                }
                removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int retainAll(E[] data, int size, XGettingCollection<E> samples, Equalator<? super E> equalator, E removeMarker) {
        int removeCount;
        if (XTypes.to_int(samples.size()) == 0) {
            int i = size;
            while (i-- > 0) {
                data[i] = null;
            }
            return size;
        }
        int lastIndex = size - 1;
        int i = -1;
        try {
            try {
                while (i < lastIndex) {
                    if (samples.containsSearched(XFunc.predicate(data[++i], equalator))) continue;
                    data[i] = removeMarker;
                }
            }
            catch (ThrowBreak throwBreak) {
                removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int rangedRetainAll(E[] data, int size, int offset, int length, XGettingCollection<E> samples, Equalator<? super E> equalator, E removeMarker) {
        int removeCount;
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        try {
            try {
                while (i != endIndex) {
                    if (samples.containsSearched(XFunc.predicate(data[i += d], equalator))) continue;
                    data[i] = removeMarker;
                }
            }
            catch (ThrowBreak throwBreak) {
                int removeStartIndex;
                if (d < 0) {
                    removeStartIndex = i;
                    i = offset;
                } else {
                    removeStartIndex = offset;
                }
                removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int process(E[] data, int size, Consumer<? super E> procedure, E removeMarker) {
        int lastIndex = size - 1;
        int removeCount = 0;
        int i = -1;
        try {
            try {
                while (i != lastIndex) {
                    procedure.accept(data[++i]);
                    data[i] = removeMarker;
                }
            }
            catch (ThrowBreak throwBreak) {
                removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int rangedProcess(E[] data, int size, int offset, int length, Consumer<? super E> procedure, E removeMarker) {
        int removeCount;
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        try {
            try {
                while (i != endIndex) {
                    procedure.accept(data[i += d]);
                    data[i] = removeMarker;
                }
            }
            catch (ThrowBreak throwBreak) {
                int removeStartIndex;
                if (d < 0) {
                    removeStartIndex = i;
                    i = offset;
                } else {
                    removeStartIndex = offset;
                }
                removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int moveTo(E[] data, int size, Consumer<? super E> target, Predicate<? super E> predicate, E removeMarker) {
        int removeCount;
        int lastIndex = size - 1;
        int i = -1;
        try {
            try {
                while (i < lastIndex) {
                    if (!predicate.test(data[++i])) continue;
                    target.accept(data[i]);
                    data[i] = removeMarker;
                }
            }
            catch (ThrowBreak throwBreak) {
                removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, 0, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int rangedMoveTo(E[] data, int size, int offset, int length, Consumer<? super E> target, Predicate<? super E> predicate, E removeMarker) {
        int removeCount;
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        try {
            try {
                while (i != endIndex) {
                    if (!predicate.test(data[i += d])) continue;
                    target.accept(data[i]);
                    data[i] = removeMarker;
                }
            }
            catch (ThrowBreak throwBreak) {
                int removeStartIndex;
                if (d < 0) {
                    removeStartIndex = i;
                    i = offset;
                } else {
                    removeStartIndex = offset;
                }
                removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
            }
        }
        finally {
            int removeStartIndex;
            if (d < 0) {
                removeStartIndex = i;
                i = offset;
            } else {
                removeStartIndex = offset;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int moveSelection(E[] data, int size, long[] indices, Consumer<? super E> target, E removeMarker) {
        int removeCount;
        long min;
        int length = indices.length;
        if (length == 0) {
            return 0;
        }
        long max = min = indices[0];
        int i = 1;
        while (i < length) {
            long idx = indices[i];
            if (idx < min) {
                min = idx;
            } else if (idx > max) {
                max = idx;
            }
            ++i;
        }
        if (min < 0L) {
            throw new IndexExceededException(size, min);
        }
        if (max >= (long)size) {
            throw new IndexExceededException(size, max);
        }
        try {
            try {
                int i2 = 0;
                while (i2 < length) {
                    int j = (int)indices[i2];
                    target.accept(data[j]);
                    data[j] = removeMarker;
                    ++i2;
                }
            }
            catch (ThrowBreak throwBreak) {
                removeCount = XArrays.removeAllFromArray(data, (int)min, (int)(++max), removeMarker);
            }
        }
        finally {
            removeCount = XArrays.removeAllFromArray(data, (int)min, (int)(++max), removeMarker);
        }
        return removeCount;
    }

    public static final <E> int rangedRemoveAll(E[] data, int size, int offset, int length, XGettingCollection<? extends E> elements) {
        int bound;
        int start;
        if (length >= 0) {
            if (length == 0) {
                return 0;
            }
            start = offset;
            bound = offset + length;
        } else if (length < 0) {
            bound = offset + 1;
            start = offset + length + 1;
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexExceededException(size, offset);
            }
            return 0;
        }
        if (start < 0 || bound > size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        return XArrays.removeAllFromArray(elements, data, start, bound);
    }

    public static final <E> int rangedRemoveAll(E[] data, int size, int offset, int length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, E removeMarker) {
        int bound;
        int start;
        if (length >= 0) {
            if (length == 0) {
                return 0;
            }
            start = offset;
            bound = offset + length;
        } else if (length < 0) {
            bound = offset + 1;
            start = offset + length + 1;
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexExceededException(size, offset);
            }
            return 0;
        }
        if (start < 0 || bound > size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        if (XTypes.to_int(samples.size()) == 0) {
            return 0;
        }
        return XArrays.removeAllFromArray(data, start, bound, samples, equalator);
    }

    public static final <E> int removeDuplicates(E[] data, int size, Equalator<? super E> equalator, E removeMarker) {
        return AbstractArrayStorage.rangedRemoveDuplicates(data, size, 0, size, equalator, removeMarker);
    }

    public static final <E> int rangedRemoveDuplicates(E[] data, int size, int offset, int length, Equalator<? super E> equalator, E removeMarker) {
        int removeCount;
        int i;
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int removeStartIndex = i = offset - d;
        try {
            while (i != endIndex) {
                E ei = data[i += d];
                int j = i + d;
                while (j != endIndex) {
                    E ej = data[j += d];
                    if (ej == removeMarker || !equalator.equal(ei, ej)) continue;
                    data[j] = removeMarker;
                }
            }
        }
        finally {
            if (d < 0) {
                int temp = removeStartIndex;
                removeStartIndex = i;
                i = temp;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int removeDuplicates(E[] data, int size, E removeMarker) {
        return AbstractArrayStorage.rangedRemoveDuplicates(data, size, 0, size, removeMarker);
    }

    public static final <E> int rangedRemoveDuplicates(E[] data, int size, int offset, int length, E removeMarker) {
        int removeCount;
        int i;
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int removeStartIndex = i = offset - d;
        try {
            while (i != endIndex) {
                E ei = data[i += d];
                if (ei == removeMarker) continue;
                int j = i;
                while (j != endIndex) {
                    E ej = data[j += d];
                    if (ej == removeMarker || ei != ej) continue;
                    data[j] = removeMarker;
                }
            }
        }
        finally {
            if (d < 0) {
                int temp = removeStartIndex;
                removeStartIndex = i;
                i = temp;
            }
            removeCount = XArrays.removeAllFromArray(data, removeStartIndex, ++i, removeMarker);
        }
        return removeCount;
    }

    public static final <E> int removeSelection(E[] data, int size, long[] indices, E removeMarker) {
        long min;
        int length = indices.length;
        if (length == 0) {
            return 0;
        }
        long max = min = indices[0];
        int i = 1;
        while (i < length) {
            long idx = indices[i];
            if (idx < min) {
                min = idx;
            } else if (idx > max) {
                max = idx;
            }
            ++i;
        }
        if (min < 0L) {
            throw new IndexExceededException(size, min);
        }
        if (max >= (long)size) {
            throw new IndexExceededException(size, max);
        }
        i = 0;
        while (i < length) {
            data[(int)indices[i]] = removeMarker;
            ++i;
        }
        int removeCount = XArrays.removeAllFromArray(data, (int)min, (int)(++max), removeMarker);
        return removeCount;
    }

    public static final <E> int removeRange(E[] data, int size, int offset, int length) {
        int bound;
        int start;
        if (length >= 0) {
            if (length == 0) {
                return 0;
            }
            start = offset;
            bound = offset + length;
        } else if (length < 0) {
            bound = offset + 1;
            start = offset + length + 1;
        } else {
            if (offset < 0 || offset >= size) {
                throw new IndexExceededException(size, offset);
            }
            return 0;
        }
        if (start < 0 || bound > size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        System.arraycopy(data, bound, data, start, size - bound);
        int i = size - length;
        while (i < size) {
            data[i] = null;
            ++i;
        }
        return length;
    }

    public static final <E> int retainRange(E[] data, int size, int offset, int length) {
        if (offset < 0 || offset >= size) {
            throw new IndexExceededException(size, offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (offset + length > size) {
            throw new IndexExceededException(size, offset + length + 1);
        }
        if (offset == 0 && length == size) {
            return 0;
        }
        System.arraycopy(data, offset, data, 0, length);
        int i = length;
        while (i < size) {
            data[i] = null;
            ++i;
        }
        return length;
    }

    public static final <E> E retrieve(E[] data, int size, E element, E notFoundMarker) {
        int i = 0;
        while (i < size) {
            if (data[i] == element) {
                if (i < --size) {
                    System.arraycopy(data, i + 1, data, i, size - i);
                }
                data[size] = null;
                return element;
            }
            ++i;
        }
        return notFoundMarker;
    }

    public static final <E> E retrieve(E[] data, int size, E sample, Equalator<? super E> equalator, E notFoundMarker) {
        int i = 0;
        while (i < size) {
            if (equalator.equal(data[i], sample)) {
                E oldElement = data[i];
                if (i < --size) {
                    System.arraycopy(data, i + 1, data, i, size - i);
                }
                data[size] = null;
                return oldElement;
            }
            ++i;
        }
        return notFoundMarker;
    }

    public static final <E> E retrieve(E[] data, int size, Predicate<? super E> predicate, E notFoundMarker) {
        int i = 0;
        while (i < size) {
            if (predicate.test(data[i])) {
                E oldElement = data[i];
                if (i < --size) {
                    System.arraycopy(data, i + 1, data, i, size - i);
                }
                data[size] = null;
                return oldElement;
            }
            ++i;
        }
        return notFoundMarker;
    }

    public static final <E> boolean removeOne(E[] data, int size, E element) {
        int i = 0;
        while (i < size) {
            if (data[i] == element) {
                if (i < --size) {
                    System.arraycopy(data, i + 1, data, i, size - i);
                }
                data[size] = null;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final <E> boolean removeOne(E[] data, int size, E sample, Equalator<? super E> equalator) {
        int i = 0;
        while (i < size) {
            if (equalator.equal(data[i], sample)) {
                if (i < --size) {
                    System.arraycopy(data, i + 1, data, i, size - i);
                }
                data[size] = null;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final <E> E rangedRetrieve(E[] data, int size, int offset, int length, E element, E notFoundMarker) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return null;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (element != data[i += d]) continue;
            if (i < --size) {
                System.arraycopy(data, i + 1, data, i, size - i);
            }
            data[size] = null;
            return element;
        }
        return notFoundMarker;
    }

    public static final <E> E rangedRetrieve(E[] data, int size, int offset, int length, E sample, Equalator<? super E> equalator, E notFoundMarker) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return null;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (!equalator.equal(data[i += d], sample)) continue;
            E oldElement = data[i];
            if (i < --size) {
                System.arraycopy(data, i + 1, data, i, size - i);
            }
            data[size] = null;
            return oldElement;
        }
        return notFoundMarker;
    }

    public static final <E> E rangedRetrieve(E[] data, int size, int offset, int length, Predicate<? super E> predicate, E notFoundMarker) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return null;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (!predicate.test(data[i += d])) continue;
            E oldElement = data[i];
            if (i < --size) {
                System.arraycopy(data, i + 1, data, i, size - i);
            }
            data[size] = null;
            return oldElement;
        }
        return notFoundMarker;
    }

    public static final <E> boolean rangedRemoveOne(E[] data, int size, int offset, int length, E element) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return false;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (element != data[i += d]) continue;
            if (i < --size) {
                System.arraycopy(data, i + 1, data, i, size - i);
            }
            data[size] = null;
            return true;
        }
        return false;
    }

    public static final <E> boolean rangedRemoveOne(E[] data, int size, int offset, int length, E sample, Equalator<? super E> equalator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return false;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (!equalator.equal(data[i += d], sample)) continue;
            if (i < --size) {
                System.arraycopy(data, i + 1, data, i, size - i);
            }
            data[size] = null;
            return true;
        }
        return false;
    }

    public static final <E> boolean replaceOne(E[] data, int size, E oldElement, E newElement) {
        int i = 0;
        while (i < size) {
            if (data[i] == oldElement) {
                data[i] = newElement;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final <E> int rangedReplaceOne(E[] data, int size, int offset, int length, E oldElement, E newElement) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return -1;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            if (oldElement != data[i += d]) continue;
            data[i] = newElement;
            return i;
        }
        return -1;
    }

    public static final <E> boolean replaceOne(E[] data, int size, E sample, E newElement, Equalator<? super E> equalator) {
        int i = 0;
        while (i < size) {
            if (equalator.equal(data[i], sample)) {
                data[i] = newElement;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final <E> int rangedReplaceOne(E[] data, int size, int offset, int length, E sample, E newElement, Equalator<? super E> equalator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return -1;
        }
        try {
            int endIndex = offset + length - d;
            int i = offset - d;
            while (i != endIndex) {
                if (!equalator.equal(data[i += d], sample)) continue;
                data[i] = newElement;
                return i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <E> boolean substituteOne(E[] data, int size, Predicate<? super E> predicate, E replacement) {
        try {
            int i = 0;
            while (true) {
                if (i >= size) {
                    return false;
                }
                if (predicate.test(data[i])) {
                    data[i] = replacement;
                    return true;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return false;
    }

    public static final <E> int rangedReplaceOne(E[] data, int size, int offset, int length, Predicate<? super E> predicate, E newElement) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return -1;
        }
        try {
            int endIndex = offset + length - d;
            int i = offset - d;
            while (i != endIndex) {
                if (!predicate.test(data[i += d])) continue;
                data[i] = newElement;
                return i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    public static final <E> int replace(E[] data, int size, E oldElement, E newElement) {
        int replaceCount = 0;
        int i = 0;
        while (i < size) {
            if (data[i] == oldElement) {
                data[i] = newElement;
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static final <E> int rangedReplace(E[] data, int size, int offset, int length, E oldElement, E newElement) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (data[i += d] != oldElement) continue;
            data[i] = newElement;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final <E> int replace(E[] data, int size, E sample, E newElement, Equalator<? super E> equalator) {
        int replaceCount = 0;
        try {
            int i = 0;
            while (i < size) {
                if (equalator.equal(data[i], sample)) {
                    data[i] = newElement;
                    ++replaceCount;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    public static final <E> long rangedReplace(E[] data, int size, int offset, int length, E sample, E newElement, Equalator<? super E> equalator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0L;
        }
        int endIndex = offset + length - d;
        long replaceCount = 0L;
        int i = offset - d;
        while (i != endIndex) {
            if (!equalator.equal(data[i += d], sample)) continue;
            data[i] = newElement;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final <E> long substitute(E[] data, int size, Predicate<? super E> predicate, E newElement) {
        long replaceCount = 0L;
        try {
            int i = 0;
            while (i < size) {
                if (predicate.test(data[i])) {
                    data[i] = newElement;
                    ++replaceCount;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    public static final <E> int rangedReplace(E[] data, int size, int offset, int length, Predicate<? super E> predicate, E newElement) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int replaceCount = 0;
        try {
            int endIndex = offset + length - d;
            int i = offset - d;
            while (i != endIndex) {
                if (!predicate.test(data[i += d])) continue;
                data[i] = newElement;
                ++replaceCount;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    public static final <E, U extends E> int replaceAll(E[] data, int size, XGettingCollection<U> oldElements, E newElement, E marker) {
        int replaceCount;
        try {
            oldElements.iterate(e -> {
                Object[] data1 = data;
                int i = 0;
                int len = size;
                while (i < len) {
                    if (data1[i] == e) {
                        data1[i] = marker;
                        break;
                    }
                    ++i;
                }
            });
        }
        finally {
            replaceCount = XArrays.replaceAllInArray(data, 0, size, marker, newElement);
        }
        return replaceCount;
    }

    public static final <E> int rangedReplaceAll(E[] data, int size, int offset, int length, XGettingCollection<E> oldElements, E newElement) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (!oldElements.containsId(data[i += d])) continue;
            data[i] = newElement;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final <E, U extends E> int replaceAll(E[] data, int size, XGettingCollection<U> samples, E newElement, Equalator<? super E> equalator, E marker) {
        int replaceCount;
        try {
            samples.iterate(e -> {
                Object[] data1 = data;
                int i = 0;
                int len = size;
                while (i < len) {
                    if (equalator.equal((Object)data1[i], (Object)e)) {
                        data1[i] = marker;
                        break;
                    }
                    ++i;
                }
            });
        }
        finally {
            replaceCount = XArrays.replaceAllInArray(data, 0, size, marker, newElement);
        }
        return replaceCount;
    }

    public static final <E> int rangedReplaceAll(E[] data, int size, int offset, int length, XGettingCollection<E> samples, E newElement, Equalator<? super E> equalator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (!samples.containsSearched(XFunc.predicate(data[i += d], equalator))) continue;
            data[i] = newElement;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final <E> int replaceAll(E[] data, int size, XMap<E, E> replacementMapping) {
        int replaceCount = 0;
        int i = 0;
        while (i < size) {
            E replacement = replacementMapping.get(data[i]);
            if (replacement != null) {
                data[i] = replacement;
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static final <E> long substitute(E[] data, int size, Function<? super E, ? extends E> mapper) {
        long replaceCount = 0L;
        int i = 0;
        while (i < size) {
            data[i] = mapper.apply(data[i]);
            if (data[i] != data[i]) {
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static final <E> long substitute(E[] data, int size, Predicate<? super E> predicate, Function<E, E> mapper) {
        long replaceCount = 0L;
        try {
            int i = 0;
            while (i < size) {
                if (predicate.test(data[i])) {
                    data[i] = mapper.apply(data[i]);
                    ++replaceCount;
                }
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    public static final <E> int rangedReplaceAll(E[] data, int size, int offset, int length, XMap<E, E> replacementMapping) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            E replacement = replacementMapping.get(data[i += d]);
            if (replacement == null) continue;
            data[i] = replacement;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final <E> int rangedModify(E[] data, int size, int offset, int length, Function<E, E> mapper) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return 0;
        }
        int endIndex = offset + length - d;
        int replaceCount = 0;
        int i = offset - d;
        while (i != endIndex) {
            if (data[i += d] == (data[i] = mapper.apply(data[i]))) continue;
            ++replaceCount;
        }
        return replaceCount;
    }

    public static final <E> void swap(E[] data, int size, int indexA, int indexB) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (indexA >= size) {
            throw new IndexExceededException(size, indexA);
        }
        if (indexB >= size) {
            throw new IndexExceededException(size, indexB);
        }
        E t = data[indexA];
        data[indexA] = data[indexB];
        data[indexB] = t;
    }

    /*
     * Unable to fully structure code
     */
    public static final <E> void swap(E[] data, int size, int indexA, int indexB, int length) {
        if (length == 0 || indexA == indexB) {
            return;
        }
        if (indexA > indexB) {
            t = indexA;
            indexA = indexB;
            indexB = t;
        }
        if (indexA >= 0 && length >= 0 && (bound = indexA + length) < indexB && indexB + length < size) ** GOTO lbl12
        throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionIllegalSwapBounds(size, indexA, indexB, length));
lbl-1000:
        // 1 sources

        {
            t = data[indexA];
            data[indexA++] = data[indexB];
            data[indexB++] = t;
lbl12:
            // 2 sources

            ** while (indexA < bound)
        }
lbl13:
        // 1 sources

    }

    public static final <E> void reverse(E[] data, int size) {
        int halfSize = size >> 1;
        int i = 0;
        int j = size - 1;
        while (i < halfSize) {
            E element = data[i];
            data[i] = data[j];
            data[j] = element;
            ++i;
            --j;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final <E> void rangedReverse(E[] data, int size, int offset, int length) {
        block6: {
            block5: {
                if (length < 0) break block5;
                low = offset;
                if (low < 0 || (high = offset + length - 1) >= size) {
                    throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
                }
                if (length == 0) {
                    return;
                }
                ** GOTO lbl21
            }
            if (length >= 0) break block6;
            low = offset + length + 1;
            if (low < 0 || (high = offset) >= size) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
            }
            ** GOTO lbl21
        }
        if (offset < 0 || offset >= size) {
            throw new IndexExceededException(size, offset);
        }
        return;
lbl-1000:
        // 1 sources

        {
            element = data[low];
            data[low++] = data[high];
            data[high--] = element;
lbl21:
            // 3 sources

            ** while (low < high)
        }
lbl22:
        // 1 sources

    }

    public static final <E> void set(E[] data, int size, int offset, E[] elements) {
        if (offset < 0 || offset + elements.length > size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, offset + elements.length - 1));
        }
        System.arraycopy(elements, 0, data, offset, elements.length);
    }

    public static final <E> void set(E[] data, int size, int offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        if (offset < 0 || (long)offset + elements.size() > (long)size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, (long)offset + elements.size() - 1L));
        }
        throw new NotImplementedYetError();
    }

    public static final <E> void set(E[] data, int size, int offset, E[] src, int srcIndex, int srcLength) {
        if (srcLength < 0) {
            if (offset < 0 || offset - srcLength > size) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, offset - srcLength + 1));
            }
            if (srcIndex >= src.length) {
                throw new ArrayIndexOutOfBoundsException(srcIndex);
            }
            int bound = offset + srcLength;
            if (bound < -1) {
                throw new ArrayIndexOutOfBoundsException(bound + 1);
            }
            int s = srcIndex;
            int i = offset;
            while (s > bound) {
                data[i++] = src[s];
                --s;
            }
            return;
        }
        if (offset < 0 || offset + srcLength > size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, offset + src.length - 1));
        }
        System.arraycopy(src, srcIndex, data, offset, srcLength);
    }

    public static final <E> void fill(E[] data, int size, int offset, int length, E element) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        if (length >= 0) {
            int bound = offset + length;
            int i = offset;
            while (i < bound) {
                data[i] = element;
                ++i;
            }
        } else {
            int lastIndex = offset + length + 1;
            int i = offset;
            while (i >= lastIndex) {
                data[i] = element;
                --i;
            }
        }
    }

    public static final String toString(Object[] data, int size) {
        if (size == 0) {
            return "[]";
        }
        VarString vc = VarString.New((int)((float)size * 2.0f)).append('[');
        int i = 0;
        while (i < size) {
            vc.add(data[i]).add(',', ' ');
            ++i;
        }
        vc.deleteLast().setLast(']');
        return vc.toString();
    }

    public static final <E> VarString appendTo(E[] data, int size, VarString vc) {
        int i = 0;
        while (i < size) {
            vc.add(data[i]);
            ++i;
        }
        return vc;
    }

    public static final <E> VarString appendTo(E[] data, int size, VarString vc, char separator) {
        if (size == 0) {
            return vc;
        }
        int i = 0;
        while (i < size) {
            vc.add(data[i]).append(separator);
            ++i;
        }
        vc.deleteLast();
        return vc;
    }

    public static final <E> VarString appendTo(E[] data, int size, VarString vc, String separator) {
        if (size == 0) {
            return vc;
        }
        if (separator == null || separator.isEmpty()) {
            int i = 0;
            while (i < size) {
                vc.add(data[i]);
                ++i;
            }
        } else {
            char[] sepp = XChars.readChars(separator);
            int i = 0;
            while (i < size) {
                vc.add(data[i]).add(sepp);
                ++i;
            }
            vc.deleteLast(sepp.length);
        }
        return vc;
    }

    public static final <E> VarString appendTo(E[] data, int size, VarString vc, BiConsumer<VarString, ? super E> appender) {
        if (size == 0) {
            return vc;
        }
        int i = 0;
        while (i < size) {
            appender.accept(vc, data[i]);
            ++i;
        }
        return vc;
    }

    public static final <E> VarString appendTo(E[] data, int size, VarString vc, BiConsumer<VarString, ? super E> appender, char separator) {
        if (size == 0) {
            return vc;
        }
        int i = 0;
        while (i < size) {
            appender.accept(vc, data[i]);
            vc.append(separator);
            ++i;
        }
        vc.deleteLast();
        return vc;
    }

    public static final <E> VarString appendTo(E[] data, int size, VarString vc, BiConsumer<VarString, ? super E> appender, String separator) {
        if (size == 0) {
            return vc;
        }
        if (separator == null || separator.isEmpty()) {
            int i = 0;
            while (i < size) {
                appender.accept(vc, data[i]);
                ++i;
            }
        } else {
            char[] sepp = XChars.readChars(separator);
            int i = 0;
            while (i < size) {
                appender.accept(vc, data[i]);
                vc.add(sepp);
                ++i;
            }
            vc.deleteLast(sepp.length);
        }
        return vc;
    }

    public static final <E> VarString rangedAppendTo(E[] data, int size, int offset, int length, VarString vc) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            vc.add(data[i += d]);
        }
        return vc;
    }

    public static final <E> VarString rangedAppendTo(E[] data, int size, int offset, int length, VarString vc, char separator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            vc.add(data[i += d]).append(separator);
        }
        vc.deleteLast();
        return vc;
    }

    public static final <E> VarString rangedAppendTo(E[] data, int size, int offset, int length, VarString vc, String separator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        if (separator == null || separator.isEmpty()) {
            int i = offset - d;
            while (i != endIndex) {
                vc.add(data[i += d]);
            }
        } else {
            char[] sepp = XChars.readChars(separator);
            int i = offset - d;
            while (i != endIndex) {
                vc.add(data[i += d]).add(sepp);
            }
            vc.deleteLast(sepp.length);
        }
        return vc;
    }

    public static final <E> VarString rangedAppendTo(E[] data, int size, int offset, int length, VarString vc, BiConsumer<VarString, ? super E> appender) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            appender.accept(vc, data[i += d]);
        }
        return vc;
    }

    public static final <E> VarString rangedAppendTo(E[] data, int size, int offset, int length, VarString vc, BiConsumer<VarString, ? super E> appender, char separator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            appender.accept(vc, data[i += d]);
            vc.append(separator);
        }
        vc.deleteLast();
        return vc;
    }

    public static final <E> VarString rangedAppendTo(E[] data, int size, int offset, int length, VarString vc, BiConsumer<VarString, ? super E> appender, String separator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return vc;
        }
        int endIndex = offset + length - d;
        if (separator == null || separator.isEmpty()) {
            int i = offset - d;
            while (i != endIndex) {
                appender.accept(vc, data[i += d]);
            }
        } else {
            char[] sepp = XChars.readChars(separator);
            int i = offset - d;
            while (i != endIndex) {
                appender.accept(vc, data[i += d]);
                vc.add(sepp);
            }
            vc.deleteLast(sepp.length);
        }
        return vc;
    }

    public static final <E> boolean isSorted(E[] data, int size, Comparator<? super E> comparator) {
        if (size <= 1) {
            return true;
        }
        E loopLastElement = data[0];
        int i = 1;
        while (i < size) {
            E element = data[i];
            if (comparator.compare(loopLastElement, element) > 0) {
                return false;
            }
            loopLastElement = element;
            ++i;
        }
        return true;
    }

    public static final <E> boolean rangedIsSorted(E[] data, int size, int offset, int length, Comparator<? super E> comparator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return true;
        }
        int endIndex = offset + length - d;
        E loopLastElement = data[offset];
        int i = offset - d;
        while (i != endIndex) {
            E element = data[i += d];
            if (comparator.compare(loopLastElement, element) > 0) {
                return false;
            }
            loopLastElement = element;
        }
        return true;
    }

    public static final <E> void sortInsertion(E[] data, int size, Comparator<? super E> comparator) {
        int i = 0;
        while (i < size) {
            int j = i;
            while (j != 0 && comparator.compare(data[j - 1], data[j]) > 0) {
                E t = data[j];
                data[j] = data[j - 1];
                data[j - 1] = t;
                --j;
            }
            ++i;
        }
    }

    public static final <E> void rangedSortInsertion(E[] data, int size, int offset, int length, Comparator<? super E> comparator) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        if (length >= 0) {
            AbstractArrayStorage.internalSortInsertion(data, offset, offset + length, comparator);
        } else {
            AbstractArrayStorage.internalSortInsertion(data, offset + length + 1, offset + 1, comparator);
        }
    }

    static final <E> void internalSortInsertion(E[] data, int low, int bound, Comparator<? super E> comparator) {
        int i = low;
        while (i < bound) {
            int j = i;
            while (j != 0 && comparator.compare(data[j - 1], data[j]) > 0) {
                E t = data[j];
                data[j] = data[j - 1];
                data[j - 1] = t;
                --j;
            }
            ++i;
        }
    }

    public static final <E> void rangedSortQuick(E[] data, int size, int offset, int length, Comparator<? super E> comparator) {
        AbstractArrayStorage.validateRange0toUpperBound(size, offset, length);
        if (length >= 0) {
            XSort.quicksort(data, offset, offset + length, comparator);
        } else {
            XSort.quicksort(data, offset + length + 1, offset + 1, comparator);
        }
    }

    public static final <E> void rangedSortMerge(E[] data, int size, int offset, int length, Comparator<? super E> comparator) {
        if (length > 0) {
            int endIndex;
            if (offset < 0 || (endIndex = offset + length - 1) >= size) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
            }
            XSort.mergesort(data, offset, endIndex + 1, comparator);
        } else if (length < 0) {
            int endIndex = offset + length + 1;
            if (endIndex < 0 || offset >= size) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
            }
            XSort.mergesort(data, endIndex, offset + 1, comparator);
        } else if (offset < 0 || offset >= size) {
            throw new IndexExceededException(size, offset);
        }
    }

    public static final <E> void rangedSort(E[] data, int size, int offset, int length, Comparator<? super E> comparator) {
        if (length > 0) {
            int endIndex;
            if (offset < 0 || (endIndex = offset + length - 1) >= size) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
            }
            XSort.mergesort(data, offset, endIndex + 1, comparator);
        } else if (length < 0) {
            int endIndex = offset + length + 1;
            if (endIndex < 0 || offset >= size) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
            }
            XSort.mergesort(data, endIndex, offset + 1, comparator);
        } else if (offset < 0 || offset >= size) {
            throw new IndexExceededException(size, offset);
        }
    }

    public static final <E> void shuffle(E[] data, int size) {
        FastRandom random = new FastRandom();
        int i = size;
        while (i > 1) {
            E t = data[i - 1];
            int j = random.nextInt(i);
            data[i - 1] = data[j];
            data[j] = t;
            --i;
        }
    }

    public static final <E> void rangedShuffle(E[] data, int size, int offset, int length) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return;
        }
        int endIndex = offset + length - d;
        Random r = XMath.random();
        int i = offset - d;
        while (i != endIndex) {
            E t = data[i += d];
            int j = r.nextInt(i);
            data[i] = data[j];
            data[j] = t;
        }
    }

    public static final <T> T[] toReversed(T[] array, int size) {
        T[] rArray = X.ArrayOfSameType(array, size);
        int i = 0;
        int r = size;
        while (i < size) {
            rArray[--r] = array[i];
            ++i;
        }
        return rArray;
    }

    public static final <E> boolean hasDistinctValues(E[] data, int size) {
        HashEnum<E> uniques = HashEnum.NewCustom(size);
        int i = 0;
        while (i < size) {
            if (!uniques.add(data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final <E> boolean rangedHasUniqueValues(E[] data, int size, int offset, int length) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return true;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            E element = data[i += d];
            int j = i;
            while (j != endIndex) {
                if (data[j += d] != element) continue;
                return false;
            }
        }
        return true;
    }

    public static final <E> boolean hasDistinctValues(E[] data, int size, Equalator<? super E> equalator) {
        if (equalator instanceof HashEqualator) {
            return AbstractArrayStorage.hasDistinctValues(data, size, (HashEqualator)equalator);
        }
        int i = 0;
        while (i < size) {
            E element = data[i];
            int j = i + 1;
            while (j < size) {
                if (equalator.equal(element, data[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static final <E> boolean hasDistinctValues(E[] data, int size, HashEqualator<? super E> equalator) {
        EqHashEnum<E> uniques = EqHashEnum.NewCustom(equalator, size);
        int i = 0;
        while (i < size) {
            if (!uniques.add(data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final <E> boolean rangedHasUniqueValues(E[] data, int size, int offset, int length, Equalator<? super E> equalator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return true;
        }
        int endIndex = offset + length - d;
        int i = offset - d;
        while (i != endIndex) {
            E element = data[i += d];
            int j = i;
            while (j != endIndex) {
                if (!equalator.equal(element, data[j += d])) continue;
                return false;
            }
        }
        return true;
    }

    public static final <E> boolean equalsContent(E[] data, int size, Collection<? extends E> collection, Equalator<? super E> equalator) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            return XArrays.equals(data, 0, AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), 0, size, equalator);
        }
        int i = 0;
        Iterator<E> itr = collection.iterator();
        while (itr.hasNext()) {
            if (equalator.equal(data[i++], itr.next())) continue;
            return false;
        }
        return true;
    }

    public static final <E> boolean equalsContent(final E[] data, int size, XGettingCollection<? extends E> samples, final Equalator<? super E> equalator) {
        if (size != XTypes.to_int(samples.size())) {
            return false;
        }
        if (samples instanceof AbstractSimpleArrayCollection) {
            return XArrays.equals(data, 0, AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples)), 0, size, equalator);
        }
        return samples.applies(new Predicate<E>(){
            private int i;

            @Override
            public boolean test(E e) {
                return equalator.equal(data[this.i++], e);
            }
        });
    }

    public static final <E> boolean rangedEqualsContent(E[] data, int size, int offset, int length, List<? extends E> list, Equalator<? super E> equalator) {
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return list.size() == 0;
        }
        int endIndex = offset + length - d;
        if (list == null || list.size() != (length < 0 ? -length : length)) {
            return false;
        }
        if (list instanceof RandomAccess) {
            int i = offset - d;
            int j = 0;
            while (i != endIndex) {
                if (equalator.equal(data[i += d], list.get(j++))) continue;
                return false;
            }
        } else {
            int i = offset - d;
            ListIterator<E> itr = list.listIterator();
            while (itr.hasNext()) {
                if (equalator.equal(data[i += d], itr.next())) continue;
                return false;
            }
        }
        return true;
    }

    public static final <E> boolean rangedEqualsContent(final E[] data, int size, int offset, int length, XGettingSequence<? extends E> sequence, final Equalator<? super E> equalator) {
        if (size != XTypes.to_int(sequence.size())) {
            return false;
        }
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return XArrays.equals(data, offset, AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), 0, length, equalator);
        }
        int d = AbstractArrayStorage.checkIterationDirection(size, offset, length);
        if (d == 0) {
            return XTypes.to_int(sequence.size()) == 0;
        }
        if (d < 0) {
            return sequence.applies(new Predicate<E>(offset){
                private int i;
                {
                    this.i = n;
                }

                @Override
                public boolean test(E e) {
                    return equalator.equal(data[this.i--], e);
                }
            });
        }
        return sequence.applies(new Predicate<E>(offset){
            private int i;
            {
                this.i = n;
            }

            @Override
            public boolean test(E e) {
                return equalator.equal(data[this.i++], e);
            }
        });
    }

    public static final Object[] rangedToArray(Object[] data, int size, int offset, int length) {
        if (offset < 0 || offset >= size) {
            throw new IndexExceededException(size, offset);
        }
        if (length == 0) {
            return new Object[0];
        }
        if (length > 0) {
            Object[] array = new Object[length];
            System.arraycopy(data, offset, array, 0, length);
            return array;
        }
        int boundIndex = offset + length;
        if (boundIndex < -1) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        Object[] array = new Object[-length];
        int i = offset;
        int j = 0;
        while (i > boundIndex) {
            array[j++] = data[i];
            --i;
        }
        return array;
    }

    public static final <T> T[] rangedToArray(Object[] data, int size, int offset, int length, T[] a) {
        if (offset < 0 || offset >= size) {
            throw new IndexExceededException(size, offset);
        }
        if (length == 0) {
            if (a.length == 0) {
                return X.ArrayOfSameType(a, 1);
            }
            return a;
        }
        if (length > 0) {
            if (a.length < length) {
                a = X.ArrayOfSameType(a, length);
            }
            System.arraycopy(data, offset, a, 0, length);
        } else {
            int boundIndex = offset + length;
            if (boundIndex < -1) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
            }
            if (a.length < -length) {
                a = X.ArrayOfSameType(a, -length);
            }
            int i = offset;
            int j = 0;
            while (i > boundIndex) {
                a[j++] = data[i];
                --i;
            }
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public static <E> E[] rangedToArray(E[] data, int size, int offset, int length, Class<E> type) {
        if (offset < 0 || offset >= size) {
            if (offset == 0 && size == 0 && length == 0) {
                return X.Array(type, 0);
            }
            throw new IndexExceededException(size, offset);
        }
        if (length == 0) {
            return X.Array(type, 0);
        }
        if (length > 0) {
            E[] array = X.Array(type, length);
            System.arraycopy(data, offset, array, 0, length);
            return array;
        }
        return AbstractArrayStorage.internalReverseToArray(data, size, offset, length, type);
    }

    private static <E> E[] internalReverseToArray(E[] data, int size, int offset, int length, Class<E> type) {
        int boundIndex = offset + length;
        if (boundIndex < -1) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        E[] array = X.Array(type, -length);
        int i = offset;
        int j = 0;
        while (i > boundIndex) {
            array[j++] = data[i];
            --i;
        }
        return array;
    }

    @Deprecated
    static final String exceptionRange(int size, int offset, long length) {
        return "Range [" + (length < 0L ? String.valueOf((long)offset + length + 1L) + ";" + offset : (length > 0L ? String.valueOf(offset) + ";" + ((long)offset + length - 1L) : String.valueOf(offset) + ";" + offset)) + "] not in [0;" + (size - 1) + "]";
    }

    @Deprecated
    private static String exceptionIllegalSwapBounds(int size, int indexA, int indexB, int length) {
        return "Illegal swap bounds: (" + indexA + " [" + length + "] -> " + indexB + " [" + length + "]) in range [0;" + (size - 1) + "]";
    }

    @Deprecated
    public static final int checkIterationDirection(int size, int offset, int length) {
        if (length > 0) {
            if (offset < 0 || offset + length > size) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
            }
            return 1;
        }
        if (length < 0) {
            if (offset >= size || offset + length < -1) {
                throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
            }
            return -1;
        }
        if (offset < 0 || offset >= size) {
            throw new IndexOutOfBoundsException(AbstractArrayStorage.exceptionRange(size, offset, length));
        }
        return 0;
    }
}

