/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import one.microstream.collections.interfaces.ExtendedCollection;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.exceptions.ArrayCapacityException;
import one.microstream.exceptions.IndexBoundsException;

public abstract class AbstractExtendedCollection<E>
implements ExtendedCollection<E> {
    public static void validateIndex(long bound, long index) throws IndexBoundsException {
        if (index < 0L) {
            throw new IndexBoundsException(bound, index);
        }
        if (index >= bound) {
            throw new IndexBoundsException(bound, index);
        }
    }

    public static void ensureFreeArrayCapacity(int size) {
        if (size >= Integer.MAX_VALUE) {
            throw new ArrayCapacityException((long)size);
        }
    }

    protected abstract int internalCountingAddAll(E[] var1) throws UnsupportedOperationException;

    protected abstract int internalCountingAddAll(E[] var1, int var2, int var3) throws UnsupportedOperationException;

    protected abstract int internalCountingAddAll(XGettingCollection<? extends E> var1) throws UnsupportedOperationException;

    protected abstract int internalCountingPutAll(E[] var1) throws UnsupportedOperationException;

    protected abstract int internalCountingPutAll(E[] var1, int var2, int var3) throws UnsupportedOperationException;

    protected abstract int internalCountingPutAll(XGettingCollection<? extends E> var1) throws UnsupportedOperationException;
}

