/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.chars.VarString;
import one.microstream.collections.AbstractChainEntryLinked;
import one.microstream.collections.AbstractChainKeyValueCollection;
import one.microstream.collections.AbstractChainKeyValueStorage;
import one.microstream.collections.ArrayView;
import one.microstream.collections.ChainMapEntryLinkedStrongStrong;
import one.microstream.collections.ChainStrongStrongStorage;
import one.microstream.collections.ConstList;
import one.microstream.collections.EnumView;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.TableView;
import one.microstream.collections.interfaces.HashCollection;
import one.microstream.collections.old.OldCollection;
import one.microstream.collections.old.OldList;
import one.microstream.collections.types.XEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XImmutableList;
import one.microstream.collections.types.XImmutableTable;
import one.microstream.collections.types.XIterable;
import one.microstream.equality.Equalator;
import one.microstream.equality.IdentityEqualator;
import one.microstream.equality.IdentityEqualityLogic;
import one.microstream.functional.Aggregator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.functional.XFunc;
import one.microstream.hashing.HashEqualator;
import one.microstream.hashing.XHashing;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.Composition;
import one.microstream.typing.Copyable;
import one.microstream.typing.KeyValue;
import one.microstream.typing.XTypes;

public final class ConstHashTable<K, V>
extends AbstractChainKeyValueCollection<K, V, ChainMapEntryLinkedStrongStrong<K, V>>
implements XImmutableTable<K, V>,
HashCollection<K>,
Composition,
IdentityEqualityLogic {
    final AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedStrongStrong<K, V>> chain;
    ChainMapEntryLinkedStrongStrong<K, V>[] slots;
    float hashDensity;
    int capacity;
    int range;
    int size;
    final Values values = new Values();
    final Keys keys = new Keys();

    public static final <KI, VI, KO, VO> Aggregator<KeyValue<KI, VI>, ConstHashTable<KO, VO>> projector(final ConstHashTable<KO, VO> target, final Function<KI, KO> keyProjector, final Function<VI, VO> valueProjector) {
        return new Aggregator<KeyValue<KI, VI>, ConstHashTable<KO, VO>>(){

            @Override
            public void accept(KeyValue<KI, VI> e) {
                target.internalAdd(keyProjector.apply(e.key()), valueProjector.apply(e.value()));
            }

            @Override
            public ConstHashTable<KO, VO> yield() {
                return target;
            }
        };
    }

    public static final <K, V> ConstHashTable<K, V> New() {
        return new ConstHashTable<K, V>(1, 1.0f);
    }

    public static final <K, V> ConstHashTable<K, V> NewCustom(int initialHashLength) {
        return new ConstHashTable<K, V>(XHashing.padHashLength(initialHashLength), 1.0f);
    }

    public static final <K, V> ConstHashTable<K, V> NewCustom(float hashDensity) {
        return new ConstHashTable<K, V>(1, XHashing.validateHashDensity(hashDensity));
    }

    public static final <K, V> ConstHashTable<K, V> NewCustom(int initialHashLength, float hashDensity) {
        return new ConstHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity));
    }

    public static final <K, V> ConstHashTable<K, V> New(XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new ConstHashTable<K, V>(1, 1.0f).internalAddEntries(entries);
    }

    public static final <K, V> ConstHashTable<K, V> NewCustom(int initialHashLength, float hashDensity, XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new ConstHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity)).internalAddEntries(entries);
    }

    public static final <K, V> ConstHashTable<K, V> NewSingle(K key, V value) {
        ConstHashTable<K, V> instance = ConstHashTable.New();
        instance.internalAdd(key, value);
        return instance;
    }

    @SafeVarargs
    public static final <K, V> ConstHashTable<K, V> New(KeyValue<? extends K, ? extends V> ... entries) {
        return new ConstHashTable<K, V>(1, 1.0f).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    @SafeVarargs
    public static final <K, V> ConstHashTable<K, V> NewCustom(int initialHashLength, float hashDensity, KeyValue<? extends K, ? extends V> ... entries) {
        return new ConstHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity)).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    public static final <KI, VI, KO, VO> ConstHashTable<KO, VO> NewProjected(float hashDensity, XGettingCollection<? extends KeyValue<KI, VI>> entries, Function<? super KI, KO> keyProjector, Function<? super VI, VO> valueProjector) {
        ConstHashTable newMap = new ConstHashTable(1, XHashing.validateHashDensity(hashDensity));
        entries.iterate(e -> newMap.internalAdd(keyProjector.apply((Object)e.key()), valueProjector.apply((Object)e.value())));
        return newMap;
    }

    public static final <KO, VO, KI extends KO, VI extends VO> ConstHashTable<KO, VO> NewProjected(XGettingCollection<? extends KeyValue<KI, VI>> entries) {
        return ConstHashTable.NewProjected(entries, XFunc.passThrough(), XFunc.passThrough());
    }

    public static final <KI, VI, KO, VO> ConstHashTable<KO, VO> NewProjected(XGettingCollection<? extends KeyValue<KI, VI>> entries, Function<? super KI, KO> keyProjector, Function<? super VI, VO> valueProjector) {
        return ConstHashTable.NewProjected(entries instanceof HashCollection ? ((HashCollection)((Object)entries)).hashDensity() : 1.0f, entries, keyProjector, valueProjector);
    }

    private ConstHashTable(ConstHashTable<K, V> original) {
        this.hashDensity = original.hashDensity;
        this.range = original.range;
        this.slots = ChainMapEntryLinkedStrongStrong.array(original.slots.length);
        this.chain = new ChainStrongStrongStorage(this, new ChainMapEntryLinkedStrongStrong<Object, Object>(null, null, null));
        this.capacity = original.capacity;
    }

    private ConstHashTable(int pow2InitialHashLength, float positiveHashDensity) {
        this.hashDensity = positiveHashDensity;
        this.range = pow2InitialHashLength - 1;
        this.slots = ChainMapEntryLinkedStrongStrong.array(pow2InitialHashLength);
        this.chain = new ChainStrongStrongStorage(this, new ChainMapEntryLinkedStrongStrong<Object, Object>(null, null, null));
        this.capacity = (int)((float)pow2InitialHashLength * positiveHashDensity);
    }

    private ChainMapEntryLinkedStrongStrong<K, V> createNewEntry(K key, V value) {
        if (this.size >= this.capacity) {
            ConstHashTable.ensureFreeArrayCapacity(this.size);
            this.increaseStorage();
        }
        ChainMapEntryLinkedStrongStrong<K, V> e = new ChainMapEntryLinkedStrongStrong<K, V>(key, value, this.slots[System.identityHashCode(key) & this.range]);
        this.slots[System.identityHashCode(key) & this.range] = e;
        ++this.size;
        return e;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.slots.length * 2.0f));
    }

    private void rebuildStorage(int newSlotLength) {
        ChainMapEntryLinkedStrongStrong<K, V>[] newSlots = ChainMapEntryLinkedStrongStrong.array(newSlotLength);
        int modulo = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : newSlotLength - 1;
        ChainMapEntryLinkedStrongStrong entry = (ChainMapEntryLinkedStrongStrong)this.chain.head();
        while ((entry = (ChainMapEntryLinkedStrongStrong)entry.next) != null) {
            entry.link = newSlots[System.identityHashCode(entry.key) & modulo];
            newSlots[System.identityHashCode(entry.key) & modulo] = entry;
        }
        this.capacity = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)newSlotLength * this.hashDensity);
        this.slots = newSlots;
        this.range = modulo;
    }

    @Override
    public final KeyValue<K, V> lookup(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    final boolean containsKey(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return true;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return false;
    }

    final void internalAdd(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
    }

    final ConstHashTable<K, V> internalAddEntries(XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        entries.iterate(new Consumer<KeyValue<? extends K, ? extends V>>(){

            @Override
            public void accept(KeyValue<? extends K, ? extends V> e) {
                ConstHashTable.this.internalAdd(e.key(), e.value());
            }
        });
        return this;
    }

    protected int internalCountingAddAll(KeyValue<K, V>[] elements) throws UnsupportedOperationException {
        return this.internalCountingAddAll(elements, 0, elements.length);
    }

    protected int internalCountingAddAll(KeyValue<K, V>[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends KeyValue<K, V>> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected int internalCountingPutAll(KeyValue<K, V>[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected int internalCountingPutAll(KeyValue<K, V>[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends KeyValue<K, V>> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalRemoveNullEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void internalRemoveEntry(ChainMapEntryLinkedStrongStrong<K, V> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalClear() {
        throw new UnsupportedOperationException();
    }

    protected AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedStrongStrong<K, V>> getInternalStorageChain() {
        return this.chain;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final int rehash() {
        return XTypes.to_int(this.size());
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final ConstHashTable<K, V> copy() {
        final ConstHashTable<K, V> newVarMap = new ConstHashTable<K, V>(this);
        this.chain.iterate(new Consumer<KeyValue<K, V>>(){

            @Override
            public void accept(KeyValue<K, V> entry) {
                newVarMap.internalAdd(entry.key(), entry.value());
            }
        });
        return newVarMap;
    }

    @Override
    public final ConstHashTable<K, V> immure() {
        return this;
    }

    @Override
    public final XGettingTable<K, V> view() {
        return new TableView(this);
    }

    @Override
    public final void setHashDensity(float hashDensity) {
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final boolean nullAllowed() {
        return true;
    }

    @Override
    public final boolean nullKeyAllowed() {
        return true;
    }

    @Override
    public final boolean nullValuesAllowed() {
        return true;
    }

    @Override
    public final V get(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e.value();
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final Keys keys() {
        return this.keys;
    }

    @Override
    public final XImmutableTable.EntriesBridge<K, V> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public XImmutableTable.Bridge<K, V> oldMap() {
        return new OldVarMap();
    }

    @Override
    public final V searchValue(final Predicate<? super K> keyPredicate) {
        KeyValue foundEntry = (KeyValue)this.chain.search(new Predicate<KeyValue<K, V>>(){

            @Override
            public boolean test(KeyValue<K, V> entry) {
                return keyPredicate.test(entry.key());
            }
        });
        return foundEntry != null ? (V)foundEntry.value() : null;
    }

    @Override
    public final <C extends Consumer<? super V>> C query(XIterable<? extends K> keys, final C collector) {
        keys.iterate(new Consumer<K>(){

            @Override
            public void accept(K key) {
                collector.accept(ConstHashTable.this.get(key));
            }
        });
        return collector;
    }

    @Override
    public final Values values() {
        return this.values;
    }

    @Override
    public final long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public final long remainingCapacity() {
        return Integer.MAX_VALUE - this.size;
    }

    @Override
    public final HashCollection.Analysis<ConstHashTable<K, V>> analyze() {
        return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])this.slots);
    }

    @Override
    public final int hashDistributionRange() {
        return this.slots.length;
    }

    @Override
    public final HashEqualator<K> hashEquality() {
        return XHashing.hashEqualityIdentity();
    }

    @Override
    public final float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final boolean hasVolatileHashElements() {
        return this.chain.hasVolatileElements();
    }

    public final String toString() {
        return this.chain.appendTo(VarString.New(this.slots.length).append('{'), ",").append('}').toString();
    }

    public final Predicate<KeyValue<K, V>> predicateContainsEntry() {
        return entry -> {
            KeyValue kv = this.lookup(entry.key());
            if (kv == null) {
                return false;
            }
            return kv.key() == entry.key() && kv.value() == entry.value();
        };
    }

    @Override
    public final XEnum<KeyValue<K, V>> range(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XGettingEnum<KeyValue<K, V>> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    public final KeyValue<K, V>[] toArray(Class<KeyValue<K, V>> type) {
        return this.chain.toArray(type);
    }

    @Override
    public final <P extends Consumer<? super KeyValue<K, V>>> P iterate(P procedure) {
        this.chain.iterate(procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super KeyValue<K, V>, ? super A> joiner, A aggregate) {
        this.chain.join(joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(KeyValue<K, V> entry) {
        return this.chain.count(entry, this.equality());
    }

    @Override
    public final long countBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.count(predicate);
    }

    @Override
    public final KeyValue<K, V> search(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.search(predicate);
    }

    @Override
    public final KeyValue<K, V> max(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.max(comparator);
    }

    @Override
    public final KeyValue<K, V> min(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.min(comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.appliesAll(predicate);
    }

    @Override
    public final boolean nullContained() {
        return false;
    }

    @Override
    public final boolean containsId(KeyValue<K, V> entry) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(entry.key()) & this.range];
        while (e != null) {
            if (entry == e.key()) {
                return true;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean contains(KeyValue<K, V> entry) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(entry.key()) & this.range];
        while (e != null) {
            if (e.key() == entry.key()) {
                return true;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final KeyValue<K, V> seek(KeyValue<K, V> sample) {
        if (sample == null) {
            return null;
        }
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(sample.key()) & this.range];
        while (e != null) {
            if (e.key() == sample.key()) {
                return e;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        return elements.applies(this.predicateContainsEntry());
    }

    @Override
    public final boolean equals(XGettingCollection<? extends KeyValue<K, V>> samples, Equalator<? super KeyValue<K, V>> equalator) {
        if (samples == null || !(samples instanceof Keys)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return this.equalsContent(samples, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends KeyValue<K, V>> samples, Equalator<? super KeyValue<K, V>> equalator) {
        if (this.size != XTypes.to_int(samples.size())) {
            return false;
        }
        return this.chain.equalsContent(samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C intersect(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.intersect(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C except(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.except(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C union(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C copyTo(C target) {
        return this.chain.copyTo(target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C filterTo(C target, Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.copyTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C distinct(C target) {
        return this.distinct(target, this.equality());
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C distinct(C target, Equalator<? super KeyValue<K, V>> equalator) {
        return this.chain.distinct(target, equalator);
    }

    @Override
    public final ConstHashTable<K, V> toReversed() {
        Copyable reversedVarSet = this.copy();
        ((ConstHashTable)reversedVarSet).chain.reverse();
        return reversedVarSet;
    }

    @Override
    public final <T extends Consumer<? super KeyValue<K, V>>> T copySelection(T target, long ... indices) {
        this.chain.copySelection(target, indices);
        return target;
    }

    @Override
    public final <P extends IndexedAcceptor<? super KeyValue<K, V>>> P iterateIndexed(P procedure) {
        this.chain.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final KeyValue<K, V> at(long index) {
        return (KeyValue)this.chain.get(index);
    }

    @Override
    public final KeyValue<K, V> get() {
        return (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> first() {
        return (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> last() {
        return (KeyValue)this.chain.last();
    }

    @Override
    public final KeyValue<K, V> poll() {
        return this.size == 0 ? null : (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> peek() {
        return this.size == 0 ? null : (KeyValue)this.chain.last();
    }

    @Override
    public final long indexOf(KeyValue<K, V> entry) {
        return this.chain.indexOf(entry);
    }

    @Override
    public final long indexBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.indexOf(predicate);
    }

    @Override
    public final boolean isSorted(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.isSorted(comparator);
    }

    @Override
    public final long lastIndexOf(KeyValue<K, V> entry) {
        return this.chain.lastIndexOf(entry);
    }

    @Override
    public final long lastIndexBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.lastIndexBy(predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.maxIndex(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.minIndex(comparator);
    }

    @Override
    public final long scan(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.scan(predicate);
    }

    @Override
    public final Iterator<KeyValue<K, V>> iterator() {
        return this.chain.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.chain.toArray();
    }

    @Override
    public final HashEqualator<KeyValue<K, V>> equality() {
        return XHashing.keyValueHashEqualityKeyIdentity();
    }

    public static interface Creator<K, V> {
        public ConstHashTable<K, V> newInstance();
    }

    public final class Keys
    implements XImmutableTable.Keys<K, V>,
    HashCollection<K> {
        @Override
        public final int hashDistributionRange() {
            return ConstHashTable.this.slots.length;
        }

        @Override
        public final boolean hasVolatileHashElements() {
            return ConstHashTable.this.chain.hasVolatileElements();
        }

        @Override
        public final void setHashDensity(float hashDensity) {
            ConstHashTable.this.setHashDensity(hashDensity);
        }

        @Override
        public final HashCollection.Analysis<Keys> analyze() {
            return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])ConstHashTable.this.slots);
        }

        @Override
        public final Equalator<? super K> equality() {
            return ConstHashTable.this.hashEquality();
        }

        @Override
        public final Keys copy() {
            return ((ConstHashTable)ConstHashTable.this.copy()).keys();
        }

        @Override
        public final Keys immure() {
            return this;
        }

        @Override
        public final XGettingEnum<K> view() {
            return new EnumView(this);
        }

        @Override
        public final XEnum<K> range(long lowIndex, long highIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final XGettingEnum<K> view(long lowIndex, long highIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final K[] toArray(Class<K> type) {
            return ConstHashTable.this.chain.keyToArray(type);
        }

        @Override
        public final <P extends Consumer<? super K>> P iterate(P procedure) {
            ConstHashTable.this.chain.keyIterate(procedure);
            return procedure;
        }

        @Override
        public final <A> A join(BiConsumer<? super K, ? super A> joiner, A aggregate) {
            ConstHashTable.this.chain.keyJoin(joiner, aggregate);
            return aggregate;
        }

        @Override
        public final long count(K element) {
            return this.contains((K)element) ? 1 : 0;
        }

        @Override
        public final long countBy(Predicate<? super K> predicate) {
            return ConstHashTable.this.chain.keyCount(predicate);
        }

        @Override
        public final K seek(K sample) {
            return ConstHashTable.this.chain.keySeek(sample);
        }

        @Override
        public final K search(Predicate<? super K> predicate) {
            return ConstHashTable.this.chain.keySearch(predicate);
        }

        @Override
        public final K max(Comparator<? super K> comparator) {
            return ConstHashTable.this.chain.keyMax(comparator);
        }

        @Override
        public final K min(Comparator<? super K> comparator) {
            return ConstHashTable.this.chain.keyMin(comparator);
        }

        @Override
        public final boolean hasVolatileElements() {
            return ConstHashTable.this.chain.hasVolatileElements();
        }

        @Override
        public final boolean nullAllowed() {
            return true;
        }

        @Override
        public final boolean containsSearched(Predicate<? super K> predicate) {
            return ConstHashTable.this.chain.keyApplies(predicate);
        }

        @Override
        public final boolean applies(Predicate<? super K> predicate) {
            return ConstHashTable.this.chain.keyAppliesAll(predicate);
        }

        @Override
        public final boolean nullContained() {
            return this.contains((K)null);
        }

        @Override
        public final boolean containsId(K element) {
            ChainMapEntryLinkedStrongStrong e = ConstHashTable.this.slots[System.identityHashCode(element) & ConstHashTable.this.range];
            while (e != null) {
                if (element == e.key()) {
                    return true;
                }
                e = (ChainMapEntryLinkedStrongStrong)e.link;
            }
            return false;
        }

        @Override
        public final boolean contains(K element) {
            ChainMapEntryLinkedStrongStrong e = ConstHashTable.this.slots[System.identityHashCode(element) & ConstHashTable.this.range];
            while (e != null) {
                if (e.key() == element) {
                    return true;
                }
                e = (ChainMapEntryLinkedStrongStrong)e.link;
            }
            return false;
        }

        @Override
        public final boolean containsAll(XGettingCollection<? extends K> elements) {
            return elements.applies(this::contains);
        }

        @Override
        public final boolean equals(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
            if (samples == null || !(samples instanceof Keys)) {
                return false;
            }
            if (samples == this) {
                return true;
            }
            return this.equalsContent(samples, equalator);
        }

        @Override
        public final boolean equalsContent(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
            if (ConstHashTable.this.size != XTypes.to_int(samples.size())) {
                return false;
            }
            return ConstHashTable.this.chain.keyEqualsContent(samples, equalator);
        }

        @Override
        public final <C extends Consumer<? super K>> C intersect(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return ConstHashTable.this.chain.keyIntersect(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C except(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return ConstHashTable.this.chain.keyExcept(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C union(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return ConstHashTable.this.chain.keyUnion(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C copyTo(C target) {
            return ConstHashTable.this.chain.keyCopyTo(target);
        }

        @Override
        public final <C extends Consumer<? super K>> C filterTo(C target, Predicate<? super K> predicate) {
            return ConstHashTable.this.chain.keyCopyTo(target, predicate);
        }

        @Override
        public final <C extends Consumer<? super K>> C distinct(C target) {
            return ConstHashTable.this.chain.keyDistinct(target);
        }

        @Override
        public final <C extends Consumer<? super K>> C distinct(C target, Equalator<? super K> equalator) {
            if (equalator instanceof IdentityEqualator) {
                return this.copyTo(target);
            }
            return ConstHashTable.this.chain.keyDistinct(target, equalator);
        }

        @Override
        public final long maximumCapacity() {
            return ConstHashTable.this.maximumCapacity();
        }

        @Override
        public final boolean isFull() {
            return ConstHashTable.this.isFull();
        }

        @Override
        public final long remainingCapacity() {
            return ConstHashTable.this.remainingCapacity();
        }

        @Override
        public final Keys toReversed() {
            Copyable reversedVarSet = ConstHashTable.this.copy();
            ((ConstHashTable)reversedVarSet).chain.reverse();
            return ((ConstHashTable)reversedVarSet).keys;
        }

        @Override
        public final <T extends Consumer<? super K>> T copySelection(T target, long ... indices) {
            ConstHashTable.this.chain.keyCopySelection(target, indices);
            return target;
        }

        @Override
        public final <P extends IndexedAcceptor<? super K>> P iterateIndexed(P procedure) {
            ConstHashTable.this.chain.keyIterateIndexed(procedure);
            return procedure;
        }

        @Override
        public final K at(long index) {
            return ConstHashTable.this.chain.keyGet(index);
        }

        @Override
        public final K get() {
            return ConstHashTable.this.chain.keyFirst();
        }

        @Override
        public final K first() {
            return ConstHashTable.this.chain.keyFirst();
        }

        @Override
        public final K last() {
            return ConstHashTable.this.chain.keyLast();
        }

        @Override
        public final K poll() {
            return ConstHashTable.this.size == 0 ? null : (Object)ConstHashTable.this.chain.keyFirst();
        }

        @Override
        public final K peek() {
            return ConstHashTable.this.size == 0 ? null : (Object)ConstHashTable.this.chain.keyLast();
        }

        @Override
        public final long indexOf(K element) {
            return ConstHashTable.this.chain.keyIndexOf(element);
        }

        @Override
        public final long indexBy(Predicate<? super K> predicate) {
            return ConstHashTable.this.chain.keyIndexBy(predicate);
        }

        @Override
        public final boolean isSorted(Comparator<? super K> comparator) {
            return ConstHashTable.this.chain.keyIsSorted(comparator);
        }

        @Override
        public final long lastIndexOf(K element) {
            return ConstHashTable.this.chain.keyLastIndexOf(element);
        }

        @Override
        public final long lastIndexBy(Predicate<? super K> predicate) {
            return ConstHashTable.this.chain.keyLastIndexBy(predicate);
        }

        @Override
        public final long maxIndex(Comparator<? super K> comparator) {
            return ConstHashTable.this.chain.keyMaxIndex(comparator);
        }

        @Override
        public final long minIndex(Comparator<? super K> comparator) {
            return ConstHashTable.this.chain.keyMinIndex(comparator);
        }

        @Override
        public final long scan(Predicate<? super K> predicate) {
            return ConstHashTable.this.chain.keyScan(predicate);
        }

        @Override
        public final boolean isEmpty() {
            return ConstHashTable.this.isEmpty();
        }

        @Override
        public final Iterator<K> iterator() {
            return ConstHashTable.this.chain.keyIterator();
        }

        @Override
        public final long size() {
            return ConstHashTable.this.size;
        }

        @Override
        public final int rehash() {
            return ConstHashTable.this.rehash();
        }

        public final String toString() {
            if (ConstHashTable.this.size == 0) {
                return "[]";
            }
            VarString vc = VarString.New(ConstHashTable.this.slots.length).append('[');
            ConstHashTable.this.chain.keyAppendTo(vc, ',').append(']');
            return vc.toString();
        }

        @Override
        public final Object[] toArray() {
            return ConstHashTable.this.chain.keyToArray();
        }

        @Override
        public final OldCollection<K> old() {
            throw new NotImplementedYetError();
        }

        @Override
        public final ConstHashTable<K, V> parent() {
            return ConstHashTable.this;
        }

        @Override
        public final HashEqualator<K> hashEquality() {
            return ConstHashTable.this.hashEquality();
        }

        @Override
        public final float hashDensity() {
            return ConstHashTable.this.hashDensity();
        }
    }

    public final class OldVarMap
    implements XImmutableTable.Bridge<K, V> {
        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean containsKey(Object key) {
            try {
                return ConstHashTable.this.containsKey(key);
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public final boolean containsValue(Object value) {
            try {
                return ConstHashTable.this.chain.valuesContains(value);
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            return (Set)((Object)ConstHashTable.this.old());
        }

        @Override
        public final V get(Object key) {
            try {
                return ConstHashTable.this.get(key);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public final boolean isEmpty() {
            return ConstHashTable.this.isEmpty();
        }

        @Override
        public final Set<K> keySet() {
            throw new NotImplementedYetError();
        }

        @Override
        public final V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int size() {
            return XTypes.to_int(ConstHashTable.this.size());
        }

        @Override
        public final Collection<V> values() {
            return ConstHashTable.this.values.old();
        }

        @Override
        public final ConstHashTable<K, V> parent() {
            return ConstHashTable.this;
        }
    }

    public final class Values
    implements XImmutableTable.Values<K, V> {
        @Override
        public final Equalator<? super V> equality() {
            return Equalator.identity();
        }

        @Override
        public final XImmutableList<V> copy() {
            return ConstList.New(this);
        }

        @Override
        public final <P extends Consumer<? super V>> P iterate(P procedure) {
            ConstHashTable.this.chain.valuesIterate(procedure);
            return procedure;
        }

        @Override
        public final <A> A join(BiConsumer<? super V, ? super A> joiner, A aggregate) {
            ConstHashTable.this.chain.valuesJoin(joiner, aggregate);
            return aggregate;
        }

        @Override
        public final <P extends IndexedAcceptor<? super V>> P iterateIndexed(P procedure) {
            ConstHashTable.this.chain.valuesIterateIndexed(procedure);
            return procedure;
        }

        @Override
        public final Values toReversed() {
            Copyable reversedVarSet = ConstHashTable.this.copy();
            ((ConstHashTable)reversedVarSet).chain.reverse();
            return ((ConstHashTable)reversedVarSet).values;
        }

        @Override
        public final boolean containsSearched(Predicate<? super V> predicate) {
            return ConstHashTable.this.chain.valuesApplies(predicate);
        }

        @Override
        public final boolean applies(Predicate<? super V> predicate) {
            return ConstHashTable.this.chain.valuesAppliesAll(predicate);
        }

        @Override
        public final boolean contains(V value) {
            return ConstHashTable.this.chain.valuesContains(value);
        }

        @Override
        public final boolean containsAll(XGettingCollection<? extends V> values) {
            return ConstHashTable.this.chain.valuesContainsAll(values);
        }

        @Override
        public final boolean containsId(V value) {
            return ConstHashTable.this.chain.valuesContainsId(value);
        }

        @Override
        public final <T extends Consumer<? super V>> T copyTo(T target) {
            ConstHashTable.this.chain.valuesCopyTo(target);
            return target;
        }

        @Override
        public final <T extends Consumer<? super V>> T filterTo(T target, Predicate<? super V> predicate) {
            ConstHashTable.this.chain.valuesCopyTo(target, predicate);
            return target;
        }

        @Override
        public final long count(V value) {
            return ConstHashTable.this.chain.valuesCount(value);
        }

        @Override
        public final long countBy(Predicate<? super V> predicate) {
            return ConstHashTable.this.chain.valuesCount(predicate);
        }

        @Override
        public final <T extends Consumer<? super V>> T distinct(T target) {
            ConstHashTable.this.chain.valuesDistinct(target);
            return target;
        }

        @Override
        public final <T extends Consumer<? super V>> T distinct(T target, Equalator<? super V> equalator) {
            ConstHashTable.this.chain.valuesDistinct(target, equalator);
            return target;
        }

        @Override
        public final boolean equals(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
            if (samples == null || !(samples instanceof EqHashEnum)) {
                return false;
            }
            if (samples == this) {
                return true;
            }
            return this.equalsContent(samples, equalator);
        }

        @Override
        public final boolean equalsContent(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
            return ConstHashTable.this.chain.valuesEqualsContent(samples, equalator);
        }

        @Override
        public final <T extends Consumer<? super V>> T except(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            ConstHashTable.this.chain.valuesExcept(other, equalator, target);
            return target;
        }

        @Override
        public final boolean hasVolatileElements() {
            return false;
        }

        @Override
        public final <T extends Consumer<? super V>> T intersect(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            ConstHashTable.this.chain.valuesIntersect(other, equalator, target);
            return target;
        }

        @Override
        public final boolean isEmpty() {
            return ConstHashTable.this.isEmpty();
        }

        @Override
        public final Iterator<V> iterator() {
            return ConstHashTable.this.chain.valuesIterator();
        }

        @Override
        public final V max(Comparator<? super V> comparator) {
            return ConstHashTable.this.chain.valuesMax(comparator);
        }

        @Override
        public final V min(Comparator<? super V> comparator) {
            return ConstHashTable.this.chain.valuesMin(comparator);
        }

        @Override
        public final boolean nullAllowed() {
            return ConstHashTable.this.nullAllowed();
        }

        @Override
        public final boolean nullContained() {
            return ConstHashTable.this.chain.valuesContains(null);
        }

        @Override
        public final OldList<V> old() {
            throw new NotImplementedYetError();
        }

        @Override
        public final V seek(V sample) {
            return ConstHashTable.this.chain.valuesSeek(sample);
        }

        @Override
        public final V search(Predicate<? super V> predicate) {
            return ConstHashTable.this.chain.valuesSearch(predicate);
        }

        @Override
        public final long size() {
            return XTypes.to_int(ConstHashTable.this.size());
        }

        @Override
        public final long maximumCapacity() {
            return XTypes.to_int(ConstHashTable.this.size());
        }

        @Override
        public final boolean isFull() {
            return ConstHashTable.this.isFull();
        }

        @Override
        public final long remainingCapacity() {
            return ConstHashTable.this.remainingCapacity();
        }

        public final String toString() {
            if (ConstHashTable.this.size == 0) {
                return "[]";
            }
            VarString vc = VarString.New(ConstHashTable.this.slots.length).append('[');
            ConstHashTable.this.chain.valuesAppendTo(vc, ',').append(']');
            return vc.toString();
        }

        @Override
        public final Object[] toArray() {
            return ConstHashTable.this.chain.valuesToArray();
        }

        @Override
        public final V[] toArray(Class<V> type) {
            return ConstHashTable.this.chain.valuesToArray(type);
        }

        @Override
        public final <T extends Consumer<? super V>> T union(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            ConstHashTable.this.chain.valuesUnion(other, equalator, target);
            return target;
        }

        @Override
        public final ConstHashTable<K, V> parent() {
            return ConstHashTable.this;
        }

        @Override
        public final XImmutableList<V> view(long fromIndex, long toIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final ListIterator<V> listIterator() {
            return ConstHashTable.this.chain.valuesListIterator(0L);
        }

        @Override
        public final ListIterator<V> listIterator(long index) {
            return ConstHashTable.this.chain.valuesListIterator(index);
        }

        @Override
        public final XImmutableList<V> range(long fromIndex, long toIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final XImmutableList<V> immure() {
            return ConstList.New(this);
        }

        @Override
        public final XImmutableList<V> view() {
            throw new NotImplementedYetError();
        }

        @Override
        public final <T extends Consumer<? super V>> T copySelection(T target, long ... indices) {
            ConstHashTable.this.chain.valuesCopySelection(target, indices);
            return target;
        }

        @Override
        public final V at(long index) {
            return ConstHashTable.this.chain.valuesGet(index);
        }

        @Override
        public final V get() {
            return ConstHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V first() {
            return ConstHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V last() {
            return ConstHashTable.this.chain.valuesLast();
        }

        @Override
        public final V poll() {
            return ConstHashTable.this.size == 0 ? null : (Object)ConstHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V peek() {
            return ConstHashTable.this.size == 0 ? null : (Object)ConstHashTable.this.chain.valuesLast();
        }

        @Override
        public final long indexOf(V value) {
            return ConstHashTable.this.chain.valuesIndexOf(value);
        }

        @Override
        public final long indexBy(Predicate<? super V> predicate) {
            return ConstHashTable.this.chain.valuesIndexBy(predicate);
        }

        @Override
        public final boolean isSorted(Comparator<? super V> comparator) {
            return ConstHashTable.this.chain.valuesIsSorted(comparator);
        }

        @Override
        public final long lastIndexOf(V value) {
            return ConstHashTable.this.chain.valuesLastIndexOf(value);
        }

        @Override
        public final long lastIndexBy(Predicate<? super V> predicate) {
            return ConstHashTable.this.chain.valuesLastIndexBy(predicate);
        }

        @Override
        public final long maxIndex(Comparator<? super V> comparator) {
            return ConstHashTable.this.chain.valuesMaxIndex(comparator);
        }

        @Override
        public final long minIndex(Comparator<? super V> comparator) {
            return ConstHashTable.this.chain.valuesMinIndex(comparator);
        }

        @Override
        public final long scan(Predicate<? super V> predicate) {
            return ConstHashTable.this.chain.valuesScan(predicate);
        }
    }
}

