/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.collections.AbstractArrayStorage;
import one.microstream.collections.AbstractSimpleArrayCollection;
import one.microstream.collections.XArrays;
import one.microstream.collections.old.AbstractOldGettingList;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XImmutableList;
import one.microstream.equality.Equalator;
import one.microstream.exceptions.IndexBoundsException;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.functional.IsCustomEqual;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.Composition;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.ReadOnlyListIterator;

public final class EqConstList<E>
extends AbstractSimpleArrayCollection<E>
implements XImmutableList<E>,
Composition {
    private final E[] data;
    private final Equalator<? super E> equalator;

    public EqConstList(Equalator<? super E> equalator, int initialCapacity) {
        this.data = EqConstList.newArray(initialCapacity);
        this.equalator = equalator;
    }

    public EqConstList(EqConstList<? extends E> original) throws NullPointerException {
        this.data = (Object[])original.data.clone();
        this.equalator = original.equalator;
    }

    public EqConstList(Equalator<? super E> equalator, XGettingCollection<? extends E> elements) throws NullPointerException {
        this.data = elements.toArray();
        this.equalator = equalator;
    }

    @SafeVarargs
    public EqConstList(Equalator<? super E> equalator, E ... elements) throws NullPointerException {
        this.data = (Object[])elements.clone();
        this.equalator = equalator;
    }

    public EqConstList(Equalator<? super E> equalator, E[] src, int srcStart, int srcLength) {
        this.data = EqConstList.newArray(srcLength);
        System.arraycopy(src, srcStart, this.data, 0, srcLength);
        this.equalator = equalator;
    }

    EqConstList(Equalator<? super E> equalator, E[] internalData, int size) {
        this.data = internalData;
        this.equalator = equalator;
    }

    @Override
    protected E[] internalGetStorageArray() {
        return this.data;
    }

    @Override
    protected int internalSize() {
        return this.data.length;
    }

    @Override
    protected int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.data.length;
        return nArray;
    }

    @Override
    public Equalator<? super E> equality() {
        return this.equalator;
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EqConstList<E> copy() {
        return new EqConstList<E>(this);
    }

    @Override
    public EqConstList<E> immure() {
        return this;
    }

    @Override
    public EqConstList<E> toReversed() {
        E[] data = this.data;
        E[] rData = EqConstList.newArray(data.length);
        int i = data.length;
        int r = 0;
        while (i-- > 0) {
            rData[r++] = data[i];
        }
        return new EqConstList<E>(this.equalator, rData, data.length);
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, this.data.length);
        System.arraycopy(this.data, 0, array, 0, this.data.length);
        return array;
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.data.length, procedure);
        return procedure;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.data.length, procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.join(this.data, this.data.length, joiner, aggregate);
        return aggregate;
    }

    @Override
    public long count(E element) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.data.length, new IsCustomEqual<E>(this.equalator, element));
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.data.length, predicate);
    }

    @Override
    public long indexOf(E element) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.data.length, new IsCustomEqual<E>(this.equalator, element));
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.data.length, predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return AbstractArrayStorage.reverseConditionalIndexOf(this.data, this.data.length - 1, 0, new IsCustomEqual<E>(this.equalator, element));
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.lastIndexOf(this.data, this.data.length, predicate);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.maxIndex(this.data, this.data.length, comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.minIndex(this.data, this.data.length, comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardScan(this.data, 0, this.data.length, predicate);
    }

    @Override
    public E get() {
        return this.data[0];
    }

    @Override
    public E first() {
        return this.data[0];
    }

    @Override
    public E last() {
        return this.data[this.data.length - 1];
    }

    @Override
    public E poll() {
        return this.data.length == 0 ? null : (E)this.data[0];
    }

    @Override
    public E peek() {
        return this.data.length == 0 ? null : (E)this.data[this.data.length - 1];
    }

    @Override
    public E seek(E sample) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.data.length, new IsCustomEqual<E>(this.equalator, sample), null);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.data.length, predicate, null);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return AbstractArrayStorage.max(this.data, this.data.length, comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return AbstractArrayStorage.min(this.data, this.data.length, comparator);
    }

    @Override
    public boolean hasVolatileElements() {
        return false;
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return AbstractArrayStorage.isSorted(this.data, this.data.length, comparator);
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.data.length, predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardApplies(this.data, 0, this.data.length, predicate);
    }

    @Override
    public boolean nullContained() {
        return AbstractArrayStorage.forwardNullContained(this.data, 0, this.data.length);
    }

    @Override
    public boolean containsId(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.data.length, element);
    }

    @Override
    public boolean contains(E element) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.data.length, new IsCustomEqual<E>(this.equalator, element));
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.containsAll(this.data, this.data.length, elements, this.equalator);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof EqConstList) || XTypes.to_int(samples.size()) != this.data.length) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return XArrays.equals(this.data, 0, ((EqConstList)samples).data, 0, this.data.length, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || XTypes.to_int(samples.size()) != this.data.length) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return AbstractArrayStorage.equalsContent(this.data, this.data.length, samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.intersect(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.except(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.union(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.data.length, target);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.data.length, target, predicate);
    }

    public <T> T[] rngCopyTo(int startIndex, int length, T[] target, int offset) {
        return AbstractArrayStorage.rangedCopyTo(this.data, this.data.length, startIndex, length, target, offset);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return AbstractArrayStorage.distinct(this.data, this.data.length, target, this.equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.distinct(this.data, this.data.length, target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return AbstractArrayStorage.copySelection(this.data, this.data.length, indices, target);
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        EqConstList.validateIndex(this.data.length, index);
        return new ReadOnlyListIterator(this, (int)index);
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    public long maximumCapacity() {
        return this.data.length;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public long remainingCapacity() {
        return 0L;
    }

    @Override
    public EqConstList<E> view() {
        return this;
    }

    @Override
    public EqConstList<E> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public EqConstList<E> range(long fromIndex, long toIndex) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return AbstractArrayStorage.toString(this.data, this.data.length);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public E at(long index) throws ArrayIndexOutOfBoundsException {
        if (index >= (long)this.data.length) {
            throw new IndexBoundsException((long)this.data.length, index);
        }
        return this.data[(int)index];
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (this.data.length != list.size()) {
            return false;
        }
        E[] data = this.data;
        int i = 0;
        for (Object e2 : list) {
            E e1;
            if (!((e1 = data[i++]) == null ? e2 != null : !e1.equals(e2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public int hashCode() {
        return XArrays.arrayHashCode(this.data, this.data.length);
    }

    @Override
    public OldConstList<E> old() {
        return new OldConstList(this);
    }

    public static final class OldConstList<E>
    extends AbstractOldGettingList<E> {
        OldConstList(EqConstList<E> list) {
            super(list);
        }

        @Override
        public EqConstList<E> parent() {
            return (EqConstList)super.parent();
        }
    }
}

