/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.chars.VarString;
import one.microstream.collections.AbstractChainCollection;
import one.microstream.collections.AbstractChainEntryLinked;
import one.microstream.collections.AbstractChainStorage;
import one.microstream.collections.ChainEntryLinkedStrong;
import one.microstream.collections.ChainStorageStrong;
import one.microstream.collections.ConstHashEnum;
import one.microstream.collections.EnumView;
import one.microstream.collections.XArrays;
import one.microstream.collections.interfaces.CapacityExtendable;
import one.microstream.collections.interfaces.ChainStorage;
import one.microstream.collections.interfaces.HashCollection;
import one.microstream.collections.old.AbstractBridgeXSet;
import one.microstream.collections.types.XEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.equality.Equalator;
import one.microstream.equality.IdentityEqualityLogic;
import one.microstream.exceptions.ArrayCapacityException;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.hashing.HashEqualator;
import one.microstream.hashing.XHashing;
import one.microstream.math.XMath;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.Composition;
import one.microstream.typing.Copyable;
import one.microstream.typing.XTypes;

public final class HashEnum<E>
extends AbstractChainCollection<E, E, E, ChainEntryLinkedStrong<E>>
implements XEnum<E>,
HashCollection<E>,
Composition,
IdentityEqualityLogic {
    private final AbstractChainStorage<E, E, E, ChainEntryLinkedStrong<E>> chain;
    ChainEntryLinkedStrong<E>[] slots;
    float hashDensity;
    transient int capacity;
    transient int range;
    int size;

    public static final <E> HashEnum<E> New() {
        return new HashEnum<E>(1, 1.0f);
    }

    public static final <E> HashEnum<E> NewCustom(long initialCapacity) {
        return new HashEnum<E>(XHashing.padHashLength(initialCapacity), 1.0f);
    }

    public static final <E> HashEnum<E> NewCustom(float hashDensity) {
        return new HashEnum<E>(1, hashDensity);
    }

    public static final <E> HashEnum<E> NewCustom(long desiredCapacity, float hashDensity) {
        return new HashEnum<E>(XHashing.calculateHashLength(desiredCapacity, hashDensity), XHashing.validateHashDensity(hashDensity));
    }

    @SafeVarargs
    public static final <E> HashEnum<E> New(E ... elements) {
        return new HashEnum<E>(1, 1.0f).addAll((Object[])elements);
    }

    public static final <E> HashEnum<E> New(XGettingCollection<? extends E> elements) {
        return new HashEnum<E>(1, 1.0f).addAll((XGettingCollection)elements);
    }

    private HashEnum(HashEnum<E> original) {
        this.hashDensity = original.hashDensity;
        this.range = original.range;
        this.slots = ChainEntryLinkedStrong.array(original.slots.length);
        this.chain = new ChainStorageStrong<E, E, E, ChainEntryLinkedStrong<Object>>(this, new ChainEntryLinkedStrong<Object>(null, null));
        this.capacity = original.capacity;
    }

    private HashEnum(int pow2InitialHashLength, float positiveHashDensity) {
        this.hashDensity = positiveHashDensity;
        this.range = pow2InitialHashLength - 1;
        this.slots = ChainEntryLinkedStrong.array(pow2InitialHashLength);
        this.chain = new ChainStorageStrong<E, E, E, ChainEntryLinkedStrong<Object>>(this, new ChainEntryLinkedStrong<Object>(null, null));
        this.capacity = (int)((float)pow2InitialHashLength * positiveHashDensity);
    }

    private ChainEntryLinkedStrong<E> createNewEntry(E element) {
        if (this.size >= this.capacity) {
            HashEnum.ensureFreeArrayCapacity(this.size);
            this.increaseStorage();
        }
        ChainEntryLinkedStrong<E> e = new ChainEntryLinkedStrong<E>(element, this.slots[System.identityHashCode(element) & this.range]);
        this.slots[System.identityHashCode(element) & this.range] = e;
        ++this.size;
        return e;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.slots.length * 2.0f));
    }

    private void rebuildStorage(int newSlotLength) {
        ChainEntryLinkedStrong<E>[] newSlots = ChainEntryLinkedStrong.array(newSlotLength);
        int modulo = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : newSlotLength - 1;
        ChainEntryLinkedStrong entry = this.chain.head();
        while ((entry = (ChainEntryLinkedStrong)entry.next) != null) {
            entry.link = newSlots[System.identityHashCode(entry.element) & modulo];
            newSlots[System.identityHashCode(entry.element) & modulo] = entry;
        }
        this.capacity = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)newSlotLength * this.hashDensity);
        this.slots = newSlots;
        this.range = modulo;
    }

    final void collectUnahashed(E element) {
        this.chain.appendEntry(new ChainEntryLinkedStrong<E>(element, null));
    }

    @Override
    public boolean nullAllowed() {
        throw new NotImplementedYetError();
    }

    @Override
    protected ChainStorage<E, E, E, ChainEntryLinkedStrong<E>> getInternalStorageChain() {
        return this.chain;
    }

    @Override
    protected int internalRemoveNullEntries() {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void internalRemoveEntry(ChainEntryLinkedStrong<E> entry) {
        block3: {
            setEntry = entry;
            e = this.slots[System.identityHashCode(entry.element) & this.range];
            if (e != setEntry) ** GOTO lbl9
            this.slots[System.identityHashCode(entry.element) & this.range] = (ChainEntryLinkedStrong)setEntry.link;
            break block3;
lbl-1000:
            // 1 sources

            {
                if (e == setEntry) {
                    last.link = (ChainEntryLinkedStrong)setEntry.link;
                    break;
                }
lbl9:
                // 3 sources

                last = e;
                ** while ((e = (ChainEntryLinkedStrong)last.link) != null)
            }
lbl11:
            // 2 sources

            if (e == null) {
                throw new IllegalArgumentException("Set entry inconsistency detected");
            }
        }
        --this.size;
        this.chain.disjoinEntry(setEntry);
    }

    @Override
    protected int internalClear() {
        int size = this.size;
        this.clear();
        return size;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final int rehash() {
        this.optimize();
        return XTypes.to_int(this.size());
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final void clear() {
        this.chain.clear();
        ChainEntryLinkedStrong<E>[] slots = this.slots;
        int i = 0;
        int length = slots.length;
        while (i < length) {
            slots[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public final void truncate() {
        this.chain.clear();
        this.slots = ChainEntryLinkedStrong.array(1);
        this.size = 0;
        this.capacity = (int)(1.0f * this.hashDensity);
    }

    @Override
    public final long consolidate() {
        return this.chain.consolidate();
    }

    @Override
    public final CapacityExtendable ensureCapacity(long minimalCapacity) {
        if ((long)this.capacity >= minimalCapacity) {
            return this;
        }
        int requiredSlotLength = (int)((float)minimalCapacity / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredSlotLength)) {
            this.rebuildStorage(Integer.MAX_VALUE);
            return this;
        }
        int newSlotsLength = this.slots.length;
        while (newSlotsLength < requiredSlotLength) {
            newSlotsLength <<= 1;
        }
        this.rebuildStorage(newSlotsLength);
        return this;
    }

    @Override
    public final CapacityExtendable ensureFreeCapacity(long requiredFreeCapacity) {
        if ((long)(this.capacity - this.size) >= requiredFreeCapacity) {
            return this;
        }
        if ((long)(Integer.MAX_VALUE - this.size) < requiredFreeCapacity) {
            throw new ArrayCapacityException(requiredFreeCapacity + (long)this.size);
        }
        int requiredSlotLength = (int)((float)((long)this.size + requiredFreeCapacity) / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredSlotLength)) {
            this.rebuildStorage(Integer.MAX_VALUE);
            return this;
        }
        int newSlotsLength = this.slots.length;
        while (newSlotsLength < requiredSlotLength) {
            newSlotsLength <<= 1;
        }
        this.rebuildStorage(newSlotsLength);
        return this;
    }

    @Override
    public final long optimize() {
        int requiredCapacity = (int)((float)this.size / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredCapacity)) {
            if (this.slots.length != Integer.MAX_VALUE) {
                this.rebuildStorage(Integer.MAX_VALUE);
            }
            return this.capacity;
        }
        int newCapacity = XHashing.padHashLength(requiredCapacity);
        if (this.slots.length != newCapacity) {
            this.rebuildStorage(newCapacity);
        }
        return this.capacity;
    }

    @Override
    public final HashEnum<E> copy() {
        final HashEnum<E> newVarMap = new HashEnum<E>(this);
        this.chain.iterate(new Consumer<E>(){

            @Override
            public void accept(E entry) {
                newVarMap.put(entry);
            }
        });
        return newVarMap;
    }

    @Override
    public final ConstHashEnum<E> immure() {
        this.consolidate();
        return ConstHashEnum.NewCustom(this.hashDensity, this);
    }

    @Override
    public final EnumView<E> view() {
        return new EnumView(this);
    }

    @Override
    public final void setHashDensity(float hashDensity) {
        this.hashDensity = XHashing.validateHashDensity(hashDensity);
        this.capacity = (int)((float)this.slots.length * this.hashDensity);
        this.optimize();
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final OldVarSet<E> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public final long currentCapacity() {
        return this.capacity;
    }

    @Override
    public final long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public final E addGet(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return element;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(element));
        return null;
    }

    @Override
    public final E deduplicate(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return element;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(element));
        return element;
    }

    @Override
    public final E putGet(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return e.setElement(element);
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(element));
        return null;
    }

    @Override
    public final E replace(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return element;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean add(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return false;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(element));
        return true;
    }

    @Override
    public final boolean put(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return false;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(element));
        return true;
    }

    @Override
    public final HashCollection.Analysis<HashEnum<E>> analyze() {
        return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])this.slots);
    }

    @Override
    public final int hashDistributionRange() {
        return this.slots.length;
    }

    @Override
    public final HashEqualator<E> hashEquality() {
        return XHashing.hashEqualityIdentity();
    }

    @Override
    public final float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final boolean hasVolatileHashElements() {
        return this.chain.hasVolatileElements();
    }

    public final String toString() {
        return this.chain.appendTo(VarString.New(this.slots.length).append('['), ",").append(']').toString();
    }

    @Override
    public final HashEnum<E> sort(Comparator<? super E> comparator) {
        this.chain.sort(comparator);
        return this;
    }

    @Override
    public final XEnum<E> range(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final EnumView<E> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final E[] toArray(Class<E> type) {
        return this.chain.toArray(type);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        this.chain.iterate(procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        this.chain.join(joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(E entry) {
        return this.chain.count(entry);
    }

    @Override
    public final long countBy(Predicate<? super E> predicate) {
        return this.chain.count(predicate);
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        return this.chain.search(predicate);
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        return this.chain.max(comparator);
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        return this.chain.min(comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        return this.chain.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        return this.chain.appliesAll(predicate);
    }

    @Override
    public final boolean nullContained() {
        return false;
    }

    @Override
    public final boolean containsId(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (element == e.element) {
                return true;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean contains(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return true;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        return false;
    }

    @Override
    public final E seek(E sample) {
        if (sample == null) {
            return null;
        }
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(sample) & this.range];
        while (e != null) {
            if (e.element == sample) {
                return e.element;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof HashEnum)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return this.equalsContent(samples, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        this.consolidate();
        if (this.size != XTypes.to_int(samples.size())) {
            return false;
        }
        return this.chain.equalsContent(samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.intersect(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.except(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        if (target == this) {
            return target;
        }
        return this.chain.copyTo(target);
    }

    @Override
    public final <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.chain.copyTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        return this.chain.distinct(target);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.chain.distinct(target, equalator);
    }

    @Override
    public final boolean nullAdd() {
        return this.add(null);
    }

    @Override
    @SafeVarargs
    public final HashEnum<E> addAll(E ... elements) {
        int i = 0;
        int len = elements.length;
        while (i < len) {
            this.add(elements[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final HashEnum<E> addAll(E[] elements, int srcIndex, int srcLength) {
        int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
        if (d == 0) {
            return this;
        }
        int bound = srcIndex + srcLength;
        int i = srcIndex;
        while (i != bound) {
            this.add(elements[i]);
            i += d;
        }
        return this;
    }

    @Override
    public final HashEnum<E> addAll(XGettingCollection<? extends E> elements) {
        elements.iterate(this::add);
        return this;
    }

    @Override
    public final boolean nullPut() {
        return this.put(null);
    }

    @Override
    public final void accept(E entry) {
        this.put(entry);
    }

    @Override
    @SafeVarargs
    public final HashEnum<E> putAll(E ... elements) {
        int i = 0;
        int len = elements.length;
        while (i < len) {
            this.put(elements[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final HashEnum<E> putAll(E[] elements, int srcIndex, int srcLength) {
        int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
        if (d == 0) {
            return this;
        }
        int bound = srcIndex + srcLength;
        int i = srcIndex;
        while (i != bound) {
            this.put(elements[i]);
            i += d;
        }
        return this;
    }

    @Override
    public final HashEnum<E> putAll(XGettingCollection<? extends E> elements) {
        elements.iterate(this::put);
        return this;
    }

    @Override
    public final long remove(E entry) {
        return this.chain.remove(entry);
    }

    @Override
    public long substitute(Function<? super E, ? extends E> mapper) {
        return this.chain.substitute(mapper, this::replace);
    }

    final void replace(ChainEntryLinkedStrong<E> oldEntry, E newElement) {
        int newHash = System.identityHashCode(newElement);
        ChainEntryLinkedStrong e = this.slots[newHash & this.range];
        while (e != null) {
            if (e.element == newElement && e == oldEntry) {
                e.element = newElement;
                return;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        throw new UnsupportedOperationException("Hash-changing replacement not supported, yet.");
    }

    @Override
    public final long nullRemove() {
        return 0L;
    }

    @Override
    public final long removeBy(Predicate<? super E> predicate) {
        return this.chain.reduce(predicate);
    }

    @Override
    public final long retainAll(XGettingCollection<? extends E> elements) {
        return this.chain.retainAll(elements);
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        this.chain.process(procedure);
        return procedure;
    }

    @Override
    public final <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        this.chain.moveTo(target, predicate);
        return target;
    }

    @Override
    public final long removeAll(XGettingCollection<? extends E> elements) {
        int oldSize = this.size;
        elements.iterate(this::remove);
        return oldSize - this.size;
    }

    @Override
    public final long removeDuplicates() {
        return 0L;
    }

    @Override
    public final long removeDuplicates(Equalator<? super E> equalator) {
        return this.chain.removeDuplicates(equalator);
    }

    @Override
    public final HashEnum<E> toReversed() {
        Copyable reversedVarSet = this.copy();
        ((HashEnum)reversedVarSet).chain.reverse();
        return reversedVarSet;
    }

    @Override
    public final <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        this.chain.copySelection(target, indices);
        return target;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        this.chain.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final E at(long index) {
        return this.chain.get(index);
    }

    @Override
    public final E get() {
        return this.chain.first();
    }

    @Override
    public final E first() {
        return this.chain.first();
    }

    @Override
    public final E last() {
        return this.chain.last();
    }

    @Override
    public final E poll() {
        return this.size == 0 ? null : (E)this.chain.first();
    }

    @Override
    public final E peek() {
        return this.size == 0 ? null : (E)this.chain.last();
    }

    @Override
    public final long indexOf(E entry) {
        return this.chain.indexOf(entry);
    }

    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        return this.chain.indexOf(predicate);
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        return this.chain.isSorted(comparator);
    }

    @Override
    public final long lastIndexOf(E entry) {
        return this.chain.lastIndexOf(entry);
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        return this.chain.lastIndexBy(predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        return this.chain.maxIndex(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        return this.chain.minIndex(comparator);
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        return this.chain.scan(predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        this.chain.moveSelection(target, indices);
        return target;
    }

    @Override
    public final E removeAt(long index) {
        return this.chain.remove(index);
    }

    @Override
    public final E fetch() {
        return this.chain.remove(0L);
    }

    @Override
    public final E pop() {
        return this.chain.remove(this.size - 1);
    }

    @Override
    public final E pinch() {
        return this.size == 0 ? null : (E)this.chain.remove(0L);
    }

    @Override
    public final E pick() {
        return this.size == 0 ? null : (E)this.chain.remove(this.size - 1);
    }

    @Override
    public final E retrieve(E entry) {
        return this.chain.retrieve(entry);
    }

    @Override
    public final E retrieveBy(Predicate<? super E> predicate) {
        return this.chain.retrieve(predicate);
    }

    @Override
    public final boolean removeOne(E entry) {
        return this.chain.removeOne(entry);
    }

    @Override
    public final HashEnum<E> removeRange(long startIndex, long length) {
        this.chain.removeRange(startIndex, length);
        return this;
    }

    @Override
    public final HashEnum<E> retainRange(long startIndex, long length) {
        this.chain.retainRange(startIndex, length);
        return this;
    }

    @Override
    public final long removeSelection(long[] indices) {
        return this.chain.removeSelection(indices);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.chain.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.chain.toArray();
    }

    @Override
    public final HashEnum<E> reverse() {
        this.chain.reverse();
        return this;
    }

    @Override
    public final HashEnum<E> shiftTo(long sourceIndex, long targetIndex) {
        this.chain.shiftTo(sourceIndex, targetIndex);
        return this;
    }

    @Override
    public final HashEnum<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        this.chain.shiftTo(sourceIndex, targetIndex, length);
        return this;
    }

    @Override
    public final HashEnum<E> shiftBy(long sourceIndex, long distance) {
        this.chain.shiftTo(sourceIndex, distance);
        return this;
    }

    @Override
    public final HashEnum<E> shiftBy(long sourceIndex, long distance, long length) {
        this.chain.shiftTo(sourceIndex, distance, length);
        return this;
    }

    @Override
    public final HashEnum<E> swap(long indexA, long indexB) {
        this.chain.swap(indexA, indexB);
        return this;
    }

    @Override
    public final HashEnum<E> swap(long indexA, long indexB, long length) {
        this.chain.swap(indexA, indexB, length);
        return this;
    }

    @Override
    public final HashEqualator<E> equality() {
        return this.hashEquality();
    }

    @Override
    public final boolean input(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final long inputAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long inputAll(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long inputAll(long index, XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean insert(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final long insertAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long insertAll(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long insertAll(long index, XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean prepend(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                this.chain.moveToStart(e);
                return false;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        this.chain.prependEntry(this.createNewEntry(element));
        return true;
    }

    @Override
    public final boolean preput(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                this.chain.moveToStart(e);
                return false;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        this.chain.prependEntry(this.createNewEntry(element));
        return true;
    }

    @Override
    public final boolean nullInput(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullInsert(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPrepend() {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final HashEnum<E> prependAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final HashEnum<E> prependAll(E[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    @Override
    public final HashEnum<E> prependAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPreput() {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final HashEnum<E> preputAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final HashEnum<E> preputAll(E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final HashEnum<E> preputAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean set(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final E setGet(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setFirst(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setLast(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final HashEnum<E> setAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final HashEnum<E> set(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final HashEnum<E> set(long index, XGettingSequence<? extends E> elements, long offset, long length) {
        throw new NotImplementedYetError();
    }

    public static final <I, E> Function<I, HashEnum<E>> supplier() {
        return new Function<I, HashEnum<E>>(){

            @Override
            public HashEnum<E> apply(I input) {
                return HashEnum.New();
            }
        };
    }

    public static final class OldVarSet<E>
    extends AbstractBridgeXSet<E> {
        OldVarSet(HashEnum<E> set) {
            super(set);
        }

        @Override
        public HashEnum<E> parent() {
            return (HashEnum)super.parent();
        }
    }
}

