/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.collections.AbstractChainEntryLinked;
import one.microstream.collections.AbstractChainKeyValueCollection;
import one.microstream.collections.AbstractChainKeyValueStorage;
import one.microstream.collections.ArrayView;
import one.microstream.collections.BulkList;
import one.microstream.collections.ChainMapEntryLinkedStrongStrong;
import one.microstream.collections.ChainStrongStrongStorage;
import one.microstream.collections.ConstHashEnum;
import one.microstream.collections.ConstHashTable;
import one.microstream.collections.ConstList;
import one.microstream.collections.EnumView;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.HashTable;
import one.microstream.collections.ListView;
import one.microstream.collections.SubListProcessor;
import one.microstream.collections.SubListView;
import one.microstream.collections.TableView;
import one.microstream.collections.XArrays;
import one.microstream.collections.interfaces.CapacityExtendable;
import one.microstream.collections.interfaces.HashCollection;
import one.microstream.collections.old.AbstractBridgeXSet;
import one.microstream.collections.old.AbstractOldSettingList;
import one.microstream.collections.types.XEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XImmutableList;
import one.microstream.collections.types.XIterable;
import one.microstream.collections.types.XList;
import one.microstream.collections.types.XTable;
import one.microstream.equality.Equalator;
import one.microstream.equality.IdentityEqualator;
import one.microstream.equality.IdentityEqualityLogic;
import one.microstream.exceptions.ArrayCapacityException;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.functional.XFunc;
import one.microstream.hashing.HashEqualator;
import one.microstream.hashing.XHashing;
import one.microstream.math.XMath;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.Composition;
import one.microstream.typing.Copyable;
import one.microstream.typing.KeyValue;
import one.microstream.typing.XTypes;

public final class HashTable<K, V>
extends AbstractChainKeyValueCollection<K, V, ChainMapEntryLinkedStrongStrong<K, V>>
implements XTable<K, V>,
HashCollection<K>,
Composition,
IdentityEqualityLogic {
    final AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedStrongStrong<K, V>> chain;
    ChainMapEntryLinkedStrongStrong<K, V>[] slots;
    float hashDensity;
    int capacity;
    int range;
    int size;
    final Keys keys = new Keys();
    final Values values = new Values();

    public static final <K, V> HashTable<K, V> New() {
        return new HashTable<K, V>(1, 1.0f);
    }

    public static final <K, V> HashTable<K, V> NewCustom(int initialHashLength) {
        return new HashTable<K, V>(XHashing.padHashLength(initialHashLength), 1.0f);
    }

    public static final <K, V> HashTable<K, V> NewCustom(float hashDensity) {
        return new HashTable<K, V>(1, XHashing.validateHashDensity(hashDensity));
    }

    public static final <K, V> HashTable<K, V> NewCustom(int initialHashLength, float hashDensity) {
        return new HashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity));
    }

    public static final <K, V> HashTable<K, V> New(XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return HashTable.New().internalAddEntries(entries);
    }

    public static final <K, V> HashTable<K, V> NewCustom(int initialHashLength, float hashDensity, XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new HashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity)).internalAddEntries(entries);
    }

    public static final <K, V> HashTable<K, V> NewSingle(K key, V value) {
        HashTable<K, V> instance = HashTable.New();
        instance.internalAdd(key, value);
        return instance;
    }

    @SafeVarargs
    public static final <K, V> HashTable<K, V> New(KeyValue<? extends K, ? extends V> ... entries) {
        return HashTable.New().internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    @SafeVarargs
    public static final <K, V> HashTable<K, V> NewCustom(long desiredCapacity, float hashDensity, KeyValue<? extends K, ? extends V> ... entries) {
        return new HashTable<K, V>(XHashing.calculateHashLength(desiredCapacity, hashDensity), XHashing.validateHashDensity(hashDensity)).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    public static final <K, VK, VV> Function<K, HashTable<VK, VV>> supplier() {
        return new Function<K, HashTable<VK, VV>>(){

            @Override
            public final HashTable<VK, VV> apply(K key) {
                return HashTable.New();
            }
        };
    }

    public static final <KI, VI, KO, VO> HashTable<KO, VO> NewProjected(float hashDensity, XGettingCollection<? extends KeyValue<KI, VI>> entries, Function<? super KI, KO> keyProjector, Function<? super VI, VO> valueProjector) {
        HashTable newMap = new HashTable(1, XHashing.validateHashDensity(hashDensity));
        entries.iterate(e -> newMap.internalAdd(keyProjector.apply((Object)e.key()), valueProjector.apply((Object)e.value())));
        return newMap;
    }

    public static final <KO, VO, KI extends KO, VI extends VO> HashTable<KO, VO> NewProjected(XGettingCollection<? extends KeyValue<KI, VI>> entries) {
        return HashTable.NewProjected(entries, XFunc.passThrough(), XFunc.passThrough());
    }

    public static final <KI, VI, KO, VO> HashTable<KO, VO> NewProjected(XGettingCollection<? extends KeyValue<KI, VI>> entries, Function<? super KI, KO> keyProjector, Function<? super VI, VO> valueProjector) {
        return HashTable.NewProjected(entries instanceof HashCollection ? ((HashCollection)((Object)entries)).hashDensity() : 1.0f, entries, keyProjector, valueProjector);
    }

    private HashTable(HashTable<K, V> original) {
        this.hashDensity = original.hashDensity;
        this.range = original.range;
        this.slots = ChainMapEntryLinkedStrongStrong.array(original.slots.length);
        this.chain = new ChainStrongStrongStorage(this, new ChainMapEntryLinkedStrongStrong<Object, Object>(null, null, null));
        this.capacity = original.capacity;
    }

    private HashTable(int pow2InitialCapacity, float positiveHashDensity) {
        this.hashDensity = positiveHashDensity;
        this.range = pow2InitialCapacity - 1;
        this.slots = ChainMapEntryLinkedStrongStrong.array(pow2InitialCapacity);
        this.chain = new ChainStrongStrongStorage(this, new ChainMapEntryLinkedStrongStrong<Object, Object>(null, null, null));
        this.capacity = (int)((float)pow2InitialCapacity * positiveHashDensity);
    }

    final void internalAdd(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
    }

    final HashTable<K, V> internalAddEntries(XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        entries.iterate(new Consumer<KeyValue<? extends K, ? extends V>>(){

            @Override
            public void accept(KeyValue<? extends K, ? extends V> e) {
                HashTable.this.internalAdd(e.key(), e.value());
            }
        });
        return this;
    }

    private ChainMapEntryLinkedStrongStrong<K, V> createNewEntry(K key, V value) {
        if (this.size >= this.capacity) {
            HashTable.ensureFreeArrayCapacity(this.size);
            this.increaseStorage();
        }
        ChainMapEntryLinkedStrongStrong<K, V> e = new ChainMapEntryLinkedStrongStrong<K, V>(key, value, this.slots[System.identityHashCode(key) & this.range]);
        this.slots[System.identityHashCode(key) & this.range] = e;
        ++this.size;
        return e;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.slots.length * 2.0f));
    }

    private void rebuildStorage(int newSlotLength) {
        ChainMapEntryLinkedStrongStrong<K, V>[] newSlots = ChainMapEntryLinkedStrongStrong.array(newSlotLength);
        int modulo = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : newSlotLength - 1;
        ChainMapEntryLinkedStrongStrong entry = (ChainMapEntryLinkedStrongStrong)this.chain.head();
        while ((entry = (ChainMapEntryLinkedStrongStrong)entry.next) != null) {
            entry.link = newSlots[System.identityHashCode(entry.key) & modulo];
            newSlots[System.identityHashCode(entry.key) & modulo] = entry;
        }
        this.capacity = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)newSlotLength * this.hashDensity);
        this.slots = newSlots;
        this.range = modulo;
    }

    final boolean internalAddOnlyKey(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return false;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, null));
        return true;
    }

    final boolean internalPutOnlyKey(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                e.setKey(key);
                return false;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, null));
        return true;
    }

    final K internalPutGetKey(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e.setKey(key);
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, null));
        return null;
    }

    final K internalAddGetKey(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return key;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, null));
        return null;
    }

    final K internalReplaceKey(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return key;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    final K internalSubstituteKey(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return key;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, null));
        return key;
    }

    final V oldPutGet(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e.setValue(value);
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
        return null;
    }

    @Override
    public final KeyValue<K, V> lookup(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    final boolean containsKey(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return true;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return false;
    }

    final int removeKey(K key) {
        int hash = System.identityHashCode(key);
        ChainMapEntryLinkedStrongStrong e = this.slots[hash & this.range];
        if (e == null) {
            return 0;
        }
        if (e.key() == key) {
            this.slots[hash & this.range] = (ChainMapEntryLinkedStrongStrong)e.link;
            this.chain.disjoinEntry(e);
            --this.size;
            return 1;
        }
        ChainMapEntryLinkedStrongStrong last = e;
        e = (ChainMapEntryLinkedStrongStrong)last.link;
        while (e != null) {
            if (e.key() == key) {
                last.link = (ChainMapEntryLinkedStrongStrong)e.link;
                this.chain.disjoinEntry(e);
                --this.size;
                return 1;
            }
            last = e;
            e = (ChainMapEntryLinkedStrongStrong)last.link;
        }
        return 0;
    }

    final void removeNullEntry() {
        this.removeFor(null);
    }

    boolean nullKeyPut() {
        return this.internalPutOnlyKey(null);
    }

    boolean nullKeyAdd() {
        return this.internalAddOnlyKey(null);
    }

    protected int internalCountingAddAll(KeyValue<K, V>[] elements) throws UnsupportedOperationException {
        return this.internalCountingAddAll(elements, 0, elements.length);
    }

    protected int internalCountingAddAll(KeyValue<K, V>[] elements, int offset, int length) throws UnsupportedOperationException {
        int bound = offset + length;
        int count = 0;
        int i = offset;
        while (i < bound) {
            if (this.add(elements[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends KeyValue<K, V>> elements) throws UnsupportedOperationException {
        return elements.iterate(new Consumer<KeyValue<K, V>>(){
            int count;

            @Override
            public void accept(KeyValue<K, V> e) {
                if (HashTable.this.add(e)) {
                    ++this.count;
                }
            }
        }).count;
    }

    protected int internalCountingPutAll(KeyValue<K, V>[] elements) throws UnsupportedOperationException {
        return this.internalCountingAddAll(elements, 0, elements.length);
    }

    protected int internalCountingPutAll(KeyValue<K, V>[] elements, int offset, int length) throws UnsupportedOperationException {
        int bound = offset + length;
        int count = 0;
        int i = offset;
        while (i < bound) {
            if (this.put(elements[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends KeyValue<K, V>> elements) throws UnsupportedOperationException {
        return elements.iterate(new Consumer<KeyValue<K, V>>(){
            int count;

            @Override
            public void accept(KeyValue<K, V> e) {
                if (HashTable.this.put(e)) {
                    ++this.count;
                }
            }
        }).count;
    }

    @Override
    protected int internalRemoveNullEntries() {
        return this.removeKey(null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void internalRemoveEntry(ChainMapEntryLinkedStrongStrong<K, V> entry) {
        block3: {
            setEntry = entry;
            e = this.slots[System.identityHashCode(setEntry.key) & this.range];
            if (e != setEntry) ** GOTO lbl9
            this.slots[System.identityHashCode(setEntry.key) & this.range] = (ChainMapEntryLinkedStrongStrong)setEntry.link;
            break block3;
lbl-1000:
            // 1 sources

            {
                if (e == setEntry) {
                    last.link = (ChainMapEntryLinkedStrongStrong)setEntry.link;
                    break;
                }
lbl9:
                // 3 sources

                last = e;
                ** while ((e = (ChainMapEntryLinkedStrongStrong)last.link) != null)
            }
lbl11:
            // 2 sources

            if (e == null) {
                throw new IllegalArgumentException("Entry inconsistency detected");
            }
        }
        --this.size;
        this.chain.disjoinEntry(setEntry);
    }

    @Override
    protected int internalClear() {
        int size = this.size;
        this.clear();
        return size;
    }

    protected AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedStrongStrong<K, V>> getInternalStorageChain() {
        return this.chain;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final int rehash() {
        this.optimize();
        return XTypes.to_int(this.size());
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final void clear() {
        this.chain.clear();
        ChainMapEntryLinkedStrongStrong<K, V>[] slots = this.slots;
        int i = 0;
        int length = slots.length;
        while (i < length) {
            slots[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public final void truncate() {
        this.chain.clear();
        this.slots = ChainMapEntryLinkedStrongStrong.array(1);
        this.size = 0;
        this.capacity = (int)(1.0f * this.hashDensity);
    }

    @Override
    public final long consolidate() {
        return this.chain.consolidate();
    }

    @Override
    public final CapacityExtendable ensureCapacity(long minimalCapacity) {
        if ((long)this.capacity >= minimalCapacity) {
            return this;
        }
        int requiredSlotLength = (int)((float)minimalCapacity / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredSlotLength)) {
            this.rebuildStorage(Integer.MAX_VALUE);
            return this;
        }
        int newSlotsLength = this.slots.length;
        while (newSlotsLength < requiredSlotLength) {
            newSlotsLength <<= 1;
        }
        this.rebuildStorage(newSlotsLength);
        return this;
    }

    @Override
    public final CapacityExtendable ensureFreeCapacity(long requiredFreeCapacity) {
        if ((long)(this.capacity - this.size) >= requiredFreeCapacity) {
            return this;
        }
        if ((long)(Integer.MAX_VALUE - this.size) < requiredFreeCapacity) {
            throw new ArrayCapacityException(requiredFreeCapacity + (long)this.size);
        }
        int requiredSlotLength = (int)((float)((long)this.size + requiredFreeCapacity) / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredSlotLength)) {
            this.rebuildStorage(Integer.MAX_VALUE);
            return this;
        }
        int newSlotsLength = this.slots.length;
        while (newSlotsLength < requiredSlotLength) {
            newSlotsLength <<= 1;
        }
        this.rebuildStorage(newSlotsLength);
        return this;
    }

    @Override
    public final long optimize() {
        int requiredCapacity = (int)((float)this.size / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredCapacity)) {
            if (this.slots.length != Integer.MAX_VALUE) {
                this.rebuildStorage(Integer.MAX_VALUE);
            }
            return this.capacity;
        }
        int newCapacity = XHashing.padHashLength(requiredCapacity);
        if (this.slots.length != newCapacity) {
            this.rebuildStorage(newCapacity);
        }
        return this.capacity;
    }

    @Override
    public final HashTable<K, V> copy() {
        final HashTable<K, V> newVarMap = new HashTable<K, V>(this);
        this.chain.iterate(new Consumer<KeyValue<K, V>>(){

            @Override
            public void accept(KeyValue<K, V> entry) {
                newVarMap.put(entry.key(), entry.value());
            }
        });
        return newVarMap;
    }

    @Override
    public final ConstHashTable<K, V> immure() {
        this.consolidate();
        return ConstHashTable.NewCustom(this.size, this.hashDensity, this);
    }

    @Override
    public final XGettingTable<K, V> view() {
        return new TableView(this);
    }

    @Override
    public final void setHashDensity(float hashDensity) {
        this.hashDensity = XHashing.validateHashDensity(hashDensity);
        this.capacity = (int)((float)this.slots.length * this.hashDensity);
        this.optimize();
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final boolean nullAllowed() {
        return true;
    }

    @Override
    public final boolean nullKeyAllowed() {
        return true;
    }

    @Override
    public final boolean nullValuesAllowed() {
        return true;
    }

    @Override
    public final V get(K key) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e.value();
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final V ensure(K key, Function<? super K, V> valueProvider) {
        V value = this.get(key);
        if (value == null) {
            value = valueProvider.apply(key);
            this.add(key, value);
        }
        return value;
    }

    @Override
    public final Keys keys() {
        return this.keys;
    }

    @Override
    public final XTable.EntriesBridge<K, V> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public XTable.Bridge<K, V> oldMap() {
        return new OldVarMap();
    }

    @Override
    public final V searchValue(final Predicate<? super K> keyPredicate) {
        KeyValue foundEntry = (KeyValue)this.chain.search(new Predicate<KeyValue<K, V>>(){

            @Override
            public boolean test(KeyValue<K, V> entry) {
                return keyPredicate.test(entry.key());
            }
        });
        return foundEntry != null ? (V)foundEntry.value() : null;
    }

    @Override
    public final <C extends Consumer<? super V>> C query(XIterable<? extends K> keys, final C collector) {
        keys.iterate(new Consumer<K>(){

            @Override
            public void accept(K key) {
                collector.accept(HashTable.this.get(key));
            }
        });
        return collector;
    }

    @Override
    public final Values values() {
        return this.values;
    }

    @Override
    public final long currentCapacity() {
        return this.capacity;
    }

    @Override
    public final long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public final boolean hasVolatileValues() {
        return this.chain.hasVolatileValues();
    }

    @Override
    public final KeyValue<K, V> addGet(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
        return null;
    }

    @Override
    public final KeyValue<K, V> substitute(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
        return X.KeyValue(key, value);
    }

    @Override
    public final KeyValue<K, V> putGet(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return X.KeyValue(e.setKey(key), e.setValue(value));
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
        return null;
    }

    @Override
    public final KeyValue<K, V> replace(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return X.KeyValue(e.setKey(key), e.setValue(value));
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final KeyValue<K, V> setGet(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return X.KeyValue(e.setKey(key), e.setValue(value));
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean add(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return false;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
        return true;
    }

    @Override
    public final boolean put(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                e.set0(key, value);
                return false;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
        return true;
    }

    @Override
    public final boolean set(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                e.set0(key, value);
                return true;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean valuePut(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                e.setValue0(value);
                return false;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
        return true;
    }

    @Override
    public final boolean valueSet(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                e.setValue0(value);
                return true;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final V valuePutGet(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e.setValue(value);
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(key, value));
        return null;
    }

    @Override
    public final V valueSetGet(K key, V value) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(key) & this.range];
        while (e != null) {
            if (e.key() == key) {
                return e.setValue(value);
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final V removeFor(K key) {
        int hash = System.identityHashCode(key);
        ChainMapEntryLinkedStrongStrong e = this.slots[hash & this.range];
        if (e == null) {
            return null;
        }
        if (e.key() == key) {
            this.slots[hash & this.range] = (ChainMapEntryLinkedStrongStrong)e.link;
            this.chain.disjoinEntry(e);
            --this.size;
            return e.value();
        }
        ChainMapEntryLinkedStrongStrong last = e;
        e = (ChainMapEntryLinkedStrongStrong)last.link;
        while (e != null) {
            if (e.key() == key) {
                last.link = (ChainMapEntryLinkedStrongStrong)e.link;
                this.chain.disjoinEntry(e);
                --this.size;
                return e.value();
            }
            last = e;
            e = (ChainMapEntryLinkedStrongStrong)last.link;
        }
        return null;
    }

    @Override
    public final HashCollection.Analysis<HashTable<K, V>> analyze() {
        return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])this.slots);
    }

    @Override
    public final int hashDistributionRange() {
        return this.slots.length;
    }

    @Override
    public final HashEqualator<K> hashEquality() {
        return XHashing.hashEqualityIdentity();
    }

    @Override
    public final float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final boolean hasVolatileHashElements() {
        return this.chain.hasVolatileElements();
    }

    public final String toString() {
        return this.chain.appendTo(VarString.New(this.slots.length).append('{'), ",").append('}').toString();
    }

    public final Predicate<KeyValue<K, V>> predicateContainsEntry() {
        return entry -> {
            KeyValue kv = this.lookup(entry.key());
            if (kv == null) {
                return false;
            }
            return kv.key() == entry.key() && kv.value() == entry.value();
        };
    }

    @Override
    public final HashTable<K, V> sort(Comparator<? super KeyValue<K, V>> comparator) {
        this.chain.sort(comparator);
        return this;
    }

    @Override
    public final XEnum<KeyValue<K, V>> range(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XGettingEnum<KeyValue<K, V>> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    public final KeyValue<K, V>[] toArray(Class<KeyValue<K, V>> type) {
        return this.chain.toArray(type);
    }

    @Override
    public final <P extends Consumer<? super KeyValue<K, V>>> P iterate(P procedure) {
        this.chain.iterate(procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super KeyValue<K, V>, ? super A> joiner, A aggregate) {
        this.chain.join(joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(KeyValue<K, V> entry) {
        return this.chain.count(entry);
    }

    @Override
    public final long countBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.count(predicate);
    }

    @Override
    public final KeyValue<K, V> search(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.search(predicate);
    }

    @Override
    public final KeyValue<K, V> max(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.max(comparator);
    }

    @Override
    public final KeyValue<K, V> min(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.min(comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.appliesAll(predicate);
    }

    @Override
    public final boolean nullContained() {
        return false;
    }

    @Override
    public final boolean containsId(KeyValue<K, V> entry) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(entry.key()) & this.range];
        while (e != null) {
            if (entry == e.key()) {
                return true;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean contains(KeyValue<K, V> entry) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(entry.key()) & this.range];
        while (e != null) {
            if (e.key() == entry.key()) {
                return true;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final KeyValue<K, V> seek(KeyValue<K, V> sample) {
        if (sample == null) {
            return null;
        }
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(sample.key()) & this.range];
        while (e != null) {
            if (e.key() == sample.key()) {
                return e;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        return elements.applies(this.predicateContainsEntry());
    }

    @Override
    public final boolean equals(XGettingCollection<? extends KeyValue<K, V>> samples, Equalator<? super KeyValue<K, V>> equalator) {
        if (samples == null || !(samples instanceof Keys)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return this.equalsContent(samples, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends KeyValue<K, V>> samples, Equalator<? super KeyValue<K, V>> equalator) {
        this.consolidate();
        if (this.size != XTypes.to_int(samples.size())) {
            return false;
        }
        return this.chain.equalsContent(samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C intersect(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.intersect(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C except(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.except(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C union(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C copyTo(C target) {
        if (target == this) {
            return target;
        }
        return this.chain.copyTo(target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C filterTo(C target, Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.copyTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C distinct(C target) {
        return this.chain.distinct(target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C distinct(C target, Equalator<? super KeyValue<K, V>> equalator) {
        return this.chain.distinct(target, equalator);
    }

    @Override
    public final boolean nullAdd() {
        return this.nullKeyAdd();
    }

    @Override
    public final boolean add(KeyValue<K, V> entry) {
        return this.add(entry.key(), entry.value());
    }

    @Override
    @SafeVarargs
    public final HashTable<K, V> addAll(KeyValue<K, V> ... elements) {
        HashTable parent = this;
        int i = 0;
        int len = elements.length;
        while (i < len) {
            parent.add(elements[i].key(), elements[i].value());
            ++i;
        }
        return this;
    }

    @Override
    public final HashTable<K, V> addAll(KeyValue<K, V>[] elements, int srcIndex, int srcLength) {
        int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
        if (d == 0) {
            return this;
        }
        int bound = srcIndex + srcLength;
        HashTable parent = this;
        int i = srcIndex;
        while (i != bound) {
            parent.add(elements[i].key(), elements[i].value());
            i += d;
        }
        return this;
    }

    @Override
    public final HashTable<K, V> addAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        elements.iterate(this::add);
        return this;
    }

    @Override
    public final boolean nullPut() {
        return this.nullKeyPut();
    }

    @Override
    public final void accept(KeyValue<K, V> entry) {
        this.put(entry.key(), entry.value());
    }

    @Override
    public final boolean put(KeyValue<K, V> entry) {
        return this.put(entry.key(), entry.value());
    }

    @Override
    public final KeyValue<K, V> addGet(KeyValue<K, V> entry) {
        return this.addGet(entry.key(), entry.value());
    }

    @Override
    public final KeyValue<K, V> deduplicate(KeyValue<K, V> entry) {
        ChainMapEntryLinkedStrongStrong e = this.slots[System.identityHashCode(entry.key()) & this.range];
        while (e != null) {
            if (e.key() == entry.key()) {
                return e;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(entry.key(), entry.value()));
        return entry;
    }

    @Override
    public final KeyValue<K, V> putGet(KeyValue<K, V> entry) {
        return this.putGet(entry.key(), entry.value());
    }

    @Override
    public final KeyValue<K, V> replace(KeyValue<K, V> entry) {
        return this.replace(entry.key(), entry.value());
    }

    @Override
    @SafeVarargs
    public final HashTable<K, V> putAll(KeyValue<K, V> ... elements) {
        HashTable parent = this;
        int i = 0;
        int len = elements.length;
        while (i < len) {
            parent.put(elements[i].key(), elements[i].value());
            ++i;
        }
        return this;
    }

    @Override
    public final HashTable<K, V> putAll(KeyValue<K, V>[] elements, int srcIndex, int srcLength) {
        int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
        if (d == 0) {
            return this;
        }
        int bound = srcIndex + srcLength;
        HashTable parent = this;
        int i = srcIndex;
        while (i != bound) {
            parent.put(elements[i].key(), elements[i].value());
            i += d;
        }
        return this;
    }

    @Override
    public final HashTable<K, V> putAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        elements.iterate(this::put);
        return this;
    }

    @Override
    public final long remove(KeyValue<K, V> entry) {
        return this.chain.remove(entry);
    }

    @Override
    public final long nullRemove() {
        return 0L;
    }

    @Override
    public final long removeBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.reduce(predicate);
    }

    @Override
    public final long retainAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        return this.chain.retainAll(elements);
    }

    @Override
    public final <P extends Consumer<? super KeyValue<K, V>>> P process(P procedure) {
        this.chain.process(procedure);
        return procedure;
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C moveTo(C target, Predicate<? super KeyValue<K, V>> predicate) {
        this.chain.moveTo(target, predicate);
        return target;
    }

    @Override
    public final long removeAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        int oldSize = this.size;
        elements.iterate(this::remove);
        return oldSize - this.size;
    }

    @Override
    public final long removeDuplicates() {
        return 0L;
    }

    @Override
    public final long removeDuplicates(Equalator<? super KeyValue<K, V>> equalator) {
        return this.chain.removeDuplicates(equalator);
    }

    @Override
    public final HashTable<K, V> toReversed() {
        Copyable reversedVarSet = this.copy();
        ((HashTable)reversedVarSet).chain.reverse();
        return reversedVarSet;
    }

    @Override
    public final <T extends Consumer<? super KeyValue<K, V>>> T copySelection(T target, long ... indices) {
        this.chain.copySelection(target, indices);
        return target;
    }

    @Override
    public final <P extends IndexedAcceptor<? super KeyValue<K, V>>> P iterateIndexed(P procedure) {
        this.chain.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final KeyValue<K, V> at(long index) {
        return (KeyValue)this.chain.get(index);
    }

    @Override
    public final KeyValue<K, V> get() {
        return (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> first() {
        return (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> last() {
        return (KeyValue)this.chain.last();
    }

    @Override
    public final KeyValue<K, V> poll() {
        return this.size == 0 ? null : (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> peek() {
        return this.size == 0 ? null : (KeyValue)this.chain.last();
    }

    @Override
    public final long indexOf(KeyValue<K, V> entry) {
        return this.chain.indexOf(entry);
    }

    @Override
    public final long indexBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.indexOf(predicate);
    }

    @Override
    public final boolean isSorted(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.isSorted(comparator);
    }

    @Override
    public final long lastIndexOf(KeyValue<K, V> entry) {
        return this.chain.lastIndexOf(entry);
    }

    @Override
    public final long lastIndexBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.lastIndexBy(predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.maxIndex(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.minIndex(comparator);
    }

    @Override
    public final long scan(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.scan(predicate);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C moveSelection(C target, long ... indices) {
        this.chain.moveSelection(target, indices);
        return target;
    }

    @Override
    public final KeyValue<K, V> removeAt(long index) {
        return (KeyValue)this.chain.remove(index);
    }

    @Override
    public final KeyValue<K, V> fetch() {
        return (KeyValue)this.chain.remove(0L);
    }

    @Override
    public final KeyValue<K, V> pop() {
        return (KeyValue)this.chain.remove(this.size - 1);
    }

    @Override
    public final KeyValue<K, V> pinch() {
        return this.size == 0 ? null : (KeyValue)this.chain.remove(0L);
    }

    @Override
    public final KeyValue<K, V> pick() {
        return this.size == 0 ? null : (KeyValue)this.chain.remove(this.size - 1);
    }

    @Override
    public final KeyValue<K, V> retrieve(KeyValue<K, V> entry) {
        return this.chain.retrieve(entry);
    }

    @Override
    public final KeyValue<K, V> retrieveBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.retrieve(predicate);
    }

    @Override
    public final boolean removeOne(KeyValue<K, V> entry) {
        return this.chain.removeOne(entry);
    }

    public final HashTable<K, V> removeRange(long startIndex, long length) {
        this.chain.removeRange(startIndex, length);
        return this;
    }

    public final HashTable<K, V> retainRange(long startIndex, long length) {
        this.chain.retainRange(startIndex, length);
        return this;
    }

    @Override
    public final long removeSelection(long[] indices) {
        return this.chain.removeSelection(indices);
    }

    @Override
    public final Iterator<KeyValue<K, V>> iterator() {
        return this.chain.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.chain.toArray();
    }

    @Override
    public final HashTable<K, V> reverse() {
        this.chain.reverse();
        return this;
    }

    @Override
    public final HashTable<K, V> shiftTo(long sourceIndex, long targetIndex) {
        this.chain.shiftTo(sourceIndex, targetIndex);
        return this;
    }

    @Override
    public final HashTable<K, V> shiftTo(long sourceIndex, long targetIndex, long length) {
        this.chain.shiftTo(sourceIndex, targetIndex, length);
        return this;
    }

    @Override
    public final HashTable<K, V> shiftBy(long sourceIndex, long distance) {
        this.chain.shiftTo(sourceIndex, distance);
        return this;
    }

    @Override
    public final HashTable<K, V> shiftBy(long sourceIndex, long distance, long length) {
        this.chain.shiftTo(sourceIndex, distance, length);
        return this;
    }

    @Override
    public final HashTable<K, V> swap(long indexA, long indexB) {
        this.chain.swap(indexA, indexB);
        return this;
    }

    @Override
    public final HashTable<K, V> swap(long indexA, long indexB, long length) {
        this.chain.swap(indexA, indexB, length);
        return this;
    }

    @Override
    public final HashEqualator<KeyValue<K, V>> equality() {
        return XHashing.keyValueHashEqualityKeyIdentity();
    }

    @Override
    public final boolean input(long index, KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final long inputAll(long index, KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final long inputAll(long index, KeyValue<K, V>[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long inputAll(long index, XGettingCollection<? extends KeyValue<K, V>> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean insert(long index, KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final long insertAll(long index, KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final long insertAll(long index, KeyValue<K, V>[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long insertAll(long index, XGettingCollection<? extends KeyValue<K, V>> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean prepend(KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean preput(KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullInput(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullInsert(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPrepend() {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final HashTable<K, V> prependAll(KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final HashTable<K, V> prependAll(KeyValue<K, V>[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    public final HashTable<K, V> prependAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPreput() {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final HashTable<K, V> preputAll(KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final HashTable<K, V> preputAll(KeyValue<K, V>[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    public final HashTable<K, V> preputAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean set(long index, KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final KeyValue<K, V> setGet(long index, KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setFirst(KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setLast(KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final HashTable<K, V> setAll(long index, KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final HashTable<K, V> set(long index, KeyValue<K, V>[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    public final HashTable<K, V> set(long index, XGettingSequence<? extends KeyValue<K, V>> elements, long offset, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public long substitute(Function<? super KeyValue<K, V>, ? extends KeyValue<K, V>> mapper) {
        throw new NotImplementedYetError();
    }

    final void replace(ChainMapEntryLinkedStrongStrong<K, V> oldEntry, K newElement) {
        int newHash = System.identityHashCode(newElement);
        ChainMapEntryLinkedStrongStrong e = this.slots[newHash & this.range];
        while (e != null) {
            if (e.key == newElement && e == oldEntry) {
                e.setKey0(newElement);
                return;
            }
            e = (ChainMapEntryLinkedStrongStrong)e.link;
        }
        throw new UnsupportedOperationException("Hash-changing replacement not supported, yet.");
    }

    public static interface Creator<K, V> {
        public HashTable<K, V> newInstance();
    }

    public final class Keys
    implements XTable.Keys<K, V>,
    HashCollection<K> {
        @Override
        public final int hashDistributionRange() {
            return HashTable.this.slots.length;
        }

        @Override
        public final boolean hasVolatileHashElements() {
            return HashTable.this.chain.hasVolatileElements();
        }

        @Override
        public final void setHashDensity(float hashDensity) {
            HashTable.this.setHashDensity(hashDensity);
        }

        @Override
        public final HashCollection.Analysis<Keys> analyze() {
            return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])HashTable.this.slots);
        }

        @Override
        public final Equalator<? super K> equality() {
            return HashTable.this.hashEquality();
        }

        @Override
        public final Keys copy() {
            return ((HashTable)HashTable.this.copy()).keys();
        }

        @Override
        public final ConstHashEnum<K> immure() {
            this.consolidate();
            return ConstHashEnum.NewCustom(HashTable.this.hashDensity, this);
        }

        @Override
        public final XGettingEnum<K> view() {
            return new EnumView(this);
        }

        @Override
        public final XEnum<K> range(long lowIndex, long highIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final XGettingEnum<K> view(long lowIndex, long highIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final K[] toArray(Class<K> type) {
            return HashTable.this.chain.keyToArray(type);
        }

        @Override
        public final <P extends Consumer<? super K>> P iterate(P procedure) {
            HashTable.this.chain.keyIterate(procedure);
            return procedure;
        }

        @Override
        public final <A> A join(BiConsumer<? super K, ? super A> joiner, A aggregate) {
            HashTable.this.chain.keyJoin(joiner, aggregate);
            return aggregate;
        }

        @Override
        public final long count(K element) {
            return this.contains((K)element) ? 1 : 0;
        }

        @Override
        public final long countBy(Predicate<? super K> predicate) {
            return HashTable.this.chain.keyCount(predicate);
        }

        @Override
        public final K seek(K sample) {
            return HashTable.this.chain.keySeek(sample);
        }

        @Override
        public final K search(Predicate<? super K> predicate) {
            return HashTable.this.chain.keySearch(predicate);
        }

        @Override
        public final K max(Comparator<? super K> comparator) {
            return HashTable.this.chain.keyMax(comparator);
        }

        @Override
        public final K min(Comparator<? super K> comparator) {
            return HashTable.this.chain.keyMin(comparator);
        }

        @Override
        public final boolean hasVolatileElements() {
            return HashTable.this.chain.hasVolatileElements();
        }

        @Override
        public final boolean nullAllowed() {
            return true;
        }

        @Override
        public final boolean containsSearched(Predicate<? super K> predicate) {
            return HashTable.this.chain.keyApplies(predicate);
        }

        @Override
        public final boolean applies(Predicate<? super K> predicate) {
            return HashTable.this.chain.keyAppliesAll(predicate);
        }

        @Override
        public final boolean nullContained() {
            return this.contains((K)null);
        }

        @Override
        public final boolean containsId(K element) {
            ChainMapEntryLinkedStrongStrong e = HashTable.this.slots[System.identityHashCode(element) & HashTable.this.range];
            while (e != null) {
                if (element == e.key()) {
                    return true;
                }
                e = (ChainMapEntryLinkedStrongStrong)e.link;
            }
            return false;
        }

        @Override
        public final boolean contains(K element) {
            ChainMapEntryLinkedStrongStrong e = HashTable.this.slots[System.identityHashCode(element) & HashTable.this.range];
            while (e != null) {
                if (e.key() == element) {
                    return true;
                }
                e = (ChainMapEntryLinkedStrongStrong)e.link;
            }
            return false;
        }

        @Override
        public final boolean containsAll(XGettingCollection<? extends K> elements) {
            return elements.applies(HashTable.this::containsKey);
        }

        @Override
        public final boolean equals(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
            if (samples == null || !(samples instanceof Keys)) {
                return false;
            }
            if (samples == this) {
                return true;
            }
            return this.equalsContent(samples, equalator);
        }

        @Override
        public final boolean equalsContent(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
            this.consolidate();
            if (HashTable.this.size != XTypes.to_int(samples.size())) {
                return false;
            }
            return HashTable.this.chain.keyEqualsContent(samples, equalator);
        }

        @Override
        public final <C extends Consumer<? super K>> C intersect(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return HashTable.this.chain.keyIntersect(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C except(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return HashTable.this.chain.keyExcept(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C union(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return HashTable.this.chain.keyUnion(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C copyTo(C target) {
            if (target == this) {
                return target;
            }
            return HashTable.this.chain.keyCopyTo(target);
        }

        @Override
        public final <C extends Consumer<? super K>> C filterTo(C target, Predicate<? super K> predicate) {
            return HashTable.this.chain.keyCopyTo(target, predicate);
        }

        @Override
        public final <C extends Consumer<? super K>> C distinct(C target) {
            return HashTable.this.chain.keyDistinct(target);
        }

        @Override
        public final <C extends Consumer<? super K>> C distinct(C target, Equalator<? super K> equalator) {
            if (equalator instanceof IdentityEqualator) {
                return this.copyTo(target);
            }
            return HashTable.this.chain.keyDistinct(target, equalator);
        }

        @Override
        public final long currentCapacity() {
            return HashTable.this.currentCapacity();
        }

        @Override
        public final long maximumCapacity() {
            return HashTable.this.maximumCapacity();
        }

        @Override
        public final boolean isFull() {
            return HashTable.this.isFull();
        }

        @Override
        public final long optimize() {
            return HashTable.this.optimize();
        }

        @Override
        public final Keys ensureFreeCapacity(long requiredFreeCapacity) {
            HashTable.this.ensureFreeCapacity(requiredFreeCapacity);
            return this;
        }

        @Override
        public final Keys ensureCapacity(long minimalCapacity) {
            HashTable.this.ensureCapacity(minimalCapacity);
            return this;
        }

        @Override
        public final boolean nullAdd() {
            return HashTable.this.nullKeyAdd();
        }

        @Override
        public final boolean add(K element) {
            return HashTable.this.internalAddOnlyKey(element);
        }

        @SafeVarargs
        public final Keys addAll(K ... elements) {
            HashTable parent = HashTable.this;
            int i = 0;
            int len = elements.length;
            while (i < len) {
                parent.internalAddOnlyKey(elements[i]);
                ++i;
            }
            return this;
        }

        public final Keys addAll(K[] elements, int srcIndex, int srcLength) {
            int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
            if (d == 0) {
                return this;
            }
            int bound = srcIndex + srcLength;
            HashTable parent = HashTable.this;
            int i = srcIndex;
            while (i != bound) {
                parent.internalAddOnlyKey(elements[i]);
                i += d;
            }
            return this;
        }

        public final Keys addAll(XGettingCollection<? extends K> elements) {
            elements.iterate(HashTable.this::internalAddOnlyKey);
            return this;
        }

        @Override
        public final boolean nullPut() {
            return HashTable.this.nullKeyPut();
        }

        @Override
        public final void accept(K element) {
            HashTable.this.internalPutOnlyKey(element);
        }

        @Override
        public final boolean put(K element) {
            return HashTable.this.internalPutOnlyKey(element);
        }

        @Override
        public final K addGet(K element) {
            return HashTable.this.internalAddGetKey(element);
        }

        @Override
        public final K deduplicate(K element) {
            return HashTable.this.internalSubstituteKey(element);
        }

        @Override
        public final K putGet(K element) {
            return HashTable.this.internalPutGetKey(element);
        }

        @Override
        public K replace(K element) {
            return HashTable.this.internalReplaceKey(element);
        }

        @SafeVarargs
        public final Keys putAll(K ... elements) {
            HashTable parent = HashTable.this;
            int i = 0;
            int len = elements.length;
            while (i < len) {
                parent.internalPutOnlyKey(elements[i]);
                ++i;
            }
            return this;
        }

        public final Keys putAll(K[] elements, int srcIndex, int srcLength) {
            int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
            if (d == 0) {
                return this;
            }
            int bound = srcIndex + srcLength;
            HashTable parent = HashTable.this;
            int i = srcIndex;
            while (i != bound) {
                parent.internalPutOnlyKey(elements[i]);
                i += d;
            }
            return this;
        }

        public final Keys putAll(XGettingCollection<? extends K> elements) {
            elements.iterate(k -> {
                boolean bl = HashTable.this.put(k, null);
            });
            return this;
        }

        @Override
        public final void truncate() {
            HashTable.this.truncate();
        }

        @Override
        public final long consolidate() {
            return HashTable.this.consolidate();
        }

        @Override
        public final long remove(K element) {
            return HashTable.this.removeKey(element);
        }

        @Override
        public final long nullRemove() {
            return HashTable.this.removeKey(null);
        }

        @Override
        public final long removeBy(Predicate<? super K> predicate) {
            return HashTable.this.chain.keyReduce(predicate);
        }

        @Override
        public final long retainAll(XGettingCollection<? extends K> elements) {
            return HashTable.this.chain.keyRetainAll(elements);
        }

        @Override
        public final <P extends Consumer<? super K>> P process(P procedure) {
            HashTable.this.chain.keyProcess(procedure);
            return procedure;
        }

        @Override
        public final <C extends Consumer<? super K>> C moveTo(C target, Predicate<? super K> predicate) {
            HashTable.this.chain.keyMoveTo(target, predicate);
            return target;
        }

        @Override
        public final long removeAll(XGettingCollection<? extends K> elements) {
            int oldSize = HashTable.this.size;
            elements.iterate(HashTable.this::removeFor);
            return oldSize - HashTable.this.size;
        }

        @Override
        public final long removeDuplicates() {
            return 0L;
        }

        @Override
        public final long removeDuplicates(Equalator<? super K> equalator) {
            if (equalator instanceof IdentityEqualator) {
                return 0L;
            }
            return HashTable.this.chain.keyRemoveDuplicates(equalator);
        }

        @Override
        public final Keys toReversed() {
            Copyable reversedVarSet = HashTable.this.copy();
            ((HashTable)reversedVarSet).chain.reverse();
            return ((HashTable)reversedVarSet).keys;
        }

        @Override
        public final <T extends Consumer<? super K>> T copySelection(T target, long ... indices) {
            HashTable.this.chain.keyCopySelection(target, indices);
            return target;
        }

        @Override
        public final <P extends IndexedAcceptor<? super K>> P iterateIndexed(P procedure) {
            HashTable.this.chain.keyIterateIndexed(procedure);
            return procedure;
        }

        @Override
        public final K at(long index) {
            return HashTable.this.chain.keyGet(index);
        }

        @Override
        public final K get() {
            return HashTable.this.chain.keyFirst();
        }

        @Override
        public final K first() {
            return HashTable.this.chain.keyFirst();
        }

        @Override
        public final K last() {
            return HashTable.this.chain.keyLast();
        }

        @Override
        public final K poll() {
            return HashTable.this.size == 0 ? null : (Object)HashTable.this.chain.keyFirst();
        }

        @Override
        public final K peek() {
            return HashTable.this.size == 0 ? null : (Object)HashTable.this.chain.keyLast();
        }

        @Override
        public final long indexOf(K element) {
            return HashTable.this.chain.keyIndexOf(element);
        }

        @Override
        public final long indexBy(Predicate<? super K> predicate) {
            return HashTable.this.chain.keyIndexBy(predicate);
        }

        @Override
        public final boolean isSorted(Comparator<? super K> comparator) {
            return HashTable.this.chain.keyIsSorted(comparator);
        }

        @Override
        public final long lastIndexOf(K element) {
            return HashTable.this.chain.keyLastIndexOf(element);
        }

        @Override
        public final long lastIndexBy(Predicate<? super K> predicate) {
            return HashTable.this.chain.keyLastIndexBy(predicate);
        }

        @Override
        public final long maxIndex(Comparator<? super K> comparator) {
            return HashTable.this.chain.keyMaxIndex(comparator);
        }

        @Override
        public final long minIndex(Comparator<? super K> comparator) {
            return HashTable.this.chain.keyMinIndex(comparator);
        }

        @Override
        public final long scan(Predicate<? super K> predicate) {
            return HashTable.this.chain.keyScan(predicate);
        }

        @Override
        public final <C extends Consumer<? super K>> C moveSelection(C target, long ... indices) {
            HashTable.this.chain.keyMoveSelection(target, indices);
            return target;
        }

        @Override
        public final K removeAt(long index) {
            return HashTable.this.chain.keyRemove(index);
        }

        @Override
        public final K fetch() {
            return HashTable.this.chain.keyRemove(0L);
        }

        @Override
        public final K pop() {
            return HashTable.this.chain.keyRemove(HashTable.this.size - 1);
        }

        @Override
        public final K pinch() {
            return HashTable.this.size == 0 ? null : (Object)HashTable.this.chain.keyRemove(0L);
        }

        @Override
        public final K pick() {
            return HashTable.this.size == 0 ? null : (Object)HashTable.this.chain.keyRemove(HashTable.this.size - 1);
        }

        @Override
        public final K retrieve(K element) {
            return HashTable.this.chain.keyRetrieve(element);
        }

        @Override
        public final K retrieveBy(Predicate<? super K> predicate) {
            return HashTable.this.chain.keyRetrieve(predicate);
        }

        @Override
        public final boolean removeOne(K element) {
            return HashTable.this.chain.keyRemoveOne(element);
        }

        public final Keys removeRange(long startIndex, long length) {
            HashTable.this.chain.removeRange(startIndex, length);
            return this;
        }

        public final Keys retainRange(long startIndex, long length) {
            HashTable.this.chain.retainRange(startIndex, length);
            return this;
        }

        @Override
        public final long removeSelection(long[] indices) {
            return HashTable.this.chain.removeSelection(indices);
        }

        @Override
        public final boolean isEmpty() {
            return HashTable.this.isEmpty();
        }

        @Override
        public final Iterator<K> iterator() {
            return HashTable.this.chain.keyIterator();
        }

        @Override
        public final long size() {
            return HashTable.this.size;
        }

        @Override
        public final int rehash() {
            return HashTable.this.rehash();
        }

        public final String toString() {
            if (HashTable.this.size == 0) {
                return "[]";
            }
            VarString vc = VarString.New(HashTable.this.slots.length).append('[');
            HashTable.this.chain.keyAppendTo(vc, ',').append(']');
            return vc.toString();
        }

        @Override
        public final Object[] toArray() {
            return HashTable.this.chain.keyToArray();
        }

        @Override
        public final void clear() {
            HashTable.this.clear();
        }

        @Override
        public final Keys reverse() {
            HashTable.this.chain.reverse();
            return this;
        }

        public final Keys sort(Comparator<? super K> comparator) {
            HashTable.this.chain.keySort(comparator);
            return this;
        }

        @Override
        public final Keys shiftTo(long sourceIndex, long targetIndex) {
            HashTable.this.chain.shiftTo(sourceIndex, targetIndex);
            return this;
        }

        @Override
        public final Keys shiftTo(long sourceIndex, long targetIndex, long length) {
            HashTable.this.chain.shiftTo(sourceIndex, targetIndex, length);
            return this;
        }

        @Override
        public final Keys shiftBy(long sourceIndex, long distance) {
            HashTable.this.chain.shiftTo(sourceIndex, distance);
            return this;
        }

        @Override
        public final Keys shiftBy(long sourceIndex, long distance, long length) {
            HashTable.this.chain.shiftTo(sourceIndex, distance, length);
            return this;
        }

        @Override
        public final Keys swap(long indexA, long indexB) {
            HashTable.this.chain.swap(indexA, indexB);
            return this;
        }

        @Override
        public final Keys swap(long indexA, long indexB, long length) {
            HashTable.this.chain.swap(indexA, indexB, length);
            return this;
        }

        public final one.microstream.collections.HashTable$Keys.OldKeys old() {
            return new OldKeys();
        }

        @Override
        public final HashTable<K, V> parent() {
            return HashTable.this;
        }

        @Override
        public final HashEqualator<K> hashEquality() {
            return HashTable.this.hashEquality();
        }

        @Override
        public final float hashDensity() {
            return HashTable.this.hashDensity();
        }

        @Override
        public final boolean input(long index, K element) {
            throw new NotImplementedYetError();
        }

        @Override
        @SafeVarargs
        public final long inputAll(long index, K ... elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final long inputAll(long index, K[] elements, int offset, int length) {
            throw new NotImplementedYetError();
        }

        @Override
        public final long inputAll(long index, XGettingCollection<? extends K> elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean insert(long index, K element) {
            throw new NotImplementedYetError();
        }

        @Override
        @SafeVarargs
        public final long insertAll(long index, K ... elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final long insertAll(long index, K[] elements, int offset, int length) {
            throw new NotImplementedYetError();
        }

        @Override
        public final long insertAll(long index, XGettingCollection<? extends K> elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean prepend(K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean preput(K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean nullInput(long index) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean nullInsert(long index) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean nullPrepend() {
            throw new NotImplementedYetError();
        }

        public final Keys prependAll(K ... elements) {
            throw new NotImplementedYetError();
        }

        public final Keys prependAll(K[] elements, int srcStartIndex, int srcLength) {
            throw new NotImplementedYetError();
        }

        public final Keys prependAll(XGettingCollection<? extends K> elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean nullPreput() {
            throw new NotImplementedYetError();
        }

        @SafeVarargs
        public final Keys preputAll(K ... elements) {
            throw new NotImplementedYetError();
        }

        public final Keys preputAll(K[] elements, int offset, int length) {
            throw new NotImplementedYetError();
        }

        public final Keys preputAll(XGettingCollection<? extends K> elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean set(long index, K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final K setGet(long index, K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final void setFirst(K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final void setLast(K element) {
            throw new NotImplementedYetError();
        }

        @SafeVarargs
        public final Keys setAll(long index, K ... elements) {
            throw new NotImplementedYetError();
        }

        public final Keys set(long index, K[] elements, int offset, int length) {
            throw new NotImplementedYetError();
        }

        public final Keys set(long index, XGettingSequence<? extends K> elements, long offset, long length) {
            throw new NotImplementedYetError();
        }

        @Override
        public long substitute(Function<? super K, ? extends K> mapper) {
            return HashTable.this.chain.keySubstitute(mapper, HashTable.this::replace);
        }

        public final class OldKeys
        extends AbstractBridgeXSet<K> {
            protected OldKeys() {
                super(Keys.this);
            }

            @Override
            public final Keys parent() {
                return (Keys)super.parent();
            }
        }
    }

    public final class OldVarMap
    implements XTable.Bridge<K, V> {
        @Override
        public final void clear() {
            HashTable.this.clear();
        }

        @Override
        public final boolean containsKey(Object key) {
            try {
                return HashTable.this.containsKey(key);
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public final boolean containsValue(Object value) {
            try {
                return HashTable.this.chain.valuesContains(value);
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            return (Set)((Object)HashTable.this.old());
        }

        @Override
        public final V get(Object key) {
            try {
                return HashTable.this.get(key);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public final boolean isEmpty() {
            return HashTable.this.isEmpty();
        }

        @Override
        public final Set<K> keySet() {
            return HashTable.this.keys().old();
        }

        @Override
        public final V put(K key, V value) {
            return HashTable.this.oldPutGet(key, value);
        }

        @Override
        public final void putAll(Map<? extends K, ? extends V> m) {
            if (m instanceof XGettingMap.Bridge) {
                HashTable.this.addAll((XGettingCollection)((XGettingMap.Bridge)m).parent());
                return;
            }
            HashTable parent = HashTable.this;
            for (Map.Entry entry : m.entrySet()) {
                parent.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public final V remove(Object key) {
            try {
                return HashTable.this.removeFor(key);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public final int size() {
            return XTypes.to_int(HashTable.this.size());
        }

        @Override
        public final Collection<V> values() {
            return HashTable.this.values.old();
        }

        @Override
        public final HashTable<K, V> parent() {
            return HashTable.this;
        }
    }

    public final class Values
    implements XTable.Values<K, V> {
        @Override
        public final Equalator<? super V> equality() {
            return Equalator.identity();
        }

        @Override
        public final XList<V> copy() {
            return new BulkList(XTypes.to_int(HashTable.this.size())).addAll((XGettingCollection)this);
        }

        @Override
        public final <P extends Consumer<? super V>> P iterate(P procedure) {
            HashTable.this.chain.valuesIterate(procedure);
            return procedure;
        }

        @Override
        public final <A> A join(BiConsumer<? super V, ? super A> joiner, A aggregate) {
            HashTable.this.chain.valuesJoin(joiner, aggregate);
            return aggregate;
        }

        @Override
        public final <P extends IndexedAcceptor<? super V>> P iterateIndexed(P procedure) {
            HashTable.this.chain.valuesIterateIndexed(procedure);
            return procedure;
        }

        @Override
        public final Values toReversed() {
            Copyable reversedVarSet = HashTable.this.copy();
            ((HashTable)reversedVarSet).chain.reverse();
            return ((HashTable)reversedVarSet).values;
        }

        @Override
        public final boolean containsSearched(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesApplies(predicate);
        }

        @Override
        public final boolean applies(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesAppliesAll(predicate);
        }

        @Override
        public final boolean contains(V value) {
            return HashTable.this.chain.valuesContains(value);
        }

        @Override
        public final boolean containsAll(XGettingCollection<? extends V> values) {
            return HashTable.this.chain.valuesContainsAll(values);
        }

        @Override
        public final boolean containsId(V value) {
            return HashTable.this.chain.valuesContainsId(value);
        }

        @Override
        public final <T extends Consumer<? super V>> T copyTo(T target) {
            HashTable.this.chain.valuesCopyTo(target);
            return target;
        }

        @Override
        public final <T extends Consumer<? super V>> T filterTo(T target, Predicate<? super V> predicate) {
            HashTable.this.chain.valuesCopyTo(target, predicate);
            return target;
        }

        @Override
        public final long count(V value) {
            return HashTable.this.chain.valuesCount(value);
        }

        @Override
        public final long countBy(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesCount(predicate);
        }

        @Override
        public final <T extends Consumer<? super V>> T distinct(T target) {
            HashTable.this.chain.valuesDistinct(target);
            return target;
        }

        @Override
        public final <T extends Consumer<? super V>> T distinct(T target, Equalator<? super V> equalator) {
            HashTable.this.chain.valuesDistinct(target, equalator);
            return target;
        }

        @Override
        public final boolean equals(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
            if (samples == null || !(samples instanceof EqHashEnum)) {
                return false;
            }
            if (samples == this) {
                return true;
            }
            return this.equalsContent(samples, equalator);
        }

        @Override
        public final boolean equalsContent(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
            return HashTable.this.chain.valuesEqualsContent(samples, equalator);
        }

        @Override
        public final <T extends Consumer<? super V>> T except(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            HashTable.this.chain.valuesExcept(other, equalator, target);
            return target;
        }

        @Override
        public final boolean hasVolatileElements() {
            return HashTable.this.hasVolatileValues();
        }

        @Override
        public final <T extends Consumer<? super V>> T intersect(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            HashTable.this.chain.valuesIntersect(other, equalator, target);
            return target;
        }

        @Override
        public final boolean isEmpty() {
            return HashTable.this.isEmpty();
        }

        @Override
        public final Iterator<V> iterator() {
            return HashTable.this.chain.valuesIterator();
        }

        @Override
        public final V max(Comparator<? super V> comparator) {
            return HashTable.this.chain.valuesMax(comparator);
        }

        @Override
        public final V min(Comparator<? super V> comparator) {
            return HashTable.this.chain.valuesMin(comparator);
        }

        @Override
        public final boolean nullAllowed() {
            return HashTable.this.nullAllowed();
        }

        @Override
        public final boolean nullContained() {
            return HashTable.this.chain.valuesContains(null);
        }

        public final one.microstream.collections.HashTable$Values.OldValues old() {
            return new OldValues();
        }

        @Override
        public final V seek(V sample) {
            return HashTable.this.chain.valuesSeek(sample);
        }

        @Override
        public final V search(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesSearch(predicate);
        }

        @Override
        public final long size() {
            return XTypes.to_int(HashTable.this.size());
        }

        @Override
        public final long maximumCapacity() {
            return XTypes.to_int(HashTable.this.size());
        }

        @Override
        public final boolean isFull() {
            return HashTable.this.isFull();
        }

        @Override
        public final long remainingCapacity() {
            return HashTable.this.remainingCapacity();
        }

        public final String toString() {
            if (HashTable.this.size == 0) {
                return "[]";
            }
            VarString vc = VarString.New(HashTable.this.slots.length).append('[');
            HashTable.this.chain.valuesAppendTo(vc, ',').append(']');
            return vc.toString();
        }

        @Override
        public final Object[] toArray() {
            return HashTable.this.chain.valuesToArray();
        }

        @Override
        public final V[] toArray(Class<V> type) {
            return HashTable.this.chain.valuesToArray(type);
        }

        @Override
        public final <T extends Consumer<? super V>> T union(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            HashTable.this.chain.valuesUnion(other, equalator, target);
            return target;
        }

        @Override
        public final HashTable<K, V> parent() {
            return HashTable.this;
        }

        @Override
        public final SubListView<V> view(long fromIndex, long toIndex) {
            return new SubListView(this, fromIndex, toIndex);
        }

        @Override
        public final ListIterator<V> listIterator() {
            return HashTable.this.chain.valuesListIterator(0L);
        }

        @Override
        public final ListIterator<V> listIterator(long index) {
            return HashTable.this.chain.valuesListIterator(index);
        }

        @Override
        public final SubListProcessor<V> range(long fromIndex, long toIndex) {
            return new SubListProcessor(this, fromIndex, toIndex);
        }

        @Override
        public final XImmutableList<V> immure() {
            return ConstList.New(this);
        }

        @Override
        public final ListView<V> view() {
            return new ListView(this);
        }

        @Override
        public final <T extends Consumer<? super V>> T copySelection(T target, long ... indices) {
            HashTable.this.chain.valuesCopySelection(target, indices);
            return target;
        }

        @Override
        public final V at(long index) {
            return HashTable.this.chain.valuesGet(index);
        }

        @Override
        public final V get() {
            return HashTable.this.chain.valuesFirst();
        }

        @Override
        public final V first() {
            return HashTable.this.chain.valuesFirst();
        }

        @Override
        public final V last() {
            return HashTable.this.chain.valuesLast();
        }

        @Override
        public final V poll() {
            return HashTable.this.size == 0 ? null : (Object)HashTable.this.chain.valuesFirst();
        }

        @Override
        public final V peek() {
            return HashTable.this.size == 0 ? null : (Object)HashTable.this.chain.valuesLast();
        }

        @Override
        public final long indexOf(V value) {
            return HashTable.this.chain.valuesIndexOf(value);
        }

        @Override
        public final long indexBy(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesIndexBy(predicate);
        }

        @Override
        public final boolean isSorted(Comparator<? super V> comparator) {
            return HashTable.this.chain.valuesIsSorted(comparator);
        }

        @Override
        public final long lastIndexOf(V value) {
            return HashTable.this.chain.valuesLastIndexOf(value);
        }

        @Override
        public final long lastIndexBy(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesLastIndexBy(predicate);
        }

        @Override
        public final long maxIndex(Comparator<? super V> comparator) {
            return HashTable.this.chain.valuesMaxIndex(comparator);
        }

        @Override
        public final long minIndex(Comparator<? super V> comparator) {
            return HashTable.this.chain.valuesMinIndex(comparator);
        }

        @Override
        public final long scan(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesScan(predicate);
        }

        @Override
        public final <C extends Consumer<? super V>> C moveSelection(C target, long ... indices) {
            HashTable.this.chain.valuesMoveSelection(target, indices);
            return target;
        }

        @Override
        public final V removeAt(long index) {
            return HashTable.this.chain.valuesRemove(index);
        }

        @Override
        public final V fetch() {
            return HashTable.this.chain.valuesRemove(0L);
        }

        @Override
        public final V pop() {
            return HashTable.this.chain.valuesRemove(HashTable.this.size - 1);
        }

        @Override
        public final V pinch() {
            return HashTable.this.size == 0 ? null : (Object)HashTable.this.chain.valuesRemove(0L);
        }

        @Override
        public final V pick() {
            return HashTable.this.size == 0 ? null : (Object)HashTable.this.chain.valuesRemove(HashTable.this.size - 1);
        }

        @Override
        public final V retrieve(V value) {
            return HashTable.this.chain.valuesRetrieve(value);
        }

        @Override
        public final V retrieveBy(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesRetrieve(predicate);
        }

        @Override
        public final boolean removeOne(V element) {
            return HashTable.this.chain.valuesRemoveOne(element);
        }

        public final Values removeRange(long startIndex, long length) {
            HashTable.this.chain.removeRange(startIndex, length);
            return this;
        }

        public final Values retainRange(long startIndex, long length) {
            HashTable.this.chain.retainRange(startIndex, length);
            return this;
        }

        @Override
        public final long removeSelection(long[] indices) {
            return HashTable.this.chain.removeSelection(indices);
        }

        @Override
        public final void clear() {
            HashTable.this.clear();
        }

        @Override
        public final long consolidate() {
            return HashTable.this.consolidate();
        }

        @Override
        public final <C extends Consumer<? super V>> C moveTo(C target, Predicate<? super V> predicate) {
            HashTable.this.chain.valuesMoveTo(target, predicate);
            return target;
        }

        @Override
        public final long nullRemove() {
            return HashTable.this.chain.valuesRemove(null);
        }

        @Override
        public final long optimize() {
            return HashTable.this.optimize();
        }

        @Override
        public final <P extends Consumer<? super V>> P process(P procedure) {
            HashTable.this.chain.valuesProcess(procedure);
            return procedure;
        }

        @Override
        public final long removeBy(Predicate<? super V> predicate) {
            return HashTable.this.chain.valuesReduce(predicate);
        }

        @Override
        public final long remove(V value) {
            return HashTable.this.chain.valuesRemove(value);
        }

        @Override
        public final long removeAll(XGettingCollection<? extends V> values) {
            return HashTable.this.chain.valuesRemoveAll(values);
        }

        @Override
        public final long removeDuplicates() {
            return HashTable.this.chain.valuesRemoveDuplicates();
        }

        @Override
        public final long removeDuplicates(Equalator<? super V> equalator) {
            return HashTable.this.chain.valuesRemoveDuplicates(equalator);
        }

        @Override
        public final long retainAll(XGettingCollection<? extends V> values) {
            return HashTable.this.chain.valuesRetainAll(values);
        }

        @Override
        public final void truncate() {
            HashTable.this.truncate();
        }

        public final Values fill(long offset, long length, V value) {
            HashTable.this.chain.valuesFill(offset, length, value);
            return this;
        }

        @Override
        public final long replace(V value, V replacement) {
            return HashTable.this.chain.valuesReplace(value, replacement);
        }

        @Override
        public final long replaceAll(XGettingCollection<? extends V> values, V replacement) {
            return HashTable.this.chain.valuesReplaceAll(values, (Object)replacement);
        }

        @Override
        public final long substitute(Function<? super V, ? extends V> mapper) {
            return HashTable.this.chain.valuesSubstitute(mapper);
        }

        @Override
        public final long substitute(Predicate<? super V> predicate, Function<V, V> mapper) {
            return HashTable.this.chain.valuesSubstitute((Predicate)predicate, mapper);
        }

        @Override
        public final boolean replaceOne(V value, V replacement) {
            return HashTable.this.chain.valuesReplaceOne(value, replacement);
        }

        @Override
        public final Values reverse() {
            HashTable.this.chain.reverse();
            return this;
        }

        @Override
        public final boolean set(long index, V value) {
            return HashTable.this.chain.valuesSet(index, value) == value;
        }

        @Override
        public final V setGet(long index, V value) {
            return HashTable.this.chain.valuesSet(index, value);
        }

        public final Values setAll(long offset, V ... values) {
            HashTable.this.chain.valuesSet(offset, values);
            return this;
        }

        public final Values set(long offset, V[] src, int srcIndex, int srcLength) {
            HashTable.this.chain.valuesSet(offset, src, srcIndex, srcLength);
            return this;
        }

        public final Values set(long offset, XGettingSequence<? extends V> values, long valuesOffset, long valuesLength) {
            throw new NotImplementedYetError();
        }

        @Override
        public final void setFirst(V value) {
            HashTable.this.chain.valuesSet(0L, value);
        }

        @Override
        public final void setLast(V value) {
            HashTable.this.chain.valuesSet((long)(HashTable.this.size - 1), value);
        }

        public final Values sort(Comparator<? super V> comparator) {
            HashTable.this.chain.valuesSort(comparator);
            return this;
        }

        @Override
        public final long replace(Predicate<? super V> predicate, V substitute) {
            return HashTable.this.chain.valuesSubstitute(predicate, (Object)substitute);
        }

        @Override
        public final boolean replaceOne(Predicate<? super V> predicate, V substitute) {
            return HashTable.this.chain.valuesSubstituteOne(predicate, (Object)substitute);
        }

        @Override
        public final Values shiftTo(long sourceIndex, long targetIndex) {
            HashTable.this.chain.shiftTo(sourceIndex, targetIndex);
            return this;
        }

        @Override
        public final Values shiftTo(long sourceIndex, long targetIndex, long length) {
            HashTable.this.chain.shiftTo(sourceIndex, targetIndex, length);
            return this;
        }

        @Override
        public final Values shiftBy(long sourceIndex, long distance) {
            HashTable.this.chain.shiftTo(sourceIndex, distance);
            return this;
        }

        @Override
        public final Values shiftBy(long sourceIndex, long distance, long length) {
            HashTable.this.chain.shiftTo(sourceIndex, distance, length);
            return this;
        }

        @Override
        public final Values swap(long indexA, long indexB) {
            HashTable.this.chain.swap(indexA, indexB);
            return this;
        }

        @Override
        public final Values swap(long indexA, long indexB, long length) {
            HashTable.this.chain.swap(indexA, indexB, length);
            return this;
        }

        public final class OldValues
        extends AbstractOldSettingList<V> {
            protected OldValues() {
                super(Values.this);
            }

            @Override
            public final Values parent() {
                return (Values)super.parent();
            }
        }
    }
}

