/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.collections.AbstractExtendedCollection;
import one.microstream.collections.ListView;
import one.microstream.collections.SubListProcessor;
import one.microstream.collections.SubListView;
import one.microstream.collections.old.AbstractOldRemovingList;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XImmutableList;
import one.microstream.collections.types.XProcessingList;
import one.microstream.equality.Equalator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.ReadOnlyListIterator;

public final class ListProcessor<E>
implements XProcessingList<E> {
    private final XProcessingList<E> subject;

    public ListProcessor(XProcessingList<E> list) {
        this.subject = list;
    }

    @Override
    public XImmutableList<E> immure() {
        return this.subject.immure();
    }

    @Override
    public Equalator<? super E> equality() {
        return this.subject.equality();
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return this.subject.containsSearched(predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return this.subject.applies(predicate);
    }

    @Override
    public void clear() {
        this.subject.clear();
    }

    @Override
    public boolean contains(E element) {
        return this.subject.contains(element);
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean nullContained() {
        return this.subject.nullContained();
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return this.subject.containsAll(elements);
    }

    @Override
    public boolean containsId(E element) {
        return this.subject.containsId(element);
    }

    @Override
    public ListProcessor<E> copy() {
        this.subject.copy();
        return this;
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return this.subject.copySelection(target, indices);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.subject.filterTo(target, predicate);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return this.subject.copyTo(target);
    }

    @Override
    public long count(E element) {
        return this.subject.count(element);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return this.subject.countBy(predicate);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.subject.distinct(target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return this.subject.distinct(target);
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        return this.subject.equals(o);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equals(samples, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equalsContent(samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.except(other, equalator, target);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        return this.subject.iterate(procedure);
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        return this.subject.iterateIndexed(procedure);
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        return this.subject.join(joiner, aggregate);
    }

    @Override
    public E at(long index) {
        return this.subject.at(index);
    }

    @Override
    public E get() {
        return this.subject.get();
    }

    @Override
    public E first() {
        return this.subject.first();
    }

    @Override
    public E last() {
        return this.subject.last();
    }

    @Override
    public E poll() {
        return this.subject.poll();
    }

    @Override
    public E peek() {
        return this.subject.peek();
    }

    @Override
    @Deprecated
    public int hashCode() {
        return this.subject.hashCode();
    }

    @Override
    public boolean hasVolatileElements() {
        return this.subject.hasVolatileElements();
    }

    @Override
    public long indexOf(E element) {
        return this.subject.indexOf(element);
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return this.subject.indexBy(predicate);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.intersect(other, equalator, target);
    }

    @Override
    public boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return this.subject.isSorted(comparator);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return this.subject.lastIndexBy(predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return this.subject.lastIndexOf(element);
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        AbstractExtendedCollection.validateIndex(this.subject.size(), index);
        return new ReadOnlyListIterator(this, (int)index);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return this.subject.max(comparator);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return this.subject.maxIndex(comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return this.subject.min(comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return this.subject.minIndex(comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return this.subject.scan(predicate);
    }

    @Override
    public E seek(E sample) {
        return this.subject.seek(sample);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return this.subject.search(predicate);
    }

    @Override
    public long size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public long maximumCapacity() {
        return this.subject.maximumCapacity();
    }

    @Override
    public boolean isFull() {
        return this.subject.isFull();
    }

    @Override
    public long remainingCapacity() {
        return this.subject.remainingCapacity();
    }

    @Override
    public SubListProcessor<E> range(long fromIndex, long toIndex) {
        return new SubListProcessor(this, fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.subject.toArray();
    }

    @Override
    public E[] toArray(Class<E> type) {
        return this.subject.toArray(type);
    }

    @Override
    public ListProcessor<E> toReversed() {
        this.subject.toReversed();
        return this;
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.union(other, equalator, target);
    }

    @Override
    public long consolidate() {
        return this.subject.consolidate();
    }

    @Override
    public <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        return this.subject.moveSelection(target, indices);
    }

    @Override
    public <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        return this.subject.moveTo(target, predicate);
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        this.subject.process(procedure);
        return procedure;
    }

    @Override
    public long removeBy(Predicate<? super E> predicate) {
        return this.subject.removeBy(predicate);
    }

    @Override
    public long remove(E element) {
        return this.subject.remove(element);
    }

    @Override
    public E removeAt(long index) {
        return this.subject.removeAt(index);
    }

    @Override
    public long removeAll(XGettingCollection<? extends E> elements) {
        return this.subject.removeAll(elements);
    }

    @Override
    public long removeDuplicates(Equalator<? super E> equalator) {
        return this.subject.removeDuplicates(equalator);
    }

    @Override
    public long removeDuplicates() {
        return this.subject.removeDuplicates();
    }

    @Override
    public E fetch() {
        return this.subject.fetch();
    }

    @Override
    public E pop() {
        return this.subject.pop();
    }

    @Override
    public E pinch() {
        return this.subject.pinch();
    }

    @Override
    public E pick() {
        return this.subject.pick();
    }

    @Override
    public E retrieve(E element) {
        return this.subject.retrieve(element);
    }

    @Override
    public E retrieveBy(Predicate<? super E> predicate) {
        return this.subject.retrieveBy(predicate);
    }

    @Override
    public boolean removeOne(E element) {
        return this.subject.removeOne(element);
    }

    @Override
    public ListProcessor<E> removeRange(long startIndex, long length) {
        this.subject.removeRange(startIndex, length);
        return this;
    }

    @Override
    public ListProcessor<E> retainRange(long startIndex, long length) {
        this.subject.retainRange(startIndex, length);
        return this;
    }

    @Override
    public long removeSelection(long[] indices) {
        return this.subject.removeSelection(indices);
    }

    @Override
    public long retainAll(XGettingCollection<? extends E> elements) {
        return this.subject.retainAll(elements);
    }

    @Override
    public long optimize() {
        return this.subject.optimize();
    }

    @Override
    public ListView<E> view() {
        return new ListView(this);
    }

    @Override
    public SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public void truncate() {
        this.subject.truncate();
    }

    @Override
    public long nullRemove() {
        return this.subject.nullRemove();
    }

    @Override
    public OldListProcessor<E> old() {
        return new OldListProcessor(this);
    }

    public static final class OldListProcessor<E>
    extends AbstractOldRemovingList<E> {
        OldListProcessor(ListProcessor<E> list) {
            super(list);
        }

        @Override
        public ListProcessor<E> parent() {
            return (ListProcessor)super.parent();
        }
    }
}

