/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.collections.Constant;
import one.microstream.collections.SingletonView;
import one.microstream.collections.old.OldList;
import one.microstream.collections.old.OldSet;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XReference;
import one.microstream.equality.Equalator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.TrivialIterator;

public class Singleton<E>
implements XReference<E> {
    E element;

    public static <E> Singleton<E> New(E element) {
        return new Singleton<E>(X.mayNull(element));
    }

    protected Singleton(E element) {
        this.element = element;
    }

    @Override
    public final E get() {
        return this.element;
    }

    @Override
    public final Singleton<E> copy() {
        return new Singleton<E>(this.element);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        procedure.accept(this.element);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        joiner.accept(this.element, aggregate);
        return aggregate;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        procedure.accept(this.element, 0L);
        return procedure;
    }

    @Override
    public final Constant<E> immure() {
        return new Constant<E>(this.element);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new TrivialIterator(this);
    }

    @Override
    public final ListIterator<E> listIterator(long index) {
        if (index != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return new TrivialIterator(this);
    }

    @Override
    public final OldSingleton old() {
        return new OldSingleton();
    }

    @Override
    public final Singleton<E> range(long fromIndex, long toIndex) {
        if (fromIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return new Singleton<E>(this.element);
    }

    @Override
    public final Singleton<E> toReversed() {
        return new Singleton<E>(this.element);
    }

    @Override
    public final <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        int i = 0;
        while (i < indices.length) {
            if (indices[i] != 0L) {
                throw new IndexOutOfBoundsException();
            }
            ++i;
        }
        target.accept(this.element);
        return (T)target;
    }

    @Override
    public final E first() {
        return this.element;
    }

    @Override
    public final E at(long index) {
        if (index != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.element;
    }

    @Override
    public final long indexOf(E element) {
        if (element == this.element) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        return true;
    }

    @Override
    public final E last() {
        return this.element;
    }

    @Override
    public final long lastIndexOf(E element) {
        if (element == this.element) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        return 0L;
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        return 0L;
    }

    @Override
    public final E peek() {
        return this.element;
    }

    @Override
    public final E poll() {
        return this.element;
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final SingletonView<E> view() {
        return new SingletonView(this);
    }

    @Override
    public final SingletonView<E> view(long lowIndex, long highIndex) {
        if (lowIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (highIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return new SingletonView(this);
    }

    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        return predicate.test(this.element);
    }

    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        return predicate.test(this.element);
    }

    @Override
    public final boolean contains(E element) {
        return this.element == element;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean containsId(E element) {
        return this.element == element;
    }

    @Override
    public final <T extends Consumer<? super E>> T copyTo(T target) {
        target.accept(this.element);
        return (T)target;
    }

    @Override
    public final <T extends Consumer<? super E>> T filterTo(T target, Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            target.accept(this.element);
        }
        return (T)target;
    }

    @Override
    public final long count(E element) {
        return this.element == element ? 1 : 0;
    }

    @Override
    public final long countBy(Predicate<? super E> predicate) {
        return predicate.test(this.element) ? 1 : 0;
    }

    @Override
    public final <T extends Consumer<? super E>> T distinct(T target) {
        target.accept(this.element);
        return (T)target;
    }

    @Override
    public final <T extends Consumer<? super E>> T distinct(T target, Equalator<? super E> equalator) {
        target.accept(this.element);
        return (T)target;
    }

    @Override
    public final Equalator<? super E> equality() {
        return Equalator.identity();
    }

    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public final <T extends Consumer<? super E>> T except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final <T extends Consumer<? super E>> T intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new TrivialIterator(this);
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        return this.element;
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        return this.element;
    }

    @Override
    public final boolean nullContained() {
        return this.element == null;
    }

    @Override
    public final E seek(E sample) {
        return (E)(this.element == sample ? sample : null);
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return this.element;
        }
        return null;
    }

    @Override
    public final long size() {
        return 1L;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, 1);
        array[0] = this.element;
        return array;
    }

    @Override
    public final <T extends Consumer<? super E>> T union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullAllowed() {
        return false;
    }

    @Override
    public final long remainingCapacity() {
        return 0L;
    }

    @Override
    public final boolean isFull() {
        return true;
    }

    @Override
    public final long maximumCapacity() {
        return 1L;
    }

    @Override
    public final boolean replaceOne(E element, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long replace(E element, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long replace(Predicate<? super E> predicate, E substitute) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long substitute(Function<? super E, ? extends E> mapper) {
        this.element = mapper.apply(this.element);
        if (this.element != this.element) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public final long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean set(long index, E element) {
        if (index != 0L) {
            throw new IndexOutOfBoundsException();
        }
        this.element = element;
        return false;
    }

    @Override
    public final E setGet(long index, E element) {
        E oldElement = this.element;
        this.element = element;
        return oldElement;
    }

    @Override
    public final void setFirst(E element) {
        this.element = element;
    }

    @Override
    public final void setLast(E element) {
        this.element = element;
    }

    @Override
    public final Singleton<E> shiftTo(long sourceIndex, long targetIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final Singleton<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final Singleton<E> shiftBy(long sourceIndex, long distance) {
        throw new NotImplementedYetError();
    }

    @Override
    public final Singleton<E> shiftBy(long sourceIndex, long distance, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void set(E element) {
        this.element = element;
    }

    @Override
    public final Singleton<E> fill(long offset, long length, E element) {
        if (offset != 0L || length != 1L) {
            throw new IndexOutOfBoundsException();
        }
        this.element = element;
        return this;
    }

    @Override
    @SafeVarargs
    public final Singleton<E> setAll(long index, E ... elements) {
        if (index != 0L || elements.length != 1) {
            throw new IndexOutOfBoundsException();
        }
        this.element = elements[0];
        return this;
    }

    @Override
    public final Singleton<E> set(long index, E[] elements, int offset, int length) {
        if (index != 0L || offset != 0 || length != 1) {
            throw new IndexOutOfBoundsException();
        }
        this.element = elements[0];
        return this;
    }

    @Override
    public final Singleton<E> set(long index, XGettingSequence<? extends E> elements, long offset, long length) {
        if (index != 0L || offset != 0L || length != 1L) {
            throw new IndexOutOfBoundsException();
        }
        this.element = elements.first();
        return this;
    }

    @Override
    public final Singleton<E> swap(long indexA, long indexB) {
        if (indexA != 0L || indexB != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public final Singleton<E> swap(long indexA, long indexB, long length) {
        if (indexA != 0L || indexB != 0L || length != 1L) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public final Singleton<E> reverse() {
        return this;
    }

    @Override
    public final Singleton<E> sort(Comparator<? super E> comparator) {
        return this;
    }

    final class OldSingleton
    implements OldList<E>,
    OldSet<E> {
        OldSingleton() {
        }

        @Override
        public final Singleton<E> parent() {
            return Singleton.this;
        }

        @Override
        public final boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean contains(Object o) {
            return Singleton.this.contains(o);
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (o == Singleton.this.element) continue;
                return false;
            }
            return true;
        }

        @Override
        public final E get(int index) {
            return Singleton.this.at(index);
        }

        @Override
        public final int indexOf(Object o) {
            return X.checkArrayRange(Singleton.this.indexOf(o));
        }

        @Override
        public final boolean isEmpty() {
            return Singleton.this.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new TrivialIterator(Singleton.this);
        }

        @Override
        public final int lastIndexOf(Object o) {
            return X.checkArrayRange(Singleton.this.lastIndexOf(o));
        }

        @Override
        public ListIterator<E> listIterator() {
            return new TrivialIterator(Singleton.this);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return new TrivialIterator(Singleton.this);
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int size() {
            return XTypes.to_int(Singleton.this.size());
        }

        @Override
        public final List<E> subList(int fromIndex, int toIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public Object[] toArray() {
            return Singleton.this.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            a[0] = Singleton.this.element;
            if (a.length > 1) {
                a[1] = null;
            }
            return a;
        }

        @Override
        public final Spliterator<E> spliterator() {
            return OldList.super.spliterator();
        }
    }
}

