/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.collections.SubListView;
import one.microstream.collections.XArrays;
import one.microstream.collections.XUtilsCollection;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XSettingList;
import one.microstream.meta.NotImplementedYetError;

public class SubListAccessor<E>
extends SubListView<E>
implements XSettingList<E> {
    public SubListAccessor(XSettingList<E> list, long fromIndex, long toIndex) {
        super(list, fromIndex, toIndex);
    }

    @Override
    public long replace(E element, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean replaceOne(E element, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public long substitute(Function<? super E, ? extends E> mapper) {
        throw new NotImplementedYetError();
    }

    @Override
    public long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        throw new NotImplementedYetError();
    }

    @Override
    public SubListAccessor<E> range(long fromIndex, long toIndex) {
        this.checkRange(fromIndex, toIndex);
        return new SubListAccessor<E>((XSettingList)this.list, this.startIndex + fromIndex * (long)this.d, this.startIndex + toIndex * (long)this.d);
    }

    @Override
    public SubListAccessor<E> fill(long offset, long length, E element) {
        this.checkVector(offset, length);
        ((XSettingList)this.list).fill(this.startIndex + offset * (long)this.d, length * (long)this.d, element);
        return this;
    }

    @Override
    public boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        throw new NotImplementedYetError();
    }

    @Override
    public SubListAccessor<E> reverse() {
        return this;
    }

    @Override
    public SubListAccessor<E> setAll(long offset, E ... elements) {
        this.checkVector(offset, elements.length);
        if (this.d > 0) {
            ((XSettingList)this.list).setAll(this.startIndex + offset, (Object[])elements);
        } else {
            ((XSettingList)this.list).setAll(this.startIndex - offset, (Object[])XArrays.toReversed(elements));
        }
        return this;
    }

    @Override
    public SubListAccessor<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        this.checkVector(offset, srcLength);
        if (this.d > 0) {
            ((XSettingList)this.list).set(this.startIndex + offset * 1L, (Object[])src, srcIndex, srcLength);
        } else {
            int revElementsStartIndex = srcLength == 0 ? srcIndex : (srcLength > 0 ? srcIndex + srcLength - 1 : srcIndex + srcLength + 1);
            ((XSettingList)this.list).set(this.startIndex + offset * -1L, (Object[])src, revElementsStartIndex, -srcLength);
        }
        return this;
    }

    @Override
    public SubListAccessor<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        this.checkVector(offset, elementsLength);
        if (this.d > 0) {
            ((XSettingList)this.list).set(this.startIndex + offset, (XGettingSequence)elements, elementsOffset, elementsLength);
        } else {
            long revElementsStartIndex = elementsLength == 0L ? elementsOffset : (elementsLength > 0L ? elementsOffset + elementsLength - 1L : elementsOffset + elementsLength + 1L);
            ((XSettingList)this.list).set(this.startIndex - offset, (XGettingSequence)elements, revElementsStartIndex, -elementsLength);
        }
        return this;
    }

    @Override
    public void setFirst(E element) {
        ((XSettingList)this.list).setGet(this.startIndex, element);
    }

    @Override
    public void setLast(E element) {
        ((XSettingList)this.list).setGet(this.getEndIndex(), element);
    }

    @Override
    public SubListAccessor<E> sort(Comparator<? super E> comparator) {
        XUtilsCollection.rngSort((XSettingList)this.list, this.startIndex, this.length, comparator);
        return this;
    }

    @Override
    public SubListAccessor<E> shiftTo(long sourceIndex, long targetIndex) {
        this.checkIndex(sourceIndex);
        this.checkIndex(targetIndex);
        ((XSettingList)this.list).shiftTo(sourceIndex, targetIndex);
        return this;
    }

    @Override
    public SubListAccessor<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        this.checkVector(sourceIndex, length);
        this.checkVector(targetIndex, length);
        ((XSettingList)this.list).shiftTo(sourceIndex, targetIndex, length);
        return this;
    }

    @Override
    public SubListAccessor<E> shiftBy(long sourceIndex, long distance) {
        this.checkIndex(sourceIndex);
        this.checkIndex(sourceIndex + distance);
        ((XSettingList)this.list).shiftTo(sourceIndex, distance);
        return this;
    }

    @Override
    public SubListAccessor<E> shiftBy(long sourceIndex, long distance, long length) {
        this.checkVector(sourceIndex, length);
        this.checkVector(sourceIndex + distance, length);
        ((XSettingList)this.list).shiftTo(sourceIndex, distance, length);
        return this;
    }

    @Override
    public SubListAccessor<E> swap(long indexA, long indexB) {
        this.checkIndex(indexA);
        this.checkIndex(indexB);
        ((XSettingList)this.list).swap(this.startIndex + indexA * (long)this.d, this.startIndex + indexB * (long)this.d);
        return this;
    }

    @Override
    public SubListAccessor<E> swap(long indexA, long indexB, long length) {
        this.checkVector(indexA, length);
        this.checkVector(indexB, length);
        ((XSettingList)this.list).swap(this.startIndex + indexA * (long)this.d, this.startIndex + indexB * (long)this.d, length * (long)this.d);
        return this;
    }

    @Override
    public long replace(Predicate<? super E> predicate, E substitute) {
        throw new NotImplementedYetError();
    }

    @Override
    public long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean set(long index, E element) {
        this.checkIndex(index);
        return ((XSettingList)this.list).set(this.startIndex + index * (long)this.d, element);
    }

    @Override
    public E setGet(long index, E element) {
        this.checkIndex(index);
        return ((XSettingList)this.list).setGet(this.startIndex + index * (long)this.d, element);
    }

    @Override
    public SubListView<E> view(long fromIndex, long toIndex) {
        this.checkRange(fromIndex, toIndex);
        return new SubListView(this.list, this.startIndex + fromIndex * (long)this.d, this.startIndex + toIndex * (long)this.d);
    }

    @Override
    public SubListAccessor<E> toReversed() {
        return new SubListAccessor<E>((XSettingList)this.list, this.getEndIndex(), this.startIndex);
    }

    @Override
    public SubListAccessor<E> copy() {
        return new SubListAccessor<E>((XSettingList)this.list, this.startIndex, this.getEndIndex());
    }

    @Override
    public OldSubListAccessor<E> old() {
        return new OldSubListAccessor(this);
    }

    static class OldSubListAccessor<E>
    extends SubListView.OldSubListView<E> {
        OldSubListAccessor(SubListAccessor<E> list) {
            super(list);
        }

        @Override
        public SubListAccessor<E> parent() {
            return (SubListAccessor)super.parent();
        }
    }
}

