/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.AbstractArrayStorage;
import one.microstream.collections.AbstractChainCollection;
import one.microstream.collections.AbstractExtendedCollection;
import one.microstream.collections.AbstractSimpleArrayCollection;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.Indexer;
import one.microstream.collections.LimitList;
import one.microstream.collections.XArrays;
import one.microstream.collections.XSort;
import one.microstream.collections.types.XAddingCollection;
import one.microstream.collections.types.XCollection;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XInsertingList;
import one.microstream.collections.types.XIterable;
import one.microstream.collections.types.XProcessingCollection;
import one.microstream.collections.types.XProcessingSequence;
import one.microstream.collections.types.XPuttingCollection;
import one.microstream.collections.types.XSettingList;
import one.microstream.collections.types.XSortableSequence;
import one.microstream.collections.types.XTable;
import one.microstream.equality.Equalator;
import one.microstream.exceptions.IndexBoundsException;
import one.microstream.functional.AggregateCountingAdd;
import one.microstream.functional.AggregateCountingPut;
import one.microstream.functional.AggregateMax;
import one.microstream.functional.AggregateMin;
import one.microstream.functional.AggregateOffsetLength;
import one.microstream.functional.Aggregator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.functional.IsCustomEqual;
import one.microstream.functional.IsGreater;
import one.microstream.functional.IsSmaller;
import one.microstream.functional.XFunc;
import one.microstream.math.FastRandom;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;

public final class XUtilsCollection {
    private static final Object MARKER = new Object();

    private static <T> LimitList<T> buffer(int srcSize, long length) {
        int minimum = srcSize;
        int temp = X.checkArrayRange(length < 0L ? -length : length);
        if (temp < minimum) {
            minimum = temp;
        }
        return new LimitList(minimum);
    }

    public static final <E, C extends XIterable<? extends E>> C iterate(C collection, Predicate<? super E> predicate, Consumer<? super E> procedure) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.forwardConditionalIterate(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), 0, ((AbstractSimpleArrayCollection)((Object)collection)).internalSize(), predicate, procedure);
        } else if (collection instanceof AbstractChainCollection) {
            ((AbstractChainCollection)((Object)collection)).getInternalStorageChain().iterate(predicate, procedure);
        } else {
            collection.iterate(XFunc.wrapWithPredicate(procedure, predicate));
        }
        return collection;
    }

    public static <K, E, C extends XTable<K, E>> C valueSortByValues(C collection, Comparator<? super E> order) {
        XUtilsCollection.valueSort(collection.values(), order);
        return collection;
    }

    public static <V, E, C extends XTable<E, V>> C valueSortByKeys(C collection, Comparator<? super E> order) {
        XUtilsCollection.valueSort(collection.keys(), order);
        return collection;
    }

    public static <E, C extends XSortableSequence<E>> C valueSort(C collection, Comparator<? super E> order) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            XSort.valueSort(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), 0, XTypes.to_int(collection.size()), order);
        } else {
            collection.sort((Comparator)order);
        }
        return collection;
    }

    public static <E> void shuffle(XSortableSequence<E> collection) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.shuffle(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), XTypes.to_int(collection.size()));
        } else {
            FastRandom random = new FastRandom();
            int i = XTypes.to_int(collection.size());
            while (i > 1) {
                collection.swap(i - 1, random.nextInt(i));
                --i;
            }
        }
    }

    public static <E> void rngShuffle(XSortableSequence<E> collection, long offset, long length) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedShuffle(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), XTypes.to_int(collection.size()), XTypes.to_int(offset), XTypes.to_int(length));
        } else {
            FastRandom random = new FastRandom();
            int i = XTypes.to_int(collection.size());
            while (i > 1) {
                collection.swap(i - 1, random.nextInt(i));
                --i;
            }
        }
    }

    public static <E, C extends XGettingCollection<E>> C diverge(C elements, Consumer<? super E> positives, Consumer<? super E> negatives, Predicate<? super E> predicate) {
        elements.iterate(e -> {
            if (predicate.test((Object)e)) {
                positives.accept((Object)e);
            } else {
                negatives.accept((Object)e);
            }
        });
        return elements;
    }

    public static <E, C extends XProcessingCollection<E>> C partition(C collection, Predicate<? super E> predicate, Consumer<? super E> positiveTarget, Consumer<? super E> negativeTarget) {
        collection.process(e -> {
            if (predicate.test((Object)e)) {
                positiveTarget.accept((Object)e);
            } else {
                negativeTarget.accept((Object)e);
            }
        });
        return collection;
    }

    public static <E, C extends XGettingCollection<E>> C decide(C collection, Predicate<? super E> predicate, Consumer<? super E> positiveOperation, Consumer<? super E> negativeOperation) {
        collection.iterate(e -> {
            if (predicate.test((Object)e)) {
                positiveOperation.accept((Object)e);
            } else {
                negativeOperation.accept((Object)e);
            }
        });
        return collection;
    }

    public static <E, C extends XCollection<E>> C subtract(C elements, XGettingCollection<? extends E> other) {
        elements.removeAll(other);
        return elements;
    }

    private static String exceptionStringOffset(int size, long offset) {
        return "Invalid offset of " + offset + " for size " + size;
    }

    private static String exceptionStringRange(int size, long offset, long length) {
        return "Invalid range (" + offset + ", " + length + " for size " + size;
    }

    public static <E> int rngBinarySearch(XGettingSequence<E> sequence, long offset, long length, E element, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedBinarySearch(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), element, comparator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngHasUniqueValues(XGettingSequence<E> sequence, long offset, long length) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedHasUniqueValues(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length));
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngHasUniqueValues(XGettingSequence<E> sequence, long offset, long length, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedHasUniqueValues(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), equalator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngContainsAll(XGettingSequence<E> sequence, long offset, long length, XGettingCollection<? extends E> elements) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedContainsAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), elements);
        }
        throw new NotImplementedYetError();
    }

    public static <E> E rngMax(XGettingSequence<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return (E)AbstractArrayStorage.rangedAggregate(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new AggregateMax<E>(comparator));
        }
        throw new NotImplementedYetError();
    }

    public static <E> E rngMin(XGettingSequence<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return (E)AbstractArrayStorage.rangedAggregate(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new AggregateMin<E>(comparator));
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngIndexOf(XGettingSequence<E> sequence, long offset, long length, E sample, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedScan(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new IsCustomEqual<E>(equalator, sample));
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngIndexOF(XGettingSequence<E> sequence, long offset, long length, E element) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedIndexOF(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), element);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngCount(XGettingSequence<E> sequence, long offset, long length, E sample, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedConditionalCount(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new IsCustomEqual<E>(equalator, sample));
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngCount(XGettingSequence<E> sequence, long offset, long length, E element) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedCount(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), element);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngIsSorted(XGettingSequence<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedIsSorted(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), comparator);
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends Consumer<? super E>> C rngCopyTo(XGettingSequence<E> sequence, long offset, long length, final C target) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedCopyTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), target);
        }
        AbstractArrayStorage.validateRange0toUpperBound(XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length));
        sequence.iterate(new Consumer<E>(offset, length){
            long ofs;
            long len;
            {
                this.ofs = l;
                this.len = l2;
            }

            @Override
            public void accept(E e) {
                if (this.ofs != 0L) {
                    --this.ofs;
                    return;
                }
                if (this.len-- == 0L) {
                    throw X.BREAK();
                }
                target.accept(e);
            }
        });
        return target;
    }

    public static <E, C extends Consumer<? super E>> C rngCopyTo(XGettingSequence<E> sequence, long offset, long length, C target, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedCopyTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), target, predicate);
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends XGettingSequence<E>> C rngIterate(C sequence, long offset, long length, Consumer<? super E> procedure) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedIterate(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), procedure);
            return sequence;
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends XGettingSequence<E>> C rngIterate(C sequence, long offset, long length, IndexedAcceptor<? super E> procedure) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedIterate(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), procedure);
            return sequence;
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends XGettingSequence<E>> C rngIterate(C sequence, long offset, long length, Predicate<? super E> predicate, Consumer<? super E> procedure) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedConditionalIterate(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate, procedure);
            return sequence;
        }
        throw new NotImplementedYetError();
    }

    public static <E, A> A rngJoin(XGettingSequence<E> sequence, long offset, long length, BiConsumer<? super E, ? super A> joiner, A aggregate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedJoin(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), joiner, aggregate);
            return aggregate;
        }
        throw new NotImplementedYetError();
    }

    public static <E> E rngFind(XGettingSequence<E> sequence, long offset, long length, E sample, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedQueryElement(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new IsCustomEqual<E>(equalator, sample), null);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngContains(XGettingSequence<E> sequence, long offset, long length, E element) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedContainsSame(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), element);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngContainsId(XGettingSequence<E> sequence, long offset, long length, E element) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedContainsSame(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), element);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngContains(XGettingSequence<E> sequence, long offset, long length, E sample, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedContains(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new IsCustomEqual<E>(equalator, sample));
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngContains(XGettingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedContains(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngContainsNull(XGettingSequence<E> sequence, long offset, long length) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedContainsNull(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length));
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngApplies(XGettingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngAppliesAll(XGettingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedApplies(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngCount(XGettingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedConditionalCount(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngIndexOf(XGettingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedConditionalIndexOf(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngScan(XGettingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedScan(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate);
        }
        throw new NotImplementedYetError();
    }

    public static <E> E rngGet(XGettingSequence<E> sequence, long offset, long length, E sample, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedQueryElement(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new IsCustomEqual<E>(equalator, sample), null);
        }
        throw new NotImplementedYetError();
    }

    public static <E> E rngSearch(XGettingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedQueryElement(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate, null);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngEqualsContent(XGettingSequence<E> sequence, long offset, long length, XGettingSequence<? extends E> other, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedEqualsContent(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), other, equalator);
        }
        throw new NotImplementedYetError();
    }

    public static <E, R> R rngAggregate(XGettingSequence<E> sequence, long offset, long length, Aggregator<? super E, R> aggregate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedIterate(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), aggregate);
            return aggregate.yield();
        }
        int size = XTypes.to_int(sequence.size());
        if (offset < 0L || offset >= (long)size) {
            throw new IllegalArgumentException(XUtilsCollection.exceptionStringOffset(size, offset));
        }
        if (length == 0L) {
            return aggregate.yield();
        }
        long bound = offset + length;
        if (bound < -1L || bound > (long)size) {
            throw new IllegalArgumentException(XUtilsCollection.exceptionStringRange(size, offset, length));
        }
        AggregateOffsetLength<E, R> wrappedAggregate = new AggregateOffsetLength<E, R>(offset, length, aggregate);
        sequence.iterate(wrappedAggregate);
        return wrappedAggregate.yield();
    }

    public static <E> VarString rngAppendTo(XGettingSequence<E> sequence, long offset, long length, VarString vs) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedAppendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), vs);
        }
        throw new NotImplementedYetError();
    }

    public static <E> VarString rngAppendTo(XGettingSequence<E> sequence, long offset, long length, VarString vs, String separator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedAppendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), vs, separator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> VarString rngAppendTo(XGettingSequence<E> sequence, long offset, long length, VarString vs, char separator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedAppendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), vs, separator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> VarString rngAppendTo(XGettingSequence<E> sequence, long offset, long length, VarString vs, BiConsumer<VarString, ? super E> appender) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedAppendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), vs, appender);
        }
        throw new NotImplementedYetError();
    }

    public static <E> VarString rngAppendTo(XGettingSequence<E> sequence, long offset, long length, VarString vc, BiConsumer<VarString, ? super E> appender, char separator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedAppendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), vc, appender, separator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> VarString rngAppendTo(XGettingSequence<E> sequence, long offset, long length, VarString vs, BiConsumer<VarString, ? super E> appender, String separator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedAppendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), vs, appender, separator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngMaxIndex(XGettingSequence<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedScan(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new IsGreater<E>(comparator));
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngMinIndex(XGettingSequence<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedScan(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), new IsSmaller<E>(comparator));
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends Consumer<? super E>> C rngDistinct(XGettingSequence<E> sequence, long offset, long length, C target) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedDistinct(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), target);
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends Consumer<? super E>> C rngDistinct(XGettingSequence<E> sequence, long offset, long length, C target, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedDistinct(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), target, equalator);
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends Consumer<? super E>> C rngIntersect(XGettingSequence<E> sequence, long offset, long length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedIntersect(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), samples, equalator, target);
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends Consumer<? super E>> C rngUnion(XGettingSequence<E> sequence, long offset, long length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedUnion(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), samples, equalator, target);
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends Consumer<? super E>> C rngExcept(XGettingSequence<E> sequence, long offset, long length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedExcept(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), samples, equalator, target);
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends XAddingCollection<? super E>> C addAll(C target, E[] elements, long offset, long length, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    public static <E, C extends XAddingCollection<? super E>> C addAll(C target, XGettingCollection<? extends E> elements, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    public static <E, C extends XAddingCollection<? super E>> C putAll(C target, E[] elements, long offset, long length, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    public static <E, C extends XAddingCollection<? super E>> C putAll(C target, XGettingCollection<? extends E> elements, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    public static <E, C extends XInsertingList<? super E>> C insert(C target, int index, E[] elements, long offset, long length, Predicate<? super E> predicate) {
        int size = XTypes.to_int(target.size());
        if (index == size) {
            XUtilsCollection.addAll(target, elements, offset, length, predicate);
            return target;
        }
        if (index < 0 || index > size) {
            throw new IndexBoundsException((long)size, index);
        }
        LimitList buffer = XUtilsCollection.addAll(XUtilsCollection.buffer(elements.length, length), elements, offset, length, predicate);
        if (XTypes.to_int(buffer.size()) > 0) {
            target.insertAll((long)index, buffer.internalGetStorageArray(), 0, XTypes.to_int(buffer.size()));
        }
        return target;
    }

    public static <E, C extends XInsertingList<? super E>> C insert(C target, long index, XGettingCollection<? extends E> elements, Predicate<? super E> predicate) {
        long size = target.size();
        if (index == size) {
            XUtilsCollection.addAll(target, elements, predicate);
            return target;
        }
        if (index < 0L || index > size) {
            throw new IndexBoundsException(size, index);
        }
        LimitList buffer = XUtilsCollection.addAll(new LimitList(XTypes.to_int(elements.size())), elements, predicate);
        if (buffer.size() > 0L) {
            target.insertAll(index, buffer.internalGetStorageArray(), 0, XTypes.to_int(buffer.size()));
        }
        return target;
    }

    public static <E> E rngRetrieve(XProcessingSequence<E> sequence, long offset, long length, E element) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return (E)AbstractArrayStorage.rangedRetrieve(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), element, MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E> E rngRetrieve(XProcessingSequence<E> sequence, long offset, long length, E sample, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return (E)AbstractArrayStorage.rangedRetrieve(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), sample, equalator, MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E> E rngRetrieve(XProcessingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return (E)AbstractArrayStorage.rangedRetrieve(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate, MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngRemoveOne(XProcessingSequence<E> sequence, long offset, long length, E element) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemoveOne(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), element);
        }
        throw new NotImplementedYetError();
    }

    public static <E> boolean rngRemoveOne(XProcessingSequence<E> sequence, long offset, long length, E sample, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemoveOne(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), sample, equalator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRemoveNull(XProcessingSequence<E> sequence, long offset, long length) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemoveNull(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length));
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRemove(XProcessingSequence<E> sequence, long offset, long length, E element) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemove(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), element);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRemove(XProcessingSequence<E> sequence, long offset, long length, E sample, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemove(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), sample, equalator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRemoveAll(XProcessingSequence<E> sequence, long offset, long length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemoveAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), samples, equalator, MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRemoveAll(XProcessingSequence<E> sequence, long offset, long length, XGettingCollection<? extends E> elements) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemoveAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), elements);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRetainAll(XProcessingSequence<E> sequence, long offset, long length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRetainAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), samples, equalator, MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRetainAll(XProcessingSequence<E> sequence, long offset, long length, XGettingCollection<? extends E> elements) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRetainAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), elements, MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRemoveDuplicates(XProcessingSequence<E> sequence, long offset, long length, Equalator<? super E> equalator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemoveDuplicates(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), equalator, MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngRemoveDuplicates(XProcessingSequence<E> sequence, long offset, long length) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedRemoveDuplicates(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E> int rngReduce(XProcessingSequence<E> sequence, long offset, long length, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.rangedReduce(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), predicate, MARKER);
        }
        throw new NotImplementedYetError();
    }

    public static <E, C extends Consumer<? super E>> C rngMoveTo(XProcessingSequence<E> sequence, long offset, long length, C target, Predicate<? super E> predicate) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedMoveTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), target, predicate, MARKER);
            return target;
        }
        throw new NotImplementedYetError();
    }

    public static <E> XProcessingSequence<E> rngProcess(XProcessingSequence<E> sequence, long offset, long length, Consumer<? super E> procedure) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedProcess(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), procedure, MARKER);
            return sequence;
        }
        throw new NotImplementedYetError();
    }

    public static <E> void rngSort(XSettingList<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedSort(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), comparator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> void rngShuffle(XSettingList<E> sequence, long offset, long length) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedShuffle(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length));
        }
        throw new NotImplementedYetError();
    }

    public static <E> void rngSortMerge(XSettingList<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedSortMerge(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), comparator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> void rngSortInsertion(XSettingList<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedSortInsertion(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), comparator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> void rngSortQuick(XSettingList<E> sequence, long offset, long length, Comparator<? super E> comparator) {
        if (sequence instanceof AbstractSimpleArrayCollection) {
            AbstractArrayStorage.rangedSortQuick(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)sequence)), XTypes.to_int(sequence.size()), XTypes.to_int(offset), XTypes.to_int(length), comparator);
        }
        throw new NotImplementedYetError();
    }

    public static <E> VarString appendTo(XGettingCollection<E> collection, VarString vc) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.appendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), XTypes.to_int(collection.size()), vc);
        }
        if (XTypes.to_int(collection.size()) == 0) {
            return vc;
        }
        collection.iterate(e -> {
            VarString varString2 = vc.add(e).append(',');
        });
        return vc.deleteLast();
    }

    public static <E> VarString appendTo(XGettingCollection<E> collection, VarString vc, char separator) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.appendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), XTypes.to_int(collection.size()), vc, separator);
        }
        if (XTypes.to_int(collection.size()) == 0) {
            return vc;
        }
        collection.iterate(e -> {
            VarString varString2 = vc.add(e).append(separator);
        });
        return vc.deleteLast();
    }

    public static <E> VarString appendTo(XGettingCollection<E> collection, VarString vc, String separator) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.appendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), XTypes.to_int(collection.size()), vc, separator);
        }
        if (XTypes.to_int(collection.size()) == 0) {
            return vc;
        }
        char[] sepp = XChars.readChars(separator);
        collection.iterate(e -> {
            VarString varString2 = vc.add(e).add(sepp);
        });
        return vc.deleteLast(sepp.length);
    }

    public static <E> VarString appendTo(XGettingCollection<E> collection, VarString vc, BiConsumer<VarString, ? super E> appender) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.appendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), XTypes.to_int(collection.size()), vc, appender);
        }
        if (XTypes.to_int(collection.size()) == 0) {
            return vc;
        }
        collection.iterate(e -> {
            appender.accept(vc, (Object)e);
            vc.append(',');
        });
        return vc.deleteLast();
    }

    public static <E> VarString appendTo(XGettingCollection<E> collection, VarString vc, BiConsumer<VarString, ? super E> appender, char separator) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.appendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), XTypes.to_int(collection.size()), vc, appender, separator);
        }
        if (XTypes.to_int(collection.size()) == 0) {
            return vc;
        }
        collection.iterate(e -> {
            appender.accept(vc, (Object)e);
            vc.append(separator);
        });
        return vc.deleteLast();
    }

    public static <E> VarString appendTo(XGettingCollection<E> collection, VarString vc, BiConsumer<VarString, ? super E> appender, String separator) {
        if (collection instanceof AbstractSimpleArrayCollection) {
            return AbstractArrayStorage.appendTo(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)collection)), XTypes.to_int(collection.size()), vc, appender, separator);
        }
        if (XTypes.to_int(collection.size()) == 0) {
            return vc;
        }
        char[] sepp = XChars.readChars(separator);
        collection.iterate(e -> {
            appender.accept(vc, (Object)e);
            vc.add(sepp);
        });
        return vc.deleteLast(sepp.length);
    }

    public static <E> int addAll(XAddingCollection<E> target, E ... elements) {
        if (target instanceof AbstractExtendedCollection) {
            return ((AbstractExtendedCollection)((Object)target)).internalCountingAddAll(elements);
        }
        int addCount = 0;
        int i = 0;
        while (i < elements.length) {
            if (target.add(elements[i])) {
                ++addCount;
            }
            ++i;
        }
        return addCount;
    }

    public static <E> int addAll(XAddingCollection<E> target, E[] elements, int offset, int length) {
        if (target instanceof AbstractExtendedCollection) {
            return ((AbstractExtendedCollection)((Object)target)).internalCountingAddAll(elements, XTypes.to_int(offset), XTypes.to_int(length));
        }
        int d = XArrays.validateArrayRange(elements, offset, length);
        if (d == 0) {
            return 0;
        }
        int bound = XTypes.to_int(offset + length);
        int addCount = 0;
        int i = XTypes.to_int(offset);
        while (i != bound) {
            if (target.add(elements[i])) {
                ++addCount;
            }
            i += d;
        }
        return addCount;
    }

    public static <E> int addAll(XAddingCollection<E> target, XGettingCollection<? extends E> elements) {
        if (target instanceof AbstractExtendedCollection) {
            return ((AbstractExtendedCollection)((Object)target)).internalCountingAddAll(elements);
        }
        return elements.iterate(new AggregateCountingAdd<E>(target)).yield();
    }

    public static <E> int putAll(XPuttingCollection<E> target, E ... elements) {
        if (target instanceof AbstractExtendedCollection) {
            return ((AbstractExtendedCollection)((Object)target)).internalCountingPutAll(elements);
        }
        int addCount = 0;
        int i = 0;
        while (i < elements.length) {
            if (target.put(elements[i])) {
                ++addCount;
            }
            ++i;
        }
        return addCount;
    }

    public static <E> int putAll(XPuttingCollection<E> target, E[] elements, int offset, int length) {
        if (target instanceof AbstractExtendedCollection) {
            return ((AbstractExtendedCollection)((Object)target)).internalCountingPutAll(elements, offset, length);
        }
        int d = XArrays.validateArrayRange(elements, offset, length);
        if (d == 0) {
            return 0;
        }
        int bound = XTypes.to_int(offset + length);
        int addCount = 0;
        int i = XTypes.to_int(offset);
        while (i != bound) {
            if (target.put(elements[i])) {
                ++addCount;
            }
            i += d;
        }
        return addCount;
    }

    public static <E> int putAll(XPuttingCollection<E> target, XGettingCollection<? extends E> elements) {
        if (target instanceof AbstractExtendedCollection) {
            return ((AbstractExtendedCollection)((Object)target)).internalCountingPutAll(elements);
        }
        return elements.iterate(new AggregateCountingPut<E>(target)).yield();
    }

    public static <E, S extends E> E[] toArray(XGettingCollection<S> collection, Class<E> arrayComponentType) {
        E[] array = X.Array(arrayComponentType, X.checkArrayRange(collection.size()));
        XArrays.copyTo(collection, array);
        return array;
    }

    @SafeVarargs
    public static final <V> EqHashTable<Integer, V> toTable(V ... values) {
        EqHashTable<Integer, V> table = EqHashTable.New();
        int i = 0;
        while (i < values.length) {
            table.add(i, values[i]);
            ++i;
        }
        return table;
    }

    public static <E> int[] index(XGettingSequence<E> sequence, Predicate<? super E> predicate) {
        Indexer<E> indexer = new Indexer<E>(predicate);
        sequence.iterateIndexed(indexer);
        return indexer.yield();
    }

    public static <E> int[] orderedIndex(XGettingSequence<E> sequence, Predicate<? super E> predicate) {
        Indexer<E> indexer = new Indexer<E>(predicate);
        sequence.iterateIndexed(indexer);
        return indexer.sortAndYield();
    }

    public static <I, O, C extends XAddingCollection<? super O>> C projectInto(Iterable<? extends I> elements, Function<I, O> projector, C target) {
        for (I e : elements) {
            target.add(projector.apply(e));
        }
        return target;
    }

    private XUtilsCollection() {
        throw new UnsupportedOperationException();
    }
}

