/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import one.microstream.collections.Abstract_intArrayStorage;
import one.microstream.collections.CapacityExceededException;
import one.microstream.collections.XArrays;
import one.microstream.collections.XSort;
import one.microstream.collections.interfaces._intCollecting;
import one.microstream.exceptions.ArrayCapacityException;
import one.microstream.exceptions.IndexBoundsException;
import one.microstream.functional._intFunction;
import one.microstream.functional._intIndexProcedure;
import one.microstream.functional._intPredicate;
import one.microstream.functional._intProcedure;
import one.microstream.math.XMath;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.Composition;

public final class _intList
implements _intCollecting,
Composition {
    private int[] data;
    private int size;

    private static String exceptionStringRange(int size, int startIndex, int length) {
        return "Range [" + (length < 0 ? String.valueOf(startIndex + length + 1) + ";" + startIndex : String.valueOf(startIndex) + ";" + (startIndex + length - 1)) + "] not in [0;" + (size - 1) + "]";
    }

    public _intList() {
        this.size = 0;
        this.data = new int[1];
    }

    public _intList(int initialCapacity) {
        this.size = 0;
        this.data = new int[XMath.pow2BoundMaxed(initialCapacity)];
    }

    public _intList(_intList original) throws NullPointerException {
        this.size = original.size;
        this.data = (int[])original.data.clone();
    }

    public _intList(int ... elements) throws NullPointerException {
        this.size = elements.length;
        this.data = new int[XMath.pow2BoundMaxed(this.size)];
        System.arraycopy(elements, 0, this.data, 0, this.size);
    }

    public _intList(int initialCapacity, int[] src, int srcStart, int srcLength) {
        this.data = new int[XMath.pow2BoundMaxed(initialCapacity >= srcLength ? initialCapacity : srcLength)];
        this.size = srcLength;
        System.arraycopy(src, srcStart, this.data, 0, this.size);
    }

    _intList(int[] storageArray, int size) {
        this.size = size;
        this.data = storageArray;
    }

    void internalAdd(int element) {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new ArrayCapacityException();
            }
            this.data = new int[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        this.data[this.size++] = element;
    }

    private int internalInputArray(int index, int[] elements, int elementsSize) {
        int newCapacity;
        if (this.data.length - this.size >= elementsSize) {
            System.arraycopy(this.data, index, this.data, index + elementsSize, elementsSize);
            System.arraycopy(elements, 0, this.data, index, elementsSize);
            this.size += elementsSize;
            return elementsSize;
        }
        if (Integer.MAX_VALUE - this.size < elementsSize) {
            throw new ArrayCapacityException((long)elementsSize + (long)this.size);
        }
        int newSize = this.size + elementsSize;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        int[] data = new int[newCapacity];
        System.arraycopy(this.data, 0, data, 0, index);
        System.arraycopy(this.data, index, data, index + elementsSize, elementsSize);
        this.data = data;
        System.arraycopy(elements, 0, data, index, elementsSize);
        this.size = newSize;
        return elementsSize;
    }

    private int internalInputArray(int index, int[] elements, int offset, int length) {
        int newCapacity;
        if (length < 0) {
            return this.internalReverseInputArray(index, elements, offset, -length);
        }
        if (this.data.length - this.size >= length) {
            System.arraycopy(this.data, index, this.data, index + length, length);
            System.arraycopy(elements, offset, this.data, index, length);
            this.size += length;
            return length;
        }
        if (Integer.MAX_VALUE - this.size < length) {
            throw new ArrayCapacityException((long)length + (long)this.size);
        }
        int newSize = this.size + length;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        int[] data = new int[newCapacity];
        System.arraycopy(this.data, 0, data, 0, index);
        System.arraycopy(this.data, index, data, index + length, length);
        this.data = data;
        System.arraycopy(elements, offset, data, index, length);
        this.size = newSize;
        return length;
    }

    private int internalReverseInputArray(int index, int[] elements, int offset, int length) {
        int newCapacity;
        if (this.data.length - this.size >= length) {
            System.arraycopy(this.data, index, this.data, index + length, length);
            XArrays.reverseArraycopy(elements, offset, this.data, index, length);
            this.size += length;
            return length;
        }
        if (Integer.MAX_VALUE - this.size < length) {
            throw new ArrayCapacityException((long)length + (long)this.size);
        }
        int newSize = this.size + length;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        int[] data = new int[newCapacity];
        System.arraycopy(this.data, 0, data, 0, index);
        System.arraycopy(this.data, index, data, index + length, length);
        XArrays.reverseArraycopy(elements, 0, this.data, index, -length);
        this.size = newSize;
        return length;
    }

    protected int[] internalGetStorageArray() {
        return this.data;
    }

    protected int internalSize() {
        return this.size;
    }

    protected int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.size;
        return nArray;
    }

    protected int internalCountingAddAll(int[] elements) throws UnsupportedOperationException {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return elements.length;
    }

    protected int internalCountingAddAll(int[] elements, int offset, int length) throws UnsupportedOperationException {
        if (length >= 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
            return length;
        }
        int bound = offset + length;
        if (bound < -1) {
            throw new IndexBoundsException((long)bound);
        }
        this.ensureFreeCapacity(-length);
        int[] data = this.data;
        int size = this.size;
        int i = offset;
        while (i > bound) {
            data[size++] = elements[i];
            --i;
        }
        this.size = size;
        return -length;
    }

    protected int internalCountingAddAll(_intList elements) throws UnsupportedOperationException {
        int oldSize = this.size;
        elements.copyTo(this);
        return this.size - oldSize;
    }

    protected int internalCountingPutAll(int[] elements) throws UnsupportedOperationException {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return elements.length;
    }

    protected int internalCountingPutAll(int[] elements, int offset, int length) throws UnsupportedOperationException {
        if (length >= 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
            return length;
        }
        int bound = offset + length;
        if (bound < -1) {
            throw new IndexBoundsException((long)bound);
        }
        this.ensureFreeCapacity(-length);
        int[] data = this.data;
        int size = this.size;
        int i = offset;
        while (i > bound) {
            data[size++] = elements[i];
            --i;
        }
        this.size = size;
        return -length;
    }

    protected int internalCountingPutAll(_intList elements) throws UnsupportedOperationException {
        int oldSize = this.size;
        elements.copyTo(this);
        return this.size - oldSize;
    }

    public _intList copy() {
        return new _intList(this);
    }

    public _intList toReversed() {
        int[] data = this.data;
        int[] reversedData = new int[this.data.length];
        int i = this.size;
        int r = 0;
        while (i-- > 0) {
            reversedData[r++] = data[i];
        }
        return new _intList(reversedData, this.size);
    }

    public int[] toArray() {
        int[] array = new int[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    public _intList iterate(_intProcedure procedure) {
        Abstract_intArrayStorage.iterate(this.data, this.size, procedure);
        return this;
    }

    public _intList iterate(_intIndexProcedure procedure) {
        Abstract_intArrayStorage.iterate(this.data, this.size, procedure);
        return this;
    }

    public int count(int element) {
        return Abstract_intArrayStorage.count(this.data, this.size, element);
    }

    public int count(_intPredicate predicate) {
        return Abstract_intArrayStorage.count(this.data, this.size, predicate);
    }

    public int indexOf(int element) {
        return Abstract_intArrayStorage.indexOf(this.data, this.size, element);
    }

    public int indexOf(_intPredicate predicate) {
        return Abstract_intArrayStorage.indexOf(this.data, this.size, predicate);
    }

    public int lastIndexOf(int element) {
        return Abstract_intArrayStorage.rngIndexOF(this.data, this.size, this.size - 1, -this.size, element);
    }

    public int lastIndexOf(_intPredicate predicate) {
        return Abstract_intArrayStorage.lastIndexOf(this.data, this.size, predicate);
    }

    public int scan(_intPredicate predicate) {
        return Abstract_intArrayStorage.scan(this.data, this.size, predicate);
    }

    public int first() {
        return this.data[0];
    }

    public int last() {
        return this.data[this.size - 1];
    }

    public int search(_intPredicate predicate) {
        return Abstract_intArrayStorage.search(this.data, this.size, predicate);
    }

    public int max() {
        return Abstract_intArrayStorage.max(this.data, this.size);
    }

    public int min() {
        return Abstract_intArrayStorage.min(this.data, this.size);
    }

    public boolean hasVolatileElements() {
        return false;
    }

    public boolean nullAllowed() {
        return true;
    }

    public boolean isSorted(boolean ascending) {
        return Abstract_intArrayStorage.isSorted(this.data, this.size, ascending);
    }

    public boolean containsSearched(_intPredicate predicate) {
        return Abstract_intArrayStorage.containsSearched(this.data, this.size, predicate);
    }

    public boolean applies(_intPredicate predicate) {
        return Abstract_intArrayStorage.appliesAll(this.data, this.size, predicate);
    }

    public boolean contains(int element) {
        return Abstract_intArrayStorage.contains(this.data, this.size, element);
    }

    public boolean containsAll(_intList elements) {
        return Abstract_intArrayStorage.containsAll(this.data, this.size, elements.data, 0, elements.size);
    }

    public <C extends _intCollecting> C copyTo(C target) {
        return Abstract_intArrayStorage.copyTo(this.data, this.size, target);
    }

    public _intCollecting copyTo(_intCollecting target, _intPredicate predicate) {
        return Abstract_intArrayStorage.copyTo(this.data, this.size, target, predicate);
    }

    public int[] copyTo(int[] target, int offset) {
        System.arraycopy(this.data, 0, target, offset, this.size);
        return target;
    }

    public int[] copyTo(int[] target, int targetOffset, int offset, int length) {
        return Abstract_intArrayStorage.rngCopyTo(this.data, this.size, offset, length, target, targetOffset);
    }

    public _intCollecting copySelection(_intCollecting target, long ... indices) {
        return Abstract_intArrayStorage.copySelection(this.data, this.size, indices, target);
    }

    public _intList shiftTo(int sourceIndex, int targetIndex) {
        if (sourceIndex >= this.size) {
            throw new IndexBoundsException((long)this.size, sourceIndex);
        }
        if (targetIndex >= this.size) {
            throw new IndexBoundsException((long)this.size, sourceIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0) {
                throw new IndexBoundsException((long)this.size, sourceIndex);
            }
            return this;
        }
        int shiftling = this.data[sourceIndex];
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, sourceIndex + 1, this.data, sourceIndex, targetIndex - sourceIndex);
        } else {
            System.arraycopy(this.data, targetIndex, this.data, targetIndex + 1, sourceIndex - targetIndex);
        }
        this.data[targetIndex] = shiftling;
        return this;
    }

    public _intList shiftTo(int sourceIndex, int targetIndex, int length) {
        if (sourceIndex + length >= this.size) {
            throw new IndexBoundsException((long)this.size, sourceIndex);
        }
        if (targetIndex + length >= this.size) {
            throw new IndexBoundsException((long)this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0) {
                throw new IndexBoundsException((long)this.size, sourceIndex);
            }
            return this;
        }
        int[] shiftlings = new int[length];
        System.arraycopy(this.data, sourceIndex, shiftlings, 0, length);
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, sourceIndex + length, this.data, sourceIndex, targetIndex - sourceIndex);
        } else {
            System.arraycopy(this.data, targetIndex, this.data, targetIndex + length, sourceIndex - targetIndex);
        }
        System.arraycopy(shiftlings, 0, this.data, targetIndex, length);
        return this;
    }

    public _intList shiftBy(int sourceIndex, int distance) {
        return this.shiftTo(sourceIndex, sourceIndex + distance);
    }

    public _intList shiftBy(int sourceIndex, int distance, int length) {
        return this.shiftTo(sourceIndex, sourceIndex + distance, length);
    }

    public _intList swap(int indexA, int indexB) throws IndexBoundsException, IndexOutOfBoundsException {
        if (indexA >= this.size) {
            throw new IndexBoundsException((long)this.size, indexA);
        }
        if (indexB >= this.size) {
            throw new IndexBoundsException((long)this.size, indexB);
        }
        int t = this.data[indexA];
        this.data[indexA] = this.data[indexB];
        this.data[indexB] = t;
        return this;
    }

    public _intList swap(int indexA, int indexB, int length) {
        Abstract_intArrayStorage.swap(this.data, this.size, indexA, indexB, length);
        return this;
    }

    public _intList reverse() {
        Abstract_intArrayStorage.reverse(this.data, this.size);
        return this;
    }

    public void setFirst(int element) {
        this.data[0] = element;
    }

    public void setLast(int element) {
        this.data[this.size - 1] = element;
    }

    public _intList set(int offset, int ... elements) {
        if (offset < 0 || offset + elements.length > this.size) {
            throw new IndexOutOfBoundsException(_intList.exceptionStringRange(this.size, offset, offset + elements.length - 1));
        }
        System.arraycopy(elements, 0, this.data, offset, elements.length);
        return this;
    }

    public _intList set(int offset, int[] src, int srcIndex, int srcLength) {
        Abstract_intArrayStorage.set(this.data, this.size, offset, src, srcIndex, srcLength);
        return this;
    }

    public _intList fill(int offset, int length, int element) {
        Abstract_intArrayStorage.fill(this.data, this.size, offset, length, element);
        return this;
    }

    public _intList sort() {
        XSort.sort(this.data, 0, this.size);
        return this;
    }

    public boolean replaceOne(int element, int replacement) {
        return Abstract_intArrayStorage.replaceOne(this.data, this.size, element, replacement);
    }

    public boolean replaceOne(_intPredicate predicate, int substitute) {
        return Abstract_intArrayStorage.substituteOne(this.data, this.size, predicate, substitute);
    }

    public int replace(int element, int replacement) {
        return Abstract_intArrayStorage.replace(this.data, this.size, element, replacement);
    }

    public int replace(_intPredicate predicate, int substitute) {
        return Abstract_intArrayStorage.substitute(this.data, this.size, predicate, substitute);
    }

    @Deprecated
    public int replaceAll(_intList elements, int replacement) {
        throw new NotImplementedYetError();
    }

    public int modify(_intFunction mapper) {
        return Abstract_intArrayStorage.modify(this.data, this.size, mapper);
    }

    public int modify(_intPredicate predicate, _intFunction mapper) {
        return Abstract_intArrayStorage.modify(this.data, this.size, predicate, mapper);
    }

    public int currentCapacity() {
        return this.data.length;
    }

    public int maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    public boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    public int freeCapacity() {
        return Integer.MAX_VALUE - this.size;
    }

    public int optimize() {
        int requiredCapacity = XMath.pow2BoundMaxed(this.size);
        if (requiredCapacity != this.data.length) {
            this.data = new int[requiredCapacity];
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        return this.data.length;
    }

    public _intList ensureFreeCapacity(int requiredFreeCapacity) {
        int newCapacity;
        if (this.data.length - this.size >= requiredFreeCapacity) {
            return this;
        }
        if (Integer.MAX_VALUE - this.size < requiredFreeCapacity) {
            throw new ArrayCapacityException((long)requiredFreeCapacity + (long)this.size);
        }
        int newSize = this.size + requiredFreeCapacity;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        int[] data = new int[newCapacity];
        System.arraycopy(this.data, 0, data, 0, this.size);
        this.data = data;
        return this;
    }

    public _intList ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            int[] data = new int[XMath.pow2BoundMaxed(minCapacity)];
            System.arraycopy(this.data, 0, data, 0, this.size);
            this.data = data;
        }
        return this;
    }

    public void accept(int element) {
        this.internalAdd(element);
    }

    @Override
    public boolean add(int element) {
        this.internalAdd(element);
        return true;
    }

    public _intList add(int ... elements) {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return this;
    }

    public _intList addAll(int[] elements, int offset, int length) {
        if (length >= 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
        } else {
            int bound = length + length;
            if (bound < -1) {
                throw new ArrayIndexOutOfBoundsException(bound + 1);
            }
            this.ensureFreeCapacity(-length);
            int[] data = this.data;
            int size = this.size;
            int i = length;
            while (i > bound) {
                data[size++] = elements[i];
                --i;
            }
            this.size = size;
        }
        return this;
    }

    public _intList addAll(_intList elements) {
        return elements.copyTo(this);
    }

    public boolean nullAdd() {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            this.data = new int[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        ++this.size;
        return true;
    }

    public boolean nullPut() {
        return this.nullAdd();
    }

    public boolean put(int element) {
        this.internalAdd(element);
        return true;
    }

    public _intList put(int ... elements) {
        return this.add(elements);
    }

    public _intList putAll(int[] elements, int offset, int length) {
        return this.addAll(elements, offset, length);
    }

    public _intList putAll(_intList elements) {
        return elements.copyTo(this);
    }

    public boolean prepend(int element) {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new CapacityExceededException();
            }
            this.data = new int[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 1, this.size);
        } else {
            System.arraycopy(this.data, 0, this.data, 1, this.size);
        }
        this.data[0] = element;
        ++this.size;
        return true;
    }

    public _intList prepend(int ... elements) {
        this.internalInputArray(0, elements, elements.length);
        return this;
    }

    public _intList prependAll(int[] elements, int offset, int length) {
        this.internalInputArray(0, elements, offset, length);
        return this;
    }

    public _intList prependAll(_intList elements) {
        this.insertAll(0, elements);
        return this;
    }

    public boolean preput(int element) {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            this.data = new int[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        } else {
            System.arraycopy(this.data, 0, this.data, 1, this.size);
        }
        this.data[0] = element;
        ++this.size;
        return true;
    }

    public _intList preput(int ... elements) {
        this.internalInputArray(0, elements, elements.length);
        return this;
    }

    public _intList preputAll(int[] elements, int offset, int length) {
        this.internalInputArray(0, elements, offset, length);
        return this;
    }

    public _intList preputAll(_intList elements) {
        this.inputAll(0, elements);
        return this;
    }

    public boolean insert(int index, int element) {
        if (this.size >= Integer.MAX_VALUE) {
            throw new ArrayCapacityException();
        }
        if (index >= this.size || index < 0) {
            if (index == this.size) {
                if (this.size >= this.data.length) {
                    if (this.size >= Integer.MAX_VALUE) {
                        throw new IndexOutOfBoundsException();
                    }
                    this.data = new int[(int)((float)this.data.length * 2.0f)];
                    System.arraycopy(this.data, 0, this.data, 0, this.size);
                }
                this.data[this.size++] = element;
                return true;
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            int[] oldData = this.data;
            this.data = new int[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, index);
            System.arraycopy(oldData, index, this.data, index + 1, this.size - index);
        } else {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        }
        this.data[index] = element;
        ++this.size;
        return true;
    }

    public int insert(int index, int ... elements) throws IndexOutOfBoundsException {
        if (index >= this.size || index < 0) {
            if (index == this.size) {
                return this.internalCountingAddAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray(index, elements, elements.length);
    }

    public int insertAll(int index, int[] elements, int offset, int length) {
        if (index >= this.size || index < 0) {
            if (index == this.size) {
                return this.internalCountingAddAll(elements, offset, length);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray(index, elements, offset, length);
    }

    public int insertAll(int index, _intList elements) {
        if (index >= this.size || index < 0) {
            if (index == this.size) {
                return this.internalCountingAddAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray(index, elements.data, elements.size);
    }

    public boolean input(int index, int element) {
        if (this.size >= Integer.MAX_VALUE) {
            throw new ArrayCapacityException();
        }
        if (index >= this.size || index < 0) {
            if (index == this.size) {
                if (this.size >= this.data.length) {
                    if (this.size >= Integer.MAX_VALUE) {
                        throw new IndexOutOfBoundsException();
                    }
                    this.data = new int[(int)((float)this.data.length * 2.0f)];
                    System.arraycopy(this.data, 0, this.data, 0, this.size);
                }
                this.data[this.size++] = element;
                return true;
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            int[] oldData = this.data;
            this.data = new int[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, index);
            System.arraycopy(oldData, index, this.data, index + 1, this.size - index);
        } else {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        }
        this.data[index] = element;
        ++this.size;
        return true;
    }

    public int input(int index, int ... elements) throws IndexOutOfBoundsException {
        if (index >= this.size || index < 0) {
            if (index == this.size) {
                return this.internalCountingPutAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray(index, elements, elements.length);
    }

    public int inputAll(int index, int[] elements, int offset, int length) {
        if (index >= this.size || index < 0) {
            if (index == this.size) {
                return this.internalCountingPutAll(elements, offset, length);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray(index, elements, offset, length);
    }

    public int inputAll(int index, _intList elements) {
        if (index >= this.size || index < 0) {
            if (index == this.size) {
                return this.internalCountingPutAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray(index, elements.data, elements.size);
    }

    public void truncate() {
        this.size = 0;
        this.data = new int[1];
    }

    public int consolidate() {
        return 0;
    }

    public boolean removeOne(int element) {
        if (Abstract_intArrayStorage.removeOne(this.data, this.size, element)) {
            --this.size;
            return true;
        }
        return false;
    }

    public int retrieve(int element) {
        int removedElement = Abstract_intArrayStorage.retrieve(this.data, this.size, element, Integer.MIN_VALUE);
        if (removedElement != 0) {
            --this.size;
            return removedElement;
        }
        return 0;
    }

    public int retrieve(_intPredicate predicate) {
        int e = Abstract_intArrayStorage.retrieve(this.data, this.size, predicate, Integer.MIN_VALUE);
        if (e != 0) {
            --this.size;
            return e;
        }
        return 0;
    }

    public int remove(int element) {
        int removeCount = XArrays.removeAllFromArray(this.data, 0, this.size, element);
        this.size -= removeCount;
        return removeCount;
    }

    public int removeAt(int index) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        int oldValue = this.data[index];
        int moveCount = this.size - 1 - index;
        if (moveCount > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, moveCount);
        }
        this.data[--this.size] = 0;
        return oldValue;
    }

    public int remove(_intPredicate predicate) {
        int removeCount = Abstract_intArrayStorage.reduce(this.data, this.size, predicate, Integer.MIN_VALUE);
        this.size -= removeCount;
        return removeCount;
    }

    public _intList process(_intProcedure procedure) {
        this.size -= Abstract_intArrayStorage.process(this.data, this.size, procedure, Integer.MIN_VALUE);
        return this;
    }

    public _intCollecting moveTo(_intCollecting target, _intPredicate predicate) {
        this.size -= Abstract_intArrayStorage.moveTo(this.data, this.size, target, predicate, Integer.MIN_VALUE);
        return target;
    }

    public _intCollecting moveSelection(_intCollecting target, long ... indices) {
        this.size -= Abstract_intArrayStorage.moveSelection(this.data, this.size, indices, target, Integer.MIN_VALUE);
        return target;
    }

    public int removeAll(_intList elements) {
        throw new NotImplementedYetError();
    }

    public int removeDuplicates() {
        int removeCount = Abstract_intArrayStorage.removeDuplicates(this.data, this.size, Integer.MIN_VALUE);
        this.size -= removeCount;
        return removeCount;
    }

    public int fetch() {
        int element = this.data[0];
        System.arraycopy(this.data, 1, this.data, 0, --this.size);
        this.data[this.size] = 0;
        return element;
    }

    public int pop() {
        int element = this.data[this.size - 1];
        this.data[--this.size] = 0;
        return element;
    }

    public int pinch() {
        if (this.size == 0) {
            return 0;
        }
        int element = this.data[0];
        System.arraycopy(this.data, 1, this.data, 0, --this.size);
        this.data[this.size] = 0;
        return element;
    }

    public int pick() {
        if (this.size == 0) {
            return 0;
        }
        int element = this.data[--this.size];
        this.data[this.size] = 0;
        return element;
    }

    public int removeSelection(int[] indices) {
        int removeCount = Abstract_intArrayStorage.removeSelection(this.data, this.size, indices, Integer.MIN_VALUE);
        this.size -= removeCount;
        return removeCount;
    }

    public _intList removeRange(int startIndex, int length) {
        this.size -= Abstract_intArrayStorage.removeRange(this.data, this.size, startIndex, length);
        return this;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.data[index];
    }

    public boolean set(int index, int element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        this.data[index] = element;
        return false;
    }

    public int setGet(int index, int element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        int old = this.data[index];
        this.data[index] = element;
        return old;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return Abstract_intArrayStorage.toString(this.data, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public static class Factory {
        private final int initialCapacity;

        public Factory(int initialCapacity) {
            this.initialCapacity = XMath.pow2BoundMaxed(initialCapacity);
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public _intList newInstance() {
            return new _intList(new int[this.initialCapacity], this.initialCapacity);
        }
    }
}

