/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.entity;

import one.microstream.X;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingTable;
import one.microstream.entity.Entity;
import one.microstream.entity.EntityExceptionMissingDataForVersion;
import one.microstream.entity.EntityLayer;
import one.microstream.entity.EntityVersionCleaner;
import one.microstream.entity.EntityVersionContext;

public final class EntityLayerVersioning<K>
extends EntityLayer {
    EntityVersionContext<K> context;
    EqHashTable<K, Entity> versions;

    protected EntityLayerVersioning(Entity inner, EntityVersionContext<K> context) {
        super(inner);
        this.context = X.notNull(context);
        this.versions = EqHashTable.New(context.equalator());
    }

    synchronized XGettingTable<K, Entity> versions() {
        return this.versions.immure();
    }

    @Override
    protected synchronized Entity entityData() {
        K versionKey = this.context.currentVersion();
        if (versionKey == null) {
            return super.entityData();
        }
        Entity versionedData = this.versions.get(versionKey);
        if (versionedData == null) {
            throw new EntityExceptionMissingDataForVersion(this.entityIdentity(), versionKey);
        }
        return versionedData;
    }

    @Override
    protected synchronized void entityCreated() {
        K versionKey = this.context.versionForUpdate();
        if (versionKey != null) {
            this.versions.put(versionKey, super.entityData());
        }
        super.entityCreated();
    }

    @Override
    protected synchronized boolean updateEntityData(Entity data) {
        K versionKey = this.context.versionForUpdate();
        if (versionKey != null) {
            this.versions.put(versionKey, data);
            EntityVersionCleaner<K> cleaner = this.context.cleaner();
            if (cleaner != null) {
                cleaner.cleanVersions(this.versions);
            }
        }
        return super.updateEntityData(data);
    }
}

