/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.entity.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import one.microstream.chars.XChars;
import one.microstream.entity.Entity;
import one.microstream.entity.codegen.EntityExceptionInvalidEntityMethod;
import one.microstream.entity.codegen.Member;
import one.microstream.entity.codegen.TypeGenerator;
import one.microstream.entity.codegen.TypeGeneratorAppendableType;
import one.microstream.entity.codegen.TypeGeneratorCreatorType;
import one.microstream.entity.codegen.TypeGeneratorDataType;
import one.microstream.entity.codegen.TypeGeneratorEntityIdentityType;
import one.microstream.entity.codegen.TypeGeneratorHashEqualatorType;
import one.microstream.entity.codegen.TypeGeneratorUpdaterType;

public class EntityProcessor
extends AbstractProcessor {
    private static final String OPTION_HASHEQUALATOR = "microstream.entity.hashequalator";
    private static final String OPTION_APPENDABLE = "microstream.entity.appendable";
    private boolean generateHashEqualator;
    private boolean generateAppendable;
    private List<ExecutableElement> javaLangObjectMethods;
    private TypeMirror runtimeExceptionType;
    private boolean processed = false;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add(OPTION_HASHEQUALATOR);
        set.add(OPTION_APPENDABLE);
        return set;
    }

    private boolean getBooleanOption(String name, boolean defaultValue) {
        String option = this.processingEnv.getOptions().get(name);
        return XChars.isEmpty(option) ? defaultValue : Boolean.parseBoolean(option);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.javaLangObjectMethods = processingEnv.getElementUtils().getTypeElement(Object.class.getName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(method -> !method.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
        this.runtimeExceptionType = processingEnv.getElementUtils().getTypeElement(RuntimeException.class.getName()).asType();
        this.generateHashEqualator = this.getBooleanOption(OPTION_HASHEQUALATOR, true);
        this.generateAppendable = this.getBooleanOption(OPTION_APPENDABLE, true);
    }

    boolean isGenerateHashEqualator() {
        return this.generateHashEqualator;
    }

    boolean getGenerateAppendable() {
        return this.generateAppendable;
    }

    ProcessingEnvironment getEnvironment() {
        return this.processingEnv;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || this.processed) {
            return false;
        }
        roundEnv.getRootElements().stream().filter(e -> e.getKind() == ElementKind.INTERFACE).map(TypeElement.class::cast).filter(this::isEntity).forEach(this::generateTypes);
        this.processed = true;
        return false;
    }

    private boolean isEntity(TypeElement typeElem) {
        return typeElem.getInterfaces().stream().anyMatch(this::isEntity);
    }

    private boolean isEntity(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement element = (TypeElement)declaredType.asElement();
            if (element.getQualifiedName().contentEquals(Entity.class.getName())) {
                return true;
            }
            return this.isEntity(element);
        }
        return false;
    }

    private void generateTypes(TypeElement entityTypeElement) {
        LinkedHashSet<ExecutableElement> potentialMemberMethods = new LinkedHashSet<ExecutableElement>();
        this.collectPotentialMemberMethods(entityTypeElement, potentialMemberMethods);
        potentialMemberMethods.forEach(this::validateMemberMethod);
        DeclaredType entityType = (DeclaredType)entityTypeElement.asType();
        List<Member> members = potentialMemberMethods.stream().map(element -> new Member((ExecutableElement)element, this.getTypeInEntity(entityType, (ExecutableElement)element))).collect(Collectors.toList());
        ArrayList<TypeGenerator> typeGenerators = new ArrayList<TypeGenerator>(5);
        typeGenerators.add(new TypeGeneratorDataType(this, entityTypeElement, members));
        typeGenerators.add(new TypeGeneratorEntityIdentityType(this, entityTypeElement, members));
        typeGenerators.add(new TypeGeneratorCreatorType(this, entityTypeElement, members));
        typeGenerators.add(new TypeGeneratorUpdaterType(this, entityTypeElement, members));
        if (this.generateHashEqualator) {
            typeGenerators.add(new TypeGeneratorHashEqualatorType(this, entityTypeElement, members));
        }
        if (this.generateAppendable) {
            typeGenerators.add(new TypeGeneratorAppendableType(this, entityTypeElement, members));
        }
        typeGenerators.forEach(TypeGenerator::generateType);
    }

    private void collectPotentialMemberMethods(TypeElement typeElement, Set<ExecutableElement> members) {
        typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(method -> this.isPotentialMemberMethod((ExecutableElement)method, (Collection<ExecutableElement>)members)).forEach(members::add);
        typeElement.getInterfaces().stream().filter(type -> type.getKind() == TypeKind.DECLARED).map(DeclaredType.class::cast).map(DeclaredType::asElement).map(TypeElement.class::cast).filter(element -> !element.getQualifiedName().contentEquals(Entity.class.getName())).forEach(element -> this.collectPotentialMemberMethods((TypeElement)element, members));
    }

    private boolean isPotentialMemberMethod(ExecutableElement method, Collection<ExecutableElement> methods) {
        return !method.isDefault() && !method.getModifiers().contains((Object)Modifier.STATIC) && !this.isOverwritten(method, methods) && !this.overridesObjectMethod(method);
    }

    private boolean isOverwritten(ExecutableElement overridden, Collection<ExecutableElement> methods) {
        Elements elements = this.processingEnv.getElementUtils();
        return methods.stream().filter(overrider -> overridden != overrider && (elements.overrides((ExecutableElement)overrider, overridden, (TypeElement)overrider.getEnclosingElement()) || elements.overrides(overridden, (ExecutableElement)overrider, (TypeElement)overridden.getEnclosingElement()))).findAny().isPresent();
    }

    private boolean overridesObjectMethod(ExecutableElement method) {
        Elements elements = this.processingEnv.getElementUtils();
        return this.javaLangObjectMethods.stream().filter(objectMethod -> elements.overrides(method, (ExecutableElement)objectMethod, (TypeElement)method.getEnclosingElement())).findAny().isPresent();
    }

    private void validateMemberMethod(ExecutableElement method) {
        if (method.getReturnType().getKind() == TypeKind.VOID || method.getTypeParameters().size() > 0 || method.getParameters().size() > 0 || this.containsCheckedException(method.getThrownTypes())) {
            throw new EntityExceptionInvalidEntityMethod(method);
        }
    }

    private boolean containsCheckedException(List<? extends TypeMirror> exceptionTypes) {
        return exceptionTypes.stream().anyMatch(this::isCheckedException);
    }

    private boolean isCheckedException(TypeMirror exceptionType) {
        return !this.processingEnv.getTypeUtils().isAssignable(exceptionType, this.runtimeExceptionType);
    }

    private TypeMirror getTypeInEntity(DeclaredType entityType, ExecutableElement method) {
        TypeMirror memberType = this.processingEnv.getTypeUtils().asMemberOf(entityType, method);
        return memberType instanceof ExecutableType ? ((ExecutableType)memberType).getReturnType() : memberType;
    }
}

