/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.entity.codegen;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import one.microstream.chars.VarString;
import one.microstream.entity.codegen.EntityProcessor;
import one.microstream.entity.codegen.Member;
import one.microstream.exceptions.IORuntimeException;

abstract class TypeGenerator {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private static final String GENERATED_PREFIX = "_";
    final EntityProcessor processor;
    final TypeElement entityTypeElement;
    final List<Member> members;
    final String entityName;
    final String packageName;
    final String typeName;
    private final Map<String, String> imports = new HashMap<String, String>();
    private final VarString source = VarString.New();

    TypeGenerator(EntityProcessor processor, TypeElement entityTypeElement, List<Member> members, boolean memberTypesUsed, String typeNameSuffix) {
        this.processor = processor;
        this.entityTypeElement = entityTypeElement;
        this.entityName = entityTypeElement.getSimpleName().toString();
        this.packageName = VarString.New().add(processor.getEnvironment().getElementUtils().getPackageOf(entityTypeElement).getQualifiedName().toString()).add('.').add(GENERATED_PREFIX).add(this.entityName).toString();
        this.typeName = this.getGeneratedTypeName(typeNameSuffix);
        this.members = this.prepareMembers(members, memberTypesUsed);
        this.addImport(entityTypeElement.asType());
    }

    String getGeneratedTypeName(String suffix) {
        return this.entityName.concat(suffix);
    }

    private List<Member> prepareMembers(List<Member> members, boolean memberTypesUsed) {
        if (memberTypesUsed) {
            members.forEach(m -> {
                String string = m.typeName = this.addImport(m.type);
            });
            int maxTypeNameLength = members.stream().mapToInt(m -> m.typeName.length()).max().getAsInt();
            members.forEach(m -> {
                m.paddedTypeName = this.rpad(m.typeName, maxTypeNameLength);
                m.throwsClause = this.createThrowsClause((Member)m);
            });
        }
        int maxMethodNameLength = members.stream().mapToInt(m -> m.methodName.length()).max().getAsInt();
        int maxNameLength = members.stream().mapToInt(m -> m.name.length()).max().getAsInt();
        members.forEach(m -> {
            m.paddedMethodName = this.rpad(m.methodName, maxMethodNameLength);
            m.paddedName = this.rpad(m.name, maxNameLength);
        });
        return members;
    }

    private String rpad(String string, int maxLength) {
        int length = string.length();
        return length >= maxLength ? string : VarString.New(string).blank(maxLength - length).toString();
    }

    private String createThrowsClause(Member member) {
        List<? extends TypeMirror> thrownTypes = member.element.getThrownTypes();
        return thrownTypes.isEmpty() ? "" : thrownTypes.stream().map(this::addImport).collect(Collectors.joining(", ", " throws ", ""));
    }

    final void generateType() {
        this.processor.getEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, VarString.New("Generating ").add(this.packageName).add('.').add(this.typeName).toString());
        this.generateCode();
        this.writeFile();
    }

    abstract void generateCode();

    String addImport(TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            return this.addImport(((ArrayType)type).getComponentType()).concat("[]");
        }
        if (type.getKind() != TypeKind.DECLARED) {
            return type.toString();
        }
        DeclaredType declaredType = (DeclaredType)type;
        DeclaredType declaredTypeErasure = (DeclaredType)this.processor.getEnvironment().getTypeUtils().erasure(declaredType);
        TypeElement typeErasureElement = (TypeElement)declaredTypeErasure.asElement();
        String simpleName = typeErasureElement.getSimpleName().toString();
        String qualifiedName = typeErasureElement.getQualifiedName().toString();
        String packageName = this.processor.getEnvironment().getElementUtils().getPackageOf(typeErasureElement).toString();
        VarString vs = VarString.New();
        if (JAVA_LANG_PACKAGE.equals(packageName) || this.packageName.equals(packageName)) {
            vs.add(simpleName);
        } else {
            String mappedQualifiedName = this.imports.computeIfAbsent(simpleName, key -> qualifiedName);
            if (mappedQualifiedName.equals(qualifiedName)) {
                vs.add(simpleName);
            } else {
                vs.add(qualifiedName);
            }
        }
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            vs.add(typeArguments.stream().map(this::addImport).collect(Collectors.joining(", ", "<", ">")));
        }
        return vs.toString();
    }

    String addImport(Class<?> type) {
        String simpleName = type.getSimpleName();
        if (JAVA_LANG_PACKAGE.equals(type.getPackage().getName())) {
            return simpleName;
        }
        String qualifiedName = type.getCanonicalName();
        String mappedQualifiedName = this.imports.computeIfAbsent(simpleName, key -> qualifiedName);
        return mappedQualifiedName.equals(qualifiedName) ? simpleName : qualifiedName;
    }

    String createTypeParameterNameCode(List<? extends TypeParameterElement> typeParameters) {
        return typeParameters.isEmpty() ? "" : typeParameters.stream().map(tp -> tp.getSimpleName().toString()).collect(Collectors.joining(", ", "<", ">"));
    }

    String createTypeParameterDeclCode(List<? extends TypeParameterElement> typeParameters) {
        return typeParameters.isEmpty() ? "" : typeParameters.stream().map(tp -> this.createTypeParameterDeclCode((TypeParameterElement)tp)).collect(Collectors.joining(", ", "<", ">"));
    }

    private String createTypeParameterDeclCode(TypeParameterElement typeParam) {
        String name = typeParam.getSimpleName().toString();
        List<? extends TypeMirror> bounds = typeParam.getBounds();
        return bounds.isEmpty() || bounds.size() == 1 && this.isJavaLangObject(bounds.get(0)) ? name : String.valueOf(name) + bounds.stream().map(this::addImport).collect(Collectors.joining(" & ", " extends ", ""));
    }

    boolean isJavaLangObject(TypeMirror type) {
        return Object.class.getName().equals(this.getFullQualifiedName(type));
    }

    String getFullQualifiedName(TypeMirror type) {
        ProcessingEnvironment environment = this.processor.getEnvironment();
        TypeElement element = (TypeElement)environment.getTypeUtils().asElement(type);
        return element.getQualifiedName().toString();
    }

    TypeGenerator add(String code) {
        this.source.add(code);
        return this;
    }

    TypeGenerator blank() {
        this.source.blank();
        return this;
    }

    TypeGenerator tab() {
        this.source.tab();
        return this;
    }

    TypeGenerator tab(int amount) {
        this.source.tab(amount);
        return this;
    }

    TypeGenerator newline() {
        this.source.add(System.lineSeparator());
        return this;
    }

    String getCode() {
        String lineSeparator = System.lineSeparator();
        VarString vs = VarString.New();
        vs.add("package ").add(this.packageName).add(";").add(lineSeparator);
        vs.add(lineSeparator);
        if (this.imports.size() > 0) {
            this.imports.values().forEach(path -> {
                VarString varString2 = vs.add("import ").add((String)path).add(";").add(lineSeparator);
            });
            vs.add(lineSeparator);
            vs.add(lineSeparator);
        }
        vs.add(this.source);
        return vs.toString();
    }

    private void writeFile() {
        try {
            JavaFileObject file = this.processor.getEnvironment().getFiler().createSourceFile(String.valueOf(this.packageName) + "." + this.typeName, this.entityTypeElement);
            Throwable throwable = null;
            Object var3_5 = null;
            try (Writer writer = file.openWriter();){
                writer.write(this.getCode());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

